/*
 * Decompiled with CFR 0.152.
 */
package userinterface.log;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import prism.PrismLog;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import userinterface.GUIClipboardEvent;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.log.GUIVisualLogModel;
import userinterface.log.GUIVisualLogger;
import userinterface.log.GUIWindowLog;
import userinterface.util.GUIEvent;
import userinterface.util.GUILogEvent;

public class GUILog
extends GUIPlugin
implements MouseListener,
PrismSettingsListener {
    private PrismLog theLog;
    private JTextArea text;
    private JPopupMenu popupMenu;
    private JMenu logMenu;
    private FileFilter logFilter;
    private Action clearAction;
    private Action saveAction;

    public GUILog(GUIPrism gUIPrism) {
        super(gUIPrism, true);
        this.theLog = gUIPrism.getLog();
        if (this.theLog instanceof GUIWindowLog) {
            GUIWindowLog gUIWindowLog = (GUIWindowLog)this.theLog;
            this.initComponentsAsWindowLog(gUIWindowLog);
        } else if (this.theLog instanceof GUIVisualLogModel) {
            GUIVisualLogModel gUIVisualLogModel = (GUIVisualLogModel)this.theLog;
            this.initComponentsAsVisualLog(gUIVisualLogModel);
        }
    }

    @Override
    public void takeCLArgs(String[] stringArray) {
    }

    @Override
    public boolean displaysTab() {
        return true;
    }

    @Override
    public JMenu getMenu() {
        return this.logMenu;
    }

    @Override
    public String getTabText() {
        return "Log";
    }

    @Override
    public JToolBar getToolBar() {
        return null;
    }

    @Override
    public String getXMLIDTag() {
        return "";
    }

    @Override
    public Object getXMLSaveTree() {
        return null;
    }

    @Override
    public void loadXML(Object object) {
    }

    @Override
    public boolean processGUIEvent(GUIEvent gUIEvent) {
        if (gUIEvent instanceof GUILogEvent) {
            GUILogEvent gUILogEvent = (GUILogEvent)gUIEvent;
            if (gUILogEvent.getID() == 0) {
                this.theLog.println(gUILogEvent.getData());
            } else if (gUILogEvent.getID() == 1) {
                this.theLog.print(gUILogEvent.getData());
            } else if (gUILogEvent.getID() == 2) {
                this.theLog.printSeparator();
            } else if (gUILogEvent.getID() == 3) {
                this.theLog.printWarning((String)gUILogEvent.getData());
            }
        } else if (gUIEvent instanceof GUIClipboardEvent && super.getGUI().getFocussedPlugin() == this) {
            GUIClipboardEvent gUIClipboardEvent = (GUIClipboardEvent)gUIEvent;
            if (gUIClipboardEvent.getID() == 0) {
                ((GUIWindowLog)this.theLog).copy();
                return true;
            }
            if (gUIClipboardEvent.getID() == 4) {
                ((GUIWindowLog)this.theLog).selectAll();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canDoClipBoardAction(Action action) {
        if (action == GUIPrism.getClipboardPlugin().getCopyAction()) {
            return ((GUIWindowLog)this.theLog).hasSelectedText();
        }
        return action == GUIPrism.getClipboardPlugin().getSelectAllAction();
    }

    private void initComponentsAsWindowLog(GUIWindowLog gUIWindowLog) {
        JScrollPane jScrollPane = new JScrollPane();
        this.text = new JTextArea();
        this.text.addMouseListener(this);
        this.text.setFont(new Font("monospaced", 0, 12));
        this.text.setBackground(Color.lightGray);
        gUIWindowLog.open(this.text, this);
        this.text.addMouseListener(this);
        this.text.setEditable(false);
        this.text.setBorder(new TitledBorder("Log Output"));
        jScrollPane.add(this.text);
        jScrollPane.setViewportView(this.text);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.popupMenu = new JPopupMenu();
        this.logMenu = new JMenu("Log");
        this.clearAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((GUIWindowLog)GUILog.this.theLog).clear();
            }
        };
        this.clearAction.putValue("ShortDescription", "Clear log");
        this.clearAction.putValue("MnemonicKey", 67);
        this.clearAction.putValue("Name", "Clear log");
        this.clearAction.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUILog.this.showSaveFileDialog(GUILog.this.logFilter) == 0) {
                    File file = GUILog.this.getChooserFile();
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                        printWriter.print(GUILog.this.text.getText());
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (IOException iOException) {
                        GUILog.this.error("Could not save to file \"" + file + "\"");
                        return;
                    }
                }
            }
        };
        this.saveAction.putValue("ShortDescription", "Save log as...");
        this.saveAction.putValue("MnemonicKey", 83);
        this.saveAction.putValue("Name", "Save log as...");
        this.saveAction.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSave.png"));
        this.popupMenu.add(this.saveAction);
        this.popupMenu.add(new JSeparator());
        this.popupMenu.add(GUIPrism.getClipboardPlugin().getCopyAction());
        this.popupMenu.add(this.clearAction);
        this.popupMenu.add(new JSeparator());
        this.popupMenu.add(GUIPrism.getClipboardPlugin().getSelectAllAction());
        this.logMenu.setMnemonic('L');
        this.logMenu.add(this.saveAction);
        this.logMenu.add(new JSeparator());
        this.logMenu.add(this.clearAction);
        this.logFilter = new FileNameExtensionFilter("Plain text files (*.txt)", "txt");
    }

    private void initComponentsAsVisualLog(GUIVisualLogModel gUIVisualLogModel) {
        GUIVisualLogger gUIVisualLogger = new GUIVisualLogger(gUIVisualLogModel);
        this.setLayout(new BorderLayout());
        this.add((Component)gUIVisualLogger, "Center");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == this.text) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == this.text) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        if (this.theLog instanceof GUIWindowLog) {
            ((GUIWindowLog)this.theLog).notifySettings(prismSettings);
        }
    }
}

