/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import prism.PrismException;
import prism.PrismSettings;
import settings.DefaultSettingOwner;
import settings.SettingTable;
import userinterface.GUIPrism;

public class GUIOptionsDialog
extends JDialog {
    private ArrayList panels;
    private PrismSettings settings;
    JButton cancelButton;
    JButton defaultButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton saveSettingsButton;
    JTabbedPane theTabs;

    public GUIOptionsDialog(GUIPrism gUIPrism) {
        super((Frame)gUIPrism, true);
        this.settings = gUIPrism.getPrism().getSettings();
        this.panels = new ArrayList();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.setLocationRelativeTo(this.getParent());
        for (int i = 0; i < this.settings.optionOwners.length; ++i) {
            SettingTable settingTable = new SettingTable(this);
            ArrayList<DefaultSettingOwner> arrayList = new ArrayList<DefaultSettingOwner>();
            this.settings.optionOwners[i].setDisplay(settingTable);
            arrayList.add(this.settings.optionOwners[i]);
            settingTable.setOwners(arrayList);
            this.panels.add(settingTable);
            this.theTabs.add(settingTable);
            this.theTabs.setTitleAt(this.panels.indexOf(settingTable), PrismSettings.propertyOwnerNames[i]);
        }
    }

    @Override
    public void show() {
        super.show();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.theTabs = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.defaultButton = new JButton();
        this.saveSettingsButton = new JButton();
        this.jPanel4 = new JPanel();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIOptionsDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.theTabs.setMinimumSize(new Dimension(400, 50));
        this.theTabs.setPreferredSize(new Dimension(600, 500));
        this.jPanel1.add((Component)this.theTabs, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setMinimumSize(new Dimension(400, 35));
        this.jPanel3.setLayout(new FlowLayout(0));
        this.defaultButton.setMnemonic('D');
        this.defaultButton.setText("Load Defaults");
        this.defaultButton.setMaximumSize(new Dimension(220, 50));
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIOptionsDialog.this.defaultButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.defaultButton);
        this.saveSettingsButton.setMnemonic('S');
        this.saveSettingsButton.setText("Save Options");
        this.saveSettingsButton.setPreferredSize(new Dimension(120, 25));
        this.saveSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIOptionsDialog.this.saveSettingsButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.saveSettingsButton);
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanel4.setLayout(new FlowLayout(2));
        this.cancelButton.setText("Okay");
        this.cancelButton.setMaximumSize(new Dimension(200, 50));
        this.cancelButton.setMinimumSize(new Dimension(80, 25));
        this.cancelButton.setPreferredSize(new Dimension(80, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIOptionsDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.cancelButton);
        this.jPanel2.add((Component)this.jPanel4, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void saveSettingsButtonActionPerformed(ActionEvent actionEvent) {
        this.settings.notifySettingsListeners();
        try {
            this.settings.saveSettingsFile();
        }
        catch (PrismException prismException) {
            GUIPrism.getGUI().errorDialog("Error saving settings:\n" + prismException.getMessage());
        }
    }

    private void defaultButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new String[]{"Yes", "No"};
        int n = -1;
        n = JOptionPane.showOptionDialog(this, "Are you sure you wish to load the default settings?\nAll previous settings will be lost.", "Save Settings", 0, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            this.settings.loadDefaults();
            this.settings.notifySettingsListeners();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.hide();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

