/*
 * Decompiled with CFR 0.152.
 */
package strat;

import java.util.Optional;

public class StrategyExportOptions
implements Cloneable {
    private StrategyExportType type;
    private Optional<InducedModelMode> mode = Optional.empty();
    private Optional<Boolean> reachOnly = Optional.empty();
    private Optional<Boolean> showStates = Optional.empty();
    private Optional<Boolean> mergeObs = Optional.empty();
    private Optional<Integer> modelPrecision = Optional.empty();

    public StrategyExportOptions() {
        this(StrategyExportType.ACTIONS);
    }

    public StrategyExportOptions(StrategyExportType strategyExportType) {
        this.type = strategyExportType;
    }

    public StrategyExportOptions setType(StrategyExportType strategyExportType) {
        this.type = strategyExportType;
        return this;
    }

    public StrategyExportOptions setMode(InducedModelMode inducedModelMode) {
        this.mode = Optional.of(inducedModelMode);
        return this;
    }

    public StrategyExportOptions setReachOnly(boolean bl) {
        this.reachOnly = Optional.of(bl);
        return this;
    }

    public StrategyExportOptions setShowStates(boolean bl) {
        this.showStates = Optional.of(bl);
        return this;
    }

    public StrategyExportOptions setMergeObservations(boolean bl) {
        this.mergeObs = Optional.of(bl);
        return this;
    }

    public StrategyExportOptions setModelPrecision(int n) {
        this.modelPrecision = Optional.of(n);
        return this;
    }

    public StrategyExportType getType() {
        return this.type;
    }

    public InducedModelMode getMode() {
        return this.mode.orElse(InducedModelMode.RESTRICT);
    }

    public boolean getReachOnly() {
        return this.reachOnly.orElse(!this.getType().equals((Object)StrategyExportType.INDUCED_MODEL));
    }

    public boolean getShowStates() {
        return this.showStates.orElse(true);
    }

    public boolean getMergeObservations() {
        return this.mergeObs.orElse(true);
    }

    public int getModelPrecision() {
        return this.modelPrecision.orElse(16);
    }

    public String description() {
        Object object = this.getType().description();
        if (this.getType() == StrategyExportType.INDUCED_MODEL) {
            object = (String)object + " (" + this.getMode().description() + ")";
        }
        return object;
    }

    public StrategyExportOptions clone() {
        try {
            return (StrategyExportOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Object#clone is expected to work for Cloneable objects", cloneNotSupportedException);
        }
    }

    public static enum StrategyExportType {
        ACTIONS,
        INDICES,
        INDUCED_MODEL,
        DOT_FILE;


        public String description() {
            switch (this) {
                case ACTIONS: {
                    return "as actions";
                }
                case INDICES: {
                    return "as indices";
                }
                case INDUCED_MODEL: {
                    return "as an induced model";
                }
                case DOT_FILE: {
                    return "as a dot file";
                }
            }
            return this.toString();
        }
    }

    public static enum InducedModelMode {
        RESTRICT,
        REDUCE;


        public String description() {
            switch (this) {
                case RESTRICT: {
                    return "restricted";
                }
                case REDUCE: {
                    return "reduced";
                }
            }
            return this.toString();
        }
    }
}

