/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.Distribution;
import explicit.MDPSimple;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismPrintStreamLog;
import simulator.RandomNumberGenerator;
import strat.FMDStrategyStep;
import strat.MDStrategyArray;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public interface Strategy<Value>
extends StrategyInfo<Value> {
    public Object getChoiceAction(int var1, int var2);

    default public Value getChoiceActionProbability(int n, int n2, Object object) {
        return this.getChoiceActionProbability(this.getChoiceAction(n, n2), object);
    }

    default public boolean isActionChosen(int n, int n2, Object object) {
        return this.isActionChosen(this.getChoiceAction(n, n2), object);
    }

    default public Object sampleChoiceAction(int n, int n2, RandomNumberGenerator randomNumberGenerator) {
        return this.sampleChoiceAction(this.getChoiceAction(n, n2), randomNumberGenerator);
    }

    public int getChoiceIndex(int var1, int var2);

    default public boolean isChoiceDefined(int n, int n2) {
        return this.getChoiceAction(n, n2) != UNDEFINED;
    }

    default public StrategyInfo.UndefinedReason whyUndefined(int n, int n2) {
        return null;
    }

    default public String getChoiceActionString(int n, int n2) {
        Object object = this.getChoiceAction(n, n2);
        if (object != UNDEFINED) {
            return object == null ? "" : object.toString();
        }
        StrategyInfo.UndefinedReason undefinedReason = this.whyUndefined(n, n2);
        if (undefinedReason == null) {
            return "?";
        }
        switch (undefinedReason) {
            case UNKNOWN: {
                return "?";
            }
            case ARBITRARY: {
                return "";
            }
            case UNREACHABLE: {
                return "-";
            }
        }
        return "?";
    }

    default public int getMemorySize() {
        return 0;
    }

    default public int getInitialMemory(int n) {
        return -1;
    }

    default public int getUpdatedMemory(int n, Object object, int n2) {
        return -1;
    }

    public int getNumStates();

    default public void export(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        switch (strategyExportOptions.getType()) {
            case ACTIONS: {
                this.exportActions(prismLog, strategyExportOptions);
                break;
            }
            case INDICES: {
                this.exportIndices(prismLog, strategyExportOptions);
                break;
            }
            case INDUCED_MODEL: {
                this.exportInducedModel(prismLog, strategyExportOptions);
                break;
            }
            case DOT_FILE: {
                this.exportDotFile(prismLog, strategyExportOptions);
            }
        }
    }

    default public void exportActions(PrismLog prismLog) throws PrismException {
        this.exportActions(prismLog, new StrategyExportOptions());
    }

    public void exportActions(PrismLog var1, StrategyExportOptions var2) throws PrismException;

    default public void exportIndices(PrismLog prismLog) throws PrismException {
        this.exportIndices(prismLog, new StrategyExportOptions());
    }

    public void exportIndices(PrismLog var1, StrategyExportOptions var2) throws PrismException;

    default public void exportInducedModel(PrismLog prismLog) throws PrismException {
        this.exportInducedModel(prismLog, new StrategyExportOptions());
    }

    public void exportInducedModel(PrismLog var1, StrategyExportOptions var2) throws PrismException;

    default public void exportDotFile(PrismLog prismLog) throws PrismException {
        this.exportDotFile(prismLog, new StrategyExportOptions());
    }

    public void exportDotFile(PrismLog var1, StrategyExportOptions var2) throws PrismException;

    public void clear();

    public static void main(String[] stringArray) {
        PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.out);
        MDPSimple<Double> mDPSimple = new MDPSimple<Double>(2);
        Distribution<Double> distribution = Distribution.ofDouble();
        distribution.add(0, 0.4);
        distribution.add(1, 0.6);
        Distribution<Double> distribution2 = Distribution.ofDouble();
        distribution2.add(0, 1.0);
        mDPSimple.addActionLabelledChoice(0, distribution2, "a");
        mDPSimple.addActionLabelledChoice(0, distribution, "b");
        mDPSimple.addActionLabelledChoice(1, distribution2, "c");
        mDPSimple.addActionLabelledChoice(1, distribution, "d");
        try {
            StrategyExplicit strategyExplicit = null;
            strategyExplicit = new MDStrategyArray(mDPSimple, new int[]{0, 1});
            System.out.println(strategyExplicit);
            strategyExplicit.exportActions(prismPrintStreamLog);
            strategyExplicit = new FMDStrategyStep(mDPSimple, 2);
            ((FMDStrategyStep)strategyExplicit).setStepChoices(0, new int[]{0, 1});
            ((FMDStrategyStep)strategyExplicit).setStepChoices(1, new int[]{1, 1});
            System.out.println(strategyExplicit);
            strategyExplicit.exportActions(prismPrintStreamLog);
        }
        catch (PrismException prismException) {
            throw new RuntimeException(prismException);
        }
    }
}

