/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.ConstructInducedModel;
import explicit.Model;
import explicit.NondetModel;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.State;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;
import strat.Strategy;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class MDStrategyArray<Value>
extends StrategyExplicit<Value>
implements MDStrategy<Value> {
    private int[] choices;

    public MDStrategyArray(NondetModel<Value> nondetModel, int[] nArray) {
        super(nondetModel);
        this.choices = nArray;
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        int n3 = this.choices[n];
        return n3 >= 0 ? this.model.getAction(n, n3) : Strategy.UNDEFINED;
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        return this.choices[n];
    }

    @Override
    public StrategyInfo.UndefinedReason whyUndefined(int n, int n2) {
        switch (this.choices[n]) {
            case -1: {
                return StrategyInfo.UndefinedReason.UNKNOWN;
            }
            case -2: {
                return StrategyInfo.UndefinedReason.ARBITRARY;
            }
            case -3: {
                return StrategyInfo.UndefinedReason.UNREACHABLE;
            }
        }
        return null;
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        List<State> list = this.model.getStatesList();
        boolean bl = strategyExportOptions.getShowStates() && list != null;
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (!this.isChoiceDefined(i)) continue;
            prismLog.println((bl ? (Serializable)list.get(i) : Integer.valueOf(i)) + "=" + this.getChoiceActionString(i));
        }
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructInducedModel constructInducedModel = new ConstructInducedModel();
        constructInducedModel.setMode(strategyExportOptions.getMode()).setReachOnly(strategyExportOptions.getReachOnly());
        Model model = constructInducedModel.constructInducedModel(this.model, this);
        model.exportToPrismExplicitTra(prismLog, strategyExportOptions.getModelPrecision());
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructInducedModel constructInducedModel = new ConstructInducedModel();
        constructInducedModel.setMode(strategyExportOptions.getMode()).setReachOnly(strategyExportOptions.getReachOnly());
        Model model = constructInducedModel.constructInducedModel(this.model, this);
        model.exportToDotFile(prismLog, null, strategyExportOptions.getShowStates(), strategyExportOptions.getModelPrecision());
    }

    @Override
    public void clear() {
        this.choices = null;
    }

    public String toString() {
        return "[" + IntStream.range(0, this.getNumStates()).mapToObj(n -> n + "=" + this.getChoiceActionString(n)).collect(Collectors.joining(",")) + "]";
    }
}

