/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.CSG;
import explicit.Distribution;
import explicit.MDPSimple;
import explicit.ModelCheckerResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import parser.VarList;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import strat.InvalidStrategyStateException;
import strat.Strategy;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class CSGStrategy
extends PrismComponent
implements Strategy<Double> {
    protected CSG<Double> model;
    protected List<List<List<Map<BitSet, Double>>>> csgchoices;
    protected ModelCheckerResult[] prechoices;
    protected BitSet[] targets;
    protected Map<BitSet, BitSet> subgames;
    protected CSGStrategyType type;
    protected BitSet no;
    protected BitSet yes;
    protected BitSet inf;
    protected int numCoalitions;

    public CSGStrategy(CSG<Double> cSG, List<List<List<Map<BitSet, Double>>>> list, Map<BitSet, BitSet> map, int n, CSGStrategyType cSGStrategyType) {
        this.model = cSG;
        this.csgchoices = list;
        this.subgames = map;
        this.numCoalitions = n;
        this.type = cSGStrategyType;
    }

    public CSGStrategy(CSG<Double> cSG, List<List<List<Map<BitSet, Double>>>> list, ModelCheckerResult[] modelCheckerResultArray, BitSet[] bitSetArray, CSGStrategyType cSGStrategyType) {
        this.model = cSG;
        this.csgchoices = list;
        this.prechoices = modelCheckerResultArray;
        this.targets = bitSetArray;
        this.type = cSGStrategyType;
    }

    public CSGStrategy(CSG<Double> cSG, List<List<List<Map<BitSet, Double>>>> list, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, CSGStrategyType cSGStrategyType) {
        this.model = cSG;
        this.csgchoices = list;
        this.prechoices = null;
        this.targets = null;
        this.no = bitSet;
        this.yes = bitSet2;
        this.inf = bitSet3;
        this.type = cSGStrategyType;
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public StrategyInfo.Memory memory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemorySize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInitialMemory(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdatedMemory(int n, Object object, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismNotSupportedException("CSG strategy export in this format not yet supported");
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismNotSupportedException("CSG strategy export in this format not yet supported");
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismNotSupportedException("CSG strategy export in this format not yet supported");
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        try {
            switch (this.type) {
                case ZERO_SUM: {
                    this.exportZeroSumStrategy(prismLog);
                    break;
                }
                case EQUILIBRIA_M: {
                    this.exportMultiEquilibriaStrategy(prismLog);
                    break;
                }
                case EQUILIBRIA_P: 
                case EQUILIBRIA_R: {
                    this.exportEquilibriaStrategy(prismLog);
                    break;
                }
                case EQUILIBRIA_CE_M: {
                    this.exportMultiEquilibriaStrategy(prismLog);
                    break;
                }
                case EQUILIBRIA_CE_P: 
                case EQUILIBRIA_CE_R: {
                    this.exportEquilibriaStrategy(prismLog);
                }
            }
        }
        catch (InvalidStrategyStateException invalidStrategyStateException) {
            throw new PrismException("Error during strategy processing: " + invalidStrategyStateException.getMessage());
        }
    }

    public void exportZeroSumStrategy(PrismLog prismLog) throws PrismException {
        MDPSimple mDPSimple = new MDPSimple();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList<State> arrayList = new ArrayList<State>();
        VarList varList = null;
        BitSet bitSet = new BitSet();
        int n = this.model.getFirstInitialState();
        State state = this.model.getStatesList().get(n);
        varList = this.model.getVarList();
        int n2 = mDPSimple.addState();
        mDPSimple.addInitialState(n2);
        mDPSimple.setVarList(varList);
        arrayList.add(n2, state);
        hashMap.put(n, n2);
        this.generateMDPZeroSum(mDPSimple, hashMap, arrayList, bitSet, 0, 0, n);
        mDPSimple.setStatesList(arrayList);
        mDPSimple.exportToDotFile(prismLog, null, true);
        prismLog.print("\n/*");
        prismLog.print("\n -- Transitions --  \n");
        mDPSimple.exportToPrismExplicitTra(prismLog);
        prismLog.print("\n -- States --  \n");
        mDPSimple.exportStates(0, mDPSimple.getVarList(), prismLog);
        prismLog.print("*/\n");
        this.mainLog.println("Additional info on transitions and states added to file.");
    }

    public void exportEquilibriaStrategy(PrismLog prismLog) throws PrismException, InvalidStrategyStateException {
        MDPSimple mDPSimple = new MDPSimple();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList<State> arrayList = new ArrayList<State>();
        VarList varList = null;
        BitSet bitSet = new BitSet();
        int n = this.model.getFirstInitialState();
        State state = this.model.getStatesList().get(n);
        varList = this.model.getVarList();
        int n2 = mDPSimple.addState();
        mDPSimple.addInitialState(n2);
        mDPSimple.setVarList(varList);
        arrayList.add(n2, state);
        hashMap.put(n, n2);
        if (this.targets[0].isEmpty() && this.targets[1].isEmpty()) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n2, 1.0);
            mDPSimple.addActionLabelledChoice(n2, distribution, "CSG: Unsat(0) -- Unsat(1)");
        } else {
            BitSet[] bitSetArray = new BitSet[this.targets.length];
            for (int i = 0; i < 2; ++i) {
                bitSetArray[i] = new BitSet();
                for (int j = 0; j < this.model.getNumStates(); ++j) {
                    if ((this.type == CSGStrategyType.EQUILIBRIA_P || this.type == CSGStrategyType.EQUILIBRIA_CE_P) && this.prechoices[i].soln[j] > 0.0) {
                        bitSetArray[i].set(j);
                    }
                    if (this.type != CSGStrategyType.EQUILIBRIA_R && this.type != CSGStrategyType.EQUILIBRIA_CE_R || !(this.prechoices[i].soln[j] < Double.POSITIVE_INFINITY)) continue;
                    bitSetArray[i].set(j);
                }
            }
            if (this.type == CSGStrategyType.EQUILIBRIA_P || this.type == CSGStrategyType.EQUILIBRIA_R) {
                this.generateMDPEquilibria(mDPSimple, hashMap, arrayList, bitSetArray, bitSet, 0, n);
            }
            if (this.type == CSGStrategyType.EQUILIBRIA_CE_P || this.type == CSGStrategyType.EQUILIBRIA_CE_R) {
                this.generateMDPCorrelatedEquilibria(mDPSimple, hashMap, arrayList, bitSetArray, bitSet, 0, n);
            }
            this.addPrecompStrategies(mDPSimple, hashMap, arrayList, bitSetArray);
        }
        mDPSimple.setStatesList(arrayList);
        mDPSimple.exportToDotFile(prismLog, null, true);
        prismLog.print("\n/*");
        prismLog.print("\n -- Transitions --  \n");
        mDPSimple.exportToPrismExplicitTra(prismLog);
        prismLog.print("\n -- States --  \n");
        mDPSimple.exportStates(0, mDPSimple.getVarList(), prismLog);
        prismLog.print("*/\n");
        this.mainLog.println("Additional info on transitions and states added to file.");
    }

    public void exportMultiEquilibriaStrategy(PrismLog prismLog) throws PrismException {
        MDPSimple mDPSimple = new MDPSimple();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList<State> arrayList = new ArrayList<State>();
        BitSet bitSet = new BitSet();
        int n = this.model.getFirstInitialState();
        State state = this.model.getStatesList().get(n);
        int n2 = mDPSimple.addState();
        mDPSimple.addInitialState(n2);
        mDPSimple.setVarList(this.model.getVarList());
        arrayList.add(n2, state);
        hashMap.put(n, n2);
        this.generateMDPMultiEquilibria(mDPSimple, hashMap, arrayList, bitSet, 0, n);
        mDPSimple.setStatesList(arrayList);
        mDPSimple.exportToDotFile(prismLog, null, true);
        prismLog.print("\n/*");
        prismLog.print("\n -- Transitions --  \n");
        mDPSimple.exportToPrismExplicitTra(prismLog);
        prismLog.print("\n -- States --  \n");
        mDPSimple.exportStates(0, mDPSimple.getVarList(), prismLog);
        prismLog.print("*/\n");
        this.mainLog.println("Additional info on transitions and states added to file.");
    }

    public void addPrecompStrategies(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet[] bitSetArray) throws PrismException, InvalidStrategyStateException {
        int n;
        BitSet[] bitSetArray2 = new BitSet[this.targets.length];
        BitSet[] bitSetArray3 = new BitSet[this.targets.length];
        BitSet bitSet = new BitSet();
        for (n = 0; n < 2; ++n) {
            bitSetArray2[n] = new BitSet();
            bitSetArray2[n].or(this.targets[n]);
            bitSetArray2[n].andNot(this.targets[(n + 1) % 2]);
            bitSetArray3[n] = new BitSet();
            bitSetArray3[n].or(this.targets[n]);
        }
        for (n = 0; n < 2; ++n) {
            int n2 = bitSetArray2[n].nextSetBit(0);
            while (n2 >= 0) {
                bitSet = new BitSet();
                if (!(!list.contains(this.model.getStatesList().get(n2)) || bitSetArray3[0].get(n2) && bitSetArray3[1].get(n2))) {
                    this.addPrecompStrategies(mDPSimple, map, list, bitSetArray3, bitSetArray, bitSet, n, n2);
                }
                n2 = bitSetArray2[n].nextSetBit(n2 + 1);
            }
        }
    }

    public void addPrecompStrategies(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet[] bitSetArray, BitSet[] bitSetArray2, BitSet bitSet, int n, int n2) throws PrismException, InvalidStrategyStateException {
        int n3;
        Object object = "MDP: ";
        Object object2 = "";
        if (!map.containsKey(n2)) {
            n3 = mDPSimple.addState();
            map.put(n2, n3);
            list.add(n3, this.model.getStatesList().get(n2));
        } else {
            n3 = map.get(n2);
        }
        Iterator<Integer> iterator = this.model.getSuccessorsIterator(n2);
        while (iterator.hasNext()) {
            int n4 = iterator.next();
            if (bitSetArray[0].get(n2)) {
                bitSetArray[0].set(n4);
            }
            if (!bitSetArray[1].get(n2)) continue;
            bitSetArray[1].set(n4);
        }
        bitSet.set(n2);
        if (bitSetArray[n].get(n2) && bitSetArray[(n + 1) % 2].get(n2)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, "CSG: Sat(0) -- Sat(1)");
        } else if (bitSetArray[n].get(n2) && !bitSetArray[(n + 1) % 2].get(n2) && !bitSetArray2[(n + 1) % 2].get(n2)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, "CSG: Sat(" + n + ") -- Unsat(" + (n + 1) % 2 + ")");
        } else if (!bitSetArray[(n + 1) % 2].get(n2)) {
            Distribution<Double> distribution = new Distribution<Double>();
            int n5 = 1;
            int n6 = this.prechoices[(n + 1) % 2].strat.getChoiceIndex(n2, -1);
            double d = 1.0;
            Iterator iterator2 = this.model.getTransitionsIterator(n2, n6);
            while (iterator2.hasNext()) {
                int n7;
                Map.Entry entry = iterator2.next();
                int n8 = entry.getKey();
                if (!map.containsKey(n8)) {
                    n7 = mDPSimple.addState();
                    map.put(n8, n7);
                    list.add(n7, this.model.getStatesList().get(n8));
                } else {
                    n7 = map.get(n8);
                }
                if (!bitSet.get(n8)) {
                    this.addPrecompStrategies(mDPSimple, map, list, bitSetArray, bitSetArray2, bitSet, n, n8);
                }
                distribution.add(n7, d * (Double)entry.getValue());
            }
            for (int i = 0; i < this.model.getActions(n2, n6).length; ++i) {
                object2 = (String)object2 + "[" + this.model.getActions(n2, n6)[i] + "]";
            }
            object = (String)object + d + ": " + (String)object2 + (--n5 > 0 ? " + " : "");
            mDPSimple.addActionLabelledChoice(n3, distribution, object);
        }
    }

    public void localMixedProduct(Map<BitSet, Double> map, BitSet bitSet, double d, int n, int n2, int n3) {
        if (n2 < this.csgchoices.size() - 1) {
            for (BitSet bitSet2 : this.csgchoices.get(n2).get(n).get(n3).keySet()) {
                BitSet bitSet3 = new BitSet();
                double d2 = d * this.csgchoices.get(n2).get(n).get(n3).get(bitSet2);
                bitSet3.or(bitSet);
                bitSet3.or(bitSet2);
                this.localMixedProduct(map, bitSet3, d2, n, n2 + 1, n3);
            }
        } else {
            for (BitSet bitSet4 : this.csgchoices.get(n2).get(n).get(n3).keySet()) {
                BitSet bitSet5 = new BitSet();
                bitSet5.or(bitSet);
                bitSet5.or(bitSet4);
                double d3 = d * this.csgchoices.get(n2).get(n).get(n3).get(bitSet4);
                map.put(bitSet5, d3);
            }
        }
    }

    public void generateMDPMultiEquilibria(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet bitSet, int n, int n2) {
        int n3;
        HashMap<BitSet, Double> hashMap = new HashMap<BitSet, Double>();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        String[] stringArray = new String[this.csgchoices.size()];
        Object object = null;
        Object object2 = null;
        Object object3 = "";
        boolean bl = true;
        boolean bl2 = false;
        bitSet.set(n2);
        int n4 = map.get(n2);
        for (BitSet object4 : this.subgames.keySet()) {
            if (!this.subgames.get(object4).get(n2)) continue;
            bitSet3.or(object4);
        }
        for (n3 = 0; n3 < this.numCoalitions; ++n3) {
            object3 = bitSet3.get(n3) ? (String)object3 + "Sat(" + n3 + ")" : (String)object3 + "Unsat(" + n3 + ")";
            if (n3 >= this.numCoalitions - 1) continue;
            object3 = (String)object3 + " -- ";
        }
        if (bitSet3.cardinality() == this.numCoalitions) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n4, 1.0);
            mDPSimple.addActionLabelledChoice(n4, distribution, object3);
        } else {
            for (n3 = 0; n3 < this.numCoalitions; ++n3) {
                bl = bl && this.csgchoices.get(n3).get(n).get(n2) != null;
                stringArray[n3] = "";
            }
            if (bl) {
                int n5;
                this.localMixedProduct(hashMap, new BitSet(), 1.0, 0, 0, n2);
                Distribution<Double> distribution = new Distribution<Double>();
                for (int i = 0; i < this.model.getNumChoices(n2); ++i) {
                    bitSet2.clear();
                    for (int j = 0; j < this.model.getIndexes(n2, i).length; ++j) {
                        n5 = this.model.getIndexes(n2, i)[j];
                        bitSet2.set(n5 > 0 ? n5 : this.model.getIdles()[j]);
                    }
                    if (!hashMap.containsKey(bitSet2)) continue;
                    Iterator<Object> iterator = this.model.getTransitionsIterator(n2, i);
                    while (iterator.hasNext()) {
                        int n6;
                        Map.Entry entry = (Map.Entry)iterator.next();
                        int n7 = (Integer)entry.getKey();
                        if (!map.containsKey(n7)) {
                            n6 = mDPSimple.addState();
                            map.put(n7, n6);
                            list.add(n6, this.model.getStatesList().get(n7));
                            if (!bitSet.get(n7)) {
                                this.generateMDPMultiEquilibria(mDPSimple, map, list, bitSet, n, n7);
                            }
                        } else {
                            n6 = map.get(n7);
                            if (n6 == n4 && this.model.getNumChoices(n2) == 1 && this.model.getNumTransitions(n2, i) == 1) {
                                bl2 = true;
                            }
                        }
                        distribution.add(n6, (Double)entry.getValue() * (Double)hashMap.get(bitSet2));
                    }
                }
                if (bl2) {
                    mDPSimple.addActionLabelledChoice(n4, distribution, object3);
                } else if (!distribution.isEmpty()) {
                    object2 = "CSG: ";
                    for (n3 = 0; n3 < this.numCoalitions; ++n3) {
                        int n8 = this.csgchoices.get(n3).get(n).get(n2).keySet().size();
                        for (BitSet bitSet4 : this.csgchoices.get(n3).get(n).get(n2).keySet()) {
                            object = "";
                            n5 = bitSet4.nextSetBit(0);
                            while (n5 >= 0) {
                                object = (String)object + "[" + this.model.getActions().get(n5 - 1) + "]";
                                n5 = bitSet4.nextSetBit(n5 + 1);
                            }
                            int n9 = n3;
                            stringArray[n9] = stringArray[n9] + this.csgchoices.get(n3).get(n).get(n2).get(bitSet4) + ": " + (String)object + (--n8 > 0 ? " + " : "");
                        }
                        object2 = (String)object2 + (String)(n3 + 1 < this.csgchoices.size() ? stringArray[n3] + " -- " : stringArray[n3]);
                    }
                    mDPSimple.addActionLabelledChoice(n4, distribution, object2);
                }
            }
        }
    }

    public void generateMDPMultiCorrelatedEquilibria(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet bitSet, int n, int n2) {
        Map<Object, Object> map2 = new HashMap();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        Object object = null;
        Object object2 = null;
        Object object3 = "";
        Object object4 = "";
        boolean bl = false;
        bitSet.set(n2);
        int n3 = map.get(n2);
        for (BitSet bitSet4 : this.subgames.keySet()) {
            if (!this.subgames.get(bitSet4).get(n2)) continue;
            bitSet3.or(bitSet4);
        }
        for (int i = 0; i < this.numCoalitions; ++i) {
            object3 = bitSet3.get(i) ? (String)object3 + "Sat(" + i + ")" : (String)object3 + "Unsat(" + i + ")";
            if (i >= this.numCoalitions - 1) continue;
            object3 = (String)object3 + " -- ";
        }
        if (bitSet3.cardinality() == this.numCoalitions) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, object3);
        } else {
            int n4;
            map2 = this.csgchoices.get(0).get(n).get(n2);
            Distribution<Double> distribution = new Distribution<Double>();
            for (int i = 0; i < this.model.getNumChoices(n2); ++i) {
                bitSet2.clear();
                for (int j = 0; j < this.model.getIndexes(n2, i).length; ++j) {
                    n4 = this.model.getIndexes(n2, i)[j];
                    bitSet2.set(n4 > 0 ? n4 : this.model.getIdles()[j]);
                }
                if (!map2.containsKey(bitSet2)) continue;
                Iterator<Serializable> iterator = this.model.getChoice(n2, i).getSupport().iterator();
                while (iterator.hasNext()) {
                    int n5;
                    int n6 = (Integer)iterator.next();
                    if (!map.containsKey(n6)) {
                        n5 = mDPSimple.addState();
                        map.put(n6, n5);
                        list.add(n5, this.model.getStatesList().get(n6));
                        if (!bitSet.get(n6)) {
                            this.generateMDPMultiCorrelatedEquilibria(mDPSimple, map, list, bitSet, n, n6);
                        }
                    } else {
                        n5 = map.get(n6);
                        if (n5 == n3 && this.model.getChoice(n2, i).getSupport().size() == 1 && this.model.getNumChoices(n2) == 1) {
                            bl = true;
                        }
                    }
                    distribution.add(n5, this.model.getChoice(n2, i).get(n6) * (Double)map2.get(bitSet2));
                }
            }
            if (bl) {
                mDPSimple.addActionLabelledChoice(n3, distribution, object3);
            } else if (!distribution.isEmpty()) {
                object2 = "CSG: ";
                int n7 = this.csgchoices.get(0).get(n).get(n2).keySet().size();
                for (BitSet bitSet5 : this.csgchoices.get(0).get(n).get(n2).keySet()) {
                    object4 = (String)object4 + this.csgchoices.get(0).get(n).get(n2).get(bitSet5) + ": ";
                    object = "";
                    n4 = bitSet5.nextSetBit(0);
                    while (n4 >= 0) {
                        object = (String)object + "[" + this.model.getActions().get(n4 - 1) + "]";
                        n4 = bitSet5.nextSetBit(n4 + 1);
                    }
                    object4 = (String)object4 + (String)object + (--n7 > 0 ? " + " : "");
                }
                object2 = (String)object2 + (String)object4;
                mDPSimple.addActionLabelledChoice(n3, distribution, object2);
            }
        }
    }

    public void generateMDPEquilibria(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet[] bitSetArray, BitSet bitSet, int n, int n4) {
        String[] stringArray = new String[this.csgchoices.size()];
        Object object = null;
        Object object2 = null;
        BitSet bitSet2 = new BitSet();
        HashMap<BitSet, Double> hashMap = new HashMap<BitSet, Double>();
        boolean bl = true;
        int n5 = map.get(n4);
        bitSet.set(n4);
        if (this.targets[0].get(n4) && this.targets[1].get(n4)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n5, 1.0);
            mDPSimple.addActionLabelledChoice(n5, distribution, "CSG: Sat(0) -- Sat(1)");
        } else if (this.targets[0].get(n4) && !this.targets[1].get(n4) && !bitSetArray[0].get(n4)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n5, 1.0);
            mDPSimple.addActionLabelledChoice(n5, distribution, "CSG: Sat(0) -- Unsat(1)");
        } else if (!this.targets[0].get(n4) && this.targets[1].get(n4) && !bitSetArray[1].get(n4)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n5, 1.0);
            mDPSimple.addActionLabelledChoice(n5, distribution, "CSG: Unsat(0) -- Sat(1)");
        } else if (!(this.targets[0].get(n4) || this.targets[1].get(n4) || bitSetArray[0].get(n4) || bitSetArray[1].get(n4))) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n5, 1.0);
            mDPSimple.addActionLabelledChoice(n5, distribution, "CSG: Unsat(0) -- Unsat(1)");
        } else {
            int n6;
            for (n6 = 0; n6 < 2; ++n6) {
                bl = bl && this.csgchoices.get(n6).get(n).get(n4) != null;
                stringArray[n6] = "";
            }
            if (bl) {
                int n7;
                this.localMixedProduct(hashMap, new BitSet(), 1.0, 0, 0, n4);
                Distribution distribution = new Distribution();
                for (int i = 0; i < this.model.getNumChoices(n4); ++i) {
                    bitSet2.clear();
                    for (int j = 0; j < this.model.getIndexes(n4, i).length; ++j) {
                        n7 = this.model.getIndexes(n4, i)[j];
                        bitSet2.set(n7 > 0 ? n7 : this.model.getIdles()[j]);
                    }
                    if (!hashMap.containsKey(bitSet2)) continue;
                    this.model.forEachTransition(n4, i, (n2, n3, d) -> {
                        int n4;
                        if (!map.containsKey(n3)) {
                            n4 = mDPSimple.addState();
                            map.put(n3, n4);
                            list.add(n4, this.model.getStatesList().get(n3));
                            if (!bitSet.get(n3)) {
                                this.generateMDPEquilibria(mDPSimple, map, list, bitSetArray, bitSet, n, n3);
                            }
                        } else {
                            n4 = (Integer)map.get(n3);
                        }
                        distribution.add(n4, d * (Double)hashMap.get(bitSet2));
                    });
                }
                if (!distribution.isEmpty()) {
                    object = "CSG: ";
                    for (n6 = 0; n6 < 2; ++n6) {
                        int n8 = this.csgchoices.get(n6).get(n).get(n4).keySet().size();
                        for (BitSet bitSet3 : this.csgchoices.get(n6).get(n).get(n4).keySet()) {
                            object2 = "";
                            n7 = bitSet3.nextSetBit(0);
                            while (n7 >= 0) {
                                object2 = (String)object2 + "[" + this.model.getActions().get(n7 - 1) + "]";
                                n7 = bitSet3.nextSetBit(n7 + 1);
                            }
                            int n9 = n6;
                            stringArray[n9] = stringArray[n9] + this.csgchoices.get(n6).get(n).get(n4).get(bitSet3) + ": " + (String)object2 + (--n8 > 0 ? " + " : "");
                        }
                        object = (String)object + (String)(n6 + 1 < this.csgchoices.size() ? stringArray[n6] + " -- " : stringArray[n6]);
                    }
                    mDPSimple.addActionLabelledChoice(n5, distribution, object);
                }
            }
        }
    }

    public void generateMDPCorrelatedEquilibria(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet[] bitSetArray, BitSet bitSet, int n, int n2) {
        Object object = "";
        Object object2 = null;
        Object object3 = null;
        BitSet bitSet2 = new BitSet();
        Map<Object, Object> map2 = new HashMap();
        int n3 = map.get(n2);
        bitSet.set(n2);
        if (this.targets[0].get(n2) && this.targets[1].get(n2)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, "CSG: Sat(0) -- Sat(1)");
        } else if (this.targets[0].get(n2) && !this.targets[1].get(n2) && !bitSetArray[0].get(n2)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, "CSG: Sat(0) -- Unsat(1)");
        } else if (!this.targets[0].get(n2) && this.targets[1].get(n2) && !bitSetArray[1].get(n2)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, "CSG: Unsat(0) -- Sat(1)");
        } else if (!(this.targets[0].get(n2) || this.targets[1].get(n2) || bitSetArray[0].get(n2) || bitSetArray[1].get(n2))) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n3, 1.0);
            mDPSimple.addActionLabelledChoice(n3, distribution, "CSG: Unsat(0) -- Unsat(1)");
        } else if (this.csgchoices.get(0).get(n).get(n2) != null) {
            int n4;
            map2 = this.csgchoices.get(0).get(n).get(n2);
            Distribution<Double> distribution = new Distribution<Double>();
            for (int i = 0; i < this.model.getNumChoices(n2); ++i) {
                bitSet2.clear();
                for (int j = 0; j < this.model.getIndexes(n2, i).length; ++j) {
                    n4 = this.model.getIndexes(n2, i)[j];
                    bitSet2.set(n4 > 0 ? n4 : this.model.getIdles()[j]);
                }
                if (!map2.containsKey(bitSet2)) continue;
                Iterator<Serializable> iterator = this.model.getChoice(n2, i).getSupport().iterator();
                while (iterator.hasNext()) {
                    int n5;
                    int n6 = iterator.next();
                    if (!map.containsKey(n6)) {
                        n5 = mDPSimple.addState();
                        map.put(n6, n5);
                        list.add(n5, this.model.getStatesList().get(n6));
                        if (!bitSet.get(n6)) {
                            this.generateMDPCorrelatedEquilibria(mDPSimple, map, list, bitSetArray, bitSet, n, n6);
                        }
                    } else {
                        n5 = map.get(n6);
                    }
                    distribution.add(n5, this.model.getChoice(n2, i).get(n6) * (Double)map2.get(bitSet2));
                }
            }
            if (!distribution.isEmpty()) {
                object2 = "CSG: ";
                int n7 = this.csgchoices.get(0).get(n).get(n2).keySet().size();
                for (BitSet bitSet3 : this.csgchoices.get(0).get(n).get(n2).keySet()) {
                    object = (String)object + this.csgchoices.get(0).get(n).get(n2).get(bitSet3) + ": ";
                    object3 = "";
                    n4 = bitSet3.nextSetBit(0);
                    while (n4 >= 0) {
                        object3 = (String)object3 + "[" + this.model.getActions().get(n4 - 1) + "]";
                        n4 = bitSet3.nextSetBit(n4 + 1);
                    }
                    object = (String)object + (String)object3 + (--n7 > 0 ? " + " : "");
                }
                object2 = (String)object2 + (String)object;
                mDPSimple.addActionLabelledChoice(n3, distribution, object2);
            }
        }
    }

    public void generateMDPZeroSum(MDPSimple mDPSimple, Map<Integer, Integer> map, List<State> list, BitSet bitSet, int n, int n2, int n3) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        Object object = null;
        Object object2 = null;
        int n4 = map.get(n3);
        bitSet.set(n3);
        if (this.yes.get(n3)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n4, 1.0);
            mDPSimple.addActionLabelledChoice(n4, distribution, "Sat");
        } else if (this.no.get(n3)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n4, 1.0);
            mDPSimple.addActionLabelledChoice(n4, distribution, "Unsat");
        } else if (this.inf.get(n3)) {
            Distribution<Double> distribution = new Distribution<Double>();
            distribution.add(n4, 1.0);
            mDPSimple.addActionLabelledChoice(n4, distribution, "Infinity");
        } else if (this.csgchoices.get(n2).get(n).get(n3) != null) {
            for (int i = 0; i < this.model.getNumChoices(n3); ++i) {
                int n5;
                bitSet2.clear();
                for (int j = 0; j < this.model.getIndexes(n3, i).length; ++j) {
                    n5 = this.model.getIndexes(n3, i)[j];
                    bitSet2.set(n5 > 0 ? n5 : this.model.getIdles()[j]);
                }
                for (BitSet bitSet4 : this.csgchoices.get(n2).get(n).get(n3).keySet()) {
                    Distribution<Double> distribution = null;
                    object = "";
                    object2 = "";
                    bitSet3.clear();
                    bitSet3.or(bitSet4);
                    bitSet3.andNot(bitSet2);
                    if (bitSet3.isEmpty()) {
                        distribution = new Distribution<Double>();
                        Iterator iterator = this.model.getTransitionsIterator(n3, i);
                        while (iterator.hasNext()) {
                            int n6;
                            Map.Entry entry = iterator.next();
                            int n7 = entry.getKey();
                            if (!map.containsKey(n7)) {
                                n6 = mDPSimple.addState();
                                map.put(n7, n6);
                                list.add(n6, this.model.getStatesList().get(n7));
                                if (!bitSet.get(n7)) {
                                    this.generateMDPZeroSum(mDPSimple, map, list, bitSet, n, n2, n7);
                                }
                            } else {
                                n6 = map.get(n7);
                            }
                            distribution.add(n6, (Double)entry.getValue() * this.csgchoices.get(n2).get(n).get(n3).get(bitSet4));
                        }
                        n5 = bitSet2.nextSetBit(0);
                        while (n5 >= 0) {
                            if (bitSet4.get(n5)) {
                                object = (String)object + "[" + this.model.getActions().get(n5 - 1) + "]";
                            } else {
                                object2 = (String)object2 + "[" + this.model.getActions().get(n5 - 1) + "]";
                            }
                            n5 = bitSet2.nextSetBit(n5 + 1);
                        }
                        object = this.csgchoices.get(n2).get(n).get(n3).get(bitSet4) + ": " + (String)object;
                    }
                    if (distribution == null) continue;
                    mDPSimple.addActionLabelledChoice(n4, distribution, (String)object + "--" + (String)object2);
                }
            }
        }
    }

    @Override
    public void clear() {
    }

    public String toString() {
        Object object = "CSG:";
        int n = 0;
        if (this.csgchoices != null) {
            for (int i = 0; i < this.model.getNumStates(); ++i) {
                int n2;
                String[] stringArray = new String[this.csgchoices.size()];
                boolean bl = true;
                for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                    bl = bl && this.csgchoices.get(n2).get(n).get(i) != null;
                    stringArray[n2] = "";
                }
                object = (String)object + " $ s:" + i + " -> ";
                for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                    if (this.csgchoices.get(n2).get(n).get(i) == null) continue;
                    int n3 = this.csgchoices.get(n2).get(n).get(i).keySet().size();
                    for (BitSet bitSet : this.csgchoices.get(n2).get(n).get(i).keySet()) {
                        Object object2 = "";
                        int n4 = bitSet.nextSetBit(0);
                        while (n4 >= 0) {
                            object2 = (String)object2 + "[" + this.model.getActions().get(n4 - 1) + "]";
                            n4 = bitSet.nextSetBit(n4 + 1);
                        }
                        int n5 = n2;
                        stringArray[n5] = stringArray[n5] + this.csgchoices.get(n2).get(n).get(i).get(bitSet) + ": " + (String)object2 + (--n3 > 0 ? " + " : "");
                    }
                    object = (String)object + (String)(n2 + 1 < this.csgchoices.size() ? stringArray[n2] + " -- " : stringArray[n2]);
                }
            }
            return object;
        }
        return object;
    }

    public static enum CSGStrategyType {
        ZERO_SUM,
        EQUILIBRIA_M,
        EQUILIBRIA_P,
        EQUILIBRIA_R,
        EQUILIBRIA_CE_P,
        EQUILIBRIA_CE_R,
        EQUILIBRIA_CE_M;

    }
}

