/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import prism.ModelGenerator;
import prism.PrismException;
import simulator.Path;
import simulator.sampler.Sampler;

public abstract class SamplerDouble
extends Sampler {
    protected double value;
    protected int numSamples;
    protected double valueSum;
    protected double correctionTerm;
    protected double valueSumShifted;
    protected double valueSumShiftedSq;

    @Override
    public void reset() {
        this.valueKnown = false;
        this.value = 0.0;
    }

    @Override
    public void resetStats() {
        this.valueSum = 0.0;
        this.valueSumShifted = 0.0;
        this.valueSumShiftedSq = 0.0;
        this.numSamples = 0;
    }

    @Override
    public abstract boolean update(Path var1, ModelGenerator var2) throws PrismException;

    @Override
    public void updateStats() {
        if (this.numSamples == 0) {
            this.correctionTerm = this.value;
        }
        this.valueSum += this.value;
        this.valueSumShifted += this.value - this.correctionTerm;
        this.valueSumShiftedSq += Math.pow(this.value - this.correctionTerm, 2.0);
        ++this.numSamples;
    }

    @Override
    public Object getCurrentValue() {
        return this.value;
    }

    @Override
    public double getMeanValue() {
        return this.valueSum / (double)this.numSamples;
    }

    @Override
    public double getVariance() {
        if (this.numSamples <= 1) {
            return 0.0;
        }
        double d = this.valueSumShifted / (double)this.numSamples;
        return (this.valueSumShiftedSq - (double)this.numSamples * d * d) / ((double)this.numSamples - 1.0);
    }

    @Override
    public double getLikelihoodRatio(double d, double d2) throws PrismException {
        if (this.numSamples <= 1) {
            return 0.0;
        }
        if (this.valueSumShiftedSq == 0.0) {
            throw new PrismException("Cannot compute likelihood ratio with null variance");
        }
        double d3 = this.valueSumShiftedSq / (double)this.numSamples - this.valueSumShifted * this.valueSumShifted / (double)this.numSamples / (double)this.numSamples;
        double d4 = -1.0 / (2.0 * d3) * ((double)this.numSamples * (d * d - d2 * d2) - 2.0 * this.valueSum * (d - d2));
        if (Double.isNaN(d4)) {
            throw new PrismException("Error computing likelihood ratio");
        }
        return Math.exp(d4);
    }
}

