/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.RelOp;
import prism.Accuracy;
import prism.PrismException;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public abstract class CIMethod
extends SimulationMethod {
    protected boolean missingParameterComputed = false;
    protected double width = 0.0;
    protected double confidence = 0.0;
    protected int numSamples = 0;
    protected int prOp;
    protected double theta;

    @Override
    public String getName() {
        return "CI";
    }

    @Override
    public String getFullName() {
        return "Confidence Interval";
    }

    @Override
    public void reset() {
        this.missingParameterComputed = false;
    }

    @Override
    public void computeMissingParameterBeforeSim() throws PrismException {
    }

    @Override
    public void setExpression(Expression expression) throws PrismException {
        RelOp relOp;
        Expression expression2;
        if (expression instanceof ExpressionProb) {
            expression2 = ((ExpressionProb)expression).getProb();
            relOp = ((ExpressionProb)expression).getRelOp();
        } else if (expression instanceof ExpressionReward) {
            expression2 = ((ExpressionReward)expression).getReward();
            relOp = ((ExpressionReward)expression).getRelOp();
        } else {
            throw new PrismException("Cannot approximate " + expression + " using simulation");
        }
        if (expression2 == null) {
            this.prOp = 0;
            this.theta = -1.0;
        } else {
            this.prOp = relOp.isLowerBound() ? -1 : 1;
            this.theta = expression2.evaluateDouble();
        }
    }

    @Override
    public abstract void computeMissingParameterAfterSim();

    @Override
    public abstract Object getMissingParameter() throws PrismException;

    @Override
    public abstract String getParametersString();

    @Override
    public abstract boolean shouldStopNow(int var1, Sampler var2);

    @Override
    public abstract int getProgress(int var1, Sampler var2);

    @Override
    public Object getResult(Sampler sampler) throws PrismException {
        double d = sampler.getMeanValue();
        switch (this.prOp) {
            case 0: {
                return d;
            }
            case -1: {
                if (d >= this.theta + this.width) {
                    return true;
                }
                if (d <= this.theta - this.width) {
                    return false;
                }
                throw new PrismException("Approximation is not precise enough to get a result");
            }
            case 1: {
                if (d >= this.theta + this.width) {
                    return false;
                }
                if (d <= this.theta - this.width) {
                    return true;
                }
                throw new PrismException("Approximation is not precise enough to get a result");
            }
        }
        throw new PrismException("Unknown property type");
    }

    @Override
    public Accuracy getResultAccuracy(Sampler sampler) throws PrismException {
        Accuracy accuracy = this.prOp == 0 ? new Accuracy(Accuracy.AccuracyLevel.PROBABLY_BOUNDED, this.width, Accuracy.AccuracyType.ABSOLUTE) : new Accuracy(Accuracy.AccuracyLevel.PROBABLY_BOUNDED, 0.0, Accuracy.AccuracyType.ABSOLUTE);
        accuracy.setProbability(1.0 - this.confidence);
        return accuracy;
    }

    @Override
    public String getResultExplanation(Sampler sampler) throws PrismException {
        return "confidence interval is " + sampler.getMeanValue() + " +/- " + this.width + ", based on " + 100.0 * (1.0 - this.confidence) + "% confidence level";
    }
}

