/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.EvaluateContextState;
import parser.State;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.TypeClock;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import simulator.ChoiceListFlexi;
import simulator.TransitionList;

public class Updater<Value>
extends PrismComponent {
    public Evaluator<Value> eval;
    protected EvaluateContextState ec;
    protected boolean doProbChecks = true;
    protected ModulesFile modulesFile;
    protected ModelType modelType;
    protected int numModules;
    protected VarList varList;
    protected List<String> synchs;
    protected int numSynchs;
    protected int[] synchModuleCounts;
    protected int numRewardStructs;
    protected BitSet clockVars;
    protected List<List<List<Updates>>> updateLists;
    protected BitSet enabledSynchs;
    protected BitSet[] enabledModules;
    protected Map<Updates, Expression> clockGuards;
    protected int numPlayers;
    protected int[] playersIndexes;
    protected BitSet[] playersActionsIndexes;
    protected Map<Integer, Integer> actionIndexPlayerMap;
    protected ArrayList<ArrayList<Set<BitSet>>> expansions;

    public Updater(ModulesFile modulesFile, VarList varList, Evaluator<Value> evaluator) {
        this(modulesFile, varList, evaluator, null);
    }

    public Updater(ModulesFile modulesFile, VarList varList, Evaluator<Value> evaluator, PrismComponent prismComponent) {
        int n;
        this.doProbChecks = prismComponent.getSettings().getBoolean("prism.doProbChecks");
        this.modulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.numModules = modulesFile.getNumModules();
        this.synchs = modulesFile.getSynchs();
        this.numSynchs = this.synchs.size();
        this.numRewardStructs = modulesFile.getNumRewardStructs();
        this.varList = varList;
        this.eval = evaluator;
        this.ec = new EvaluateContextState(modulesFile.getConstantValues(), new State(modulesFile.getNumVars()));
        this.ec.setEvaluationMode(evaluator.evalMode());
        if (this.modelType.realTime()) {
            int n2 = varList.getNumVars();
            this.clockVars = new BitSet();
            for (n = 0; n < n2; ++n) {
                if (!(varList.getType(n) instanceof TypeClock)) continue;
                this.clockVars.set(n);
            }
        }
        ArrayList<HashSet<String>> arrayList = new ArrayList<HashSet<String>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            arrayList.add(new HashSet<String>(modulesFile.getModule(n).getAllSynchs()));
        }
        this.synchModuleCounts = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            this.synchModuleCounts[n] = 0;
            String string = this.synchs.get(n);
            for (int i = 0; i < this.numModules; ++i) {
                if (!((HashSet)arrayList.get(i)).contains(string)) continue;
                int n3 = n;
                this.synchModuleCounts[n3] = this.synchModuleCounts[n3] + 1;
            }
        }
        this.updateLists = new ArrayList<List<List<Updates>>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            this.updateLists.add(new ArrayList(this.numSynchs + 1));
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                this.updateLists.get(n).add(new ArrayList());
            }
        }
        this.enabledSynchs = new BitSet(this.numSynchs + 1);
        this.enabledModules = new BitSet[this.numSynchs + 1];
        for (n = 0; n < this.numSynchs + 1; ++n) {
            this.enabledModules[n] = new BitSet(this.numModules);
        }
        this.clockGuards = new HashMap<Updates, Expression>();
        this.numPlayers = modulesFile.getNumPlayers();
    }

    public void initialiseCSG() throws PrismLangException {
        this.playersActionsIndexes = new BitSet[this.numPlayers];
        this.actionIndexPlayerMap = new HashMap<Integer, Integer>();
        this.expansions = new ArrayList();
        if (this.numPlayers > 0) {
            int n;
            int n2;
            BitSet bitSet = new BitSet();
            this.playersIndexes = new int[this.numModules];
            Arrays.fill(this.playersIndexes, -1);
            for (n2 = 0; n2 < this.numPlayers; ++n2) {
                this.playersActionsIndexes[n2] = new BitSet();
            }
            for (n2 = 0; n2 < this.numModules; ++n2) {
                this.playersIndexes[n2] = this.modulesFile.getPlayerForModule(this.modulesFile.getModuleName(n2));
                this.expansions.add(n2, new ArrayList());
                if (this.playersIndexes[n2] != -1) {
                    for (n = 0; n < this.modulesFile.getModule(n2).getNumCommands(); ++n) {
                        if (this.modulesFile.getModule(n2).getCommand(n).isUnlabelled()) {
                            throw new PrismLangException("Commands in a player-owned module cannot be unlabelled", this.modulesFile.getModule(n2).getCommand(n));
                        }
                        this.expansions.get(n2).add(n, new HashSet());
                        int n3 = this.modulesFile.getModule(n2).getCommand(n).getSynchIndices().get(0);
                        if (bitSet.get(n3) && !this.playersActionsIndexes[this.playersIndexes[n2]].get(n3)) {
                            throw new PrismLangException("Action " + this.modulesFile.getModule(n2).getCommand(n).getSynchs().get(0) + " of module " + this.modulesFile.getModule(n2).getName() + " had already been associated to a different module. Action sets must be disjoint");
                        }
                        bitSet.set(n3);
                        this.playersActionsIndexes[this.playersIndexes[n2]].set(n3);
                        this.actionIndexPlayerMap.put(n3, this.playersIndexes[n2]);
                    }
                    continue;
                }
                for (n = 0; n < this.modulesFile.getModule(n2).getNumCommands(); ++n) {
                    this.expansions.get(n2).add(n, new HashSet());
                }
            }
            for (n2 = 0; n2 < this.numModules; ++n2) {
                if (this.playersIndexes[n2] != -1) continue;
                for (n = 0; n < this.modulesFile.getModule(n2).getNumCommands(); ++n) {
                    for (int n4 : this.modulesFile.getModule(n2).getCommand(n).getSynchIndices()) {
                        if (this.actionIndexPlayerMap.keySet().contains(n4) || n4 == 0) continue;
                        throw new PrismLangException("Label \"" + this.modulesFile.getSynch(n4 - 1) + "\" of commandd " + n + " of module " + this.modulesFile.getModuleName(n2) + " is not associated to any player. Independent modules can only synchronize on players' actions.");
                    }
                }
            }
        }
    }

    public void calculateTransitions(State state, TransitionList<Value> transitionList) throws PrismException {
        Object object;
        ChoiceListFlexi<Value> choiceListFlexi3;
        int n;
        int n2;
        transitionList.clear();
        for (n2 = 0; n2 < this.numModules; ++n2) {
            for (n = 0; n < this.numSynchs + 1; ++n) {
                this.updateLists.get(n2).get(n).clear();
            }
        }
        this.enabledSynchs.clear();
        for (n2 = 0; n2 < this.numSynchs + 1; ++n2) {
            this.enabledModules[n2].clear();
        }
        this.clockGuards.clear();
        for (n2 = 0; n2 < this.numModules; ++n2) {
            this.calculateUpdatesForModule(n2, state);
        }
        n2 = this.enabledModules[0].nextSetBit(0);
        while (n2 >= 0) {
            for (Updates object2 : this.updateLists.get(n2).get(0)) {
                choiceListFlexi3 = this.processUpdatesAndCreateNewChoice(-(n2 + 1), object2, state);
                if (choiceListFlexi3.size() <= 0) continue;
                transitionList.add(choiceListFlexi3);
            }
            n2 = this.enabledModules[0].nextSetBit(n2 + 1);
        }
        ArrayList arrayList = new ArrayList();
        n2 = this.enabledSynchs.nextSetBit(1);
        while (n2 >= 0) {
            arrayList.clear();
            if (this.enabledModules[n2].cardinality() >= this.synchModuleCounts[n2 - 1]) {
                n = this.enabledModules[n2].nextSetBit(0);
                while (n >= 0) {
                    int n3 = this.updateLists.get(n).get(n2).size();
                    if (n3 == 1) {
                        object = this.updateLists.get(n).get(n2).get(0);
                        if (arrayList.size() == 0) {
                            ChoiceListFlexi<Value> choiceListFlexi2 = this.processUpdatesAndCreateNewChoice(n2, (Updates)object, state);
                            if (choiceListFlexi2.size() > 0) {
                                arrayList.add(choiceListFlexi2);
                            }
                        } else {
                            for (ChoiceListFlexi<Value> choiceListFlexi3 : arrayList) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, choiceListFlexi3);
                            }
                        }
                    } else if (arrayList.size() == 0) {
                        for (Updates updates : this.updateLists.get(n).get(n2)) {
                            choiceListFlexi3 = this.processUpdatesAndCreateNewChoice(n2, updates, state);
                            if (choiceListFlexi3.size() <= 0) continue;
                            arrayList.add(choiceListFlexi3);
                        }
                    } else {
                        int n4;
                        int n5;
                        int n6 = arrayList.size();
                        for (n5 = 0; n5 < n3 - 1; ++n5) {
                            for (n4 = 0; n4 < n6; ++n4) {
                                arrayList.add(new ChoiceListFlexi((ChoiceListFlexi)arrayList.get(n4)));
                            }
                        }
                        for (n5 = 0; n5 < n3; ++n5) {
                            object = this.updateLists.get(n).get(n2).get(n5);
                            for (n4 = 0; n4 < n6; ++n4) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, (ChoiceListFlexi)arrayList.get(n5 * n6 + n4));
                            }
                        }
                    }
                    n = this.enabledModules[n2].nextSetBit(n + 1);
                }
                for (ChoiceListFlexi choiceListFlexi4 : arrayList) {
                    transitionList.add(choiceListFlexi4);
                }
            }
            n2 = this.enabledSynchs.nextSetBit(n2 + 1);
        }
        if (this.modelType == ModelType.DTMC) {
            object = transitionList.getProbabilitySum();
            transitionList.scaleProbabilitiesBy(this.eval.divide((Iterator<Updates>)this.eval.one(), (Iterator<Updates>)object));
        }
    }

    public void calculateEnabledCommands(int n, BitSet bitSet, State state) throws PrismLangException {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        HashSet<BitSet> hashSet = new HashSet<BitSet>();
        Module module = this.modulesFile.getModule(n);
        int n2 = module.getNumCommands();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Command command = module.getCommand(i);
            this.expansions.get(n).get(i).clear();
            if (command.getSynchIndices().get(0) == 0) {
                n4 = this.playersIndexes[n];
                if (n4 != -1) {
                    throw new PrismLangException("Module " + this.modulesFile.getModuleName(n) + " from to player " + n4 + " has an unlabelled command");
                }
                if (!command.getGuard().evaluateBoolean(state)) continue;
                if (n3 == -1) {
                    bitSet.set(i);
                    n3 = i;
                    continue;
                }
                throw new PrismLangException("Module " + this.modulesFile.getModuleName(n) + " has multiple unlabeled active commands in state " + state);
            }
            if (!command.getGuard().evaluateBoolean(state)) continue;
            bitSet3.clear();
            for (int n5 : command.getSynchIndices()) {
                bitSet3.set(n5);
            }
            for (n4 = 0; n4 < this.numPlayers; ++n4) {
                bitSet2.clear();
                bitSet2.or(bitSet3);
                bitSet2.andNot(this.playersActionsIndexes[n4]);
                if (bitSet2.cardinality() >= bitSet3.cardinality() - 1) continue;
                throw new PrismLangException("Module " + this.modulesFile.getModuleName(n) + " has multiple actions associated to player " + this.modulesFile.getPlayerName(n4) + " in command " + i);
            }
            if (!hashSet.contains(bitSet3)) {
                hashSet.add((BitSet)bitSet3.clone());
                bitSet.set(i);
                continue;
            }
            throw new PrismLangException("Module " + this.modulesFile.getModuleName(n) + " has multiple active commands labeled " + command.getSynchs() + " in state " + state);
        }
    }

    public void indexProduct(Set<BitSet> set, BitSet[] bitSetArray, BitSet bitSet, int n) {
        if (n < this.numPlayers - 1) {
            if (!bitSetArray[n].isEmpty()) {
                int n2 = bitSetArray[n].nextSetBit(0);
                while (n2 >= 0) {
                    BitSet bitSet2 = new BitSet();
                    bitSet2.or(bitSet);
                    bitSet2.set(n2);
                    this.indexProduct(set, bitSetArray, bitSet2, n + 1);
                    n2 = bitSetArray[n].nextSetBit(n2 + 1);
                }
            } else {
                BitSet bitSet3 = new BitSet();
                bitSet3.or(bitSet);
                this.indexProduct(set, bitSetArray, bitSet3, n + 1);
            }
        } else if (!bitSetArray[n].isEmpty()) {
            int n3 = bitSetArray[n].nextSetBit(0);
            while (n3 >= 0) {
                BitSet bitSet4 = new BitSet();
                bitSet4.or(bitSet);
                bitSet4.set(n3);
                set.add(bitSet4);
                n3 = bitSetArray[n].nextSetBit(n3 + 1);
            }
        } else {
            BitSet bitSet5 = new BitSet();
            bitSet5.or(bitSet);
            set.add(bitSet5);
        }
    }

    public void expandCommand(Set<BitSet> set, int n, int n2) {
        BitSet bitSet = new BitSet();
        Iterator<Serializable> iterator = this.modulesFile.getModule(n).getCommand(n2).getSynchIndices().iterator();
        while (iterator.hasNext()) {
            int n3 = iterator.next();
            if (n3 == 0) continue;
            bitSet.set(n3);
        }
        for (BitSet bitSet2 : set) {
            BitSet bitSet3 = new BitSet();
            bitSet3.or(bitSet);
            bitSet3.andNot(bitSet2);
            if (!bitSet3.isEmpty()) continue;
            this.expansions.get(n).get(n2).add(bitSet2);
        }
    }

    public void calculateTransitionsCSG(State state, TransitionList<Value> transitionList) throws PrismLangException {
        int n;
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4;
        ArrayList<ChoiceListFlexi<Value>> arrayList = new ArrayList<ChoiceListFlexi<Value>>();
        HashSet<BitSet> hashSet = new HashSet<BitSet>();
        BitSet[] bitSetArray = new BitSet[this.numModules];
        Object[] objectArray = new BitSet[this.numPlayers];
        BitSet[] bitSetArray2 = new BitSet[this.numPlayers];
        BitSet bitSet = new BitSet();
        boolean[] blArray = new boolean[this.numModules];
        transitionList.clear();
        Arrays.fill(objectArray, null);
        for (n4 = 0; n4 < this.numModules; ++n4) {
            bitSetArray[n4] = new BitSet();
            this.calculateEnabledCommands(n4, bitSetArray[n4], state);
            n3 = this.playersIndexes[n4];
            if (n3 == -1) continue;
            if (objectArray[n3] == null) {
                objectArray[n3] = new BitSet();
            }
            int n5 = bitSetArray[n4].nextSetBit(0);
            while (n5 >= 0) {
                ArrayList<Integer> arrayList2 = this.modulesFile.getModule(n4).getCommand(n5).getSynchIndices();
                ((BitSet)objectArray[n3]).set((Integer)arrayList2.get(0));
                n5 = bitSetArray[n4].nextSetBit(n5 + 1);
            }
        }
        this.indexProduct(hashSet, (BitSet[])objectArray, new BitSet(), 0);
        for (n4 = 0; n4 < this.numModules; ++n4) {
            n2 = bitSetArray[n4].nextSetBit(0);
            while (n2 >= 0) {
                this.expandCommand(hashSet, n4, n2);
                n2 = bitSetArray[n4].nextSetBit(n2 + 1);
            }
        }
        for (n4 = 0; n4 < this.numModules; ++n4) {
            n2 = bitSetArray[n4].nextSetBit(0);
            while (n2 >= 0) {
                Command command = this.modulesFile.getModule(n4).getCommand(n2);
                if (command.getSynchIndices().get(0) != 0) {
                    int n6 = bitSetArray[n4].nextSetBit(0);
                    while (n6 >= 0) {
                        Command command2 = this.modulesFile.getModule(n4).getCommand(n6);
                        if (n2 != n6) {
                            for (BitSet object3 : this.expansions.get(n4).get(n2)) {
                                if (command2.getSynchIndices().get(0) != 0) {
                                    if (command2.getSynchIndices().get(0) != command.getSynchIndices().get(0) || command2.getSynchIndices().size() >= command.getSynchIndices().size()) continue;
                                    this.expansions.get(n4).get(n6).remove(object3);
                                    continue;
                                }
                                this.expansions.get(n4).get(n6).remove(object3);
                            }
                        }
                        n6 = bitSetArray[n4].nextSetBit(n6 + 1);
                    }
                }
                n2 = bitSetArray[n4].nextSetBit(n2 + 1);
            }
        }
        HashSet<BitSet> hashSet2 = new HashSet<BitSet>(hashSet);
        for (BitSet bitSet2 : hashSet) {
            bitSet.clear();
            bitSet.or(bitSet2);
            for (n4 = 0; n4 < this.numModules; ++n4) {
                if (this.playersIndexes[n4] == -1 || bitSetArray[n4].isEmpty()) continue;
                n2 = bitSetArray[n4].nextSetBit(0);
                while (n2 >= 0) {
                    if (this.expansions.get(n4).get(n2).contains(bitSet2)) {
                        bitSet.clear(this.modulesFile.getModule(n4).getCommand(n2).getSynchIndices().get(0));
                    }
                    n2 = bitSetArray[n4].nextSetBit(n2 + 1);
                }
            }
            if (bitSet.isEmpty()) continue;
            object2 = "Missing specification for action product [";
            object = "";
            n = bitSet2.nextSetBit(0);
            while (n >= 0) {
                object = (String)object + this.modulesFile.getSynch(n - 1) + (bitSet2.nextSetBit(n + 1) > 0 ? "," : "]");
                n = bitSet2.nextSetBit(n + 1);
            }
            object2 = (String)object2 + (String)object;
            object2 = (String)object2 + " in state " + state + ".";
            this.mainLog.printWarning((String)object2);
            hashSet2.remove(bitSet2);
        }
        int n5 = 0;
        for (BitSet bitSet3 : hashSet2) {
            int[] nArray = new int[this.numPlayers];
            Arrays.fill(nArray, -1);
            ChoiceListFlexi<Value> choiceListFlexi = null;
            for (n4 = 0; n4 < this.numModules; ++n4) {
                blArray[n4] = false;
                n2 = bitSetArray[n4].nextSetBit(0);
                while (n2 >= 0) {
                    Updates updates = this.modulesFile.getModule(n4).getCommand(n2).getUpdates();
                    if (this.expansions.get(n4).get(n2).contains(bitSet3)) {
                        if (!blArray[n4]) {
                            if (choiceListFlexi == null) {
                                choiceListFlexi = this.processUpdatesAndCreateNewChoice(n5, updates, state);
                                ++n5;
                            } else {
                                this.processUpdatesAndAddToProduct(updates, state, choiceListFlexi);
                            }
                            blArray[n4] = true;
                        } else {
                            throw new PrismLangException("Module " + this.modulesFile.getModuleName(n4) + " has multiple active commands for action '" + this.modulesFile.getModule(n4).getCommand(n2).getSynch() + "' in state " + state);
                        }
                    }
                    n2 = bitSetArray[n4].nextSetBit(n2 + 1);
                }
            }
            n2 = bitSet3.nextSetBit(0);
            while (n2 >= 0) {
                nArray[this.actionIndexPlayerMap.get((Object)Integer.valueOf((int)n2)).intValue()] = n2;
                n2 = bitSet3.nextSetBit(n2 + 1);
            }
            if (choiceListFlexi == null) continue;
            choiceListFlexi.setActions(nArray);
            arrayList.add(choiceListFlexi);
        }
        int n6 = 1;
        for (n3 = 0; n3 < this.numPlayers; ++n3) {
            bitSetArray2[n3] = new BitSet();
            for (ChoiceListFlexi choiceListFlexi : arrayList) {
                bitSetArray2[n3].set(choiceListFlexi.getActions()[n3] > 0 ? choiceListFlexi.getActions()[n3] : this.modulesFile.getSynchs().size() + 1);
            }
            n6 *= bitSetArray2[n3].cardinality();
        }
        hashSet.clear();
        if (n6 != arrayList.size()) {
            this.indexProduct(hashSet, bitSetArray2, new BitSet(), 0);
            Iterator<BitSet> iterator = new BitSet();
            for (ChoiceListFlexi choiceListFlexi : arrayList) {
                ((BitSet)((Object)iterator)).clear();
                for (int n7 : choiceListFlexi.getActions()) {
                    ((BitSet)((Object)iterator)).set(n7);
                }
                hashSet.remove(iterator);
            }
            for (BitSet bitSet4 : hashSet) {
                object2 = "Missing specification for action product [";
                object = "";
                n = bitSet4.nextSetBit(0);
                while (n >= 0) {
                    object = (String)object + this.modulesFile.getSynch(n - 1) + (bitSet4.nextSetBit(n + 1) > 0 ? "," : "]");
                    n = bitSet4.nextSetBit(n + 1);
                }
                object2 = (String)object2 + (String)object;
                object2 = (String)object2 + " in state " + state + ".";
                this.mainLog.printWarning((String)object2);
            }
            throw new PrismLangException("Error in model specification.");
        }
        for (ChoiceListFlexi choiceListFlexi : arrayList) {
            transitionList.add(choiceListFlexi, choiceListFlexi.getActions());
        }
    }

    protected void calculateUpdatesForModule(int n, State state) throws PrismLangException {
        Module module = this.modulesFile.getModule(n);
        int n2 = module.getNumCommands();
        for (int i = 0; i < n2; ++i) {
            Command command = module.getCommand(i);
            boolean bl = false;
            Expression expression = null;
            if (this.modelType.realTime()) {
                State state2 = new State(state);
                int n3 = this.clockVars.nextSetBit(0);
                while (n3 >= 0) {
                    state2.varValues[n3] = null;
                    n3 = this.clockVars.nextSetBit(n3 + 1);
                }
                expression = command.getGuard().deepCopy();
                if (!Expression.isFalse(expression = (Expression)expression.evaluatePartially(this.ec.setState(state2)).simplify())) {
                    bl = true;
                }
            } else {
                bl = command.getGuard().evaluateBoolean(this.ec.setState(state));
            }
            if (!bl) continue;
            int n4 = command.getSynchIndex();
            this.updateLists.get(n).get(n4).add(command.getUpdates());
            this.enabledSynchs.set(n4);
            this.enabledModules[n4].set(n);
            if (!this.modelType.realTime()) continue;
            this.clockGuards.put(command.getUpdates(), expression);
        }
    }

    protected Value getProbabilityInState(Updates updates, int n, State state) throws PrismLangException {
        Expression expression = updates.getProbability(n);
        if (expression == null) {
            return this.eval.one();
        }
        return this.eval.evaluate(expression, state);
    }

    private ChoiceListFlexi<Value> processUpdatesAndCreateNewChoice(int n, Updates updates, State state) throws PrismLangException {
        ChoiceListFlexi<Value> choiceListFlexi = new ChoiceListFlexi<Value>(this.eval);
        choiceListFlexi.setModuleOrActionIndex(n);
        int n2 = updates.getNumUpdates();
        Value Value2 = this.eval.zero();
        for (int i = 0; i < n2; ++i) {
            Value Value3 = this.getProbabilityInState(updates, i, state);
            if (!this.eval.isSymbolic()) {
                if (!this.eval.isFinite(Value3)) {
                    String string = this.modelType.probabilityOrRate() + " is not finite in state " + state.toString(this.modulesFile);
                    throw new PrismLangException(string, updates);
                }
                if (!this.eval.geq(Value3, this.eval.zero())) {
                    String string = this.modelType.probabilityOrRate() + " is negative in state " + state.toString(this.modulesFile);
                    throw new PrismLangException(string, updates);
                }
            }
            if (this.eval.isZero(Value3)) continue;
            Value2 = this.eval.add(Value2, Value3);
            ArrayList<Update> arrayList = new ArrayList<Update>();
            arrayList.add(updates.getUpdate(i));
            choiceListFlexi.add(Value3, arrayList);
        }
        if (choiceListFlexi.size() == 0) {
            Object object = this.modelType.probabilityOrRate();
            object = (String)object + (updates.getNumUpdates() > 1 ? " values sum to " : " is ");
            object = (String)object + "zero for updates in state " + state.toString(this.modulesFile);
            throw new PrismLangException((String)object, updates);
        }
        if (this.doProbChecks && choiceListFlexi.size() > 0 && this.modelType.choicesSumToOne() && !this.eval.isSymbolic()) {
            try {
                this.eval.checkProbabilitySum(Value2);
            }
            catch (PrismException prismException) {
                throw new PrismLangException(prismException.getMessage() + " in state " + state.toString(this.modulesFile), updates);
            }
        }
        if (this.modelType.realTime() && this.clockGuards.containsKey(updates)) {
            choiceListFlexi.setClockGuard(this.clockGuards.get(updates));
        }
        return choiceListFlexi;
    }

    private void processUpdatesAndAddToProduct(Updates updates, State state, ChoiceListFlexi<Value> choiceListFlexi) throws PrismLangException {
        ChoiceListFlexi<Value> choiceListFlexi2 = this.processUpdatesAndCreateNewChoice(0, updates, state);
        choiceListFlexi.productWith(choiceListFlexi2);
    }
}

