/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import parser.State;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.ExpressionVar;
import parser.ast.Update;
import parser.visitor.ASTTraverse;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;

public class ChoiceListFlexi<Value>
implements Choice<Value> {
    protected Evaluator<Value> eval;
    protected int moduleOrActionIndex;
    protected List<List<Update>> updates;
    protected List<Value> probability;
    protected Expression clockGuard;
    protected int[] actions;
    protected boolean containsPrimes;
    protected boolean containsPrimeKnown;

    public ChoiceListFlexi(Evaluator<Value> evaluator) {
        this.eval = evaluator;
        this.updates = new ArrayList<List<Update>>();
        this.probability = new ArrayList<Value>();
        this.clockGuard = null;
        this.containsPrimes = false;
        this.containsPrimeKnown = false;
    }

    public ChoiceListFlexi(ChoiceListFlexi<Value> choiceListFlexi) {
        this.eval = choiceListFlexi.eval;
        this.moduleOrActionIndex = choiceListFlexi.moduleOrActionIndex;
        this.updates = new ArrayList<List<Update>>(choiceListFlexi.updates.size());
        for (List<Update> list : choiceListFlexi.updates) {
            ArrayList<Update> arrayList = new ArrayList<Update>(list.size());
            this.updates.add(arrayList);
            for (Update update : list) {
                arrayList.add(update);
            }
        }
        this.probability = new ArrayList<Value>(choiceListFlexi.size());
        for (List<Update> list : choiceListFlexi.probability) {
            this.probability.add(list);
        }
        this.clockGuard = choiceListFlexi.clockGuard;
    }

    public void setModuleOrActionIndex(int n) {
        this.moduleOrActionIndex = n;
    }

    public void setActions(int[] nArray) {
        this.actions = nArray;
    }

    public void setClockGuard(Expression expression) {
        this.clockGuard = expression;
    }

    public void add(Value Value2, List<Update> list) {
        this.updates.add(list);
        this.probability.add(Value2);
    }

    @Override
    public void scaleProbabilitiesBy(Value Value2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.probability.set(i, this.eval.multiply(this.probability.get(i), Value2));
        }
    }

    public void productWith(ChoiceListFlexi<Value> choiceListFlexi) {
        int n;
        Value Value2;
        int n2 = choiceListFlexi.size();
        int n3 = this.size();
        for (int i = 1; i < n2; ++i) {
            Value2 = choiceListFlexi.getProbability(i);
            for (n = 0; n < n3; ++n) {
                ArrayList<Update> arrayList = new ArrayList<Update>(this.updates.get(n).size() + choiceListFlexi.updates.get(i).size());
                for (Update update : this.updates.get(n)) {
                    arrayList.add(update);
                }
                for (Update update : choiceListFlexi.updates.get(i)) {
                    arrayList.add(update);
                }
                this.add(this.eval.multiply(Value2, this.getProbability(n)), arrayList);
            }
        }
        Value2 = choiceListFlexi.getProbability(0);
        for (n = 0; n < n3; ++n) {
            for (Update update : choiceListFlexi.updates.get(0)) {
                this.updates.get(n).add(update);
            }
            this.probability.set(n, this.eval.multiply(Value2, this.probability.get(n)));
        }
        if (choiceListFlexi.clockGuard != null) {
            this.clockGuard = this.clockGuard == null ? choiceListFlexi.clockGuard : Expression.And(this.clockGuard, choiceListFlexi.clockGuard);
        }
    }

    @Override
    public int getModuleOrActionIndex() {
        return this.moduleOrActionIndex;
    }

    @Override
    public String getModuleOrAction() {
        Update update = this.updates.get(0).get(0);
        Command command = update.getParent().getParent();
        if ("".equals(command.getSynch())) {
            return command.getParent().getName();
        }
        return "[" + command.getSynch() + "]";
    }

    @Override
    public Expression getClockGuard() {
        return this.clockGuard;
    }

    @Override
    public int size() {
        return this.probability.size();
    }

    @Override
    public String getUpdateString(int n, State state, VarList varList) throws PrismLangException {
        State state2 = this.computeTarget(n, state, varList);
        Object object = "";
        boolean bl = true;
        for (Update update : this.updates.get(n)) {
            int n2 = update.getNumElements();
            for (int i = 0; i < n2; ++i) {
                if (bl) {
                    bl = false;
                } else {
                    object = (String)object + ", ";
                }
                object = (String)object + update.getVar(i) + "'=" + state2.varValues[update.getVarIndex(i)];
            }
        }
        return object;
    }

    @Override
    public String getUpdateStringFull(int n) {
        Object object = "";
        boolean bl = true;
        for (Update update : this.updates.get(n)) {
            if (update.getNumElements() == 0) continue;
            if (bl) {
                bl = false;
            } else {
                object = (String)object + " & ";
            }
            object = (String)object + update;
        }
        return object;
    }

    public int[] getActions() {
        return this.actions;
    }

    @Override
    public State computeTarget(int n, State state, VarList varList) throws PrismLangException {
        if (this.getContainsPrimes()) {
            return this.computeTargetWithPrimes(n, state, varList);
        }
        State state2 = new State(state);
        for (Update update : this.updates.get(n)) {
            update.update(state, state2, this.eval.exact(), varList);
        }
        return state2;
    }

    private State computeTargetWithPrimes(int n, State state, VarList varList) throws PrismLangException {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        HashMap<String, Update> hashMap2 = new HashMap<String, Update>();
        for (Update update : this.updates.get(n)) {
            for (int i = 0; i < update.getNumElements(); ++i) {
                if (!hashMap2.containsKey(update.getVar(i))) {
                    hashMap2.put(update.getVar(i), new Update());
                }
                ((Update)hashMap2.get(update.getVar(i))).addElement(update.getVarIdent(i), update.getExpression(i));
                ((Update)hashMap2.get(update.getVar(i))).setVar(0, update.getVarIdent(i));
                ((Update)hashMap2.get(update.getVar(i))).setVarIndex(0, update.getVarIndex(i));
                ((Update)hashMap2.get(update.getVar(i))).setType(0, update.getType(i));
                if (hashSet.contains(update.getVar(i))) {
                    throw new PrismLangException("Multiple updates of variable " + update.getVar(i) + " in state " + state);
                }
                hashSet.add(update.getVar(i));
                hashMap.put(update.getVar(i), new HashSet<String>(update.getExpression(i).getPrimedVars()));
            }
        }
        State state2 = new State(state);
        while (!hashSet.isEmpty()) {
            int n2 = hashSet.size();
            for (String string : hashMap2.keySet()) {
                if (!hashSet.contains(string) || !Collections.disjoint((Collection)hashMap.get(string), hashSet)) continue;
                ((Update)hashMap2.get(string)).update(state, state2, this.eval.exact(), varList);
                hashSet.remove(string);
            }
            if (hashSet.size() < n2) continue;
            throw new PrismLangException("Cyclic updates with variables " + ((Object)hashSet).toString());
        }
        return state2;
    }

    @Override
    public void computeTarget(int n, State state, State state2, VarList varList) throws PrismLangException {
        for (Update update : this.updates.get(n)) {
            update.update(state, state2, this.eval.exact(), varList);
        }
    }

    @Override
    public Value getProbability(int n) {
        return this.probability.get(n);
    }

    @Override
    public Value getProbabilitySum() {
        Value Value2 = this.eval.zero();
        for (Value Value3 : this.probability) {
            Value2 = this.eval.add(Value2, Value3);
        }
        return Value2;
    }

    @Override
    public int getIndexByProbabilitySum(Value Value2) {
        int n;
        Value Value3 = this.eval.zero();
        int n2 = this.size();
        for (n = 0; this.eval.geq(Value2, Value3) && n < n2; ++n) {
            Value3 = this.eval.add(Value3, this.probability.get(n));
        }
        return n - 1;
    }

    @Override
    public void checkValid(ModelType modelType) throws PrismException {
    }

    @Override
    public void checkForErrors(State state, VarList varList) throws PrismException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            for (Update update : this.updates.get(i)) {
                update.checkUpdate(state, varList);
            }
        }
    }

    public String toString() {
        boolean bl = true;
        Object object = "";
        if (this.clockGuard != null) {
            object = (String)object + "(" + this.clockGuard + ")";
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + " + ";
            }
            object = (String)object + this.getProbability(i) + ":" + this.updates.get(i);
        }
        return object;
    }

    private boolean getContainsPrimes() {
        if (!this.containsPrimeKnown) {
            this.containsPrimeKnown = true;
            this.containsPrimes = false;
            for (List<Update> list : this.updates) {
                for (Update update : list) {
                    if (!ChoiceListFlexi.astElementContainsPrimes(update)) continue;
                    this.containsPrimes = true;
                    return this.containsPrimes;
                }
            }
        }
        return this.containsPrimes;
    }

    private static boolean astElementContainsPrimes(ASTElement aSTElement) {
        try {
            aSTElement.accept(new ASTTraverse(){

                @Override
                public void visitPost(ExpressionVar expressionVar) throws PrismLangException {
                    if (expressionVar.getPrime()) {
                        throw new PrismLangException("Found one", expressionVar);
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }
}

