/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionVar;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.RelOp;
import parser.type.TypeClock;
import parser.visitor.ASTTraverseModify;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.Result;
import pta.BackwardsReach;
import pta.Constraint;
import pta.ConstructPTA;
import pta.Edge;
import pta.PTA;
import pta.PTAAbstractRefine;
import pta.Transition;
import simulator.ModulesFileModelGenerator;

public class PTAModelChecker
extends PrismComponent {
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private Values constantValues;
    private LabelList labelList;
    private PTA pta;

    public PTAModelChecker(PrismComponent prismComponent, ModulesFile modulesFile, PropertiesFile propertiesFile) throws PrismException {
        super(prismComponent);
        int n;
        this.modulesFile = modulesFile;
        this.propertiesFile = propertiesFile;
        this.constantValues = new Values();
        this.constantValues.addValues(modulesFile.getConstantValues());
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
        this.labelList = new LabelList();
        for (n = 0; n < modulesFile.getLabelList().size(); ++n) {
            this.labelList.addLabel(modulesFile.getLabelList().getLabelNameIdent(n), modulesFile.getLabelList().getLabel(n).deepCopy());
        }
        for (n = 0; n < propertiesFile.getLabelList().size(); ++n) {
            this.labelList.addLabel(propertiesFile.getLabelList().getLabelNameIdent(n), propertiesFile.getLabelList().getLabel(n).deepCopy());
        }
        this.labelList = (LabelList)this.labelList.replaceConstants(this.constantValues);
    }

    public Result check(Expression expression) throws PrismException {
        ModulesFileModelGenerator<Double> modulesFileModelGenerator;
        long l = System.currentTimeMillis();
        try {
            modulesFileModelGenerator = ModulesFileModelGenerator.create(this.modulesFile, this);
        }
        catch (PrismException prismException) {
            throw new PrismException(prismException.getMessage() + ". Try the digital clocks engine instead");
        }
        this.mainLog.println("\nBuilding PTA...");
        ConstructPTA constructPTA = new ConstructPTA(this);
        this.pta = constructPTA.constructPTA(modulesFileModelGenerator);
        this.mainLog.println("\nPTA: " + this.pta.infoString());
        expression.accept(new ASTTraverseModify(){

            @Override
            public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                if (expressionVar.getType() instanceof TypeClock) {
                    throw new PrismLangException("Properties cannot contain references to clocks (try the digital clocks engine instead)", expressionVar);
                }
                return expressionVar;
            }
        });
        expression = expression.deepCopy();
        expression = (Expression)expression.expandPropRefsAndLabels(this.propertiesFile, this.labelList);
        expression = (Expression)expression.replaceConstants(this.constantValues);
        expression = (Expression)expression.simplify();
        Result result = this.checkExpression(expression);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nModel checking completed in " + (double)l / 1000.0 + " secs.");
        Object object = "Result";
        if (!"Result".equals(expression.getResultName())) {
            object = (String)object + " (" + expression.getResultName().toLowerCase() + ")";
        }
        object = (String)object + ": " + result;
        this.mainLog.print("\n" + (String)object + "\n");
        return result;
    }

    private Result checkExpression(Expression expression) throws PrismException {
        Result result;
        if (expression instanceof ExpressionProb) {
            result = this.checkExpressionProb((ExpressionProb)expression);
        } else if (expression instanceof ExpressionReward) {
            result = this.checkExpressionReward((ExpressionReward)expression);
        } else {
            if (expression instanceof ExpressionFilter) {
                throw new PrismException("PTA model checker does not handle filters since it only computes values for the initial state");
            }
            throw new PrismException("PTA model checking not yet supported for this operator (try the digital clocks engine)");
        }
        return result;
    }

    private Result checkExpressionProb(ExpressionProb expressionProb) throws PrismException {
        boolean bl;
        RelOp relOp = expressionProb.getRelOp();
        if (expressionProb.getProb() != null) {
            throw new PrismException("PTA model checking currently only supports Pmin=? and Pmax=? properties (try the digital clocks engine instead)");
        }
        boolean bl2 = bl = relOp.isLowerBound() || relOp.isMin();
        if (!(expressionProb.getExpression() instanceof ExpressionTemporal)) {
            throw new PrismException("PTA model checking currently only supports the F path operator (try the digital clocks engine instead)");
        }
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)expressionProb.getExpression();
        if (expressionTemporal.getOperator() != 3 || !expressionTemporal.isSimplePathFormula()) {
            throw new PrismException("PTA model checking currently only supports the F path operator (try the digital clocks engine instead)");
        }
        Expression expression = expressionTemporal.getOperand2();
        BitSet bitSet = this.checkLocationExpression(expression);
        this.mainLog.println("Target (" + expression + ") satisfied by " + bitSet.cardinality() + " locations.");
        if (expressionTemporal.hasBounds()) {
            this.mainLog.println("Modifying PTA to encode time bound from property...");
            int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
            boolean bl3 = expressionTemporal.upperBoundIsStrict();
            if (n < (bl3 ? 1 : 0)) {
                throw new PrismLangException("Negative bound in " + expressionTemporal);
            }
            bitSet = this.buildTimeBoundIntoPta(this.pta, bitSet, n, bl3);
            this.mainLog.println("New PTA: " + this.pta.infoString());
        }
        double d = this.computeProbabilisticReachability(bitSet, bl);
        return new Result(d);
    }

    private BitSet buildTimeBoundIntoPta(PTA pTA, BitSet bitSet, int n, boolean bl) {
        Object object = null;
        object = "time";
        while (pTA.getClockIndex((String)object) != -1) {
            object = (String)object + "_";
        }
        int n2 = pTA.addClock((String)object);
        int n3 = pTA.getNumLocations();
        Object object2 = "target";
        while (pTA.getLocationIndex(object2) != -1) {
            object2 = (String)object2 + "_";
        }
        int n4 = pTA.addLocation(object2);
        for (int i = 0; i < n3; ++i) {
            ArrayList<Transition> arrayList = new ArrayList<Transition>();
            for (Transition transition : pTA.getTransitions(i)) {
                boolean bl2 = false;
                for (Edge edge : transition.getEdges()) {
                    if (!bitSet.get(edge.getDestination())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                Transition transition2 = new Transition(transition);
                for (Edge edge : transition2.getEdges()) {
                    if (!bitSet.get(edge.getDestination())) continue;
                    edge.setDestination(n4);
                }
                if (bl) {
                    transition2.addGuardConstraint(Constraint.buildLt(n2, n));
                } else {
                    transition2.addGuardConstraint(Constraint.buildLeq(n2, n));
                }
                arrayList.add(transition2);
                if (bl) {
                    transition.addGuardConstraint(Constraint.buildGeq(n2, n));
                    continue;
                }
                transition.addGuardConstraint(Constraint.buildGt(n2, n));
            }
            for (Transition transition : arrayList) {
                pTA.addTransition(transition);
            }
        }
        BitSet bitSet2 = new BitSet(pTA.getNumLocations());
        bitSet2.set(n4);
        if (bitSet.get(0)) {
            bitSet2.set(0);
        }
        return bitSet2;
    }

    private double computeProbabilisticReachability(BitSet bitSet, boolean bl) throws PrismException {
        if (bitSet.get(0)) {
            this.mainLog.println("Skipping numerical computation since initial state is a target...");
            return 1.0;
        }
        String string = this.settings.getString("prism.ptaMethod");
        if (string.equals("Stochastic games")) {
            PTAAbstractRefine pTAAbstractRefine = new PTAAbstractRefine(this);
            String string2 = this.settings.getString("prism.arOptions");
            pTAAbstractRefine.parseOptions(string2.split(","));
            return pTAAbstractRefine.forwardsReachAbstractRefine(this.pta, bitSet, null, bl);
        }
        if (string.equals("Backwards reachability")) {
            BackwardsReach backwardsReach = new BackwardsReach(this);
            return backwardsReach.computeProbabilisticReachability(this.pta, bitSet, bl);
        }
        throw new PrismException("Unknown PTA solution method");
    }

    private Result checkExpressionReward(ExpressionReward expressionReward) throws PrismException {
        throw new PrismException("Reward properties not yet supported for PTA model checking (try the digital clocks engine instead)");
    }

    private BitSet checkLocationExpression(Expression expression) throws PrismException {
        if (expression instanceof ExpressionLabel) {
            ExpressionLabel expressionLabel = (ExpressionLabel)expression;
            if (expressionLabel.isDeadlockLabel()) {
                throw new PrismException("The \"deadlock\" label is not yet supported for PTAs");
            }
            if (expressionLabel.isInitLabel()) {
                throw new PrismException("The \"init\" label is not yet supported for PTAs");
            }
            int n = this.labelList.getLabelIndex(expressionLabel.getName());
            if (n == -1) {
                throw new PrismException("Unknown label \"" + expressionLabel.getName() + "\" in property");
            }
            return this.checkLocationExpression(this.labelList.getLabel(n));
        }
        List<Object> list = this.pta.getLocationNameList();
        int n = list.size();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            State state = (State)list.get(i);
            if (!expression.evaluateBoolean(state)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }
}

