/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.util.Map;
import pta.Constraint;
import pta.Edge;
import pta.PTA;
import pta.Transition;
import pta.Zone;

public class LocZone {
    public int loc;
    public Zone zone;

    public LocZone(int n, Zone zone) {
        this.loc = n;
        this.zone = zone;
    }

    public void tPost(PTA pTA) {
        this.zone.up(pTA.getInvariantConstraints(this.loc));
    }

    public void dPost(Edge edge) {
        Transition transition = edge.getParent();
        for (Constraint object : transition.getGuardConstraints()) {
            this.zone.addConstraint(object);
        }
        for (Map.Entry entry : edge.getResets()) {
            this.zone.reset((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        this.zone.addConstraints(transition.getParent().getInvariantConstraints(edge.getDestination()));
        this.loc = edge.getDestination();
    }

    public void cClosure(PTA pTA) {
        this.zone.cClosure(pTA.getMaxClockConstraint());
    }

    public void tPre(PTA pTA) {
        this.zone.down(pTA.getInvariantConstraints(this.loc));
    }

    public void dPre(Edge edge) {
        Transition transition = edge.getParent();
        for (Map.Entry<Integer, Integer> object : edge.getResets()) {
            this.zone.backReset(object.getKey(), object.getValue());
        }
        for (Constraint constraint : transition.getGuardConstraints()) {
            this.zone.addConstraint(constraint);
        }
        this.zone.addConstraints(transition.getParent().getInvariantConstraints(transition.getSource()));
        this.loc = transition.getSource();
    }

    public LocZone deepCopy() {
        return new LocZone(this.loc, this.zone.deepCopy());
    }

    public int hashCode() {
        return this.loc + this.zone.hashCode();
    }

    public boolean equals(Object object) {
        LocZone locZone;
        if (object == null) {
            return false;
        }
        try {
            locZone = (LocZone)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.loc != locZone.loc) {
            return false;
        }
        return this.zone.equals(locZone.zone);
    }

    public String toString() {
        return "(" + this.zone.getPTA().getLocationNameString(this.loc) + "," + this.zone + ")";
    }
}

