/*
 * Decompiled with CFR 0.152.
 */
package prism;

import parser.VarList;
import prism.PrismLog;
import prism.StateAndValueConsumer;

class StateAndValuePrinter
implements StateAndValueConsumer {
    private PrismLog outputLog;
    private VarList varList;
    boolean printSparse = true;
    boolean printMatlab = false;
    boolean printStates = true;
    boolean printIndices = true;
    private boolean hadOutput = false;

    public StateAndValuePrinter(PrismLog prismLog, VarList varList, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.outputLog = prismLog;
        this.varList = varList;
        this.printSparse = bl;
        this.printMatlab = bl2;
        this.printStates = bl3;
        this.printIndices = bl4;
    }

    @Override
    public void accept(int[] nArray, double d, long l) {
        if (this.printSparse && d == 0.0) {
            return;
        }
        this.hadOutput = true;
        if (this.printMatlab) {
            if (this.printSparse) {
                this.outputLog.println("v(" + (l + 1L) + ")=" + d + ";");
            } else {
                this.outputLog.println(d);
            }
            return;
        }
        if (this.printIndices) {
            this.outputLog.print(l);
        }
        if (this.printStates) {
            if (this.printIndices) {
                this.outputLog.print(":");
            }
            this.outputLog.print("(");
            int n = this.varList.getNumVars();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.outputLog.print(",");
                }
                this.outputLog.print(this.varList.decodeFromInt(i, nArray[i]).toString());
            }
            this.outputLog.print(")");
        }
        if (this.printIndices || this.printStates) {
            this.outputLog.print("=");
        }
        this.outputLog.println(d);
    }

    public boolean hadOutput() {
        return this.hadOutput;
    }
}

