/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.Stack;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismComponent;
import prism.PrismException;
import prism.SCCComputer;

public class SCCComputerSCCFind
extends SCCComputer {
    private JDDNode allSCCs;
    private Stack<DecompTask> tasks;

    public SCCComputerSCCFind(PrismComponent prismComponent, JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        super(prismComponent, jDDNode, jDDNode2, jDDVars, jDDVars2);
    }

    @Override
    public void computeSCCs() {
        this.sccs = new Vector();
        this.allSCCs = JDD.Constant(0.0);
        this.tasks = new Stack();
        JDD.Ref(this.reach);
        JDD.Ref(this.trans01);
        JDDNode jDDNode = this.trim(this.reach, this.trans01);
        JDD.Ref(this.trans01);
        this.tasks.push(new DecompTask(jDDNode, this.trans01, JDD.Constant(0.0), JDD.Constant(0.0)));
        while (!this.tasks.isEmpty()) {
            this.sccFind(this.tasks.pop());
        }
        JDD.Ref(this.reach);
        this.notInSCCs = JDD.And(this.reach, JDD.Not(this.allSCCs));
    }

    @Override
    public void computeSCCs(JDDNode jDDNode) {
        this.sccs = new Vector();
        this.allSCCs = JDD.Constant(0.0);
        this.tasks = new Stack();
        JDD.Ref(this.reach);
        JDD.Ref(this.trans01);
        JDDNode jDDNode2 = this.trim(this.reach, this.trans01);
        JDD.Ref(this.trans01);
        this.tasks.push(new DecompTask(jDDNode2, this.trans01, JDD.Constant(0.0), JDD.Constant(0.0)));
        while (!this.tasks.isEmpty()) {
            this.sccFind(this.tasks.pop(), jDDNode);
        }
        JDD.Ref(this.reach);
        this.notInSCCs = JDD.And(this.reach, JDD.Not(this.allSCCs));
    }

    private JDDNode image(JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.Apply(3, jDDNode2, jDDNode);
        jDDNode3 = JDD.ThereExists(jDDNode3, this.allDDRowVars);
        jDDNode3 = JDD.PermuteVariables(jDDNode3, this.allDDColVars, this.allDDRowVars);
        return jDDNode3;
    }

    private JDDNode preimage(JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode, this.allDDRowVars, this.allDDColVars);
        jDDNode3 = JDD.Apply(3, jDDNode2, jDDNode3);
        jDDNode3 = JDD.ThereExists(jDDNode3, this.allDDColVars);
        return jDDNode3;
    }

    private JDDNode trim(JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3;
        int n = 1;
        JDD.Ref(jDDNode);
        JDDNode jDDNode4 = jDDNode;
        do {
            jDDNode3 = jDDNode4;
            JDD.Ref(jDDNode4);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode5 = this.image(jDDNode4, jDDNode2);
            JDD.Ref(jDDNode4);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode6 = this.preimage(jDDNode4, jDDNode2);
            jDDNode4 = JDD.And(jDDNode4, JDD.And(jDDNode5, jDDNode6));
            if (!this.settings.getBoolean("prism.verbose")) continue;
            this.mainLog.println("Trimming pass " + n + ":");
            JDD.PrintVector(jDDNode4, this.allDDRowVars);
            ++n;
        } while (!jDDNode4.equals(jDDNode3));
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
        return jDDNode4;
    }

    private void report(JDDNode jDDNode) {
        if (jDDNode.equals(JDD.ZERO)) {
            JDD.Deref(jDDNode);
            return;
        }
        assert (!this.sccs.contains(jDDNode));
        this.sccs.addElement(jDDNode);
        JDD.Ref(jDDNode);
        this.allSCCs = JDD.Or(this.allSCCs, jDDNode);
    }

    private SkelForwardResult skelForward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) {
        Stack<JDDNode> stack = new Stack<JDDNode>();
        JDD.Ref(jDDNode3);
        JDDNode jDDNode4 = jDDNode3;
        JDDNode jDDNode5 = JDD.Constant(0.0);
        while (!jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            stack.push(jDDNode4);
            JDD.Ref(jDDNode4);
            jDDNode5 = JDD.Or(jDDNode5, jDDNode4);
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode2);
            jDDNode4 = JDD.And(this.image(jDDNode4, jDDNode2), JDD.Not(jDDNode5));
        }
        JDD.Deref(jDDNode4);
        jDDNode4 = (JDDNode)stack.pop();
        JDDNode jDDNode6 = JDD.RestrictToFirst(jDDNode4, this.allDDRowVars);
        JDD.Ref(jDDNode6);
        JDDNode jDDNode7 = jDDNode6;
        while (!stack.isEmpty()) {
            jDDNode4 = (JDDNode)stack.pop();
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode2);
            jDDNode7 = JDD.Or(jDDNode7, JDD.RestrictToFirst(JDD.And(this.preimage(jDDNode7, jDDNode2), jDDNode4), this.allDDRowVars));
        }
        return new SkelForwardResult(jDDNode5, jDDNode7, jDDNode6);
    }

    private void sccFind(DecompTask decompTask) {
        JDDNode jDDNode = decompTask.nodes;
        JDDNode jDDNode2 = decompTask.edges;
        JDDNode jDDNode3 = decompTask.spineSetPath;
        JDDNode jDDNode4 = decompTask.spineSetNode;
        if (jDDNode.equals(JDD.ZERO)) {
            JDD.Deref(jDDNode);
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode3);
            JDD.Deref(jDDNode4);
            return;
        }
        if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Deref(jDDNode4);
            JDD.Ref(jDDNode);
            jDDNode4 = JDD.RestrictToFirst(jDDNode, this.allDDRowVars);
        }
        SkelForwardResult skelForwardResult = this.skelForward(jDDNode, jDDNode2, jDDNode4);
        JDDNode jDDNode5 = skelForwardResult.forwardSet;
        JDDNode jDDNode6 = skelForwardResult.spineSetPath;
        JDDNode jDDNode7 = skelForwardResult.spineSetNode;
        JDD.Ref(jDDNode4);
        JDDNode jDDNode8 = jDDNode4;
        JDD.Ref(jDDNode8);
        JDD.Ref(jDDNode2);
        JDD.Ref(jDDNode5);
        JDDNode jDDNode9 = JDD.And(this.preimage(jDDNode8, jDDNode2), jDDNode5);
        JDD.Ref(jDDNode9);
        JDD.Ref(jDDNode8);
        JDDNode jDDNode10 = JDD.And(jDDNode9, JDD.Not(jDDNode8));
        while (!jDDNode10.equals(JDD.ZERO)) {
            jDDNode8 = JDD.Or(jDDNode8, jDDNode9);
            JDD.Ref(jDDNode8);
            JDD.Ref(jDDNode2);
            JDD.Ref(jDDNode5);
            jDDNode9 = JDD.And(this.preimage(jDDNode8, jDDNode2), jDDNode5);
            JDD.Ref(jDDNode9);
            JDD.Ref(jDDNode8);
            JDD.Deref(jDDNode10);
            jDDNode10 = JDD.And(jDDNode9, JDD.Not(jDDNode8));
        }
        JDD.Deref(jDDNode10);
        JDD.Deref(jDDNode9);
        JDD.Ref(jDDNode8);
        jDDNode10 = JDD.PermuteVariables(jDDNode8, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode2);
        jDDNode10 = JDD.And(jDDNode10, jDDNode2);
        JDD.Ref(jDDNode8);
        jDDNode10 = JDD.And(jDDNode10, jDDNode8);
        if (!jDDNode10.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode8);
            this.report(jDDNode8);
        }
        JDD.Deref(jDDNode10);
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode5);
        JDDNode jDDNode11 = JDD.And(jDDNode, JDD.Not(jDDNode5));
        JDD.Ref(jDDNode2);
        JDD.Ref(jDDNode11);
        JDDNode jDDNode12 = JDD.Apply(3, jDDNode2, jDDNode11);
        JDD.Ref(jDDNode11);
        jDDNode12 = JDD.Apply(3, jDDNode12, JDD.PermuteVariables(jDDNode11, this.allDDRowVars, this.allDDColVars));
        JDD.Ref(jDDNode3);
        JDD.Ref(jDDNode8);
        JDDNode jDDNode13 = JDD.And(jDDNode3, JDD.Not(jDDNode8));
        JDD.Ref(jDDNode8);
        JDD.Ref(jDDNode3);
        JDD.Ref(jDDNode2);
        JDD.Ref(jDDNode13);
        JDDNode jDDNode14 = JDD.And(this.preimage(JDD.And(jDDNode8, jDDNode3), jDDNode2), jDDNode13);
        JDD.Ref(jDDNode8);
        JDDNode jDDNode15 = JDD.And(jDDNode5, JDD.Not(jDDNode8));
        JDD.Ref(jDDNode2);
        JDD.Ref(jDDNode15);
        JDDNode jDDNode16 = JDD.Apply(3, jDDNode2, jDDNode15);
        JDD.Ref(jDDNode15);
        jDDNode16 = JDD.Apply(3, jDDNode16, JDD.PermuteVariables(jDDNode15, this.allDDRowVars, this.allDDColVars));
        JDD.Ref(jDDNode8);
        JDDNode jDDNode17 = JDD.And(jDDNode6, JDD.Not(jDDNode8));
        JDDNode jDDNode18 = JDD.And(jDDNode7, JDD.Not(jDDNode8));
        this.tasks.push(new DecompTask(jDDNode15, jDDNode16, jDDNode17, jDDNode18));
        this.tasks.push(new DecompTask(jDDNode11, jDDNode12, jDDNode13, jDDNode14));
        JDD.Deref(jDDNode4);
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
    }

    private void sccFind(DecompTask decompTask, JDDNode jDDNode) {
        JDDNode jDDNode2;
        JDDNode jDDNode3;
        JDDNode jDDNode4;
        JDDNode jDDNode5 = decompTask.nodes;
        JDDNode jDDNode6 = decompTask.edges;
        JDDNode jDDNode7 = decompTask.spineSetPath;
        JDDNode jDDNode8 = decompTask.spineSetNode;
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Deref(jDDNode5);
            JDD.Deref(jDDNode6);
            JDD.Deref(jDDNode7);
            JDD.Deref(jDDNode8);
            return;
        }
        if (jDDNode7.equals(JDD.ZERO)) {
            JDD.Deref(jDDNode8);
            JDD.Ref(jDDNode5);
            jDDNode8 = JDD.RestrictToFirst(jDDNode5, this.allDDRowVars);
        }
        SkelForwardResult skelForwardResult = this.skelForward(jDDNode5, jDDNode6, jDDNode8);
        JDDNode jDDNode9 = skelForwardResult.forwardSet;
        JDDNode jDDNode10 = skelForwardResult.spineSetPath;
        JDDNode jDDNode11 = skelForwardResult.spineSetNode;
        JDD.Ref(jDDNode8);
        JDDNode jDDNode12 = jDDNode8;
        JDD.Ref(jDDNode12);
        JDD.Ref(jDDNode6);
        JDD.Ref(jDDNode9);
        JDDNode jDDNode13 = JDD.And(this.preimage(jDDNode12, jDDNode6), jDDNode9);
        JDD.Ref(jDDNode13);
        JDD.Ref(jDDNode12);
        JDDNode jDDNode14 = JDD.And(jDDNode13, JDD.Not(jDDNode12));
        while (!jDDNode14.equals(JDD.ZERO)) {
            jDDNode12 = JDD.Or(jDDNode12, jDDNode13);
            JDD.Ref(jDDNode12);
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode9);
            jDDNode13 = JDD.And(this.preimage(jDDNode12, jDDNode6), jDDNode9);
            JDD.Ref(jDDNode13);
            JDD.Ref(jDDNode12);
            JDD.Deref(jDDNode14);
            jDDNode14 = JDD.And(jDDNode13, JDD.Not(jDDNode12));
        }
        JDD.Deref(jDDNode14);
        JDD.Deref(jDDNode13);
        JDD.Ref(jDDNode12);
        jDDNode14 = JDD.PermuteVariables(jDDNode12, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode6);
        jDDNode14 = JDD.And(jDDNode14, jDDNode6);
        JDD.Ref(jDDNode12);
        jDDNode14 = JDD.And(jDDNode14, jDDNode12);
        if (!jDDNode14.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode12);
            this.report(jDDNode12);
        }
        JDD.Deref(jDDNode14);
        JDD.Ref(jDDNode5);
        JDD.Ref(jDDNode9);
        JDDNode jDDNode15 = JDD.And(jDDNode5, JDD.Not(jDDNode9));
        if (JDD.AreIntersecting(jDDNode15, jDDNode)) {
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode15);
            jDDNode4 = JDD.Apply(3, jDDNode6, jDDNode15);
            JDD.Ref(jDDNode15);
            jDDNode4 = JDD.Apply(3, jDDNode4, JDD.PermuteVariables(jDDNode15, this.allDDRowVars, this.allDDColVars));
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode12);
            jDDNode3 = JDD.And(jDDNode7, JDD.Not(jDDNode12));
            JDD.Ref(jDDNode12);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode3);
            jDDNode2 = JDD.And(this.preimage(JDD.And(jDDNode12, jDDNode7), jDDNode6), jDDNode3);
            this.tasks.push(new DecompTask(jDDNode15, jDDNode4, jDDNode3, jDDNode2));
        } else {
            JDD.Deref(jDDNode15);
        }
        JDD.Ref(jDDNode12);
        jDDNode4 = JDD.And(jDDNode9, JDD.Not(jDDNode12));
        if (JDD.AreIntersecting(jDDNode4, jDDNode)) {
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode4);
            jDDNode3 = JDD.Apply(3, jDDNode6, jDDNode4);
            JDD.Ref(jDDNode4);
            jDDNode3 = JDD.Apply(3, jDDNode3, JDD.PermuteVariables(jDDNode4, this.allDDRowVars, this.allDDColVars));
            JDD.Ref(jDDNode12);
            jDDNode2 = JDD.And(jDDNode10, JDD.Not(jDDNode12));
            JDD.Ref(jDDNode12);
            JDDNode jDDNode16 = JDD.And(jDDNode11, JDD.Not(jDDNode12));
            this.tasks.push(new DecompTask(jDDNode4, jDDNode3, jDDNode2, jDDNode16));
        } else {
            JDD.Deref(jDDNode4);
            JDD.Deref(jDDNode10);
            JDD.Deref(jDDNode11);
        }
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode12);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode6);
    }

    private class DecompTask {
        JDDNode nodes;
        JDDNode edges;
        JDDNode spineSetPath;
        JDDNode spineSetNode;

        DecompTask(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) {
            this.nodes = jDDNode;
            this.edges = jDDNode2;
            this.spineSetPath = jDDNode3;
            this.spineSetNode = jDDNode4;
        }
    }

    private class SkelForwardResult {
        JDDNode forwardSet;
        JDDNode spineSetPath;
        JDDNode spineSetNode;

        SkelForwardResult(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) {
            this.forwardSet = jDDNode;
            this.spineSetPath = jDDNode2;
            this.spineSetNode = jDDNode3;
        }
    }
}

