/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import prism.Model;
import prism.PrismComponent;
import prism.PrismException;
import prism.SCCComputerLockstep;
import prism.SCCComputerSCCFind;
import prism.SCCComputerXB;

public abstract class SCCComputer
extends PrismComponent {
    protected JDDNode trans01;
    protected JDDNode reach;
    protected JDDVars allDDRowVars;
    protected JDDVars allDDColVars;
    protected Vector<JDDNode> sccs;
    protected JDDNode notInSCCs;
    protected JDDNode trivialSCCs;
    protected Vector<JDDNode> bsccs;
    protected JDDNode notInBSCCs;

    public static SCCComputer createSCCComputer(PrismComponent prismComponent, Model model) throws PrismException {
        return SCCComputer.createSCCComputer(prismComponent, model.getReach(), model.getTransReln(), model.getAllDDRowVars(), model.getAllDDColVars());
    }

    public static SCCComputer createSCCComputer(PrismComponent prismComponent, JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return SCCComputer.createSCCComputer(prismComponent, prismComponent.getSettings().getChoice("prism.sccMethod"), jDDNode, jDDNode2, jDDVars, jDDVars2);
    }

    public static SCCComputer createSCCComputer(PrismComponent prismComponent, int n, JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        SCCComputer sCCComputer;
        switch (n) {
            case 2: {
                sCCComputer = new SCCComputerLockstep(prismComponent, jDDNode, jDDNode2, jDDVars, jDDVars2);
                break;
            }
            case 3: {
                sCCComputer = new SCCComputerSCCFind(prismComponent, jDDNode, jDDNode2, jDDVars, jDDVars2);
                break;
            }
            case 1: {
                sCCComputer = new SCCComputerXB(prismComponent, jDDNode, jDDNode2, jDDVars, jDDVars2);
                break;
            }
            default: {
                sCCComputer = new SCCComputerLockstep(prismComponent, jDDNode, jDDNode2, jDDVars, jDDVars2);
            }
        }
        return sCCComputer;
    }

    public SCCComputer(PrismComponent prismComponent, JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        super(prismComponent);
        this.trans01 = jDDNode2;
        this.reach = jDDNode;
        this.allDDRowVars = jDDVars;
        this.allDDColVars = jDDVars2;
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode2, jDDVars, jDDVars2);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
    }

    public abstract void computeSCCs() throws PrismException;

    public abstract void computeSCCs(JDDNode var1) throws PrismException;

    public List<JDDNode> getSCCs() {
        return this.sccs;
    }

    public JDDNode getNotInSCCs() {
        return this.notInSCCs;
    }

    public List<JDDNode> getBSCCs() {
        return this.bsccs;
    }

    public JDDNode getNotInBSCCs() {
        return this.notInBSCCs;
    }

    public void computeBSCCs() throws PrismException {
        int n;
        this.computeSCCs();
        this.bsccs = new Vector();
        this.notInBSCCs = this.notInSCCs;
        int n2 = this.sccs.size();
        for (n = 0; n < n2; ++n) {
            JDDNode jDDNode = this.sccs.elementAt(n);
            JDD.Ref(this.trans01);
            JDD.Ref(jDDNode);
            JDDNode jDDNode2 = JDD.And(this.trans01, jDDNode);
            JDD.Ref(jDDNode);
            jDDNode2 = JDD.And(jDDNode2, JDD.Not(JDD.PermuteVariables(jDDNode, this.allDDRowVars, this.allDDColVars)));
            if (jDDNode2.equals(JDD.ZERO)) {
                this.bsccs.addElement(jDDNode);
            } else {
                JDD.Ref(jDDNode);
                this.notInBSCCs = JDD.Or(jDDNode, this.notInBSCCs);
                JDD.Deref(jDDNode);
            }
            JDD.Deref(jDDNode2);
        }
        this.mainLog.print("\nSCCs: " + this.sccs.size());
        this.mainLog.print(", BSCCs: " + this.bsccs.size());
        this.mainLog.println(", non-BSCC states: " + JDD.GetNumMintermsString(this.notInBSCCs, this.allDDRowVars.n()));
        boolean bl = this.getSettings().getBoolean("prism.verbose");
        if (!bl && this.bsccs.size() > 10) {
            this.mainLog.print("BSCC sizes: More than 10 BSCCs, use verbose mode to view sizes for all.\n");
        } else {
            this.mainLog.print("BSCC sizes:");
            for (n = 0; n < this.bsccs.size(); ++n) {
                this.mainLog.print(" " + (n + 1) + ":" + JDD.GetNumMintermsString(this.bsccs.elementAt(n), this.allDDRowVars.n()));
            }
            this.mainLog.println();
        }
    }
}

