/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.IterableBitSet;
import common.iterable.FunctionalPrimitiveIterator;
import csv.BasicReader;
import csv.CsvFormatException;
import csv.CsvReader;
import csv.ReplacingReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import param.BigRational;
import parser.ParseException;
import parser.PrismParser;
import parser.Values;
import parser.ast.ExpressionConstant;
import parser.ast.Property;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.DefinedConstant;
import prism.Pair;
import prism.Prism;
import prism.PrismLangException;
import prism.ResultsCollection;

public class ResultsImporter
implements Iterable<Pair<Property, RawResultsCollection>> {
    private static final int COMMA = 44;
    final Header header;
    final Map<String, RawResultsCollection> rawResults;

    public ResultsImporter(Reader reader) throws PrismLangException, IOException, CsvFormatException {
        try (ReplacingReader.ToChar toChar = BasicReader.wrap(reader).normalizeLineEndings();
             CsvReader csvReader = new CsvReader(toChar, 44, 10);){
            this.header = new Header(csvReader.getHeader());
            this.rawResults = new LinkedHashMap<String, RawResultsCollection>();
            while (csvReader.hasNextRecord()) {
                String[] stringArray = csvReader.nextRecord();
                RawResult rawResult = new RawResult(stringArray, this.header, csvReader.getLine());
                String string = rawResult.propertyName;
                if (this.rawResults.containsKey(rawResult.propertyName)) {
                    this.rawResults.get(rawResult.propertyName).add(rawResult);
                    continue;
                }
                this.rawResults.put(string, new RawResultsCollection(this.header, rawResult));
            }
        }
    }

    @Override
    public Iterator<Pair<Property, RawResultsCollection>> iterator() {
        return new Iterator<Pair<Property, RawResultsCollection>>(){
            Iterator<RawResultsCollection> collections;
            {
                this.collections = ResultsImporter.this.rawResults.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.collections.hasNext();
            }

            @Override
            public Pair<Property, RawResultsCollection> next() {
                ExpressionConstant expressionConstant;
                RawResultsCollection rawResultsCollection = this.collections.next();
                String string = rawResultsCollection.getPropertyName();
                switch (rawResultsCollection.getResultType()) {
                    case Boolean: {
                        expressionConstant = new ExpressionConstant(string, TypeBool.getInstance());
                        break;
                    }
                    case Integer: {
                        expressionConstant = new ExpressionConstant(string, TypeInt.getInstance());
                        break;
                    }
                    case Double: 
                    case BigRational: {
                        expressionConstant = new ExpressionConstant(string, TypeDouble.getInstance());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Result type not supported: " + rawResultsCollection.getResultType());
                    }
                }
                Property property = new Property(expressionConstant, string);
                return new Pair<Property, RawResultsCollection>(property, rawResultsCollection);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String parseIdentifier(String string) throws PrismLangException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            Prism.getPrismParser();
            try {
                PrismParser.ReInit(byteArrayInputStream);
                boolean bl = true;
                try {
                    bl = string.equals(PrismParser.Identifier());
                }
                catch (ParseException parseException) {
                    bl = false;
                }
                if (!bl) {
                    throw new PrismLangException("Expected identifier but got: " + string);
                }
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return string;
    }

    protected static Object parseValue(String string) {
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return new BigRational(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    return string;
                }
            }
        }
    }

    public static class Header {
        final int numColumns;
        final String resultName;
        final String[] constantNames;
        int propertyIndex = -1;
        int resultIndex = -1;

        public Header(String[] stringArray) throws PrismLangException {
            this.numColumns = stringArray.length;
            this.setPropertyAndResultIndex(stringArray);
            this.resultName = stringArray[this.resultIndex];
            this.constantNames = this.parseConstantNames(stringArray);
        }

        protected void setPropertyAndResultIndex(String[] stringArray) throws PrismLangException {
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                switch (stringArray[i]) {
                    case "Property": {
                        this.propertyIndex = i;
                        continue block8;
                    }
                    case "Result": {
                        this.resultIndex = i;
                        continue block8;
                    }
                }
            }
            if (this.propertyIndex < 0) {
                if (this.resultIndex == 0) {
                    throw new PrismLangException("Cannot find the property column (either \"Property\" or the first column)");
                }
                this.propertyIndex = 0;
            }
            if (this.resultIndex < 0) {
                if (this.propertyIndex == stringArray.length - 1) {
                    throw new PrismLangException("Cannot find the result column (either \"Result\" or the last column)");
                }
                this.resultIndex = stringArray.length - 1;
            }
        }

        protected String[] parseConstantNames(String[] stringArray) throws PrismLangException {
            String[] stringArray2 = new String[stringArray.length - 2];
            int n = 0;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (i == this.propertyIndex || i == this.resultIndex) continue;
                try {
                    stringArray2[n++] = ResultsImporter.parseIdentifier(stringArray[i]);
                    continue;
                }
                catch (PrismLangException prismLangException) {
                    throw new PrismLangException("Header fields for constants must be identifiers but got: " + stringArray[i] + "(field " + i + ")");
                }
            }
            return stringArray2;
        }
    }

    public static class RawResult {
        final String propertyName;
        final Object resultValue;
        final Object[] constantValues;

        public RawResult(String[] stringArray, Header header, int n) throws PrismLangException {
            this.checkNumberOfFields(stringArray, header);
            this.propertyName = this.parsePropertyName(stringArray, header, n);
            this.constantValues = this.parseConstants(stringArray, header, n);
            this.resultValue = this.parseResult(stringArray, header, n);
        }

        protected int checkNumberOfFields(String[] stringArray, Header header) throws PrismLangException {
            if (stringArray.length != header.numColumns) {
                throw new PrismLangException("Record must have " + header.numColumns + " columns but got " + stringArray.length);
            }
            return stringArray.length;
        }

        protected String parsePropertyName(String[] stringArray, Header header, int n) throws PrismLangException {
            try {
                return ResultsImporter.parseIdentifier(stringArray[header.propertyIndex]);
            }
            catch (PrismLangException prismLangException) {
                throw new PrismLangException("Property must be an identifier (input line: " + n + ", field: " + (header.propertyIndex + 1) + ")");
            }
        }

        protected Object[] parseConstants(String[] stringArray, Header header, int n) throws PrismLangException {
            Object[] objectArray = new Object[stringArray.length - 2];
            int n2 = 0;
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                if (i == header.propertyIndex || i == header.resultIndex) continue;
                objectArray[n2++] = this.parseConstant(stringArray, n, i);
            }
            return objectArray;
        }

        protected Object parseConstant(String[] stringArray, int n, int n2) throws PrismLangException {
            String string = stringArray[n2];
            if (string.isEmpty()) {
                return null;
            }
            Object object = ResultsImporter.parseValue(stringArray[n2]);
            if (object instanceof Boolean || object instanceof Number) {
                return object;
            }
            throw new PrismLangException("Constant must be either Boolean or numeric (input line: " + n + ", field: " + (n2 + 1) + ") but got: " + object);
        }

        protected Object parseResult(String[] stringArray, Header header, int n) throws PrismLangException {
            Object object = ResultsImporter.parseValue(stringArray[header.resultIndex]);
            if (object instanceof Boolean || object instanceof Number) {
                return object;
            }
            throw new PrismLangException("Result must be either Boolean or numeric (input line: " + n + ", field: " + (header.resultIndex + 1) + ") but got: " + object);
        }
    }

    public static class RawResultsCollection {
        final Header header;
        final String propertyName;
        final List<RawResult> results;
        BitSet typeConversions;
        TypeInfo[] constantTypes;
        TypeInfo resultType;

        public RawResultsCollection(Header header, RawResult rawResult) {
            this.header = header;
            this.propertyName = rawResult.propertyName;
            this.results = new ArrayList<RawResult>();
            this.initializeTypes(rawResult);
            this.inferTypes(rawResult);
            this.results.add(rawResult);
        }

        public void add(RawResult rawResult) throws PrismLangException {
            if (!this.propertyName.equals(rawResult.propertyName)) {
                throw new PrismLangException("Property field expected to be \"" + this.propertyName + "\" but got: " + rawResult.propertyName);
            }
            this.inferTypes(rawResult);
            this.results.add(rawResult);
        }

        public ResultsCollection toResultsCollection() throws PrismLangException {
            this.convertConstants();
            Vector<DefinedConstant> vector = this.getRangingConstants();
            ResultsCollection resultsCollection = new ResultsCollection(vector, 0, vector.size(), new Values(), this.header.resultName);
            for (RawResult rawResult : this.results) {
                int n;
                Values values = new Values();
                int n2 = this.constantTypes.length;
                for (n = 0; n < n2; ++n) {
                    if (this.constantTypes[n] == TypeInfo.Nil) continue;
                    values.addValue(this.header.constantNames[n], rawResult.constantValues[n]);
                }
                n = resultsCollection.setResult(values, rawResult.resultValue);
                if (n < 1) {
                    throw new PrismLangException("Result overridden: " + values + " -> " + rawResult);
                }
                if (n <= 1) continue;
                throw new PrismLangException("Multiple results set: " + values + " -> " + rawResult);
            }
            return resultsCollection;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public TypeInfo getResultType() {
            return this.resultType;
        }

        protected void initializeTypes(RawResult rawResult) {
            int n = rawResult.constantValues.length;
            this.typeConversions = new BitSet(n);
            this.constantTypes = new TypeInfo[n];
            for (int i = 0; i < n; ++i) {
                this.constantTypes[i] = TypeInfo.from(rawResult.constantValues[i]);
            }
            this.resultType = TypeInfo.from(rawResult.resultValue);
        }

        protected void inferTypes(RawResult rawResult) {
            int n = this.constantTypes.length;
            for (int i = 0; i < n; ++i) {
                TypeInfo typeInfo;
                Object object = rawResult.constantValues[i];
                TypeInfo typeInfo2 = TypeInfo.from(object);
                TypeInfo typeInfo3 = this.constantTypes[i];
                this.constantTypes[i] = typeInfo = typeInfo3.infer(object);
                if (typeInfo2 == typeInfo3 && typeInfo == typeInfo3) continue;
                this.typeConversions.set(i);
            }
            this.resultType = this.resultType.infer(rawResult.resultValue);
        }

        protected void convertConstants() {
            if (this.typeConversions.isEmpty()) {
                return;
            }
            for (RawResult rawResult : this.results) {
                FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(this.typeConversions).iterator();
                while (ofInt.hasNext()) {
                    int n = ofInt.nextInt();
                    rawResult.constantValues[n] = this.constantTypes[n].convert(rawResult.constantValues[n]);
                }
            }
        }

        protected Vector<DefinedConstant> getRangingConstants() throws PrismLangException {
            Set<Object>[] setArray = this.collectConstantDomains();
            Vector<DefinedConstant> vector = new Vector<DefinedConstant>();
            int n = setArray.length;
            for (int i = 0; i < n; ++i) {
                Set<Object> set = setArray[i];
                if (set.isEmpty()) continue;
                DefinedConstant.DefinedDomain<?> definedDomain = this.defineConstant(this.header.constantNames[i], setArray[i], this.constantTypes[i]);
                vector.add(definedDomain);
            }
            return vector;
        }

        protected DefinedConstant.DefinedDomain<?> defineConstant(String string, Set<?> set, TypeInfo typeInfo) throws PrismLangException {
            DefinedConstant.DefinedDomain definedDomain;
            switch (typeInfo) {
                case Integer: {
                    definedDomain = DefinedConstant.DefinedDomain.fromValues((String)string, (Type)TypeInt.getInstance(), set, (Number[])new Integer[0]);
                    break;
                }
                case Double: {
                    definedDomain = DefinedConstant.DefinedDomain.fromValues((String)string, (Type)TypeDouble.getInstance(), set, (Number[])new Double[0]);
                    break;
                }
                case BigRational: {
                    definedDomain = DefinedConstant.DefinedDomain.fromValues((String)string, (Type)TypeDouble.getInstance(), set, (Number[])new BigRational[0]);
                    break;
                }
                default: {
                    throw new PrismLangException("Ranging constants must not be of type" + typeInfo);
                }
            }
            return definedDomain;
        }

        protected Set<Object>[] collectConstantDomains() {
            Set[] setArray = new Set[this.constantTypes.length];
            int n = setArray.length;
            for (int i = 0; i < n; ++i) {
                setArray[i] = new HashSet();
            }
            for (RawResult rawResult : this.results) {
                int n2 = setArray.length;
                for (int i = 0; i < n2; ++i) {
                    Object object = rawResult.constantValues[i];
                    if (object == null) continue;
                    setArray[i].add(object);
                }
            }
            return setArray;
        }
    }

    public static enum TypeInfo {
        Nil{

            @Override
            public Object convert(Object object) {
                if (object == null) {
                    return null;
                }
                throw new IllegalArgumentException("Nil type");
            }

            @Override
            public TypeInfo infer(Object object) {
                if (object == null) {
                    return this;
                }
                throw new IllegalArgumentException("Expected null but got: " + object.getClass());
            }
        }
        ,
        String{

            @Override
            public String convert(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                throw new IllegalArgumentException("Expected String but got: " + object.getClass());
            }

            @Override
            public TypeInfo infer(Object object) {
                if (object instanceof String) {
                    return this;
                }
                throw new IllegalArgumentException("Expected String but got: " + object.getClass());
            }
        }
        ,
        Boolean{

            @Override
            public Boolean convert(Object object) {
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
                throw new IllegalArgumentException("Expected Boolean but got: " + object.getClass());
            }

            @Override
            public TypeInfo infer(Object object) {
                if (object instanceof Boolean) {
                    return this;
                }
                throw new IllegalArgumentException("Expected Boolean but got: " + object.getClass());
            }
        }
        ,
        Integer{

            @Override
            public Integer convert(Object object) {
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                throw new IllegalArgumentException("Expected Integer but got: " + object.getClass());
            }

            @Override
            public TypeInfo infer(Object object) {
                if (object instanceof Integer) {
                    return Integer;
                }
                if (object instanceof Double) {
                    return Double;
                }
                if (object instanceof BigRational) {
                    return BigRational;
                }
                throw new IllegalArgumentException("Expected Integer, Double or BigRational but got: " + object.getClass());
            }
        }
        ,
        Double{

            @Override
            public Double convert(Object object) {
                if (object instanceof Double) {
                    return (Double)object;
                }
                if (object instanceof Integer) {
                    return ((Integer)object).doubleValue();
                }
                throw new IllegalArgumentException("Expected Integer but got: " + object.getClass());
            }

            @Override
            public TypeInfo infer(Object object) {
                if (object instanceof Double || object instanceof Integer) {
                    return Double;
                }
                if (object instanceof BigRational) {
                    return BigRational;
                }
                throw new IllegalArgumentException("Expected Double or BigRational but got: " + object.getClass());
            }
        }
        ,
        BigRational{

            @Override
            public BigRational convert(Object object) {
                if (object instanceof BigRational) {
                    return (BigRational)object;
                }
                if (object instanceof Double) {
                    return param.BigRational.from(object);
                }
                if (object instanceof Integer) {
                    return new BigRational(((Integer)object).intValue());
                }
                throw new IllegalArgumentException("Expected Integer but got: " + object.getClass());
            }

            @Override
            public TypeInfo infer(Object object) {
                if (object instanceof BigRational || object instanceof Double || object instanceof Integer) {
                    return BigRational;
                }
                throw new IllegalArgumentException("Expected BigRational but got: " + object.getClass());
            }
        };


        public abstract Object convert(Object var1);

        public abstract TypeInfo infer(Object var1);

        public static TypeInfo from(Object object) {
            if (object == null) {
                return Nil;
            }
            if (object instanceof String) {
                return String;
            }
            if (object instanceof Boolean) {
                return Boolean;
            }
            if (object instanceof Integer) {
                return Integer;
            }
            if (object instanceof Double) {
                return Double;
            }
            if (object instanceof BigRational) {
                return BigRational;
            }
            throw new IllegalArgumentException("Unsupported type " + object.getClass());
        }
    }
}

