/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import parser.Values;
import parser.ast.Property;
import prism.DefinedConstant;
import prism.ResultsCollection;

public abstract class ResultsExporter {
    protected List<DefinedConstant> rangingConstants;
    protected Values nonRangingConstantValues;
    protected PrintWriter target;
    protected Property property;
    protected boolean printProperty;

    public void setRangingConstants(List<DefinedConstant> list) {
        this.rangingConstants = list;
    }

    public void setNonRangingConstantValues(Values values) {
        this.nonRangingConstantValues = values;
    }

    public void printResults(List<ResultsCollection> list, List<Property> list2, PrintWriter printWriter) {
        int n = list.size();
        this.printProperty = n > 1;
        for (int i = 0; i < n; ++i) {
            this.property = list2.get(i);
            if (i > 0) {
                this.printCollectionSeparator(printWriter);
            }
            this.exportResultsCollection(list.get(i), printWriter);
        }
        printWriter.flush();
    }

    protected void printCollectionSeparator(PrintWriter printWriter) {
        printWriter.println();
    }

    protected abstract void printPropertyHeading();

    public void exportResultsCollection(ResultsCollection resultsCollection, PrintWriter printWriter) {
        this.target = printWriter;
        resultsCollection.export(this);
        this.target = null;
    }

    public void start() {
        if (this.printProperty) {
            this.printPropertyHeading();
        }
    }

    public abstract void exportResult(Values var1, Object var2);

    public void end() {
    }

    public static class ResultsExporterComment
    extends ResultsExporter {
        @Override
        protected void printPropertyHeading() {
        }

        @Override
        public void exportResult(Values values, Object object) {
            Values values2 = new Values(this.nonRangingConstantValues, values);
            this.target.print("// RESULT");
            if (values2.getNumValues() > 0) {
                this.target.print(" (");
                this.target.print(values2.toString(true, ","));
                this.target.print(")");
            }
            this.target.print(": ");
            this.target.println(Values.valToString(object));
        }

        @Override
        public void end() {
            if (this.printProperty) {
                this.target.println(this.property.toString());
            }
            super.end();
        }
    }

    public static class ResultsExporterMatrix
    extends ResultsExporter {
        ExportFormat style;

        public ResultsExporterMatrix(ExportFormat exportFormat) {
            this.style = exportFormat;
        }

        @Override
        protected void printPropertyHeading() {
            if (this.property != null) {
                this.target.println(this.style.printHeader(this.property.toString()));
            }
        }

        @Override
        public void exportResultsCollection(ResultsCollection resultsCollection, PrintWriter printWriter) {
            this.target = printWriter;
            this.start();
            this.target.println(resultsCollection.toStringMatrix(this.style.separator));
            this.end();
        }

        @Override
        public void exportResult(Values values, Object object) {
        }
    }

    public static class ResultsExporterDataFrame
    extends ResultsExporter {
        public static final String PROPERTY_COLUMN = "Property";
        public static final String RESULT_COLUMN = "Result";
        boolean multipleResultCollections = true;
        String propertyColumn = "Property";
        String resultColumn = "Result";
        Set<String> columns = new LinkedHashSet<String>();
        Map<String, Integer> columnIndices = new HashMap<String, Integer>();

        @Override
        public void printResults(List<ResultsCollection> list, List<Property> list2, PrintWriter printWriter) {
            this.multipleResultCollections = true;
            this.initializeColumns(list);
            this.printHeader(printWriter);
            super.printResults(list, this.disambiguatePropertyNames(list2), printWriter);
            this.resetColumns();
            this.multipleResultCollections = false;
        }

        protected void initializeColumns(List<ResultsCollection> list) {
            this.resetColumns();
            HashSet<String> hashSet = new HashSet<String>();
            for (ResultsCollection resultsCollection : list) {
                Vector<DefinedConstant> vector = resultsCollection.getRangingConstants();
                this.addConstantsToColumns(vector);
                hashSet.add(resultsCollection.getResultName());
            }
            this.propertyColumn = this.disambiguateName(PROPERTY_COLUMN, this.columns);
            this.resultColumn = this.disambiguateName(hashSet.size() == 1 ? (String)hashSet.iterator().next() : RESULT_COLUMN, this.columns);
        }

        protected String disambiguateName(String string, Collection<String> collection) {
            Object object = string;
            int n = 1;
            while (collection.contains(object)) {
                object = string + "_" + n++;
            }
            return object;
        }

        protected void resetColumns() {
            this.columns.clear();
            this.propertyColumn = PROPERTY_COLUMN;
            this.resultColumn = RESULT_COLUMN;
        }

        protected void addConstantsToColumns(List<DefinedConstant> list) {
            for (DefinedConstant definedConstant : list) {
                String string = definedConstant.getName();
                if (this.columns.contains(string)) continue;
                this.columns.add(string);
            }
        }

        protected void printHeader(PrintWriter printWriter) {
            printWriter.print(PROPERTY_COLUMN);
            printWriter.print(ExportFormat.CSV.separator);
            for (String string : this.columns) {
                printWriter.print(string);
                printWriter.print(ExportFormat.CSV.separator);
            }
            printWriter.println(this.resultColumn);
        }

        protected List<Property> disambiguatePropertyNames(List<Property> list) {
            int n;
            Object object;
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                object = (Property)list.get(i).deepCopy();
                Object object2 = ((Property)object).getName();
                if (object2 == null || ((String)object2).isEmpty()) {
                    object2 = "Property_" + (i + 1);
                    ((Property)object).setName((String)object2);
                }
                arrayList.add((Property)object);
                n = hashMap.getOrDefault(object2, 0);
                hashMap.put(object2, n + 1);
            }
            block1: for (Property property : arrayList) {
                object = property.getName();
                int n3 = (Integer)hashMap.get(object);
                if (n3 <= 1) continue;
                for (n = 1; n <= n3; ++n) {
                    String string = (String)object + "_" + n;
                    if (hashMap.containsKey(string)) continue;
                    property.setName(string);
                    hashMap.put(string, 1);
                    continue block1;
                }
            }
            return arrayList;
        }

        @Override
        protected void printCollectionSeparator(PrintWriter printWriter) {
        }

        @Override
        protected void printPropertyHeading() {
        }

        @Override
        public void start() {
            this.initializeColumnIndices();
            if (!this.multipleResultCollections) {
                this.addConstantsToColumns(this.rangingConstants);
                this.printHeader(this.target);
                this.resetColumns();
                String string = this.property.getName();
                if (string == null || string.isEmpty()) {
                    this.property = (Property)this.property.deepCopy();
                    this.property.setName("Property_1");
                }
            }
            super.start();
        }

        protected void initializeColumnIndices() {
            this.columnIndices.clear();
            int n = this.rangingConstants.size();
            for (int i = 0; i < n; ++i) {
                this.columnIndices.put(((DefinedConstant)this.rangingConstants.get(i)).getName(), i);
            }
        }

        @Override
        public void exportResult(Values values, Object object) {
            this.target.print(this.property.getName().toString());
            this.target.print(ExportFormat.CSV.separator);
            for (String string : this.columns) {
                if (this.columnIndices.containsKey(string)) {
                    Object object2 = values.getValue(this.columnIndices.get(string));
                    this.target.print(Values.valToString(object2));
                }
                this.target.print(ExportFormat.CSV.separator);
            }
            this.target.println(Values.valToString(object));
        }
    }

    public static class ResultsExporterList
    extends ResultsExporter {
        ExportFormat style;

        public ResultsExporterList(ExportFormat exportFormat) {
            this.style = exportFormat;
        }

        @Override
        protected void printPropertyHeading() {
            if (this.property != null) {
                this.target.println(this.style.printHeader(this.property.toString()));
            }
        }

        @Override
        public void start() {
            super.start();
            if (this.rangingConstants != null) {
                for (int i = 0; i < this.rangingConstants.size(); ++i) {
                    if (i > 0) {
                        this.target.print(this.style.separator);
                    }
                    this.target.print(((DefinedConstant)this.rangingConstants.get(i)).getName());
                }
                if (this.rangingConstants.size() > 0) {
                    this.target.print(this.style.separator);
                }
                this.target.println("Result");
            }
        }

        @Override
        public void exportResult(Values values, Object object) {
            this.target.print(values.toString(false, this.style.separator));
            if (values.getNumValues() > 0) {
                this.target.print(this.style.separator);
            }
            this.target.println(Values.valToString(object));
        }
    }

    public static enum ExportFormat {
        PLAIN("\t"){

            @Override
            public String quote(String string) {
                return string;
            }

            @Override
            public String printHeader(String string) {
                return string + ":";
            }
        }
        ,
        CSV(","){

            @Override
            public String quote(String string) {
                return "\"" + string.replaceAll("\"", "\"\"") + "\"";
            }

            @Override
            public String printHeader(String string) {
                return this.quote(string);
            }
        };

        public final String separator;

        private ExportFormat(String string2) {
            this.separator = string2;
        }

        public abstract String quote(String var1);

        public abstract String printHeader(String var1);
    }

    public static enum ResultsExportShape {
        LIST_PLAIN("list (plain text)", false, false){

            @Override
            public ResultsExporter getExporter() {
                return new ResultsExporterList(ExportFormat.PLAIN);
            }
        }
        ,
        LIST_CSV("list (CSV)", false, true){

            @Override
            public ResultsExporter getExporter() {
                return new ResultsExporterList(ExportFormat.CSV);
            }
        }
        ,
        MATRIX_PLAIN("matrix (plain text)", true, false){

            @Override
            public ResultsExporter getExporter() {
                return new ResultsExporterMatrix(ExportFormat.PLAIN);
            }
        }
        ,
        MATRIX_CSV("matrix (CSV)", true, true){

            @Override
            public ResultsExporter getExporter() {
                return new ResultsExporterMatrix(ExportFormat.CSV);
            }
        }
        ,
        DATA_FRAME("data frame (CSV)", true, true){

            @Override
            public ResultsExporter getExporter() {
                return new ResultsExporterDataFrame();
            }
        }
        ,
        COMMENT("comment", false, false){

            @Override
            public ResultsExporter getExporter() {
                return new ResultsExporterComment();
            }
        };

        public final String fullName;
        public final boolean isMatrix;
        public final boolean isCSV;

        private ResultsExportShape(String string2, boolean bl, boolean bl2) {
            this.fullName = string2;
            this.isMatrix = bl;
            this.isCSV = bl2;
        }

        public abstract ResultsExporter getExporter();
    }
}

