/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Element;
import parser.PrismParser;
import prism.MathML2Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLanguageTranslator;
import prism.PrismLog;
import prism.PrismUtils;

public abstract class Reactions2Prism
extends PrismLanguageTranslator {
    protected PrismLog mainLog = null;
    protected String compartmentName;
    protected String speciesId;
    protected String initialAmountString;
    protected double compartmentSize;
    protected ArrayList<Species> speciesList;
    protected ArrayList<Parameter> parameterList;
    protected ArrayList<Reaction> reactionList;
    protected int maxAmount = 100;
    protected String prismCodeHeader;
    protected String prismCodeFooter;

    public Reactions2Prism() {
        this(new PrismFileLog("stdout"));
    }

    public Reactions2Prism(PrismLog prismLog) {
        this.mainLog = prismLog;
    }

    public void setMaxAmount(int n) {
        this.maxAmount = n;
    }

    protected void printModel(PrintStream printStream) {
        printStream.println(this.speciesList.size() + " species: " + this.speciesList);
        if (this.parameterList.size() > 0) {
            printStream.println(this.parameterList.size() + " parameters: " + this.parameterList);
        }
        int n = this.reactionList.size();
        printStream.println(n + " reactions:");
        for (int i = 0; i < n; ++i) {
            Reaction reaction = this.reactionList.get(i);
            printStream.print(" * " + reaction);
        }
    }

    protected void convertToPRISMCode(PrintStream printStream) throws PrismException {
        StringBuilder stringBuilder = this.convertToPRISMCode();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(printStream), "utf-8");
            outputStreamWriter.append(stringBuilder);
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new PrismException("Error writing to output stream");
        }
    }

    protected void convertToPRISMCode(File file) throws PrismException {
        StringBuilder stringBuilder = this.convertToPRISMCode();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.append(stringBuilder);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Error writing to file \"" + file + "\"");
        }
    }

    protected StringBuilder convertToPRISMCode() throws PrismException {
        this.processModel();
        return this.generatePRISMCode();
    }

    private void processModel() throws PrismException {
        int n;
        Object object;
        String string;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Species arrayList3 : this.speciesList) {
            if (arrayList2.contains(arrayList3.id)) {
                throw new PrismException("Duplicate species id \"" + arrayList3.id + "\"");
            }
            arrayList2.add(arrayList3.id);
        }
        ArrayList arrayList4 = new ArrayList();
        for (Parameter parameter : this.parameterList) {
            if (arrayList4.contains(parameter.name)) {
                throw new PrismException("Duplicate parameter name \"" + parameter.name + "\"");
            }
            arrayList4.add(parameter.name);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Reaction reaction : this.reactionList) {
            if (arrayList.contains(reaction.id)) {
                throw new PrismException("Duplicate reaction id \"" + reaction.id + "\"");
            }
            arrayList.add(reaction.id);
        }
        for (Species species : this.speciesList) {
            if (!(species.init > (double)this.maxAmount)) continue;
            this.maxAmount = (int)species.init;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (Species species : this.speciesList) {
            string = species.id;
            object = Reactions2Prism.convertToValidPrismIdent(string);
            if (!string.equals(object)) {
                this.mainLog.printWarning("Converted species id \"" + string + "\" to \"" + (String)object + "\" (invalid PRISM identifier)");
            }
            if (!hashSet.add(object)) {
                n = 2;
                while (!hashSet.add((String)object + "_" + n)) {
                    ++n;
                }
                object = (String)object + "_" + n;
                this.mainLog.printWarning("Converted species id \"" + string + "\" to \"" + (String)object + "\" (duplicate PRISM identifiers)");
            }
            species.prismName = object;
            hashSet2.add(object);
        }
        for (Parameter parameter : this.parameterList) {
            string = parameter.name;
            object = Reactions2Prism.convertToValidPrismIdent(string);
            if (!string.equals(object)) {
                this.mainLog.printWarning("Converted parameter id \"" + string + "\" to \"" + (String)object + "\" (invalid PRISM identifier)");
            }
            if (!hashSet.add(object)) {
                n = 2;
                while (!hashSet2.add((String)object + "_" + n)) {
                    ++n;
                }
                object = (String)object + "_" + n;
                this.mainLog.printWarning("Converted parameter id \"" + string + "\" to \"" + (String)object + "\" (duplicate PRISM identifiers)");
            }
            parameter.prismName = object;
            hashSet2.add(object);
        }
        for (Reaction reaction : this.reactionList) {
            int n2 = reaction.parameters.size();
            for (n = 0; n < n2; ++n) {
                string = reaction.parameters.get((int)n).name;
                object = Reactions2Prism.convertToValidPrismIdent(string);
                if (!string.equals(object)) {
                    this.mainLog.printWarning("Converted parameter id \"" + string + "\" to \"" + (String)object + "\" (invalid PRISM identifier)");
                }
                if (!hashSet2.add(object)) {
                    int n3 = 2;
                    while (!hashSet2.add((String)object + "_" + n3)) {
                        ++n3;
                    }
                    object = (String)object + "_" + n3;
                    this.mainLog.printWarning("Converted parameter id \"" + string + "\" to \"" + (String)object + "\" (duplicate PRISM identifiers)");
                }
                reaction.parameters.get((int)n).prismName = object;
            }
        }
    }

    private StringBuilder generatePRISMCode() throws PrismException {
        Species species;
        int n;
        int n2;
        Reaction reaction;
        Parameter parameter;
        int n3;
        int n4;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prismCodeHeader != null) {
            stringBuilder.append(this.prismCodeHeader);
        }
        stringBuilder.append("ctmc\n");
        stringBuilder.append("\nconst int MAX_AMOUNT = " + this.maxAmount + ";\n");
        if (this.compartmentName != null) {
            stringBuilder.append("\n// Compartment size\n");
            stringBuilder.append("const double " + this.compartmentName + " = " + this.compartmentSize + ";\n");
        }
        if ((n4 = this.parameterList.size()) > 0) {
            stringBuilder.append("\n// Model parameters\n");
        }
        for (n3 = 0; n3 < n4; ++n3) {
            parameter = this.parameterList.get(n3);
            stringBuilder.append("const double " + parameter.prismName);
            if (parameter.value != null && parameter.value.length() > 0) {
                stringBuilder.append(" = " + parameter.value);
            }
            stringBuilder.append("; // " + parameter.name + "\n");
        }
        n4 = this.reactionList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            reaction = this.reactionList.get(n3);
            n2 = reaction.parameters.size();
            if (n2 > 0) {
                stringBuilder.append("\n// Parameters for reaction " + reaction.id + "\n");
            }
            for (n = 0; n < n2; ++n) {
                parameter = reaction.parameters.get(n);
                stringBuilder.append("const double " + parameter.prismName);
                if (parameter.value != null && parameter.value.length() > 0) {
                    stringBuilder.append(" = " + parameter.value);
                }
                stringBuilder.append("; // " + parameter.name + "\n");
            }
        }
        n4 = this.speciesList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            species = this.speciesList.get(n3);
            if (species.boundaryCondition) continue;
            stringBuilder.append("\n// Species " + species + "\n");
            stringBuilder.append("const int " + species.prismName + "_MAX = MAX_AMOUNT;\n");
            stringBuilder.append("module " + species.prismName + "\n");
            stringBuilder.append("\t\n\t" + species.prismName + " : [0.." + species.prismName + "_MAX]");
            stringBuilder.append(" init " + (int)species.init + "; // Initial amount " + (int)species.init + "\n\t\n");
            n2 = this.reactionList.size();
            for (n = 0; n < n2; ++n) {
                reaction = this.reactionList.get(n);
                if (!reaction.isSpeciesInvolved(species.id)) continue;
                stringBuilder.append("\t// " + reaction.id);
                if (reaction.name.length() > 0) {
                    stringBuilder.append(" (" + reaction.name + ")");
                }
                stringBuilder.append("\n");
                stringBuilder.append("\t[" + reaction.id + "] ");
                int n5 = reaction.before(species.id);
                int n6 = reaction.after(species.id);
                if (n5 > 0) {
                    stringBuilder.append(species.prismName + " > " + (n5 - 1));
                }
                if (n6 - n5 > 0) {
                    if (n5 > 0) {
                        stringBuilder.append(" &");
                    }
                    stringBuilder.append(" " + species.prismName + " <= " + species.prismName + "_MAX-" + (n6 - n5));
                }
                stringBuilder.append(" -> (" + species.prismName + "'=" + species.prismName);
                if (n6 - n5 > 0) {
                    stringBuilder.append("+" + (n6 - n5));
                }
                if (n6 - n5 < 0) {
                    stringBuilder.append(n6 - n5);
                }
                stringBuilder.append(");\n");
                if (!reaction.reversible) continue;
                stringBuilder.append("\t// " + reaction.id);
                if (reaction.name.length() > 0) {
                    stringBuilder.append(" (" + reaction.name + ")");
                }
                stringBuilder.append(" (reverse)\n");
                stringBuilder.append("\t[" + reaction.id + "_rev] ");
                n5 = reaction.after(species.id);
                n6 = reaction.before(species.id);
                if (n5 > 0) {
                    stringBuilder.append(species.prismName + " > " + (n5 - 1));
                }
                if (n6 - n5 > 0) {
                    if (n5 > 0) {
                        stringBuilder.append(" &");
                    }
                    stringBuilder.append(" " + species.prismName + " <= " + species.prismName + "_MAX-" + (n6 - n5));
                }
                stringBuilder.append(" -> (" + species.prismName + "'=" + species.prismName);
                if (n6 - n5 > 0) {
                    stringBuilder.append("+" + (n6 - n5));
                }
                if (n6 - n5 < 0) {
                    stringBuilder.append(n6 - n5);
                }
                stringBuilder.append(");\n");
            }
            stringBuilder.append("\t\nendmodule\n");
        }
        stringBuilder.append("\n// Reaction rates\nmodule reaction_rates\n\n");
        n4 = this.reactionList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            reaction = this.reactionList.get(n3);
            arrayList.clear();
            arrayList2.clear();
            n2 = this.speciesList.size();
            for (n = 0; n < n2; ++n) {
                species = this.speciesList.get(n);
                if (species.id.equals(species.prismName)) continue;
                arrayList.add(species.id);
                arrayList2.add(species.prismName);
            }
            n2 = reaction.parameters.size();
            for (n = 0; n < n2; ++n) {
                parameter = reaction.parameters.get(n);
                if (parameter.name.equals(parameter.prismName)) continue;
                arrayList.add(parameter.name);
                arrayList2.add(parameter.prismName);
            }
            n2 = this.parameterList.size();
            for (n = 0; n < n2; ++n) {
                parameter = this.parameterList.get(n);
                if (parameter.name.equals(parameter.prismName)) continue;
                arrayList.add(parameter.name);
                arrayList2.add(parameter.prismName);
            }
            stringBuilder.append("\t// " + reaction.id);
            if (reaction.name.length() > 0) {
                stringBuilder.append(" (" + reaction.name + ")");
            }
            stringBuilder.append(": " + reaction.reactionString());
            stringBuilder.append("\n");
            String string = reaction.kineticLawString != null ? reaction.kineticLawString : MathML2Prism.convert(reaction.kineticLaw, arrayList, arrayList2);
            stringBuilder.append("\t[" + reaction.id + "] " + string + " > 0 -> " + string + " : true;\n");
            if (!reaction.reversible) continue;
            stringBuilder.append("\t// " + reaction.id);
            if (reaction.name.length() > 0) {
                stringBuilder.append(" (" + reaction.name + ")");
            }
            stringBuilder.append(": " + reaction.reactionString());
            stringBuilder.append(" (reverse)\n");
            string = reaction.kineticLawReverseString != null ? reaction.kineticLawReverseString : MathML2Prism.convert(reaction.kineticLawReverse, arrayList, arrayList2);
            stringBuilder.append("\t[" + reaction.id + "_rev] " + string + " > 0 -> " + string + " : true;\n");
        }
        stringBuilder.append("\nendmodule\n");
        stringBuilder.append("\n// Reward structures (one per species)\n\n");
        n4 = this.speciesList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            species = this.speciesList.get(n3);
            if (species.boundaryCondition) continue;
            stringBuilder.append("// Reward " + (n3 + 1) + ": " + species + "\nrewards \"" + species.prismName + "\" true : " + species.prismName + "; endrewards\n");
        }
        if (this.prismCodeFooter != null) {
            stringBuilder.append(this.prismCodeFooter);
        }
        return stringBuilder;
    }

    protected static boolean isValidPrismIdent(String string) {
        if (!string.matches("[_a-zA-Z_][_a-zA-Z0-9]*")) {
            return false;
        }
        return !PrismParser.isKeyword(string);
    }

    protected static String convertToValidPrismIdent(String string) {
        Object object = !string.matches("[_a-zA-Z_][_a-zA-Z0-9]*") ? string.replaceAll("[^_a-zA-Z0-9]", "") : string;
        if (PrismParser.isKeyword((String)object)) {
            object = "_" + (String)object;
        }
        return object;
    }

    class Reaction {
        public String id;
        public String name;
        public ArrayList<String> reactants;
        public ArrayList<Integer> reactantStoichs;
        public ArrayList<String> products;
        public ArrayList<Integer> productStoichs;
        public boolean reversible;
        public Element kineticLaw;
        public String kineticLawString;
        public Element kineticLawReverse;
        public String kineticLawReverseString;
        public ArrayList<Parameter> parameters;

        public Reaction(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.reactants = new ArrayList();
            this.reactantStoichs = new ArrayList();
            this.products = new ArrayList();
            this.productStoichs = new ArrayList();
            this.reversible = false;
            this.kineticLaw = null;
            this.kineticLawString = null;
            this.kineticLawReverse = null;
            this.kineticLawReverseString = null;
            this.parameters = new ArrayList();
        }

        public void addReactant(String string) {
            this.addReactant(string, 1);
        }

        public void addReactant(String string, int n) {
            int n2 = this.reactants.indexOf(string);
            if (n2 == -1) {
                this.reactants.add(string);
                this.reactantStoichs.add(n);
            } else {
                this.reactantStoichs.set(n2, this.reactantStoichs.get(n2) + n);
            }
        }

        public void addProduct(String string) {
            this.addProduct(string, 1);
        }

        public void addProduct(String string, int n) {
            int n2 = this.products.indexOf(string);
            if (n2 == -1) {
                this.products.add(string);
                this.productStoichs.add(n);
            } else {
                this.productStoichs.set(n2, this.productStoichs.get(n2) + n);
            }
        }

        public void setReversible(boolean bl) {
            this.reversible = bl;
        }

        public void setKineticLaw(Element element) {
            this.kineticLaw = element;
            this.kineticLawString = null;
        }

        public void setKineticLawString(String string) {
            this.kineticLawString = string;
            this.kineticLaw = null;
        }

        public void setKineticLawReverse(Element element) {
            this.kineticLawReverse = element;
            this.kineticLawReverseString = null;
        }

        public void setKineticLawReverseString(String string) {
            this.kineticLawReverseString = string;
            this.kineticLawReverse = null;
        }

        public void addParameter(String string, String string2) {
            this.parameters.add(new Parameter(string, string2));
        }

        public boolean isSpeciesInvolved(String string) {
            return this.reactants.contains(string) || this.products.contains(string);
        }

        public int before(String string) {
            int n = this.reactants.indexOf(string);
            if (n == -1) {
                return 0;
            }
            return this.reactantStoichs.get(n);
        }

        public int after(String string) {
            int n = this.products.indexOf(string);
            if (n == -1) {
                return 0;
            }
            return this.productStoichs.get(n);
        }

        public String reactionString() {
            Object object = PrismUtils.joinString(this.reactants, "+");
            object = (String)object + " -> " + PrismUtils.joinString(this.products, "+");
            return object;
        }

        public String toString() {
            Object object = "";
            object = (String)object + this.id;
            if (this.name.length() > 0) {
                object = (String)object + " (" + this.name + ")";
            }
            object = (String)object + ":\n";
            object = (String)object + "    Reactants: " + this.reactants + "\n";
            object = (String)object + "    Reactants stoichiometry: " + this.productStoichs + "\n";
            object = (String)object + "    Products: " + this.products + "\n";
            object = (String)object + "    Products stoichiometry: " + this.productStoichs + "\n";
            object = (String)object + "    Kinetic law: " + (this.kineticLawString != null ? this.kineticLawString : this.kineticLaw) + "\n";
            if (this.reversible) {
                object = (String)object + "    Reverse kinetic law: " + (this.kineticLawReverseString != null ? this.kineticLawReverseString : this.kineticLawReverse) + "\n";
            }
            object = (String)object + "    Parameters: " + this.parameters + "\n";
            return object;
        }
    }

    class Species {
        public String id;
        public String name;
        public double init;
        public String prismName;
        public boolean boundaryCondition;

        public Species(String string, String string2, double d) {
            this.id = string;
            this.name = string2;
            this.init = d;
            this.prismName = null;
            this.boundaryCondition = false;
        }

        public String toString() {
            return this.id + (String)(this.name != null && this.name.length() > 0 ? " (" + this.name + ")" : "");
        }
    }

    class Parameter {
        public String name;
        public String value;
        public String prismName;

        public Parameter(String string, String string2) {
            this.name = string;
            this.value = string2;
            this.prismName = null;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }
}

