/*
 * Decompiled with CFR 0.152.
 */
package prism;

import prism.PrismLog;

public class ProgressDisplay {
    private PrismLog mainLog;
    private int delay = 3000;
    private int percentMultiple = 2;
    private long totalCount;
    private long lastCount;
    private long lastPercentageDone;
    private long timerProgress;
    private boolean first;

    public ProgressDisplay(PrismLog prismLog) {
        this.mainLog = prismLog;
    }

    public void start() {
        this.totalCount = -1L;
        this.lastCount = 0L;
        this.lastPercentageDone = 0L;
        this.timerProgress = System.currentTimeMillis();
        this.first = true;
    }

    public void setTotalCount(long l) {
        this.totalCount = l;
    }

    public boolean ready() {
        return System.currentTimeMillis() - this.timerProgress > (long)this.delay;
    }

    public void updateIfReady(long l) {
        if (this.ready()) {
            this.update(l);
        }
    }

    public void update(long l) {
        if (this.totalCount != -1L) {
            int n;
            if (l >= this.totalCount) {
                n = 100;
            } else {
                n = (int)Math.floor(100.0 * (double)l / (double)this.totalCount);
                n = n / this.percentMultiple * this.percentMultiple;
            }
            if ((long)n > this.lastPercentageDone) {
                if (this.first) {
                    this.mainLog.print("[");
                    this.first = false;
                }
                this.lastPercentageDone = n;
                this.mainLog.print(" " + n + "%");
                this.mainLog.flush();
                this.timerProgress = System.currentTimeMillis();
            }
        } else if (l > this.lastCount) {
            this.lastCount = l;
            this.mainLog.print(" " + l);
            this.mainLog.flush();
            this.timerProgress = System.currentTimeMillis();
        }
    }

    public void end() {
        this.end("");
    }

    public void end(String string) {
        this.mainLog.print(string);
        if (this.totalCount != -1L) {
            this.mainLog.print(" ]");
        }
        this.mainLog.println();
    }
}

