/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceReachDD;
import acceptance.AcceptanceType;
import automata.DA;
import common.StopWatch;
import dv.DoubleVector;
import explicit.ExportIterations;
import hybrid.PrismHybrid;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import parser.ast.Expression;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import parser.ast.RelOp;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import parser.type.TypePathDouble;
import prism.AccuracyFactory;
import prism.IntegerBound;
import prism.LTLModelChecker;
import prism.Model;
import prism.ModelType;
import prism.NonProbModelChecker;
import prism.NondetModel;
import prism.OpRelOpBound;
import prism.OptionsIntervalIteration;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ProbModel;
import prism.SCCComputer;
import prism.StateValues;
import prism.StateValuesDV;
import prism.StateValuesMTBDD;
import sparse.PrismSparse;

public class ProbModelChecker
extends NonProbModelChecker {
    protected ProbModel model;
    protected boolean precomp;
    protected boolean prob0;
    protected boolean prob1;
    protected boolean bsccComp;

    public ProbModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
        if (!(model instanceof ProbModel)) {
            throw new PrismException("Wrong model type passed to ProbModelChecker.");
        }
        this.model = (ProbModel)model;
        this.precomp = prism.getPrecomp();
        this.prob0 = prism.getProb0();
        this.prob1 = prism.getProb1();
        this.bsccComp = prism.getBSCCComp();
        PrismNative.setCompact(prism.getCompact());
        PrismNative.setLinEqMethod(prism.getLinEqMethod());
        PrismNative.setLinEqMethodParam(prism.getLinEqMethodParam());
        PrismNative.setTermCrit(prism.getTermCrit());
        PrismNative.setTermCritParam(prism.getTermCritParam());
        PrismNative.setMaxIters(prism.getMaxIters());
        PrismNative.setSBMaxMem(prism.getSBMaxMem());
        PrismNative.setNumSBLevels(prism.getNumSBLevels());
        PrismNative.setSORMaxMem(prism.getSORMaxMem());
        PrismNative.setNumSORLevels(prism.getNumSORLevels());
        PrismNative.setDoSSDetect(prism.getDoSSDetect());
        PrismNative.setExportAdv(prism.getExportAdv());
        PrismNative.setExportAdvFilename(prism.getExportAdvFilename());
    }

    public ProbModelChecker createNewModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        return new ProbModelChecker(prism, model, propertiesFile);
    }

    @Override
    public StateValues checkExpression(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionProb ? this.checkExpressionProb((ExpressionProb)expression, jDDNode) : (expression instanceof ExpressionReward ? this.checkExpressionReward((ExpressionReward)expression, jDDNode) : (expression instanceof ExpressionSS ? this.checkExpressionSteadyState((ExpressionSS)expression, jDDNode) : super.checkExpression(expression, jDDNode)));
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb, JDDNode jDDNode) throws PrismException {
        OpRelOpBound opRelOpBound = expressionProb.getRelopBoundInfo(this.constantValues);
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            JDD.Deref(jDDNode);
            return new StateValuesMTBDD(this.reach, this.model, AccuracyFactory.doublesFromQualitative());
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            JDD.Deref(jDDNode);
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model, AccuracyFactory.doublesFromQualitative());
        }
        if (opRelOpBound.getRelOp() == RelOp.MIN || opRelOpBound.getRelOp() == RelOp.MAX) {
            this.mainLog.printWarning("\"Pmin=?\" and \"Pmax=?\" operators are identical to \"P=?\" for DTMCs/CTMCs");
        }
        boolean bl = opRelOpBound.isQualitative() && this.precomp && this.prob0 && this.prob1;
        StateValues stateValues = this.checkProbPathFormula(expressionProb.getExpression(), bl, jDDNode);
        if (this.prism.getVerbose()) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        JDDNode jDDNode2 = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode2 = JDD.And(jDDNode2, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD(jDDNode2, this.model);
    }

    protected StateValues checkExpressionReward(ExpressionReward expressionReward, JDDNode jDDNode) throws PrismException {
        Object object;
        if (expressionReward.getRewardStructIndexDiv() != null) {
            throw new PrismException("Ratio rewards not supported with the selected engine and module type.");
        }
        OpRelOpBound opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
        Object object2 = expressionReward.getRewardStructIndex();
        JDDNode jDDNode2 = this.getStateRewardsByIndexObject(object2, this.model, this.constantValues);
        JDDNode jDDNode3 = this.getTransitionRewardsByIndexObject(object2, this.model, this.constantValues);
        if (opRelOpBound.getRelOp() == RelOp.MIN || opRelOpBound.getRelOp() == RelOp.MAX) {
            this.mainLog.printWarning("\"Rmin=?\" and \"Rmax=?\" operators are identical to \"R=?\" for DTMCs/CTMCs");
        }
        StateValues stateValues = null;
        Expression expression = expressionReward.getExpression();
        if (expression.getType() instanceof TypePathDouble) {
            object = (ExpressionTemporal)expression;
            switch (((ExpressionTemporal)object).getOperator()) {
                case 11: {
                    if (((ExpressionTemporal)object).hasBounds()) {
                        stateValues = this.checkRewardCumul((ExpressionTemporal)object, jDDNode2, jDDNode3, jDDNode);
                        break;
                    }
                    stateValues = this.checkRewardTotal((ExpressionTemporal)object, jDDNode2, jDDNode3, jDDNode);
                    break;
                }
                case 12: {
                    stateValues = this.checkRewardInst((ExpressionTemporal)object, jDDNode2, jDDNode3, jDDNode);
                    break;
                }
                case 14: {
                    stateValues = this.checkRewardSS((ExpressionTemporal)object, jDDNode2, jDDNode3, jDDNode);
                }
            }
        } else if (expression.getType() instanceof TypePathBool || expression.getType() instanceof TypeBool) {
            stateValues = this.checkRewardPathFormula(expression, jDDNode2, jDDNode3, jDDNode);
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        if (this.prism.getVerbose()) {
            this.mainLog.print("\nRewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        object = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        object = JDD.And((JDDNode)object, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD((JDDNode)object, this.model);
    }

    protected StateValues checkExpressionSteadyState(ExpressionSS expressionSS, JDDNode jDDNode) throws PrismException {
        int n;
        List<Object> list = null;
        JDDNode jDDNode2 = null;
        JDDNode jDDNode3 = null;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n2 = 0;
        JDD.Deref(jDDNode);
        OpRelOpBound opRelOpBound = expressionSS.getRelopBoundInfo(this.constantValues);
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            return new StateValuesMTBDD(this.reach, this.model, AccuracyFactory.doublesFromQualitative());
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model, AccuracyFactory.doublesFromQualitative());
        }
        try {
            JDDNode jDDNode4;
            jDDNode3 = this.checkExpressionDD(expressionSS.getExpression(), this.model.getReach().copy());
            if (this.bsccComp) {
                SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
                sCCComputer.computeBSCCs();
                list = sCCComputer.getBSCCs();
                jDDNode2 = sCCComputer.getNotInBSCCs();
                n2 = list.size();
            } else {
                this.mainLog.println("\nSkipping BSCC computation...");
                list = new Vector();
                JDD.Ref(this.reach);
                list.add(this.reach);
                jDDNode2 = JDD.Constant(0.0);
                n2 = 1;
            }
            double[] dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                double d;
                this.mainLog.println("\nComputing steady state probabilities for BSCC " + (n + 1));
                jDDNode4 = (JDDNode)list.get(n);
                stateValues = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode4);
                if (this.verbose) {
                    this.mainLog.print("\nBSCC " + (n + 1) + " steady-state probabilities: \n");
                    stateValues.print(this.mainLog);
                }
                dArray[n] = d = stateValues.sumOverBDD(jDDNode3);
                this.mainLog.print("\nBSCC " + (n + 1) + " probability: " + d + "\n");
                stateValues.clear();
            }
            if (jDDNode2.equals(JDD.ZERO)) {
                this.mainLog.println("\nAll states are in BSCCs (so no reachability probabilities computed)");
                JDDNode jDDNode5 = JDD.Constant(0.0);
                for (n = 0; n < n2; ++n) {
                    jDDNode4 = (JDDNode)list.get(n);
                    JDD.Ref(jDDNode4);
                    jDDNode5 = JDD.Apply(1, jDDNode5, JDD.Apply(3, JDD.Constant(dArray[n]), jDDNode4));
                }
                stateValues2 = new StateValuesMTBDD(jDDNode5, this.model);
            } else {
                switch (this.engine) {
                    case 1: {
                        stateValues2 = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
                        break;
                    }
                    case 2: {
                        stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                        break;
                    }
                    case 3: {
                        stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                    }
                }
                for (n = 0; n < n2; ++n) {
                    if (dArray[n] == 0.0) continue;
                    this.mainLog.println("\nComputing probabilities of reaching BSCC " + (n + 1));
                    jDDNode4 = (JDDNode)list.get(n);
                    stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode4);
                    if (this.verbose) {
                        this.mainLog.print("\nBSCC " + (n + 1) + " reachability probabilities: \n");
                        stateValues.print(this.mainLog);
                    }
                    stateValues.timesConstant(dArray[n]);
                    stateValues2.add(stateValues);
                    stateValues.clear();
                }
            }
            if (this.verbose) {
                this.mainLog.print("\nS operator probabilities: \n");
                stateValues2.print(this.mainLog);
            }
        }
        catch (PrismException prismException) {
            if (jDDNode3 != null) {
                JDD.Deref(jDDNode3);
            }
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) == null) continue;
                JDD.Deref((JDDNode)list.get(i));
            }
            if (jDDNode2 != null) {
                JDD.Deref(jDDNode2);
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            throw prismException;
        }
        if (jDDNode3 != null) {
            JDD.Deref(jDDNode3);
        }
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == null) continue;
            JDD.Deref((JDDNode)list.get(n));
        }
        if (jDDNode2 != null) {
            JDD.Deref(jDDNode2);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues2;
        }
        JDDNode jDDNode6 = stateValues2.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode6 = JDD.And(jDDNode6, this.reach);
        stateValues2.clear();
        return new StateValuesMTBDD(jDDNode6, this.model);
    }

    protected StateValues checkProbPathFormula(Expression expression, boolean bl, JDDNode jDDNode) throws PrismException {
        if (Expression.containsRewardBoundedPathFormula(expression)) {
            throw new PrismException("Reward-bounded path formulas not supported");
        }
        boolean bl2 = expression.isSimplePathFormula();
        if (bl2 && this.prism.getSettings().getBoolean("prism.pathViaAutomata") && LTLModelChecker.isSupportedLTLFormula(this.model.getModelType(), expression)) {
            bl2 = false;
        }
        if (bl2) {
            return this.checkProbPathFormulaSimple(expression, bl, jDDNode);
        }
        return this.checkProbPathFormulaLTL(expression, bl, jDDNode);
    }

    protected StateValues checkProbPathFormulaSimple(Expression expression, boolean bl, JDDNode jDDNode) throws PrismException {
        boolean bl2 = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl2 = true;
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(expressionTemporal, jDDNode);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(expressionTemporal, jDDNode) : this.checkProbUntil(expressionTemporal, bl, jDDNode);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl2) {
            stateValues.subtractFromOne();
        }
        return stateValues;
    }

    protected StateValues checkProbPathFormulaLTL(Expression expression, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        AcceptanceOmegaDD acceptanceOmegaDD;
        DA<BitSet, ? extends AcceptanceOmega> dA;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        Vector<JDDNode> vector = new Vector<JDDNode>();
        if (Expression.containsRewardBoundedPathFormula(expression)) {
            throw new PrismException("Automaton construction for reward-bounded path formulas not supported");
        }
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.REACH, AcceptanceType.BUCHI, AcceptanceType.RABIN, AcceptanceType.STREETT, AcceptanceType.GENERALIZED_RABIN, AcceptanceType.GENERIC};
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        try {
            dA = lTLModelChecker.constructDAForLTLFormula(this, this.model, expression, vector, acceptanceTypeArray);
        }
        catch (Exception exception) {
            JDD.Deref(jDDNode);
            throw exception;
        }
        this.mainLog.println("\nConstructing MC-" + dA.getAutomataType() + " product...");
        JDDVars jDDVars = new JDDVars();
        JDDVars jDDVars2 = new JDDVars();
        ProbModel probModel = lTLModelChecker.constructProductMC(dA, this.model, vector, jDDVars, jDDVars2, jDDNode);
        this.mainLog.println();
        probModel.printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        if (this.prism.getExportProductTrans()) {
            try {
                int n = this.getSettings().getInteger("prism.exportModelPrecision");
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                probModel.exportToFile(1, true, new File(this.prism.getExportProductTransFilename()), n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            PrismFileLog prismFileLog = new PrismFileLog(this.prism.getExportProductStatesFilename());
            probModel.exportStates(1, prismFileLog);
            prismFileLog.close();
        }
        if ((acceptanceOmegaDD = dA.getAcceptance().toAcceptanceDD(jDDVars)) instanceof AcceptanceReachDD) {
            this.mainLog.println("\nSkipping BSCC computation since acceptance is defined via goal states...");
            jDDNode2 = ((AcceptanceReachDD)acceptanceOmegaDD).getGoalStates();
            JDD.Ref(probModel.getReach());
            jDDNode2 = JDD.And(jDDNode2, probModel.getReach());
        } else {
            this.mainLog.println("\nFinding accepting BSCCs...");
            jDDNode2 = lTLModelChecker.findAcceptingBSCCs(acceptanceOmegaDD, probModel);
        }
        acceptanceOmegaDD.clear();
        this.mainLog.println("\nComputing reachability probabilities...");
        ProbModelChecker probModelChecker = this.createNewModelChecker(this.prism, probModel, null);
        stateValues = probModelChecker.checkProbUntil(probModel.getReach(), jDDNode2, bl);
        JDDNode jDDNode3 = lTLModelChecker.buildStartMask(dA, vector, jDDVars);
        JDD.Ref(this.model.getReach());
        jDDNode3 = JDD.And(this.model.getReach(), jDDNode3);
        stateValues.filter(jDDNode3);
        stateValues2 = stateValues.sumOverDDVars(jDDVars, this.model);
        stateValues.clear();
        probModel.clear();
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode3);
        jDDVars.derefAll();
        jDDVars2.derefAll();
        return stateValues2;
    }

    protected StateValues checkProbNext(ExpressionTemporal expressionTemporal, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode);
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        stateValues = this.computeNextProbs(this.trans, jDDNode2);
        JDD.Deref(jDDNode2);
        return stateValues;
    }

    protected StateValues checkProbBoundedUntil(ExpressionTemporal expressionTemporal, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        StateValues stateValues = null;
        JDD.Deref(jDDNode);
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        if (n2 == null) {
            try {
                stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode2);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
        }
        if (n2 == 0) {
            JDD.Ref(jDDNode2);
            stateValues = new StateValuesMTBDD(jDDNode2, this.model, AccuracyFactory.doublesFromQualitative());
        } else {
            try {
                stateValues = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode2, n2);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stateValues = this.computeRestrictedNext(this.trans, jDDNode3, stateValues);
            }
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return stateValues;
    }

    protected StateValues checkProbUntil(ExpressionTemporal expressionTemporal, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        StateValues stateValues = null;
        JDD.Deref(jDDNode);
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        try {
            stateValues = this.checkProbUntil(jDDNode3, jDDNode2, bl);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return stateValues;
    }

    protected StateValues checkProbUntil(JDDNode jDDNode, JDDNode jDDNode2, boolean bl) throws PrismException {
        StateValues stateValues = null;
        if (bl) {
            this.mainLog.print("\nProbability bound in formula is 0/1 so not computing exact probabilities...\n");
            stateValues = this.computeUntilProbsQual(this.trans01, jDDNode, jDDNode2);
        } else {
            stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode, jDDNode2);
        }
        return stateValues;
    }

    protected StateValues checkRewardCumul(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode3);
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismException("Cumulative reward operator without time bound (C) not supported");
        }
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid time bound " + n + " in cumulative reward formula");
        }
        if (n == 0) {
            stateValues = new StateValuesMTBDD(JDD.Constant(0.0), this.model, AccuracyFactory.doublesFromQualitative());
        } else {
            stateValues = this.computeCumulRewards(this.trans, this.trans01, jDDNode, jDDNode2, n);
        }
        return stateValues;
    }

    protected StateValues checkRewardTotal(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        JDD.Deref(jDDNode3);
        StateValues stateValues = this.computeTotalRewards(this.trans, this.trans01, jDDNode, jDDNode2);
        return stateValues;
    }

    protected StateValues checkRewardInst(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode3);
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid bound " + n + " in instantaneous reward property");
        }
        stateValues = this.computeInstRewards(this.trans, jDDNode, n);
        return stateValues;
    }

    protected StateValues checkRewardPathFormula(Expression expression, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        if (Expression.isReach(expression)) {
            return this.checkRewardReach((ExpressionTemporal)expression, jDDNode, jDDNode2, jDDNode3);
        }
        if (Expression.isCoSafeLTLSyntactic(expression, true)) {
            return this.checkRewardCoSafeLTL(expression, jDDNode, jDDNode2, jDDNode3);
        }
        JDD.Deref(jDDNode3);
        throw new PrismException("R operator contains a path formula that is not syntactically co-safe: " + expression);
    }

    protected StateValues checkRewardReach(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode3);
        if (expressionTemporal.hasBounds()) {
            throw new PrismNotSupportedException("R operator cannot contain a bounded F operator: " + expressionTemporal);
        }
        JDDNode jDDNode4 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        try {
            stateValues = this.computeReachRewards(this.trans, this.trans01, jDDNode, jDDNode2, jDDNode4);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode4);
            throw prismException;
        }
        JDD.Deref(jDDNode4);
        return stateValues;
    }

    protected StateValues checkRewardCoSafeLTL(Expression expression, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        Object object;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        Vector<JDDNode> vector = new Vector<JDDNode>();
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (this.model.getModelType().continuousTime()) {
                JDD.Deref(jDDNode3);
                throw new PrismException("DA construction for time-bounded operators not supported for " + this.model.getModelType() + ".");
            }
            if (!expression.isSimplePathFormula()) {
                JDD.Deref(jDDNode3);
                throw new PrismException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        if (expression instanceof ExpressionFunc && ((ExpressionFunc)expression).getName().equals("dfa")) {
            JDD.Deref(jDDNode3);
            throw new PrismException("Model checking for \"dfa\" specifications not supported yet");
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        DA<BitSet, AcceptanceReach> dA = lTLModelChecker.constructDFAForCosafetyRewardLTL(this, this.model, expression, vector);
        if (this.prism.getSettings().getExportPropAut()) {
            this.mainLog.println("Exporting DA to file \"" + this.prism.getSettings().getExportPropAutFilename() + "\"...");
            object = PrismUtils.newPrintStream(this.prism.getSettings().getExportPropAutFilename());
            dA.print((PrintStream)object, this.prism.getSettings().getExportPropAutType());
            ((PrintStream)object).close();
        }
        LTLModelChecker.LTLProduct<ProbModel> lTLProduct = lTLModelChecker.constructProductMC(this.model, dA, vector, jDDNode3);
        if (this.prism.getExportProductTrans()) {
            try {
                int n = this.getSettings().getInteger("prism.exportModelPrecision");
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                ((ProbModel)lTLProduct.getProductModel()).exportToFile(1, true, new File(this.prism.getExportProductTransFilename()), n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.prism.getExportProductStatesFilename());
            ((ProbModel)lTLProduct.getProductModel()).exportStates(1, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        object = JDD.Apply(3, jDDNode.copy(), ((ProbModel)lTLProduct.getProductModel()).getReach().copy());
        JDDNode jDDNode4 = JDD.Apply(3, jDDNode2.copy(), ((ProbModel)lTLProduct.getProductModel()).getTrans01().copy());
        AcceptanceReachDD acceptanceReachDD = (AcceptanceReachDD)lTLProduct.getProductAcceptance();
        JDDNode jDDNode5 = acceptanceReachDD.getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        ProbModelChecker probModelChecker = this.createNewModelChecker(this.prism, (Model)lTLProduct.getProductModel(), null);
        stateValues = probModelChecker.computeReachRewards(((ProbModel)lTLProduct.getProductModel()).getTrans(), ((ProbModel)lTLProduct.getProductModel()).getTrans01(), (JDDNode)object, jDDNode4, jDDNode5);
        stateValues2 = lTLProduct.projectToOriginalModel(stateValues);
        JDD.Deref((JDDNode)object);
        JDD.Deref(jDDNode4);
        lTLProduct.clear();
        JDD.Deref(jDDNode5);
        return stateValues2;
    }

    protected StateValues checkRewardSS(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        JDDNode jDDNode4;
        JDDNode jDDNode5;
        int n;
        int n2;
        JDDNode jDDNode6;
        List<Object> list;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDD.Deref(jDDNode3);
        JDD.Ref(this.trans);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode7 = JDD.SumAbstract(JDD.Apply(3, this.trans, jDDNode2), this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode7 = JDD.Apply(1, jDDNode7, jDDNode);
        if (this.bsccComp) {
            SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
            sCCComputer.computeBSCCs();
            list = sCCComputer.getBSCCs();
            jDDNode6 = sCCComputer.getNotInBSCCs();
            n2 = list.size();
        } else {
            this.mainLog.println("\nSkipping BSCC computation...");
            list = new Vector();
            JDD.Ref(this.reach);
            list.add(this.reach);
            jDDNode6 = JDD.Constant(0.0);
            n2 = 1;
        }
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d;
            this.mainLog.println("\nComputing steady state probabilities for BSCC " + (n + 1));
            jDDNode5 = (JDDNode)list.get(n);
            try {
                stateValues = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode5);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                for (n = 0; n < n2; ++n) {
                    JDD.Deref((JDDNode)list.get(n));
                }
                JDD.Deref(jDDNode6);
                throw prismException;
            }
            if (this.verbose) {
                this.mainLog.print("\nBSCC " + (n + 1) + " steady-state probabilities: \n");
                stateValues.print(this.mainLog);
            }
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode7);
            jDDNode4 = JDD.Apply(3, jDDNode5, jDDNode7);
            dArray[n] = d = stateValues.sumOverMTBDD(jDDNode4);
            this.mainLog.print("\nBSCC " + (n + 1) + " Reward: " + d + "\n");
            JDD.Deref(jDDNode4);
            stateValues.clear();
        }
        if (jDDNode6.equals(JDD.ZERO)) {
            this.mainLog.println("\nAll states are in BSCCs (so no reachability probabilities computed)");
            jDDNode4 = JDD.Constant(0.0);
            for (n = 0; n < n2; ++n) {
                jDDNode5 = (JDDNode)list.get(n);
                JDD.Ref(jDDNode5);
                jDDNode4 = JDD.Apply(1, jDDNode4, JDD.Apply(3, JDD.Constant(dArray[n]), jDDNode5));
            }
            stateValues2 = new StateValuesMTBDD(jDDNode4, this.model);
        } else {
            switch (this.engine) {
                case 1: {
                    stateValues2 = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
                    break;
                }
                case 2: {
                    stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                    break;
                }
                case 3: {
                    stateValues2 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                }
            }
            for (n = 0; n < n2; ++n) {
                if (dArray[n] == 0.0) continue;
                this.mainLog.println("\nComputing probabilities of reaching BSCC " + (n + 1));
                jDDNode5 = (JDDNode)list.get(n);
                stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode6, jDDNode5);
                if (this.verbose) {
                    this.mainLog.print("\nBSCC " + (n + 1) + " reachability probabilities: \n");
                    stateValues.print(this.mainLog);
                }
                stateValues.timesConstant(dArray[n]);
                stateValues2.add(stateValues);
                stateValues.clear();
            }
        }
        JDD.Deref(jDDNode7);
        for (n = 0; n < n2; ++n) {
            JDD.Deref((JDDNode)list.get(n));
        }
        JDD.Deref(jDDNode6);
        return stateValues2;
    }

    public StateValues doSteadyState() throws PrismException {
        return this.doSteadyState((StateValues)null);
    }

    public StateValues doSteadyState(File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file);
        return this.doSteadyState(stateValues);
    }

    public StateValues doSteadyState(StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution() : stateValues;
        return this.computeSteadyStateProbs(this.trans, stateValues2);
    }

    public StateValues doTransient(int n) throws PrismException {
        return this.doTransient(n, (StateValues)null);
    }

    public StateValues doTransient(int n, File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file);
        return this.doTransient(n, stateValues);
    }

    public StateValues doTransient(int n, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution() : stateValues;
        return this.computeTransientProbs(this.trans, stateValues2, n);
    }

    public StateValues readDistributionFromFile(File file) throws PrismException {
        StateValues stateValues = null;
        if (file != null) {
            this.mainLog.println("\nImporting probability distribution from file \"" + file + "\"...");
            stateValues = this.engine == 1 ? new StateValuesMTBDD(JDD.Constant(0.0), this.model) : new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
            stateValues.readFromFile(file);
        }
        return stateValues;
    }

    private StateValues buildInitialDistribution() throws PrismException {
        StateValues stateValues = null;
        this.start = this.model.getStart();
        JDD.Ref(this.start);
        JDDNode jDDNode = JDD.Apply(4, this.start, JDD.Constant(JDD.GetNumMinterms(this.start, this.allDDRowVars.n())));
        if (this.engine == 1) {
            stateValues = new StateValuesMTBDD(jDDNode, this.model);
        } else {
            stateValues = new StateValuesDV(jDDNode, (Model)this.model);
            JDD.Deref(jDDNode);
        }
        return stateValues;
    }

    protected StateValues computeNextProbs(JDDNode jDDNode, JDDNode jDDNode2) {
        StateValuesMTBDD stateValuesMTBDD = null;
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode2, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        stateValuesMTBDD.setAccuracy(AccuracyFactory.boundedNumericalIterations());
        return stateValuesMTBDD;
    }

    protected StateValues computeRestrictedNext(JDDNode jDDNode, JDDNode jDDNode2, StateValues stateValues) {
        StateValuesMTBDD stateValuesMTBDD = null;
        StateValuesMTBDD stateValuesMTBDD2 = stateValues.convertToStateValuesMTBDD();
        JDDNode jDDNode3 = stateValuesMTBDD2.getJDDNode();
        JDD.Ref(jDDNode3);
        jDDNode3 = JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        JDD.Ref(jDDNode2);
        jDDNode3 = JDD.Apply(5, jDDNode3, jDDNode2);
        stateValuesMTBDD2.clear();
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        stateValuesMTBDD.setAccuracy(AccuracyFactory.boundedNumericalIterations());
        return stateValuesMTBDD;
    }

    protected StateValues computeBoundedUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, int n) throws PrismException {
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (jDDNode4.equals(JDD.ZERO)) {
            jDDNode7 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode5 = JDD.Constant(0.0);
        } else if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode4);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode4));
            jDDNode5 = JDD.Constant(0.0);
        } else {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            if (jDDNode7.equals(this.reach)) {
                jDDNode6 = JDD.Constant(0.0);
            } else if (this.precomp && this.prob0) {
                jDDNode6 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode7);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode3);
                JDD.Ref(jDDNode4);
                jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode3, jDDNode4)));
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()) + "\n");
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode7);
            stateValues = new StateValuesMTBDD(jDDNode7, this.model);
            stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode8 = PrismMTBDD.ProbBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, n);
                        stateValues = new StateValuesMTBDD(jDDNode8, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.ProbBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, n);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.ProbBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, n);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
                stateValues.setAccuracy(AccuracyFactory.boundedNumericalIterations());
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                JDD.Deref(jDDNode5);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        return stateValues;
    }

    protected StateValues computeUntilProbsQual(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) {
        JDDNode jDDNode4;
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        StateValuesMTBDD stateValuesMTBDD = null;
        if (jDDNode3.equals(JDD.ZERO)) {
            jDDNode6 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode5 = this.reach;
            jDDNode4 = JDD.Constant(0.0);
        } else if (jDDNode2.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode3);
            jDDNode6 = jDDNode3;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode3);
            jDDNode5 = JDD.And(this.reach, JDD.Not(jDDNode3));
            jDDNode4 = JDD.Constant(0.0);
        } else {
            jDDNode5 = PrismMTBDD.Prob0(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode2, jDDNode3);
            jDDNode6 = PrismMTBDD.Prob1(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode2, jDDNode3, jDDNode5);
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode5);
            jDDNode4 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode6, jDDNode5)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()) + "\n");
        if (jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode6);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode6, this.model);
        } else {
            JDD.Ref(jDDNode6);
            JDD.Ref(jDDNode4);
            stateValuesMTBDD = new StateValuesMTBDD(JDD.Apply(1, jDDNode6, JDD.Apply(3, jDDNode4, JDD.Constant(0.5))), this.model);
        }
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode4);
        return stateValuesMTBDD;
    }

    protected StateValues computeUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (this.prism.getExportTarget()) {
            JDDNode[] jDDNodeArray = new JDDNode[]{this.model.getStart(), jDDNode4};
            String[] stringArray = new String[]{"init", "target"};
            try {
                this.mainLog.println("\nExporting target states info to file \"" + this.prism.getExportTargetFilename() + "\"...");
                PrismMTBDD.ExportLabels(jDDNodeArray, stringArray, "l", this.model.getAllDDRowVars(), this.model.getODD(), 1, this.prism.getExportTargetFilename());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export target to file \"" + this.prism.getExportTargetFilename() + "\"");
            }
        }
        if (!(!this.doIntervalIteration || this.precomp && this.prob0 && this.prob1)) {
            throw new PrismNotSupportedException("Need precomputation for interval iteration, computing Until probabilities in DTMC");
        }
        if (jDDNode4.equals(JDD.ZERO)) {
            jDDNode7 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode5 = JDD.Constant(0.0);
        } else if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode4);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode4));
            jDDNode5 = JDD.Constant(0.0);
        } else {
            if (this.precomp && (this.prob0 || this.prob1)) {
                jDDNode6 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode3);
                JDD.Ref(jDDNode4);
                jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode3, jDDNode4)));
            }
            if (this.precomp && this.prob1) {
                jDDNode7 = PrismMTBDD.Prob1(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4, jDDNode6);
            } else {
                JDD.Ref(jDDNode4);
                jDDNode7 = jDDNode4;
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()) + "\n");
        if (jDDNode5.equals(JDD.ZERO)) {
            switch (this.engine) {
                case 1: {
                    JDD.Ref(jDDNode7);
                    stateValues = new StateValuesMTBDD(jDDNode7, this.model);
                    break;
                }
                case 2: 
                case 3: {
                    stateValues = new StateValuesDV(jDDNode7, (Model)this.model);
                }
            }
            stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
        } else {
            this.mainLog.println("\nComputing remaining probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode8 = this.doIntervalIteration ? PrismMTBDD.ProbUntilInterval(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, this.prism.getIntervalIterationFlags()) : PrismMTBDD.ProbUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5);
                        stateValues = new StateValuesMTBDD(jDDNode8, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = this.doIntervalIteration ? PrismSparse.ProbUntilInterval(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, this.prism.getIntervalIterationFlags()) : PrismSparse.ProbUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = this.doIntervalIteration ? PrismHybrid.ProbUntilInterval(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5, this.prism.getIntervalIterationFlags()) : PrismHybrid.ProbUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode7, jDDNode5);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
                if (this.doIntervalIteration) {
                    stateValues.setAccuracy(AccuracyFactory.guaranteedNumericalIterative(PrismNative.getLastErrorBound(), PrismNative.getTermCrit() == 1));
                } else {
                    stateValues.setAccuracy(AccuracyFactory.valueIteration(PrismNative.getTermCritParam(), PrismNative.getLastErrorBound(), PrismNative.getTermCrit() == 1));
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                JDD.Deref(jDDNode5);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        return stateValues;
    }

    protected StateValues computeCumulRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, int n) throws PrismException {
        StateValues stateValues = null;
        this.mainLog.println("\nComputing rewards...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                JDDNode jDDNode5 = PrismMTBDD.ProbCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, n);
                stateValues = new StateValuesMTBDD(jDDNode5, this.model);
                break;
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.ProbCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, n);
                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                DoubleVector doubleVector = PrismHybrid.ProbCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, n);
                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        stateValues.setAccuracy(AccuracyFactory.boundedNumericalIterations());
        return stateValues;
    }

    protected StateValues computeTotalRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        StateValues stateValues = null;
        List<JDDNode> list = null;
        JDDNode jDDNode5 = null;
        int n = 0;
        if (this.doIntervalIteration) {
            throw new PrismNotSupportedException("Interval iteration for total rewards is currently not supported");
        }
        SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
        sCCComputer.computeBSCCs();
        list = sCCComputer.getBSCCs();
        jDDNode5 = sCCComputer.getNotInBSCCs();
        n = list.size();
        JDD.Ref(jDDNode3);
        JDDNode jDDNode6 = JDD.GreaterThan(jDDNode3, 0.0);
        JDD.Ref(jDDNode4);
        JDDNode jDDNode7 = JDD.GreaterThan(jDDNode4, 0.0);
        JDDNode jDDNode8 = JDD.Constant(0.0);
        for (int i = 0; i < n; ++i) {
            if (!JDD.AreIntersecting(list.get(i), jDDNode6) && !JDD.AreIntersecting(list.get(i), jDDNode7)) continue;
            JDD.Ref(list.get(i));
            jDDNode8 = JDD.Or(jDDNode8, list.get(i));
        }
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode7);
        this.mainLog.print("States in non-zero reward BSCCs: " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()));
        JDDNode jDDNode9 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.reach, jDDNode8);
        jDDNode9 = JDD.And(this.reach.copy(), JDD.Not(jDDNode9));
        JDDNode jDDNode10 = JDD.And(this.reach.copy(), JDD.Not(jDDNode9.copy()));
        JDD.Deref(jDDNode8);
        this.mainLog.print("\ninf = " + JDD.GetNumMintermsString(jDDNode9, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode10, this.allDDRowVars.n()) + "\n");
        if (jDDNode10.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode9);
            stateValues = new StateValuesMTBDD(JDD.ITE(jDDNode9, JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
            stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
        } else {
            this.mainLog.println("\nComputing remaining rewards...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode11 = PrismMTBDD.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, JDD.ZERO, jDDNode9, jDDNode10);
                        stateValues = new StateValuesMTBDD(jDDNode11, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, JDD.ZERO, jDDNode9, jDDNode10);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, JDD.ZERO, jDDNode9, jDDNode10);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode9);
                JDD.Deref(jDDNode10);
                throw prismException;
            }
            stateValues.setAccuracy(AccuracyFactory.valueIteration(PrismNative.getTermCritParam(), PrismNative.getLastErrorBound(), PrismNative.getTermCrit() == 1));
        }
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == null) continue;
            JDD.Deref(list.get(i));
        }
        if (this.start != jDDNode5) {
            JDD.Deref(jDDNode5);
        }
        JDD.Deref(jDDNode9);
        JDD.Deref(jDDNode10);
        return stateValues;
    }

    protected StateValues computeInstRewards(JDDNode jDDNode, JDDNode jDDNode2, int n) throws PrismException {
        StateValues stateValues = null;
        if (n == 0) {
            JDD.Ref(jDDNode2);
            stateValues = new StateValuesMTBDD(jDDNode2, this.model);
            stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
        } else {
            this.mainLog.println("\nComputing rewards...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            switch (this.engine) {
                case 1: {
                    JDDNode jDDNode3 = PrismMTBDD.ProbInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, n);
                    stateValues = new StateValuesMTBDD(jDDNode3, this.model);
                    break;
                }
                case 2: {
                    DoubleVector doubleVector = PrismSparse.ProbInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, n);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                case 3: {
                    DoubleVector doubleVector = PrismHybrid.ProbInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, n);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                default: {
                    throw new PrismException("Unknown engine");
                }
            }
            stateValues.setAccuracy(AccuracyFactory.boundedNumericalIterations());
        }
        return stateValues;
    }

    protected static double computeReachRewardsUpperBound(PrismComponent prismComponent, Model model, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        double d = Double.POSITIVE_INFINITY;
        String string = null;
        switch (OptionsIntervalIteration.from(prismComponent).getBoundMethod()) {
            case VARIANT_1_COARSE: {
                d = ProbModelChecker.computeReachRewardsUpperBoundVariant1Coarse(prismComponent, model, jDDNode, jDDNode2, jDDNode3, jDDNode4, jDDNode5);
                string = "variant 1, coarse";
                break;
            }
            case VARIANT_1_FINE: {
                d = ProbModelChecker.computeReachRewardsUpperBoundVariant1Fine(prismComponent, model, jDDNode, jDDNode2, jDDNode3, jDDNode4, jDDNode5);
                string = "variant 1, fine";
                break;
            }
            case VARIANT_2: 
            case DEFAULT: {
                d = ProbModelChecker.computeReachRewardsUpperBoundVariant2(prismComponent, model, jDDNode, jDDNode2, jDDNode3, jDDNode4, jDDNode5);
                string = "variant 2";
                break;
            }
            case DSMPI: {
                throw new PrismNotSupportedException("Upper bound heuristic Dijkstra Sweep MPI currently not supported for symbolic engines");
            }
        }
        if (string == null) {
            throw new PrismException("Unsupported upper bound heuristic");
        }
        prismComponent.getLog().print("Upper bound for ");
        if (model.getModelType() == ModelType.MDP) {
            prismComponent.getLog().print("max ");
        }
        prismComponent.getLog().println("expectation (" + string + "): " + d);
        if (!Double.isFinite(d)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result. Perhaps choose a different method using -intervaliterboundmethod");
        }
        return d;
    }

    protected static double computeReachRewardsUpperBoundVariant1Coarse(PrismComponent prismComponent, Model model, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        JDDNode jDDNode9 = JDD.Constant(0.0);
        assert (model.getModelType() == ModelType.DTMC || model.getModelType() == ModelType.MDP);
        StopWatch stopWatch = new StopWatch(prismComponent.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(prismComponent, model);
        sCCComputer.computeSCCs(jDDNode5);
        JDDNode jDDNode10 = JDD.Constant(0.0);
        JDDNode jDDNode11 = JDD.GreaterThan(jDDNode.copy(), 0.0);
        double d = 0.0;
        for (JDDNode jDDNode12 : sCCComputer.getSCCs()) {
            double d2 = JDD.GetNumMinterms(jDDNode12, model.getNumDDRowVars());
            jDDNode9 = JDD.ITE(jDDNode12.copy(), JDD.Constant(d2), jDDNode9);
            double d3 = 0.0;
            jDDNode8 = JDD.PermuteVariables(jDDNode12.copy(), model.getAllDDRowVars(), model.getAllDDColVars());
            jDDNode7 = JDD.And(jDDNode11.copy(), jDDNode12.copy());
            jDDNode6 = JDD.And(jDDNode7, JDD.Not(jDDNode8.copy()));
            jDDNode6 = JDD.ThereExists(jDDNode6, model.getAllDDColVars());
            JDDNode jDDNode13 = JDD.Times(jDDNode.copy(), jDDNode12.copy(), jDDNode8);
            jDDNode13 = JDD.Times(jDDNode13, jDDNode6);
            JDDNode jDDNode14 = JDD.SumAbstract(jDDNode13, model.getAllDDColVars());
            if (model.getModelType() == ModelType.MDP) {
                jDDNode14 = JDD.MaxAbstract(jDDNode14, ((NondetModel)model).getAllDDNondetVars());
            }
            d3 = JDD.FindMax(jDDNode14);
            JDD.Deref(jDDNode14);
            d = Math.max(d, d3);
            jDDNode10 = JDD.Or(jDDNode10, jDDNode12);
        }
        double d4 = JDD.FindMinPositive(jDDNode);
        JDDNode jDDNode15 = sCCComputer.getNotInSCCs();
        jDDNode15 = JDD.And(jDDNode15, jDDNode5.copy());
        JDDNode jDDNode16 = JDD.Apply(2, jDDNode9.copy(), JDD.Constant(1.0));
        JDDNode jDDNode17 = JDD.Apply(15, JDD.Constant(d4), jDDNode16);
        jDDNode17 = JDD.Times(jDDNode17, JDD.Constant(1.0 - d));
        jDDNode17 = JDD.Apply(4, JDD.Constant(1.0), jDDNode17);
        JDDNode jDDNode18 = JDD.Times(jDDNode5.copy(), jDDNode17);
        jDDNode18 = JDD.ITE(jDDNode15, JDD.Constant(1.0), jDDNode18);
        jDDNode18 = JDD.ITE(jDDNode4.copy(), JDD.Constant(0.0), jDDNode18);
        JDDNode jDDNode19 = JDD.Times(jDDNode11.copy(), jDDNode3.copy());
        jDDNode8 = JDD.MaxAbstract(jDDNode19, model.getAllDDColVars());
        jDDNode8 = JDD.Apply(1, jDDNode8, jDDNode2.copy());
        if (model.getModelType() == ModelType.MDP) {
            jDDNode8 = JDD.MaxAbstract(jDDNode8, ((NondetModel)model).getAllDDNondetVars());
        }
        jDDNode7 = JDD.Times(jDDNode8, jDDNode18.copy());
        jDDNode6 = JDD.SumAbstract(jDDNode7, model.getAllDDRowVars());
        double d5 = jDDNode6.getValue();
        JDD.Deref(jDDNode6);
        stopWatch.stop();
        if (OptionsIntervalIteration.from(prismComponent).isBoundComputationVerbose()) {
            prismComponent.getLog().println("Upper bound for max expectation computation (variant 1, coarse):");
            prismComponent.getLog().println("p = " + d4);
            prismComponent.getLog().println("q = " + d);
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode9.copy(), model, "|Ct|");
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode18.copy(), model, "\u03b6*");
        }
        JDD.Deref(jDDNode11);
        JDD.Deref(jDDNode10);
        JDD.Deref(jDDNode18);
        JDD.Deref(jDDNode9);
        return d5;
    }

    protected static double computeReachRewardsUpperBoundVariant1Fine(PrismComponent prismComponent, Model model, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        JDDNode jDDNode6;
        JDDNode jDDNode72;
        JDDNode jDDNode8 = JDD.Constant(0.0);
        JDDNode jDDNode9 = JDD.Constant(0.0);
        JDDNode jDDNode10 = JDD.Constant(0.0);
        assert (model.getModelType() == ModelType.DTMC || model.getModelType() == ModelType.MDP);
        StopWatch stopWatch = new StopWatch(prismComponent.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(prismComponent, model);
        sCCComputer.computeSCCs(jDDNode5);
        JDDNode jDDNode11 = JDD.Constant(0.0);
        JDDNode jDDNode12 = JDD.GreaterThan(jDDNode.copy(), 0.0);
        for (JDDNode jDDNode72 : sCCComputer.getSCCs()) {
            double d = JDD.GetNumMinterms(jDDNode72, model.getNumDDRowVars());
            jDDNode8 = JDD.ITE(jDDNode72.copy(), JDD.Constant(d), jDDNode8);
            double d2 = 0.0;
            jDDNode6 = JDD.PermuteVariables(jDDNode72.copy(), model.getAllDDRowVars(), model.getAllDDColVars());
            JDDNode jDDNode13 = JDD.And(jDDNode12.copy(), jDDNode72.copy());
            JDDNode jDDNode14 = JDD.And(jDDNode13, JDD.Not(jDDNode6.copy()));
            jDDNode14 = JDD.ThereExists(jDDNode14, model.getAllDDColVars());
            JDDNode jDDNode15 = JDD.Times(jDDNode.copy(), jDDNode72.copy(), jDDNode6);
            double d3 = JDD.FindMinPositive(jDDNode15);
            jDDNode9 = JDD.ITE(jDDNode72.copy(), JDD.Constant(d3), jDDNode9);
            jDDNode15 = JDD.Times(jDDNode15, jDDNode14);
            JDDNode jDDNode16 = JDD.SumAbstract(jDDNode15, model.getAllDDColVars());
            if (model.getModelType() == ModelType.MDP) {
                jDDNode16 = JDD.MaxAbstract(jDDNode16, ((NondetModel)model).getAllDDNondetVars());
            }
            d2 = JDD.FindMax(jDDNode16);
            JDD.Deref(jDDNode16);
            jDDNode10 = JDD.ITE(jDDNode72.copy(), JDD.Constant(d2), jDDNode10);
            jDDNode11 = JDD.Or(jDDNode11, jDDNode72);
        }
        Object object = sCCComputer.getNotInSCCs();
        object = JDD.And((JDDNode)object, jDDNode5.copy());
        jDDNode72 = JDD.Apply(2, jDDNode8.copy(), JDD.Constant(1.0));
        JDDNode jDDNode17 = JDD.Apply(15, jDDNode9.copy(), jDDNode72);
        jDDNode17 = JDD.Times(jDDNode17, JDD.Apply(2, JDD.Constant(1.0), jDDNode10.copy()));
        jDDNode17 = JDD.Apply(4, JDD.Constant(1.0), jDDNode17);
        JDDNode jDDNode18 = JDD.Times(jDDNode5.copy(), jDDNode17);
        jDDNode18 = JDD.ITE((JDDNode)object, JDD.Constant(1.0), jDDNode18);
        jDDNode18 = JDD.ITE(jDDNode4.copy(), JDD.Constant(0.0), jDDNode18);
        JDDNode jDDNode19 = JDD.Times(jDDNode12.copy(), jDDNode3.copy());
        JDDNode jDDNode20 = JDD.MaxAbstract(jDDNode19, model.getAllDDColVars());
        jDDNode20 = JDD.Apply(1, jDDNode20, jDDNode2.copy());
        if (model.getModelType() == ModelType.MDP) {
            jDDNode20 = JDD.MaxAbstract(jDDNode20, ((NondetModel)model).getAllDDNondetVars());
        }
        JDDNode jDDNode21 = JDD.Times(jDDNode20, jDDNode18.copy());
        jDDNode6 = JDD.SumAbstract(jDDNode21, model.getAllDDRowVars());
        double d = jDDNode6.getValue();
        JDD.Deref(jDDNode6);
        stopWatch.stop();
        if (OptionsIntervalIteration.from(prismComponent).isBoundComputationVerbose()) {
            prismComponent.getLog().println("Upper bound for max expectation computation (variant 1, fine):");
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode9.copy(), model, "pt");
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode10.copy(), model, "qt");
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode8.copy(), model, "|Ct|");
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode18.copy(), model, "\u03b6*");
        }
        JDD.Deref(jDDNode12);
        JDD.Deref(jDDNode11);
        JDD.Deref(jDDNode18);
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode10);
        JDD.Deref(jDDNode9);
        return d;
    }

    protected static double computeReachRewardsUpperBoundVariant2(PrismComponent prismComponent, Model model, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        JDDNode jDDNode9;
        JDDNode jDDNode10;
        JDDNode jDDNode11;
        JDDNode jDDNode12;
        JDDNode jDDNode132;
        assert (model.getModelType() == ModelType.DTMC || model.getModelType() == ModelType.MDP);
        StopWatch stopWatch = new StopWatch(prismComponent.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(prismComponent, model);
        sCCComputer.computeSCCs(jDDNode5);
        JDDNode jDDNode14 = JDD.GreaterThan(jDDNode.copy(), 0.0);
        JDDNode jDDNode15 = JDD.Constant(0.0);
        for (JDDNode jDDNode132 : sCCComputer.getSCCs()) {
            jDDNode12 = JDD.PermuteVariables(jDDNode132.copy(), model.getAllDDRowVars(), model.getAllDDColVars());
            jDDNode11 = JDD.And(jDDNode132.copy(), jDDNode12);
            jDDNode15 = JDD.Or(jDDNode15, jDDNode11);
            JDD.Deref(jDDNode132);
        }
        Object object = jDDNode4.copy();
        jDDNode132 = jDDNode4.copy();
        jDDNode12 = JDD.And(jDDNode14.copy(), jDDNode5.copy());
        jDDNode11 = jDDNode5.copy();
        while (!jDDNode11.equals(JDD.ZERO)) {
            jDDNode10 = JDD.PermuteVariables(jDDNode132.copy(), model.getAllDDRowVars(), model.getAllDDColVars());
            jDDNode9 = JDD.And(jDDNode12.copy(), jDDNode10);
            jDDNode9 = JDD.ThereExists(jDDNode9, model.getAllDDColVars());
            if (model.getModelType() == ModelType.MDP) {
                jDDNode8 = JDD.Max(jDDNode9, ((NondetModel)model).getNondetMask().copy());
                jDDNode7 = JDD.ForAll(jDDNode8, ((NondetModel)model).getAllDDNondetVars());
            } else {
                jDDNode7 = jDDNode9;
            }
            jDDNode8 = JDD.Times(jDDNode.copy(), jDDNode7.copy(), JDD.PermuteVariables(jDDNode132.copy(), model.getAllDDRowVars(), model.getAllDDColVars()));
            jDDNode6 = JDD.And(jDDNode7.copy(), jDDNode15.copy());
            JDDNode jDDNode16 = JDD.PermuteVariables(((JDDNode)object).copy(), model.getAllDDRowVars(), model.getAllDDColVars());
            JDDNode jDDNode17 = JDD.ITE(jDDNode6, jDDNode16, JDD.Constant(1.0));
            jDDNode8 = JDD.Times(jDDNode8, jDDNode17);
            jDDNode8 = JDD.SumAbstract(jDDNode8, model.getAllDDColVars());
            if (model.getModelType() == ModelType.MDP) {
                jDDNode8 = JDD.Max(jDDNode8, ((NondetModel)model).getNondetMask().copy());
                jDDNode8 = JDD.MinAbstract(jDDNode8, ((NondetModel)model).getAllDDNondetVars());
            }
            object = JDD.ITE(jDDNode7.copy(), jDDNode8, (JDDNode)object);
            jDDNode11 = JDD.And(jDDNode11, JDD.Not(jDDNode7.copy()));
            jDDNode12 = JDD.And(jDDNode12, JDD.Not(jDDNode7.copy()));
            jDDNode132 = JDD.Or(jDDNode132, jDDNode7);
        }
        JDD.Deref(jDDNode11);
        JDD.Deref(jDDNode12);
        JDD.Deref(jDDNode132);
        jDDNode10 = sCCComputer.getNotInSCCs();
        jDDNode10 = JDD.And(jDDNode10, jDDNode5.copy());
        JDDNode jDDNode18 = JDD.Apply(4, JDD.Constant(1.0), ((JDDNode)object).copy());
        jDDNode18 = JDD.Times(jDDNode5.copy(), jDDNode18);
        jDDNode18 = JDD.ITE(jDDNode10, JDD.Constant(1.0), jDDNode18);
        jDDNode18 = JDD.ITE(jDDNode4.copy(), JDD.Constant(0.0), jDDNode18);
        jDDNode9 = JDD.Times(model.getTrans01().copy(), jDDNode3.copy());
        jDDNode7 = JDD.MaxAbstract(jDDNode9, model.getAllDDColVars());
        jDDNode7 = JDD.Apply(1, jDDNode7, jDDNode2.copy());
        if (model.getModelType() == ModelType.MDP) {
            jDDNode7 = JDD.MaxAbstract(jDDNode7, ((NondetModel)model).getAllDDNondetVars());
        }
        jDDNode8 = JDD.Times(jDDNode7, jDDNode18.copy());
        jDDNode6 = JDD.SumAbstract(jDDNode8, model.getAllDDRowVars());
        double d = jDDNode6.getValue();
        JDD.Deref(jDDNode6);
        stopWatch.stop();
        if (OptionsIntervalIteration.from(prismComponent).isBoundComputationVerbose()) {
            prismComponent.getLog().println("Upper bound for max expectation computation (variant 1, fine):");
            StateValuesMTBDD.print(prismComponent.getLog(), ((JDDNode)object).copy(), model, "dt");
            StateValuesMTBDD.print(prismComponent.getLog(), jDDNode18.copy(), model, "\u03b6*");
        }
        JDD.Deref(jDDNode14);
        JDD.Deref(jDDNode18);
        JDD.Deref((JDDNode)object);
        JDD.Deref(jDDNode15);
        return d;
    }

    protected StateValues computeReachRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        double d;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        JDDNode jDDNode9;
        StateValues stateValues = null;
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Ref(this.reach);
            jDDNode9 = this.reach;
            jDDNode8 = JDD.Constant(0.0);
        } else if (jDDNode5.equals(this.reach)) {
            jDDNode9 = JDD.Constant(0.0);
            jDDNode8 = JDD.Constant(0.0);
        } else {
            jDDNode7 = PrismMTBDD.Prob0(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.reach, jDDNode5);
            jDDNode6 = PrismMTBDD.Prob1(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.reach, jDDNode5, jDDNode7);
            JDD.Deref(jDDNode7);
            JDD.Ref(this.reach);
            jDDNode9 = JDD.And(this.reach, JDD.Not(jDDNode6));
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode9);
            JDD.Ref(jDDNode5);
            jDDNode8 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode9, jDDNode5)));
        }
        this.mainLog.print("\ngoal = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", inf = " + JDD.GetNumMintermsString(jDDNode9, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()) + "\n");
        jDDNode7 = null;
        jDDNode6 = null;
        if (jDDNode8.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode9);
            stateValues = new StateValuesMTBDD(JDD.ITE(jDDNode9, JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
            stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
        } else {
            if (this.doIntervalIteration) {
                double d2;
                double d3;
                OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this);
                if (optionsIntervalIteration.hasManualUpperBound()) {
                    d3 = optionsIntervalIteration.getManualUpperBound();
                    this.getLog().printWarning("Upper bound for interval iteration manually set to " + d3);
                } else {
                    d3 = ProbModelChecker.computeReachRewardsUpperBound(this, this.model, jDDNode, jDDNode3, jDDNode4, jDDNode5, jDDNode8);
                }
                jDDNode6 = JDD.ITE(jDDNode8.copy(), JDD.Constant(d3), JDD.Constant(0.0));
                if (optionsIntervalIteration.hasManualLowerBound()) {
                    d2 = optionsIntervalIteration.getManualLowerBound();
                    this.getLog().printWarning("Lower bound for interval iteration manually set to " + d2);
                } else {
                    d2 = 0.0;
                }
                jDDNode7 = JDD.ITE(jDDNode8.copy(), JDD.Constant(d2), JDD.Constant(0.0));
            }
            this.mainLog.println("\nComputing remaining rewards...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode10 = this.doIntervalIteration ? PrismMTBDD.ProbReachRewardInterval(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode9, jDDNode8, jDDNode7, jDDNode6, this.prism.getIntervalIterationFlags()) : PrismMTBDD.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode9, jDDNode8);
                        stateValues = new StateValuesMTBDD(jDDNode10, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = this.doIntervalIteration ? PrismSparse.ProbReachRewardInterval(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode9, jDDNode8, jDDNode7, jDDNode6, this.prism.getIntervalIterationFlags()) : PrismSparse.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode9, jDDNode8);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = this.doIntervalIteration ? PrismHybrid.ProbReachRewardInterval(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode9, jDDNode8, jDDNode7, jDDNode6, this.prism.getIntervalIterationFlags()) : PrismHybrid.ProbReachReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode5, jDDNode9, jDDNode8);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
                if (this.doIntervalIteration) {
                    stateValues.setAccuracy(AccuracyFactory.guaranteedNumericalIterative(PrismNative.getLastErrorBound(), PrismNative.getTermCrit() == 1));
                } else {
                    stateValues.setAccuracy(AccuracyFactory.valueIteration(PrismNative.getTermCritParam(), PrismNative.getLastErrorBound(), PrismNative.getTermCrit() == 1));
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode9);
                JDD.Deref(jDDNode8);
                if (jDDNode7 != null) {
                    JDD.Deref(jDDNode7);
                }
                if (jDDNode6 != null) {
                    JDD.Deref(jDDNode6);
                }
                throw prismException;
            }
        }
        if (this.doIntervalIteration && (d = stateValues.maxFiniteOverBDD(jDDNode8)) != Double.NEGATIVE_INFINITY) {
            this.mainLog.println("Maximum finite value in solution vector at end of interval iteration: " + d);
        }
        JDD.Deref(jDDNode9);
        JDD.Deref(jDDNode8);
        if (jDDNode7 != null) {
            JDD.Deref(jDDNode7);
        }
        if (jDDNode6 != null) {
            JDD.Deref(jDDNode6);
        }
        return stateValues;
    }

    public StateValues computeSteadyStateProbs(JDDNode jDDNode, StateValues stateValues) throws PrismException {
        int n;
        List<Object> list = null;
        JDDNode jDDNode2 = null;
        JDDNode jDDNode3 = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        int n2 = 0;
        int n3 = -1;
        try {
            JDDNode jDDNode4;
            if (this.bsccComp) {
                SCCComputer sCCComputer = this.prism.getSCCComputer(this.model);
                sCCComputer.computeBSCCs();
                list = sCCComputer.getBSCCs();
                jDDNode2 = sCCComputer.getNotInBSCCs();
                n2 = list.size();
            } else {
                this.mainLog.println("\nSkipping BSCC computation...");
                list = new Vector();
                JDD.Ref(this.reach);
                list.add(this.reach);
                jDDNode2 = JDD.Constant(0.0);
                n2 = 1;
            }
            jDDNode3 = stateValues.getBDDFromInterval(">", 0.0);
            n3 = -1;
            for (n = 0; n < n2; ++n) {
                if (!JDD.IsContainedIn(jDDNode3, (JDDNode)list.get(n))) continue;
                n3 = n;
                break;
            }
            if (n3 != -1) {
                this.mainLog.println("\nInitial states all in one BSCC (so no reachability probabilities computed)");
                jDDNode4 = (JDDNode)list.get(n3);
                stateValues3 = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode4);
            } else {
                switch (this.engine) {
                    case 1: {
                        stateValues3 = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
                        break;
                    }
                    case 2: {
                        stateValues3 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                        break;
                    }
                    case 3: {
                        stateValues3 = new StateValuesDV(new DoubleVector((int)this.model.getNumStates()), (Model)this.model);
                    }
                }
                double[] dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    this.mainLog.println("\nComputing probability of reaching BSCC " + (n + 1));
                    jDDNode4 = (JDDNode)list.get(n);
                    stateValues2 = this.computeUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode4);
                    dArray[n] = stateValues2.dotProduct(stateValues);
                    this.mainLog.print("\nProbability of reaching BSCC " + (n + 1) + ": " + dArray[n] + "\n");
                    stateValues2.clear();
                }
                for (n = 0; n < n2; ++n) {
                    this.mainLog.println("\nComputing steady-state probabilities for BSCC " + (n + 1));
                    jDDNode4 = (JDDNode)list.get(n);
                    stateValues2 = this.computeSteadyStateProbsForBSCC(this.trans, jDDNode4);
                    if (this.verbose) {
                        this.mainLog.print("\nBSCC " + (n + 1) + " Steady-State Probabilities: \n");
                        stateValues2.print(this.mainLog);
                    }
                    stateValues2.timesConstant(dArray[n]);
                    stateValues3.add(stateValues2);
                    stateValues2.clear();
                }
            }
        }
        catch (PrismException prismException) {
            if (jDDNode3 != null) {
                JDD.Deref(jDDNode3);
            }
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) == null) continue;
                JDD.Deref((JDDNode)list.get(i));
            }
            if (jDDNode3 != jDDNode2) {
                JDD.Deref(jDDNode2);
            }
            if (stateValues3 != null) {
                stateValues3.clear();
            }
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        if (jDDNode3 != null) {
            JDD.Deref(jDDNode3);
        }
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == null) continue;
            JDD.Deref((JDDNode)list.get(n));
        }
        if (jDDNode3 != jDDNode2) {
            JDD.Deref(jDDNode2);
        }
        if (stateValues != null) {
            stateValues.clear();
        }
        return stateValues3;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected StateValues computeSteadyStateProbsForBSCC(JDDNode var1_1, JDDNode var2_2) throws PrismException {
        var9_3 /* !! */  = null;
        var5_4 = var2_2.equals(this.reach) != false ? this.model.getNumStates() : Math.round(JDD.GetNumMinterms(var2_2, this.allDDRowVars.n()));
        if (var5_4 == 1L) {
            switch (this.engine) {
                case 1: {
                    JDD.Ref(var2_2);
                    return new StateValuesMTBDD(var2_2, this.model);
                }
                case 2: {
                    return new StateValuesDV(var2_2, (Model)this.model);
                }
                case 3: {
                    return new StateValuesDV(var2_2, (Model)this.model);
                }
            }
        }
        JDD.Ref(var1_1);
        JDD.Ref(var2_2);
        var3_5 = JDD.Apply(3, var1_1, var2_2);
        JDD.Ref(var2_2);
        var3_5 = JDD.Apply(3, var3_5, JDD.PermuteVariables(var2_2, this.allDDRowVars, this.allDDColVars));
        JDD.Ref(var2_2);
        var4_6 = JDD.Apply(4, var2_2, JDD.Constant(var5_4));
        if (this.settings.getBoolean("prism.exportIterations")) {
            var10_7 = ExportIterations.getUniqueFilename("iterations-ss-bscc");
            PrismNative.setDefaultExportIterationsFilename(var10_7);
        }
        this.mainLog.println("\nComputing probabilities...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        try {
            switch (this.engine) {
                case 1: {
                    var7_9 = PrismMTBDD.StochSteadyState(var3_5, this.odd, var4_6, this.allDDRowVars, this.allDDColVars);
                    var9_3 /* !! */  = new StateValuesMTBDD(var7_9, this.model);
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 2: {
                    var8_10 = PrismSparse.StochSteadyState(var3_5, this.odd, var4_6, this.allDDRowVars, this.allDDColVars);
                    var9_3 /* !! */  = new StateValuesDV(var8_10, (Model)this.model);
                    ** break;
lbl35:
                    // 1 sources

                    break;
                }
                case 3: {
                    var8_11 = PrismHybrid.StochSteadyState(var3_5, this.odd, var4_6, this.allDDRowVars, this.allDDColVars);
                    var9_3 /* !! */  = new StateValuesDV(var8_11, (Model)this.model);
                    ** break;
lbl40:
                    // 1 sources

                    break;
                }
                default: {
                    throw new PrismException("Unknown engine");
                }
            }
        }
        catch (PrismException var10_8) {
            JDD.Deref(var3_5);
            JDD.Deref(var4_6);
            throw var10_8;
        }
        finally {
            if (this.settings.getBoolean("prism.exportIterations")) {
                PrismNative.setDefaultExportIterationsFilename(ExportIterations.getDefaultFilename());
            }
        }
        JDD.Deref(var3_5);
        JDD.Deref(var4_6);
        return var9_3 /* !! */ ;
    }

    protected StateValues computeTransientProbs(JDDNode jDDNode, StateValues stateValues, int n) throws PrismException {
        StateValues stateValues2 = null;
        if (n == 0) {
            return stateValues;
        }
        this.mainLog.println("\nComputing probabilities...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                JDDNode jDDNode2 = PrismMTBDD.ProbTransient(jDDNode, this.odd, ((StateValuesMTBDD)stateValues).getJDDNode(), this.allDDRowVars, this.allDDColVars, n);
                stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
                break;
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.ProbTransient(jDDNode, this.odd, ((StateValuesDV)stateValues).getDoubleVector(), this.allDDRowVars, this.allDDColVars, n);
                stateValues2 = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                DoubleVector doubleVector = PrismHybrid.ProbTransient(jDDNode, this.odd, ((StateValuesDV)stateValues).getDoubleVector(), this.allDDRowVars, this.allDDColVars, n);
                stateValues2 = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        stateValues2.setAccuracy(AccuracyFactory.boundedNumericalIterations());
        return stateValues2;
    }
}

