/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import mtbdd.PrismMTBDD;
import odd.ODDNode;
import odd.ODDUtils;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import prism.Model;
import prism.ModelType;
import prism.ModelVariablesDD;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ProbModelTransformationOperator;
import prism.StateList;
import prism.StateListMTBDD;
import sparse.PrismSparse;

public class ProbModel
implements Model {
    protected int numModules;
    protected String[] moduleNames;
    protected int numVars;
    protected VarList varList;
    protected long[] gtol;
    protected Values constantValues;
    protected int numSynchs;
    protected List<String> synchs;
    protected int numRewardStructs;
    protected String[] rewardStructNames;
    protected double numStates;
    protected double numTransitions;
    protected double numStartStates;
    protected JDDNode trans;
    protected JDDNode trans01;
    protected JDDNode start;
    protected JDDNode reach;
    protected JDDNode deadlocks;
    protected JDDNode[] stateRewards;
    protected JDDNode[] transRewards;
    protected JDDNode transActions;
    protected JDDNode[] transPerAction;
    protected JDDVars[] varDDRowVars;
    protected JDDVars[] varDDColVars;
    protected JDDVars[] moduleDDRowVars;
    protected JDDVars[] moduleDDColVars;
    protected JDDVars allDDRowVars;
    protected JDDVars allDDColVars;
    protected ModelVariablesDD modelVariables;
    protected Map<String, JDDNode> labelsDD = new TreeMap<String, JDDNode>();
    protected ODDNode odd;

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public int getNumModules() {
        return this.numModules;
    }

    @Override
    public String[] getModuleNames() {
        return this.moduleNames;
    }

    @Override
    public String getModuleName(int n) {
        return this.moduleNames[n];
    }

    @Override
    public int getNumVars() {
        return this.numVars;
    }

    @Override
    public VarList getVarList() {
        return this.varList;
    }

    @Override
    public String getVarName(int n) {
        return this.varList.getName(n);
    }

    @Override
    public int getVarIndex(String string) {
        return this.varList.getIndex(string);
    }

    @Override
    public int getVarModule(int n) {
        return this.varList.getModule(n);
    }

    @Override
    public int getVarLow(int n) {
        return this.varList.getLow(n);
    }

    @Override
    public int getVarHigh(int n) {
        return this.varList.getHigh(n);
    }

    @Override
    public int getVarRange(int n) {
        return this.varList.getRange(n);
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public List<String> getSynchs() {
        return this.synchs;
    }

    @Override
    public int getNumRewardStructs() {
        return this.numRewardStructs;
    }

    @Override
    public long getNumStates() {
        return this.numStates > 9.223372036854776E18 ? -1L : Math.round(this.numStates);
    }

    @Override
    public long getNumTransitions() {
        return this.numTransitions > 9.223372036854776E18 ? -1L : Math.round(this.numTransitions);
    }

    @Override
    public long getNumStartStates() {
        return this.numStartStates > 9.223372036854776E18 ? -1L : Math.round(this.numStartStates);
    }

    @Override
    public String getNumStatesString() {
        return PrismUtils.bigIntToString(this.numStates);
    }

    @Override
    public String getNumTransitionsString() {
        return PrismUtils.bigIntToString(this.numTransitions);
    }

    @Override
    public String getNumStartStatesString() {
        return PrismUtils.bigIntToString(this.numStartStates);
    }

    @Override
    public StateList getReachableStates() {
        return new StateListMTBDD(this.reach, this);
    }

    @Override
    public StateList getDeadlockStates() {
        return new StateListMTBDD(this.deadlocks, this);
    }

    @Override
    public StateList getStartStates() {
        return new StateListMTBDD(this.start, this);
    }

    @Override
    public JDDNode getTrans() {
        return this.trans;
    }

    @Override
    public JDDNode getTrans01() {
        return this.trans01;
    }

    @Override
    public JDDNode getStart() {
        return this.start;
    }

    @Override
    public JDDNode getReach() {
        return this.reach;
    }

    @Override
    public JDDNode getTransReln() {
        return this.trans01;
    }

    @Override
    public JDDNode getDeadlocks() {
        return this.deadlocks;
    }

    @Override
    public JDDNode getStateRewards() {
        return this.getStateRewards(0);
    }

    @Override
    public JDDNode getStateRewards(int n) {
        return n >= 0 && n < this.numRewardStructs ? this.stateRewards[n] : null;
    }

    @Override
    public JDDNode getStateRewards(String string) {
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (!this.rewardStructNames[i].equals(string)) continue;
            return this.stateRewards[i];
        }
        return null;
    }

    @Override
    public JDDNode getTransRewards() {
        return this.getTransRewards(0);
    }

    @Override
    public JDDNode getTransRewards(int n) {
        return n >= 0 && n < this.numRewardStructs ? this.transRewards[n] : null;
    }

    @Override
    public JDDNode getTransRewards(String string) {
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (!this.rewardStructNames[i].equals(string)) continue;
            return this.transRewards[i];
        }
        return null;
    }

    @Override
    public JDDNode getTransActions() {
        return this.transActions;
    }

    @Override
    public JDDNode[] getTransPerAction() {
        return this.transPerAction;
    }

    @Override
    public JDDVars[] getVarDDRowVars() {
        return this.varDDRowVars;
    }

    @Override
    public JDDVars[] getVarDDColVars() {
        return this.varDDColVars;
    }

    @Override
    public JDDVars getVarDDRowVars(int n) {
        return this.varDDRowVars[n];
    }

    @Override
    public JDDVars getVarDDColVars(int n) {
        return this.varDDColVars[n];
    }

    @Override
    public JDDVars[] getModuleDDRowVars() {
        return this.moduleDDRowVars;
    }

    @Override
    public JDDVars[] getModuleDDColVars() {
        return this.moduleDDColVars;
    }

    @Override
    public JDDVars getModuleDDRowVars(int n) {
        return this.moduleDDRowVars[n];
    }

    @Override
    public JDDVars getModuleDDColVars(int n) {
        return this.moduleDDColVars[n];
    }

    @Override
    public JDDVars getAllDDRowVars() {
        return this.allDDRowVars;
    }

    @Override
    public JDDVars getAllDDColVars() {
        return this.allDDColVars;
    }

    @Override
    public JDDNode getLabelDD(String string) {
        return this.labelsDD.get(string);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labelsDD.keySet());
    }

    @Override
    public int getNumDDRowVars() {
        return this.allDDRowVars.n();
    }

    @Override
    public int getNumDDColVars() {
        return this.allDDColVars.n();
    }

    @Override
    public int getNumDDVarsInTrans() {
        return this.allDDRowVars.n() * 2;
    }

    @Override
    public Vector<String> getDDVarNames() {
        return this.modelVariables.getDDVarNames();
    }

    @Override
    public ModelVariablesDD getModelVariables() {
        return this.modelVariables;
    }

    @Override
    public ODDNode getODD() {
        return this.odd;
    }

    public String getTransName() {
        return "Transition matrix";
    }

    public String getTransSymbol() {
        return "P";
    }

    public ProbModel(JDDNode jDDNode, JDDNode jDDNode2, JDDNode[] jDDNodeArray, JDDNode[] jDDNodeArray2, String[] stringArray, JDDVars jDDVars, JDDVars jDDVars2, ModelVariablesDD modelVariablesDD, int n, String[] stringArray2, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, int n2, VarList varList, JDDVars[] jDDVarsArray3, JDDVars[] jDDVarsArray4, Values values) {
        int n3;
        this.trans = jDDNode;
        this.start = jDDNode2;
        this.deadlocks = null;
        this.stateRewards = jDDNodeArray;
        this.transRewards = jDDNodeArray2;
        this.numRewardStructs = this.stateRewards.length;
        this.rewardStructNames = stringArray;
        this.allDDRowVars = jDDVars;
        this.allDDColVars = jDDVars2;
        this.modelVariables = modelVariablesDD;
        this.numModules = n;
        this.moduleNames = stringArray2;
        this.moduleDDRowVars = jDDVarsArray;
        this.moduleDDColVars = jDDVarsArray2;
        this.numVars = n2;
        this.varList = varList;
        this.varDDRowVars = jDDVarsArray3;
        this.varDDColVars = jDDVarsArray4;
        this.constantValues = values;
        this.transActions = null;
        this.transPerAction = null;
        this.gtol = new long[this.numVars];
        for (n3 = 0; n3 < this.numVars; ++n3) {
            this.gtol[n3] = 1L << this.varDDRowVars[n3].getNumVars();
        }
        for (n3 = this.numVars - 2; n3 >= 0; --n3) {
            this.gtol[n3] = this.gtol[n3] * this.gtol[n3 + 1];
        }
        JDD.Ref(this.trans);
        this.trans01 = JDD.GreaterThan(this.trans, 0.0);
        this.numStartStates = JDD.GetNumMinterms(this.start, this.allDDRowVars.n());
    }

    @Override
    public void setSynchs(List<String> list) {
        this.synchs = list;
        this.numSynchs = list.size();
    }

    @Override
    public void addLabelDD(String string, JDDNode jDDNode) {
        JDDNode jDDNode2 = this.labelsDD.put(string, jDDNode);
        if (jDDNode2 != null) {
            JDD.Deref(jDDNode2);
        }
    }

    @Override
    public String addUniqueLabelDD(String string, JDDNode jDDNode, Set<String> set) {
        int n = 0;
        Object object = string;
        while (true) {
            boolean bl;
            boolean bl2 = bl = !this.hasLabelDD((String)object);
            if (set != null) {
                bl &= !set.contains(object);
            }
            if (bl) break;
            object = string + "_" + n;
            if (n == Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Integer overflow trying to add unique label");
            }
            ++n;
        }
        this.addLabelDD((String)object, jDDNode);
        return object;
    }

    @Override
    public void resetTrans(JDDNode jDDNode) {
        if (this.trans != null) {
            JDD.Deref(this.trans);
        }
        this.trans = jDDNode;
    }

    @Override
    public void resetTransRewards(int n, JDDNode jDDNode) {
        if (this.transRewards[n] != null) {
            JDD.Deref(this.transRewards[n]);
        }
        this.transRewards[n] = jDDNode;
    }

    public void resetStateRewards(int n, JDDNode jDDNode) {
        if (this.stateRewards[n] != null) {
            JDD.Deref(this.stateRewards[n]);
        }
        this.stateRewards[n] = jDDNode;
    }

    @Override
    public void doReachability() throws PrismException {
        this.setReach(PrismMTBDD.Reachability(this.trans01, this.allDDRowVars, this.allDDColVars, this.start));
    }

    public void doReachability(JDDNode jDDNode) throws PrismException {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsStateSet(jDDNode, this.getAllDDRowVars());
        }
        JDDNode jDDNode2 = JDD.Or(this.start.copy(), jDDNode);
        this.setReach(PrismMTBDD.Reachability(this.trans01, this.allDDRowVars, this.allDDColVars, jDDNode2));
        JDD.Deref(jDDNode2);
    }

    @Override
    public void skipReachability() throws PrismException {
        this.reach = JDD.Constant(1.0);
        this.numStates = Math.pow(2.0, this.allDDRowVars.n());
        if (this.odd != null) {
            ODDUtils.ClearODD(this.odd);
            this.odd = null;
        }
        this.odd = ODDUtils.BuildODD(this.reach, this.allDDRowVars);
    }

    @Override
    public void setReach(JDDNode jDDNode) throws PrismException {
        if (this.reach != null) {
            JDD.Deref(this.reach);
        }
        this.reach = jDDNode;
        this.numStates = JDD.GetNumMinterms(jDDNode, this.allDDRowVars.n());
        if (this.odd != null) {
            ODDUtils.ClearODD(this.odd);
            this.odd = null;
        }
        this.odd = ODDUtils.BuildODD(jDDNode, this.allDDRowVars);
    }

    public void setStart(JDDNode jDDNode) {
        if (this.start != null) {
            JDD.Deref(this.start);
        }
        this.start = jDDNode;
        this.numStartStates = JDD.GetNumMinterms(jDDNode, this.allDDRowVars.n());
    }

    @Override
    public void setTransActions(JDDNode jDDNode) {
        this.transActions = jDDNode;
    }

    @Override
    public void setTransPerAction(JDDNode[] jDDNodeArray) {
        this.transPerAction = jDDNodeArray;
    }

    @Override
    public void filterReachableStates() {
        int n;
        JDD.Ref(this.reach);
        this.trans = JDD.Apply(3, this.reach, this.trans);
        JDD.Ref(this.reach);
        JDDNode jDDNode = JDD.PermuteVariables(this.reach, this.allDDRowVars, this.allDDColVars);
        this.trans = JDD.Apply(3, jDDNode, this.trans);
        JDD.Deref(this.trans01);
        JDD.Ref(this.trans);
        this.trans01 = JDD.GreaterThan(this.trans, 0.0);
        for (n = 0; n < this.stateRewards.length; ++n) {
            JDD.Ref(this.reach);
            this.stateRewards[n] = JDD.Apply(3, this.reach, this.stateRewards[n]);
            JDD.Ref(this.reach);
            this.transRewards[n] = JDD.Apply(3, this.reach, this.transRewards[n]);
            JDD.Ref(this.reach);
            jDDNode = JDD.PermuteVariables(this.reach, this.allDDRowVars, this.allDDColVars);
            this.transRewards[n] = JDD.Apply(3, jDDNode, this.transRewards[n]);
        }
        if (this.transActions != null) {
            JDD.Ref(this.reach);
            this.transActions = JDD.Apply(3, this.reach, this.transActions);
        }
        if (this.transPerAction != null) {
            for (n = 0; n < this.numSynchs + 1; ++n) {
                JDD.Ref(this.reach);
                this.transPerAction[n] = JDD.Apply(3, this.reach, this.transPerAction[n]);
                JDD.Ref(this.reach);
                jDDNode = JDD.PermuteVariables(this.reach, this.allDDRowVars, this.allDDColVars);
                this.transPerAction[n] = JDD.Apply(3, jDDNode, this.transPerAction[n]);
            }
        }
        JDD.Ref(this.reach);
        this.start = JDD.Apply(3, this.reach, this.start);
        this.numStartStates = JDD.GetNumMinterms(this.start, this.allDDRowVars.n());
        this.numTransitions = JDD.GetNumMinterms(this.trans01, this.getNumDDVarsInTrans());
    }

    @Override
    public void findDeadlocks(boolean bl) {
        JDD.Ref(this.trans01);
        this.deadlocks = JDD.ThereExists(this.trans01, this.allDDColVars);
        JDD.Ref(this.reach);
        this.deadlocks = JDD.And(this.reach, JDD.Not(this.deadlocks));
        if (bl && !this.deadlocks.equals(JDD.ZERO)) {
            JDD.Ref(this.deadlocks);
            JDDNode jDDNode = JDD.And(this.deadlocks, JDD.Identity(this.allDDRowVars, this.allDDColVars));
            JDD.Ref(jDDNode);
            this.trans = JDD.Apply(1, this.trans, jDDNode);
            JDD.Ref(jDDNode);
            this.trans01 = JDD.Apply(1, this.trans01, jDDNode);
            if (this.transPerAction != null) {
                JDD.Ref(jDDNode);
                this.transPerAction[0] = JDD.Apply(1, this.transPerAction[0], jDDNode);
            }
            JDD.Deref(jDDNode);
            this.numTransitions = JDD.GetNumMinterms(this.trans01, this.getNumDDVarsInTrans());
        }
    }

    @Override
    public void printTrans() {
    }

    @Override
    public void printTrans01() {
    }

    @Override
    public void printTransInfo(PrismLog prismLog) {
        this.printTransInfo(prismLog, false);
    }

    @Override
    public void printTransInfo(PrismLog prismLog, boolean bl) {
        prismLog.print("States:      " + this.getNumStatesString() + " (" + this.getNumStartStatesString() + " initial)\n");
        prismLog.print("Transitions: " + this.getNumTransitionsString() + "\n");
        prismLog.println();
        prismLog.print(this.getTransName() + ": " + JDD.GetInfoString(this.trans, this.getNumDDVarsInTrans()));
        prismLog.print(", vars: " + this.getNumDDRowVars() + "r/" + this.getNumDDColVars() + "c\n");
        if (bl) {
            int n;
            prismLog.print("DD vars (r/c):");
            int n2 = this.allDDRowVars.getNumVars();
            for (n = 0; n < n2; ++n) {
                int n3 = this.allDDRowVars.getVarIndex(n);
                prismLog.print(" " + n3 + ":" + this.getDDVarNames().get(n3));
                n3 = this.allDDColVars.getVarIndex(n);
                prismLog.print(" " + n3 + ":" + this.getDDVarNames().get(n3));
            }
            prismLog.println();
            prismLog.print(this.getTransName() + " terminals: " + JDD.GetTerminalsAndNumbersString(this.trans, this.getNumDDVarsInTrans()) + "\n");
            prismLog.print("Reach: " + JDD.GetNumNodes(this.reach) + " nodes\n");
            prismLog.print("ODD: " + ODDUtils.GetNumODDNodes() + " nodes\n");
            for (n = 0; n < this.numRewardStructs; ++n) {
                if (this.stateRewards[n] != null && !this.stateRewards[n].equals(JDD.ZERO)) {
                    prismLog.print("State rewards (" + (n + 1) + (String)("".equals(this.rewardStructNames[n]) ? "" : ":\"" + this.rewardStructNames[n] + "\"") + "): ");
                    prismLog.print(JDD.GetNumNodes(this.stateRewards[n]) + " nodes (");
                    prismLog.print(JDD.GetNumTerminals(this.stateRewards[n]) + " terminal), ");
                    prismLog.print(JDD.GetNumMintermsString(this.stateRewards[n], this.getNumDDRowVars()) + " minterms\n");
                    if (bl) {
                        prismLog.print("State rewards terminals (" + (n + 1) + (String)("".equals(this.rewardStructNames[n]) ? "" : ":\"" + this.rewardStructNames[n] + "\"") + "): ");
                        prismLog.print(JDD.GetTerminalsAndNumbersString(this.stateRewards[n], this.getNumDDRowVars()) + "\n");
                    }
                }
                if (this.transRewards[n] == null || this.transRewards[n].equals(JDD.ZERO)) continue;
                prismLog.print("Transition rewards (" + (n + 1) + (String)("".equals(this.rewardStructNames[n]) ? "" : ":\"" + this.rewardStructNames[n] + "\"") + "): ");
                prismLog.print(JDD.GetNumNodes(this.transRewards[n]) + " nodes (");
                prismLog.print(JDD.GetNumTerminals(this.transRewards[n]) + " terminal), ");
                prismLog.print(JDD.GetNumMintermsString(this.transRewards[n], this.getNumDDVarsInTrans()) + " minterms\n");
                if (!bl) continue;
                prismLog.print("Transition rewards terminals (" + (n + 1) + (String)("".equals(this.rewardStructNames[n]) ? "" : ":\"" + this.rewardStructNames[n] + "\"") + "): ");
                prismLog.print(JDD.GetTerminalsAndNumbersString(this.transRewards[n], this.getNumDDVarsInTrans()) + "\n");
            }
            if (this.transPerAction != null) {
                for (n = 0; n < this.numSynchs + 1; ++n) {
                    prismLog.print("Action label info (");
                    prismLog.print((n == 0 ? "" : this.synchs.get(n - 1)) + "): ");
                    prismLog.println(JDD.GetInfoString(this.transPerAction[n], this.getNumDDVarsInTrans()));
                }
            }
        }
    }

    @Override
    public void exportToFile(int n, boolean bl, File file, int n2) throws FileNotFoundException, PrismException {
        if (!bl) {
            PrismMTBDD.ExportMatrix(this.trans, this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.odd, n, file != null ? file.getPath() : null, n2, null, true);
        } else {
            PrismSparse.ExportMatrix(this.trans, this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.odd, n, file != null ? file.getPath() : null, n2, null, true);
        }
    }

    @Override
    public void exportStateRewardsToFile(int n, int n2, File file, int n3, boolean bl) throws FileNotFoundException, PrismException {
        PrismMTBDD.ExportVector(this.stateRewards[n], "c" + (n + 1), this.allDDRowVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl);
    }

    @Override
    @Deprecated
    public String exportStateRewardsToFile(int n, File file, int n2) throws FileNotFoundException, PrismException {
        if (this.numRewardStructs == 0) {
            throw new PrismException("There are no state rewards to export");
        }
        Object object = "";
        for (int i = 0; i < this.numRewardStructs; ++i) {
            String string;
            String string2 = string = file != null ? file.getPath() : null;
            if (string != null && this.numRewardStructs > 1) {
                string = PrismUtils.addCounterSuffixToFilename(string, i + 1);
                object = (String)object + (i > 0 ? ", " : "") + string;
            }
            PrismMTBDD.ExportVector(this.stateRewards[i], "c" + (i + 1), this.allDDRowVars, this.odd, n, string, n2, this.rewardStructNames[i], false);
        }
        return ((String)object).length() > 0 ? object : null;
    }

    @Override
    public void exportTransRewardsToFile(int n, int n2, boolean bl, File file, int n3, boolean bl2) throws FileNotFoundException, PrismException {
        if (!bl) {
            PrismMTBDD.ExportMatrix(this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl2);
        } else {
            PrismSparse.ExportMatrix(this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl2);
        }
    }

    @Override
    @Deprecated
    public String exportTransRewardsToFile(int n, boolean bl, File file, int n2) throws FileNotFoundException, PrismException {
        if (this.numRewardStructs == 0) {
            throw new PrismException("There are no transition rewards to export");
        }
        Object object = "";
        for (int i = 0; i < this.numRewardStructs; ++i) {
            String string;
            String string2 = string = file != null ? file.getPath() : null;
            if (string != null && this.numRewardStructs > 1) {
                string = PrismUtils.addCounterSuffixToFilename(string, i + 1);
                object = (String)object + (i > 0 ? ", " : "") + string;
            }
            if (!bl) {
                PrismMTBDD.ExportMatrix(this.transRewards[i], "C" + (i + 1), this.allDDRowVars, this.allDDColVars, this.odd, n, string, n2, this.rewardStructNames[i], false);
                continue;
            }
            PrismSparse.ExportMatrix(this.transRewards[i], "C" + (i + 1), this.allDDRowVars, this.allDDColVars, this.odd, n, string, n2, this.rewardStructNames[i], false);
        }
        return ((String)object).length() > 0 ? object : null;
    }

    @Override
    public void exportStates(int n, PrismLog prismLog) {
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        int n2 = this.getNumVars();
        for (int i = 0; i < n2; ++i) {
            prismLog.print(this.getVarName(i));
            if (i >= n2 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("states=[");
        }
        if (n != 2) {
            this.getReachableStates().print(prismLog);
        } else {
            this.getReachableStates().printMatlab(prismLog);
        }
        if (n == 2) {
            prismLog.println("];");
        }
    }

    @Override
    public String globalToLocal(long l) {
        Object object = "";
        object = (String)object + "(";
        for (int i = 0; i < this.numVars - 1; ++i) {
            object = (String)object + (l / this.gtol[i + 1] + (long)this.varList.getLow(i)) + ",";
            l %= this.gtol[i + 1];
        }
        object = (String)object + (l + (long)this.varList.getLow(this.numVars - 1)) + ")";
        return object;
    }

    @Override
    public int globalToLocal(long l, int n) {
        for (int i = 0; i < this.numVars - 1; ++i) {
            if (i == n) {
                return (int)(l / this.gtol[i + 1] + (long)this.varList.getLow(i));
            }
            l %= this.gtol[i + 1];
        }
        return (int)(l + (long)this.varList.getLow(this.numVars - 1));
    }

    public ProbModel getTransformed(ProbModelTransformationOperator probModelTransformationOperator) throws PrismException {
        Object object;
        VarList varList;
        JDDVars jDDVars;
        JDDVars jDDVars2;
        JDDVars[] jDDVarsArray;
        JDDVars[] jDDVarsArray2;
        int n;
        Object object2 = probModelTransformationOperator.getExtraStateVariableName();
        while (this.varList.getIndex((String)object2) != -1) {
            object2 = "_" + (String)object2;
        }
        ModelVariablesDD modelVariablesDD = this.getModelVariables().copy();
        int n2 = probModelTransformationOperator.getExtraStateVariableCount();
        boolean bl = modelVariablesDD.canPrependExtraStateVariable(n2);
        JDDVars jDDVars3 = new JDDVars();
        JDDVars jDDVars4 = new JDDVars();
        JDDVars jDDVars5 = modelVariablesDD.allocateExtraStateVariable(n2, (String)object2, bl);
        for (n = 0; n < n2; ++n) {
            jDDVars3.addVar(jDDVars5.getVar(2 * n));
            jDDVars4.addVar(jDDVars5.getVar(2 * n + 1));
        }
        probModelTransformationOperator.hookExtraStateVariableAllocation(jDDVars3.copy(), jDDVars4.copy());
        if (n2 == 0) {
            jDDVarsArray2 = JDDVars.copyArray(this.varDDRowVars);
            jDDVarsArray = JDDVars.copyArray(this.varDDColVars);
            jDDVars2 = this.allDDRowVars.copy();
            jDDVars = this.allDDColVars.copy();
            varList = (VarList)this.varList.clone();
        } else {
            jDDVarsArray2 = new JDDVars[this.varDDRowVars.length + 1];
            jDDVarsArray = new JDDVars[this.varDDRowVars.length + 1];
            jDDVarsArray2[bl ? 0 : this.varDDRowVars.length] = jDDVars3.copy();
            jDDVarsArray[bl ? 0 : this.varDDColVars.length] = jDDVars4.copy();
            for (n = 0; n < this.varDDRowVars.length; ++n) {
                jDDVarsArray2[bl ? n + 1 : n] = this.varDDRowVars[n].copy();
                jDDVarsArray[bl ? n + 1 : n] = this.varDDColVars[n].copy();
            }
            if (bl) {
                jDDVars2 = jDDVars3.copy();
                jDDVars = jDDVars4.copy();
                jDDVars2.copyVarsFrom(this.allDDRowVars);
                jDDVars.copyVarsFrom(this.allDDColVars);
            } else {
                jDDVars2 = this.allDDRowVars.copy();
                jDDVars = this.allDDColVars.copy();
                jDDVars2.copyVarsFrom(jDDVars3);
                jDDVars.copyVarsFrom(jDDVars4);
            }
            varList = (VarList)this.varList.clone();
            object = new Declaration((String)object2, new DeclarationInt(Expression.Int(0), Expression.Int((1 << n2) - 1)));
            varList.addVar(bl ? 0 : this.varList.getNumVars(), (Declaration)object, 1, this.getConstantValues());
        }
        JDDNode jDDNode = probModelTransformationOperator.getTransformedTrans();
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars2, jDDVars);
        }
        JDDNode jDDNode2 = probModelTransformationOperator.getTransformedStart();
        if (SanityJDD.enabled) {
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars2);
        }
        JDDNode[] jDDNodeArray = new JDDNode[this.stateRewards.length];
        for (n = 0; n < this.stateRewards.length; ++n) {
            jDDNodeArray[n] = probModelTransformationOperator.getTransformedStateReward(this.stateRewards[n]);
            if (!SanityJDD.enabled) continue;
            SanityJDD.checkIsDDOverVars(jDDNodeArray[n], jDDVars2);
        }
        JDDNode[] jDDNodeArray2 = new JDDNode[this.transRewards.length];
        for (n = 0; n < this.transRewards.length; ++n) {
            jDDNodeArray2[n] = probModelTransformationOperator.getTransformedTransReward(this.transRewards[n]);
            if (!SanityJDD.enabled) continue;
            SanityJDD.checkIsDDOverVars(jDDNodeArray2[n], jDDVars2, jDDVars);
        }
        object = new ProbModel(jDDNode, jDDNode2, jDDNodeArray, jDDNodeArray2, (String[])this.rewardStructNames.clone(), jDDVars2, jDDVars, modelVariablesDD, this.getNumModules(), this.getModuleNames(), JDDVars.copyArray(this.getModuleDDRowVars()), JDDVars.copyArray(this.getModuleDDColVars()), varList.getNumVars(), varList, jDDVarsArray2, jDDVarsArray, this.getConstantValues());
        JDDNode jDDNode3 = probModelTransformationOperator.getReachableStates();
        if (jDDNode3 != null) {
            ((ProbModel)object).setReach(jDDNode3);
        } else {
            jDDNode3 = probModelTransformationOperator.getReachableStateSeed();
            if (jDDNode3 != null) {
                ((ProbModel)object).doReachability(jDDNode3);
            } else {
                ((ProbModel)object).doReachability();
            }
        }
        ((ProbModel)object).filterReachableStates();
        if (!probModelTransformationOperator.deadlocksAreFine()) {
            ((ProbModel)object).findDeadlocks(false);
            if (((ProbModel)object).getDeadlockStates().size() > 0) {
                throw new PrismException("Transformed model has deadlock states");
            }
        }
        for (Map.Entry<String, JDDNode> entry : this.labelsDD.entrySet()) {
            JDDNode jDDNode4 = entry.getValue();
            JDDNode jDDNode5 = probModelTransformationOperator.getTransformedLabelStates(jDDNode4, ((ProbModel)object).getReach());
            ((ProbModel)object).labelsDD.put(entry.getKey(), jDDNode5);
        }
        jDDVars3.derefAll();
        jDDVars4.derefAll();
        return object;
    }

    @Override
    public State convertBddToState(JDDNode jDDNode) {
        return ProbModel.convertBddToState(jDDNode, this.allDDRowVars, this.varList);
    }

    public static State convertBddToState(JDDNode jDDNode, JDDVars jDDVars, VarList varList) {
        JDDNode jDDNode2 = jDDNode;
        int n = jDDVars.n();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (jDDNode2.getIndex() > jDDVars.getVarIndex(i)) continue;
            if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                jDDNode2 = jDDNode2.getElse();
                continue;
            }
            bitSet.set(i, true);
            jDDNode2 = jDDNode2.getThen();
        }
        return varList.convertBitSetToState(bitSet);
    }

    @Override
    public int convertBddToIndex(JDDNode jDDNode) throws PrismNotSupportedException {
        ODDUtils.checkInt(this.odd, "Cannot convert Bdd to index in model");
        JDDNode jDDNode2 = jDDNode;
        ODDNode oDDNode = this.odd;
        int n = this.allDDRowVars.n();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (jDDNode2.getIndex() > this.allDDRowVars.getVarIndex(i)) {
                oDDNode = oDDNode.getElse();
                continue;
            }
            if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                jDDNode2 = jDDNode2.getElse();
                oDDNode = oDDNode.getElse();
                continue;
            }
            jDDNode2 = jDDNode2.getThen();
            n2 = (int)((long)n2 + oDDNode.getEOff());
            oDDNode = oDDNode.getThen();
        }
        return n2;
    }

    @Override
    public void clear() {
        int n;
        for (Map.Entry<String, JDDNode> entry : this.labelsDD.entrySet()) {
            JDD.Deref(entry.getValue());
        }
        this.labelsDD.clear();
        if (this.varDDRowVars != null) {
            JDDVars.derefAllArray(this.varDDRowVars);
        }
        if (this.varDDColVars != null) {
            JDDVars.derefAllArray(this.varDDColVars);
        }
        if (this.moduleDDRowVars != null) {
            JDDVars.derefAllArray(this.moduleDDRowVars);
        }
        if (this.moduleDDColVars != null) {
            JDDVars.derefAllArray(this.moduleDDColVars);
        }
        this.allDDRowVars.derefAll();
        this.allDDColVars.derefAll();
        JDD.Deref(this.trans);
        JDD.Deref(this.trans01);
        JDD.Deref(this.start);
        if (this.reach != null) {
            JDD.Deref(this.reach);
        }
        if (this.deadlocks != null) {
            JDD.Deref(this.deadlocks);
        }
        for (n = 0; n < this.numRewardStructs; ++n) {
            JDD.Deref(this.stateRewards[n]);
            JDD.Deref(this.transRewards[n]);
        }
        if (this.transActions != null) {
            JDD.Deref(this.transActions);
        }
        if (this.transPerAction != null) {
            for (n = 0; n < this.numSynchs + 1; ++n) {
                JDD.Deref(this.transPerAction[n]);
            }
        }
        if (this.odd != null) {
            ODDUtils.ClearODD(this.odd);
            this.odd = null;
        }
        if (this.modelVariables != null) {
            this.modelVariables.clear();
        }
    }
}

