/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.iterable.PrimitiveIterable;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import param.BigRational;
import prism.PrismException;

public class PrismUtils {
    public static double epsilonDouble = 1.0E-12;
    private static DecimalFormat formatterPercent1dp = new DecimalFormat("#0.0%", DecimalFormatSymbols.getInstance(Locale.UK));
    private static DecimalFormat formatterDouble2dp = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.UK));

    public static double log(double d, double d2) {
        if (d2 <= 0.0 || d2 == 1.0 || Double.isInfinite(d2) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return Math.log(d) / Math.log(d2);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static boolean doublesAreCloseAbs(double d, double d2, double d3) {
        if (Double.isInfinite(d)) {
            return Double.isInfinite(d2) && d > 0.0 == d2 > 0.0;
        }
        if (Double.isInfinite(d2)) {
            return false;
        }
        return Math.abs(d - d2) < d3;
    }

    public static boolean doublesAreCloseRel(double d, double d2, double d3) {
        if (Double.isInfinite(d)) {
            return Double.isInfinite(d2) && d > 0.0 == d2 > 0.0;
        }
        if (Double.isInfinite(d2)) {
            return false;
        }
        if (d2 == 0.0) {
            return d == 0.0;
        }
        return Math.abs((d - d2) / d) < d3;
    }

    public static boolean doublesAreClose(double d, double d2, double d3, boolean bl) {
        if (bl) {
            return PrismUtils.doublesAreCloseAbs(d, d2, d3);
        }
        return PrismUtils.doublesAreCloseRel(d, d2, d3);
    }

    public static boolean doublesAreClose(double[] dArray, double[] dArray2, double d, boolean bl) {
        int n = Math.min(dArray.length, dArray2.length);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                if (PrismUtils.doublesAreCloseAbs(dArray[i], dArray2[i], d)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (PrismUtils.doublesAreCloseRel(dArray[i], dArray2[i], d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean doublesAreClose(double[] dArray, double[] dArray2, PrimitiveIterable.OfInt ofInt, double d, boolean bl) {
        return PrismUtils.doublesAreClose(dArray, dArray2, ofInt.iterator(), d, bl);
    }

    public static boolean doublesAreClose(double[] dArray, double[] dArray2, PrimitiveIterator.OfInt ofInt, double d, boolean bl) {
        if (bl) {
            while (ofInt.hasNext()) {
                int n = ofInt.nextInt();
                if (PrismUtils.doublesAreCloseAbs(dArray[n], dArray2[n], d)) continue;
                return false;
            }
        } else {
            while (ofInt.hasNext()) {
                int n = ofInt.nextInt();
                if (PrismUtils.doublesAreCloseRel(dArray[n], dArray2[n], d)) continue;
                return false;
            }
        }
        return true;
    }

    public static <X> boolean doublesAreClose(HashMap<X, Double> hashMap, HashMap<X, Double> hashMap2, double d, boolean bl) {
        Set<Map.Entry<X, Double>> set = hashMap.entrySet();
        for (Map.Entry<X, Double> entry : set) {
            double d2 = entry.getValue();
            if (hashMap2.get(entry.getKey()) == null) continue;
            double d3 = hashMap2.get(entry.getKey());
            if (!(bl ? !PrismUtils.doublesAreCloseAbs(d2, d3, d) : !PrismUtils.doublesAreCloseRel(d2, d3, d))) continue;
            return false;
        }
        return true;
    }

    public static <X> double measureSupNorm(HashMap<X, Double> hashMap, HashMap<X, Double> hashMap2, boolean bl) {
        double d = 0.0;
        Set<Map.Entry<X, Double>> set = hashMap.entrySet();
        for (Map.Entry<X, Double> entry : set) {
            double d2 = entry.getValue();
            if (hashMap2.get(entry.getKey()) == null) continue;
            double d3 = hashMap2.get(entry.getKey());
            double d4 = bl ? PrismUtils.measureSupNormAbs(d2, d3) : PrismUtils.measureSupNormRel(d2, d3);
            if (!(d4 > d)) continue;
            d = d4;
        }
        return d;
    }

    public static double measureSupNorm(double[] dArray, double[] dArray2, boolean bl) {
        int n = Math.min(dArray.length, dArray2.length);
        double d = 0.0;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                double d2 = PrismUtils.measureSupNormAbs(dArray[i], dArray2[i]);
                if (!(d2 > d)) continue;
                d = d2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d3 = PrismUtils.measureSupNormRel(dArray[i], dArray2[i]);
                if (!(d3 > d)) continue;
                d = d3;
            }
        }
        return d;
    }

    public static double measureSupNormAbs(double d, double d2) {
        if (Double.isInfinite(d) && d == d2) {
            return 0.0;
        }
        return Math.abs(d - d2);
    }

    public static double measureSupNormRel(double d, double d2) {
        if (d == d2) {
            return 0.0;
        }
        return Math.abs(d - d2) / d;
    }

    public static double measureSupNormInterval(double[] dArray, double[] dArray2, boolean bl, PrimitiveIterator.OfInt ofInt) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = PrismUtils.measureSupNormInterval(dArray[n], dArray2[n], bl);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double measureSupNormInterval(double[] dArray, double[] dArray2, boolean bl) {
        int n = Math.min(dArray.length, dArray2.length);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = PrismUtils.measureSupNormInterval(dArray[i], dArray2[i], bl);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double measureSupNormInterval(double d, double d2, boolean bl) {
        if (Double.isInfinite(d)) {
            if (Double.isInfinite(d2) && d > 0.0 == d2 > 0.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(d2)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == d2) {
            return 0.0;
        }
        d = Math.abs(d);
        d2 = Math.abs(d2);
        double d3 = d2 - d;
        d3 = Math.abs(d3);
        if (!bl) {
            d3 /= d;
        }
        return d3;
    }

    public static boolean doublesAreEqual(double d, double d2) {
        return PrismUtils.doublesAreCloseRel(d, d2, epsilonDouble);
    }

    public static double findMaxFinite(double[] dArray, PrimitiveIterator.OfInt ofInt) {
        double d = Double.NEGATIVE_INFINITY;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = dArray[n];
            if (!(d2 < Double.POSITIVE_INFINITY)) continue;
            d = Double.max(d2, d);
        }
        return d;
    }

    public static void ensureMonotonicityFromBelow(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            if (!(d > d2)) continue;
            dArray2[i] = d;
        }
    }

    public static void ensureMonotonicityFromAbove(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            if (!(d < d2)) continue;
            dArray2[i] = d;
        }
    }

    public static void checkMonotonicity(double[] dArray, double[] dArray2, boolean bl) throws PrismException {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            if (bl && d < d2) {
                throw new PrismException("Monotonicity violated (from above): old value " + d + " < new value " + d2);
            }
            if (bl || !(d > d2)) continue;
            throw new PrismException("Monotonicity violated (from below): old value " + d + " > new value " + d2);
        }
    }

    public static void selectMidpoint(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = dArray[i];
            double d3 = dArray2[i];
            if (d2 == d3 || !((d = d2 + (d3 - d2) / 2.0) >= d2) || !(d <= d3)) continue;
            dArray[i] = d;
        }
    }

    public static double[] normalise(double[] dArray) {
        int n;
        double d = 0.0;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d += dArray[n];
        }
        n = 0;
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / d;
        }
        return dArray;
    }

    public static double[] normalise(double[] dArray, PrimitiveIterable.OfInt ofInt) {
        int n;
        double d = 0.0;
        PrimitiveIterator.OfInt ofInt2 = ofInt.iterator();
        while (ofInt2.hasNext()) {
            n = ofInt2.nextInt();
            d += dArray[n];
        }
        ofInt2 = ofInt.iterator();
        while (ofInt2.hasNext()) {
            int n2 = n = ofInt2.nextInt();
            dArray[n2] = dArray[n2] / d;
        }
        return dArray;
    }

    public static String bigIntToString(double d) {
        if (d <= 9.223372036854776E18) {
            return "" + Math.round(d);
        }
        return "" + d;
    }

    public static String addCounterSuffixToFilename(String string, int n) {
        return PrismUtils.addSuffixToFilename(string, "" + n);
    }

    public static String addSuffixToFilename(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n) + string2 + string.substring(n);
        }
        return string + string2;
    }

    public static String formatPercent1dp(double d) {
        return formatterPercent1dp.format(d);
    }

    public static String formatDouble2dp(double d) {
        return formatterDouble2dp.format(d);
    }

    public static String formatDouble(double d) {
        return PrismUtils.formatDouble(17, d);
    }

    public static String formatDouble(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("Precision has to be >= 1; got " + n);
        }
        String string = String.format((Locale)null, "%." + n + "g", d);
        string = string.replaceFirst("\\.0+(e|$)", "$1");
        return string.replaceFirst("(\\.[0-9]*?)0+(e|$)", "$1$2");
    }

    public static String formatIntFromDouble(double d) {
        BigRational bigRational = BigRational.from(d);
        return bigRational.toString();
    }

    public static String joinString(List<?> list, String string) {
        Object object = "";
        boolean bl = true;
        for (Object obj : list) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + string;
            }
            object = (String)object + obj.toString();
        }
        return object;
    }

    public static String joinString(Object[] objectArray, String string) {
        Object object = "";
        boolean bl = true;
        for (Object object2 : objectArray) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + string;
            }
            object = (String)object + object2.toString();
        }
        return object;
    }

    public static int findCycle(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                if (!blArray[n3][n3]) continue;
                n2 = n3;
                break;
            }
            if (n2 != -1) break;
            for (n3 = 0; n3 < n; ++n3) {
                for (int j = 0; j < n; ++j) {
                    if (!blArray[n3][j]) continue;
                    for (int k = 0; k < n; ++k) {
                        boolean[] blArray2 = blArray[n3];
                        int n4 = k;
                        blArray2[n4] = blArray2[n4] | blArray[j][k];
                    }
                }
            }
        }
        return n2;
    }

    public static long convertMemoryStringtoKB(String string) throws PrismException {
        long l;
        Pattern pattern = Pattern.compile("([0-9]+)([kmg]?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new PrismException("Invalid amount of memory \"" + string + "\"");
        }
        try {
            l = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Invalid amount of memory \"" + string + "\"");
        }
        if (matcher.group(2).equals("") || matcher.group(2).equals("k")) {
            return l;
        }
        if (matcher.group(2).equals("m")) {
            return l * 1024L;
        }
        if (matcher.group(2).equals("g")) {
            return l * 0x100000L;
        }
        throw new PrismException("Invalid amount of memory \"" + string + "\"");
    }

    public static int convertTimeStringtoSeconds(String string) throws PrismException {
        int n;
        Pattern pattern = Pattern.compile("([0-9]+)([smhdw]?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new PrismException("Invalid time value \"" + string + "\"");
        }
        try {
            n = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Invalid time value \"" + string + "\"");
        }
        switch (matcher.group(2)) {
            case "": 
            case "s": {
                return n;
            }
            case "m": {
                return n * 60;
            }
            case "h": {
                return n * 3600;
            }
            case "d": {
                return n * 86400;
            }
            case "w": {
                return n * 604800;
            }
        }
        throw new PrismException("Invalid time value \"" + string + "\"");
    }

    public static String convertBytesToMemoryString(long l) throws PrismException {
        String[] stringArray = new String[]{"b", "k", "m", "g"};
        for (int i = 3; i > 0; --i) {
            long l2 = 1 << i * 10;
            if (l < l2) continue;
            return (Serializable)(l % l2 == 0L ? Long.valueOf(l / l2) : String.format(Locale.UK, "%.1f", (double)l / (double)l2)) + stringArray[i];
        }
        return l + stringArray[0];
    }

    public static PrintStream newPrintStream(String string) throws PrismException {
        try {
            return new PrintStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("File \"" + string + "\" could not opened for output");
        }
    }

    public static int compareVersions(String string, String string2) {
        int n;
        String[] stringArray;
        String[] stringArray2;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        if (string.equals(string2)) {
            return 0;
        }
        String[] stringArray3 = string.split("\\.");
        if (stringArray3.length < (n2 = Math.max(stringArray3.length, (stringArray2 = string2.split("\\.")).length))) {
            stringArray = new String[n2];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n] = stringArray3[n];
            }
            for (n = stringArray3.length; n < n2; ++n) {
                stringArray[n] = "";
            }
            stringArray3 = stringArray;
        }
        if (stringArray2.length < n2) {
            stringArray = new String[n2];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray[n] = stringArray2[n];
            }
            for (n = stringArray2.length; n < n2; ++n) {
                stringArray[n] = "";
            }
            stringArray2 = stringArray;
        }
        for (n = 0; n < n2; ++n) {
            boolean bl;
            boolean bl2;
            int n3;
            if (stringArray3[n].matches("alpha.*")) {
                try {
                    n3 = stringArray3[n].length() == 5 ? 0 : Integer.parseInt(stringArray3[n].substring(5));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + (-10000 + n3);
            }
            if (stringArray2[n].matches("alpha.*")) {
                try {
                    n3 = stringArray2[n].length() == 5 ? 0 : Integer.parseInt(stringArray2[n].substring(5));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + (-10000 + n3);
            }
            if (stringArray3[n].matches("beta.*")) {
                try {
                    n3 = stringArray3[n].length() == 4 ? 0 : Integer.parseInt(stringArray3[n].substring(4));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + (-100 + n3);
            }
            if (stringArray2[n].matches("beta.*")) {
                try {
                    n3 = stringArray2[n].length() == 4 ? 0 : Integer.parseInt(stringArray2[n].substring(4));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + (-100 + n3);
            }
            if (stringArray3[n].equals("")) {
                stringArray3[n] = "0";
            }
            if (stringArray2[n].equals("")) {
                stringArray2[n] = "0";
            }
            if (stringArray3[n].matches("dev.*")) {
                try {
                    n3 = stringArray3[n].length() == 3 ? 0 : Integer.parseInt(stringArray3[n].substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + (0.5 + (double)n3 / 1000.0);
            }
            if (stringArray2[n].matches("dev.*")) {
                try {
                    n3 = stringArray2[n].length() == 3 ? 0 : Integer.parseInt(stringArray2[n].substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + (0.5 + (double)n3 / 1000.0);
            }
            if (stringArray3[n].matches("r.*")) {
                try {
                    n3 = Integer.parseInt(stringArray3[n].substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray3[n] = "" + n3;
            }
            if (stringArray2[n].matches("r.*")) {
                try {
                    n3 = Integer.parseInt(stringArray2[n].substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                stringArray2[n] = "" + n3;
            }
            try {
                bl2 = true;
                d = Double.parseDouble(stringArray3[n]);
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
            }
            try {
                bl = true;
                d2 = Double.parseDouble(stringArray2[n]);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (!bl2 || !bl) continue;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            if (d != d2) continue;
        }
        return 0;
    }
}

