/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.iterable.Range;
import dv.DoubleVector;
import explicit.CTMC;
import explicit.CTMCModelChecker;
import explicit.ConstructModel;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.ExplicitFiles2Model;
import explicit.FastAdaptiveUniformisation;
import explicit.FastAdaptiveUniformisationModelChecker;
import explicit.ModelModelGenerator;
import explicit.PartiallyObservableModel;
import explicit.SCCConsumer;
import explicit.SCCConsumerStore;
import hybrid.PrismHybrid;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import mtbdd.PrismMTBDD;
import odd.ODDUtils;
import param.BigRational;
import param.FunctionFactory;
import param.ModelBuilder;
import param.ParamMode;
import param.ParamModel;
import param.ParamModelChecker;
import param.ParamResult;
import parser.PrismParser;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ForLoop;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import prism.Accuracy;
import prism.ECComputer;
import prism.ExplicitFiles2MTBDD;
import prism.ExplicitFiles2ModelInfo;
import prism.ExplicitFilesRewardGenerator;
import prism.ExplicitFilesRewardGenerator4Explicit;
import prism.ExplicitFilesRewardGenerator4MTBDD;
import prism.ExplicitModel2MTBDD;
import prism.Model;
import prism.ModelGenerator;
import prism.ModelGenerator2MTBDD;
import prism.ModelInfo;
import prism.ModelType;
import prism.Modules2MTBDD;
import prism.NondetModel;
import prism.OptionsIntervalIteration;
import prism.PEPA2Prism;
import prism.Preprocessor;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLanguageTranslator;
import prism.PrismLog;
import prism.PrismModelListener;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import prism.PrismUtils;
import prism.ProbModelChecker;
import prism.Result;
import prism.ResultsCollection;
import prism.RewardGenerator;
import prism.SBML2Prism;
import prism.SCCComputer;
import prism.StateList;
import prism.StateListMTBDD;
import prism.StateModelChecker;
import prism.StateValues;
import prism.StochModelChecker;
import prism.UndefinedConstants;
import prism.Version;
import pta.DigitalClocks;
import pta.PTAModelChecker;
import simulator.GenerateSimulationPath;
import simulator.ModulesFileModelGenerator;
import simulator.SimulatorEngine;
import simulator.method.SimulationMethod;
import sparse.PrismSparse;
import strat.Strategy;
import strat.StrategyExportOptions;
import strat.StrategyGenerator;

public class Prism
extends PrismComponent
implements PrismSettingsListener {
    private static String versionExtension = Version.versionExtensionString;
    private static String versionExtensionSuffix = Version.versionExtensionSuffixString;
    private static String version = Version.versionString;
    private static String versionSuffix = Version.versionSuffixString;
    private static String buildNumber = "";
    public static final int MTBDD = 1;
    public static final int SPARSE = 2;
    public static final int HYBRID = 3;
    public static final int EXPLICIT = 4;
    private static String[] engineStrings;
    public static final int POWER = 1;
    public static final int JACOBI = 2;
    public static final int GAUSSSEIDEL = 3;
    public static final int BGAUSSSEIDEL = 4;
    public static final int PGAUSSSEIDEL = 5;
    public static final int BPGAUSSSEIDEL = 6;
    public static final int JOR = 7;
    public static final int SOR = 8;
    public static final int BSOR = 9;
    public static final int PSOR = 10;
    public static final int BPSOR = 11;
    public static final int MDP_VALITER = 1;
    public static final int MDP_GAUSSSEIDEL = 2;
    public static final int MDP_POLITER = 3;
    public static final int MDP_MODPOLITER = 4;
    public static final int MDP_LP = 5;
    public static final int MDP_MULTI_VALITER = 1;
    public static final int MDP_MULTI_GAUSSSEIDEL = 2;
    public static final int MDP_MULTI_LP = 3;
    public static final int ABSOLUTE = 1;
    public static final int RELATIVE = 2;
    public static final int EXPORT_PLAIN = 1;
    public static final int EXPORT_MATLAB = 2;
    public static final int EXPORT_DOT = 3;
    public static final int EXPORT_MRMC = 4;
    public static final int EXPORT_ROWS = 5;
    public static final int EXPORT_DOT_STATES = 6;
    public static final int EXPORT_ADV_NONE = 1;
    public static final int EXPORT_ADV_DTMC = 2;
    public static final int EXPORT_ADV_MDP = 3;
    public static final int EXPORT_STRAT_ACTIONS = 1;
    public static final int EXPORT_STRAT_INDICES = 2;
    public static final int EXPORT_STRAT_INDUCED = 3;
    public static final int EXPORT_STRAT_DOT = 4;
    public static final int XIEBEEREL = 1;
    public static final int LOCKSTEP = 2;
    public static final int SCCFIND = 3;
    protected static final int MTBDD_STATES_THRESHOLD = 100000000;
    protected boolean exportPrism = false;
    protected File exportPrismFile = null;
    protected boolean exportPrismConst = false;
    protected File exportPrismConstFile = null;
    protected boolean exportDigital = false;
    protected File exportDigitalFile = null;
    protected boolean exportTarget = false;
    protected String exportTargetFilename = null;
    protected boolean exportProductTrans = false;
    protected String exportProductTransFilename = null;
    protected boolean exportProductStates = false;
    protected String exportProductStatesFilename = null;
    protected boolean exportProductVector = false;
    protected String exportProductVectorFilename = null;
    protected boolean storeVector = false;
    protected boolean genStrat = false;
    protected boolean restrictStratToReach = true;
    protected boolean doBisim = false;
    private boolean doReach = true;
    private boolean bsccComp = true;
    private boolean checkZeroLoops = false;
    private int construction = 3;
    private int ordering = 1;
    private int reachMethod = REACH_BFS;
    private static PrismParser thePrismParser;
    private static boolean prismParserInUse;
    private SimulatorEngine theSimulator = null;
    private List<PrismModelListener> modelListeners;
    private ModelSource currentModelSource = ModelSource.PRISM_MODEL;
    private ModelType currentModelType = null;
    private ModelInfo currentModelInfo = null;
    private ModulesFile currentModulesFile = null;
    private ModelGenerator<?> currentModelGenerator = null;
    private RewardGenerator<?> currentRewardGenerator = null;
    private Values currentDefinedMFConstants = null;
    private boolean currentDefinedMFConstantsAreExact = false;
    private Model currentModel = null;
    private explicit.Model<?> currentModelExpl = null;
    private ModelBuildType currentModelBuildType = null;
    boolean digital = false;
    private Strategy<?> strategy = null;
    private File explicitFilesStatesFile = null;
    private File explicitFilesTransFile = null;
    private File explicitFilesLabelsFile = null;
    private List<File> explicitFilesStateRewardsFiles = new ArrayList<File>();
    private int explicitFilesNumStates = -1;
    private boolean cuddStarted = false;
    private int engineOld = -1;
    private boolean engineSwitched = false;
    public static int REACH_BFS;
    public static int REACH_FRONTIER;

    public Prism(PrismLog prismLog) {
        this.mainLog = prismLog;
        this.settings = new PrismSettings();
        this.settings.addSettingsListener(this);
        this.modelListeners = new ArrayList<PrismModelListener>();
    }

    @Deprecated
    public Prism(PrismLog prismLog, PrismLog prismLog2) {
        this(prismLog);
    }

    public void loadUserSettingsFile() {
        this.loadUserSettingsFile(null);
    }

    public void loadUserSettingsFile(File file) {
        try {
            if (file == null) {
                this.settings.loadSettingsFile();
            } else {
                this.settings.loadSettingsFile(file);
            }
        }
        catch (PrismException prismException) {
            try {
                if (file == null) {
                    this.settings.saveSettingsFile();
                } else {
                    this.settings.saveSettingsFile(file);
                }
            }
            catch (PrismException prismException2) {
                this.mainLog.printWarning("Failed to create new PRISM settings file.");
            }
        }
    }

    public void setMainLog(PrismLog prismLog) {
        this.mainLog = prismLog;
        JDD.SetOutputStream(this.mainLog.getFilePointer());
        PrismMTBDD.setMainLog(this.mainLog);
        PrismSparse.setMainLog(this.mainLog);
        PrismHybrid.setMainLog(this.mainLog);
    }

    public void setEngine(int n) throws PrismException {
        this.settings.setChoice("prism.engine", n);
    }

    public void setVerbose(boolean bl) throws PrismException {
        this.settings.set("prism.verbose", bl);
    }

    public void setFairness(boolean bl) throws PrismException {
        this.settings.set("prism.fairness", bl);
    }

    public void setPrecomp(boolean bl) throws PrismException {
        this.settings.set("prism.precomputation", bl);
    }

    public void setProb0(boolean bl) throws PrismException {
        this.settings.set("prism.prob0", bl);
    }

    public void setProb1(boolean bl) throws PrismException {
        this.settings.set("prism.prob1", bl);
    }

    public void setFixDeadlocks(boolean bl) throws PrismException {
        this.settings.set("prism.fixDeadlocks", bl);
    }

    public void setDoProbChecks(boolean bl) throws PrismException {
        this.settings.set("prism.doProbChecks", bl);
    }

    public void setSumRoundOff(double d) throws PrismException {
        this.settings.set("prism.sumRoundOff", d);
    }

    public void setCompact(boolean bl) throws PrismException {
        this.settings.set("prism.compact", bl);
    }

    public void setLinEqMethod(int n) throws PrismException {
        this.settings.setChoice("prism.linEqMethod", n);
    }

    public void setLinEqMethodParam(double d) throws PrismException {
        this.settings.set("prism.linEqMethodParam", d);
    }

    public void setMDPSolnMethod(int n) throws PrismException {
        this.settings.setChoice("prism.mdpSolnMethod", n);
    }

    public void setMDPMultiSolnMethod(int n) throws PrismException {
        this.settings.setChoice("prism.mdpMultiSolnMethod", n);
    }

    public void setTermCrit(int n) throws PrismException {
        this.settings.setChoice("prism.termCrit", n);
    }

    public void setTermCritParam(double d) throws PrismException {
        this.settings.set("prism.termCritParam", d);
    }

    public void setMaxIters(int n) throws PrismException {
        this.settings.set("prism.maxIters", n);
    }

    public void setGridResolution(int n) throws PrismException {
        this.settings.set("prism.gridResolution", n);
    }

    public void setCUDDMaxMem(String string) throws PrismException {
        this.settings.set("prism.cuddMaxMem", string);
    }

    public void setCUDDEpsilon(double d) throws PrismException {
        this.settings.set("prism.cuddEpsilon", d);
    }

    public void setNumSBLevels(int n) throws PrismException {
        this.settings.set("prism.numSBLevels", n);
    }

    public void setSBMaxMem(int n) throws PrismException {
        this.settings.set("prism.SBMaxMem", n);
    }

    public void setNumSORLevels(int n) throws PrismException {
        this.settings.set("prism.numSORLevels", n);
    }

    public void setSORMaxMem(int n) throws PrismException {
        this.settings.set("prism.SORMaxMem", n);
    }

    public void setDoSSDetect(boolean bl) throws PrismException {
        this.settings.set("prism.doSSDetect", bl);
    }

    public void setExtraDDInfo(boolean bl) throws PrismException {
        this.settings.set("prism.extraDDInfo", bl);
    }

    public void setExtraReachInfo(boolean bl) throws PrismException {
        this.settings.set("prism.extraReachInfo", bl);
    }

    public void setSCCMethod(int n) throws PrismException {
        this.settings.setChoice("prism.sccMethod", n);
    }

    public void setExportAdv(int n) throws PrismException {
        this.settings.setChoice("prism.exportAdv", n);
    }

    public void setExportAdvFilename(String string) throws PrismException {
        this.settings.set("prism.exportAdvFilename", string);
    }

    public void setExportPrism(boolean bl) throws PrismException {
        this.exportPrism = bl;
    }

    public void setExportPrismFile(File file) throws PrismException {
        this.exportPrismFile = file;
    }

    public void setExportPrismConst(boolean bl) throws PrismException {
        this.exportPrismConst = bl;
    }

    public void setExportPrismConstFile(File file) throws PrismException {
        this.exportPrismConstFile = file;
    }

    public void setExportDigital(boolean bl) throws PrismException {
        this.exportDigital = bl;
    }

    public void setExportDigitalFile(File file) throws PrismException {
        this.exportDigitalFile = file;
    }

    public void setExportTarget(boolean bl) throws PrismException {
        this.exportTarget = bl;
    }

    public void setExportTargetFilename(String string) throws PrismException {
        this.exportTargetFilename = string;
    }

    public void setExportProductTrans(boolean bl) throws PrismException {
        this.exportProductTrans = bl;
    }

    public void setExportProductTransFilename(String string) throws PrismException {
        this.exportProductTransFilename = string;
    }

    public void setExportProductStates(boolean bl) throws PrismException {
        this.exportProductStates = bl;
    }

    public void setExportProductStatesFilename(String string) throws PrismException {
        this.exportProductStatesFilename = string;
    }

    public void setExportProductVector(boolean bl) throws PrismException {
        this.exportProductVector = bl;
    }

    public void setExportProductVectorFilename(String string) throws PrismException {
        this.exportProductVectorFilename = string;
    }

    public void setStoreVector(boolean bl) {
        this.storeVector = bl;
    }

    public void setGenStrat(boolean bl) {
        this.genStrat = bl;
    }

    public void setRestrictStratToReach(boolean bl) {
        this.restrictStratToReach = bl;
    }

    public void setDoBisim(boolean bl) {
        this.doBisim = bl;
    }

    public void setDoReach(boolean bl) throws PrismException {
        this.doReach = bl;
    }

    public void setBSCCComp(boolean bl) throws PrismException {
        this.bsccComp = bl;
    }

    public void setCheckZeroLoops(boolean bl) {
        this.checkZeroLoops = bl;
    }

    public void setConstruction(int n) throws PrismException {
        this.construction = n;
    }

    public void setOrdering(int n) throws PrismException {
        this.ordering = n;
    }

    public void setReachMethod(int n) {
        this.reachMethod = n;
    }

    public static String getToolName() {
        return "PRISM-games";
    }

    public static String getCommandLineName() {
        return "prism-games";
    }

    public static String getVersion() {
        Object object = versionExtension;
        if (versionExtensionSuffix.length() > 0) {
            object = (String)object + "." + versionExtensionSuffix;
        }
        return object;
    }

    public static String getBaseVersion() {
        Object object = version;
        if (versionSuffix.length() > 0) {
            object = (String)object + "." + versionSuffix;
            if (buildNumber.length() > 0) {
                object = (String)object + ".r" + buildNumber;
            }
        }
        return object;
    }

    public static String getBuildNumber() {
        return buildNumber;
    }

    public PrismLog getMainLog() {
        return this.mainLog;
    }

    @Override
    public PrismSettings getSettings() {
        return this.settings;
    }

    public int getEngine() {
        return this.settings.getChoice("prism.engine");
    }

    public boolean getExplicit() {
        return this.getEngine() == 4;
    }

    public boolean getFixDeadlocks() {
        return this.settings.getBoolean("prism.fixDeadlocks");
    }

    public boolean getDoProbChecks() {
        return this.settings.getBoolean("prism.doProbChecks");
    }

    public double getSumRoundOff() {
        return this.settings.getDouble("prism.sumRoundOff");
    }

    public int getLinEqMethod() {
        return this.settings.getChoice("prism.linEqMethod");
    }

    public double getLinEqMethodParam() {
        return this.settings.getDouble("prism.linEqMethodParam");
    }

    public int getMDPSolnMethod() {
        return this.settings.getChoice("prism.mdpSolnMethod");
    }

    public int getMDPMultiSolnMethod() {
        return this.settings.getChoice("prism.mdpMultiSolnMethod");
    }

    public int getTermCrit() {
        return this.settings.getChoice("prism.termCrit");
    }

    public double getTermCritParam() {
        return this.settings.getDouble("prism.termCritParam");
    }

    public int getMaxIters() {
        return this.settings.getInteger("prism.maxIters");
    }

    public int getGridResolution() {
        return this.settings.getInteger("prism.gridResolution");
    }

    public boolean getVerbose() {
        return this.settings.getBoolean("prism.verbose");
    }

    public boolean getPrecomp() {
        return this.settings.getBoolean("prism.precomputation");
    }

    public boolean getProb0() {
        return this.settings.getBoolean("prism.prob0");
    }

    public boolean getProb1() {
        return this.settings.getBoolean("prism.prob1");
    }

    public boolean getPreRel() {
        return this.settings.getBoolean("prism.preRel");
    }

    public boolean getFairness() {
        return this.settings.getBoolean("prism.fairness");
    }

    public int getSBMaxMem() {
        return this.settings.getInteger("prism.SBMaxMem");
    }

    public int getNumSBLevels() {
        return this.settings.getInteger("prism.numSBLevels");
    }

    public int getSORMaxMem() {
        return this.settings.getInteger("prism.SORMaxMem");
    }

    public boolean getDoSSDetect() {
        return this.settings.getBoolean("prism.doSSDetect");
    }

    public boolean getExtraDDInfo() {
        return this.settings.getBoolean("prism.extraDDInfo");
    }

    public boolean getExtraReachInfo() {
        return this.settings.getBoolean("prism.extraReachInfo");
    }

    public int getNumSORLevels() {
        return this.settings.getInteger("prism.numSORLevels");
    }

    public boolean getCompact() {
        return this.settings.getBoolean("prism.compact");
    }

    public String getCUDDMaxMem() {
        return this.settings.getString("prism.cuddMaxMem");
    }

    public double getCUDDEpsilon() {
        return this.settings.getDouble("prism.cuddEpsilon");
    }

    public int getSCCMethod() {
        return this.settings.getChoice("prism.sccMethod");
    }

    public int getExportAdv() {
        return this.settings.getChoice("prism.exportAdv");
    }

    public String getExportAdvFilename() {
        return this.settings.getString("prism.exportAdvFilename");
    }

    public boolean getExportPrism() {
        return this.exportPrism;
    }

    public File getExportPrismFile() {
        return this.exportPrismFile;
    }

    public boolean getExportPrismConst() {
        return this.exportPrismConst;
    }

    public File getExportPrismConstFile() {
        return this.exportPrismConstFile;
    }

    public boolean getExportTarget() {
        return this.exportTarget;
    }

    public String getExportTargetFilename() {
        return this.exportTargetFilename;
    }

    public boolean getExportProductTrans() {
        return this.exportProductTrans;
    }

    public String getExportProductTransFilename() {
        return this.exportProductTransFilename;
    }

    public boolean getExportProductStates() {
        return this.exportProductStates;
    }

    public String getExportProductStatesFilename() {
        return this.exportProductStatesFilename;
    }

    public boolean getExportProductVector() {
        return this.exportProductVector;
    }

    public String getExportProductVectorFilename() {
        return this.exportProductVectorFilename;
    }

    public boolean getStoreVector() {
        return this.storeVector;
    }

    public boolean getGenStrat() {
        return this.genStrat;
    }

    public boolean getRestrictStratToReach() {
        return this.restrictStratToReach;
    }

    public boolean getDoBisim() {
        return this.doBisim;
    }

    public boolean getDoReach() {
        return this.doReach;
    }

    public boolean getBSCCComp() {
        return this.bsccComp;
    }

    public boolean getCheckZeroLoops() {
        return this.checkZeroLoops;
    }

    public int getConstruction() {
        return this.construction;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public int getReachMethod() {
        return this.reachMethod;
    }

    public int getIntervalIterationFlags() throws PrismException {
        int n = 0;
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this.settings);
        if (optionsIntervalIteration.isEnforceMonotonicityFromBelow()) {
            ++n;
        }
        if (optionsIntervalIteration.isEnforceMonotonicityFromAbove()) {
            n += 2;
        }
        if (optionsIntervalIteration.isSelectMidpointForResult()) {
            n += 4;
        }
        return n;
    }

    public void addModelListener(PrismModelListener prismModelListener) {
        this.modelListeners.add(prismModelListener);
    }

    public static String getEngineString(int n) {
        return engineStrings[n];
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        if (this.cuddStarted) {
            JDD.SetCUDDEpsilon(prismSettings.getDouble("prism.cuddEpsilon"));
            try {
                long l = PrismUtils.convertMemoryStringtoKB(this.getCUDDMaxMem());
                JDD.SetCUDDMaxMem(l);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        SanityJDD.enabled = prismSettings.getBoolean("prism.ddsanity");
        PrismSparse.SetExportIterations(prismSettings.getBoolean("prism.exportIterations"));
        PrismHybrid.SetExportIterations(prismSettings.getBoolean("prism.exportIterations"));
        PrismMTBDD.SetExportIterations(prismSettings.getBoolean("prism.exportIterations"));
    }

    public static PrismParser getPrismParser() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Class<Prism> clazz = Prism.class;
        synchronized (Prism.class) {
            try {
                while (prismParserInUse) {
                    Prism.class.wait();
                }
                prismParserInUse = true;
                if (thePrismParser == null) {
                    thePrismParser = new PrismParser();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return thePrismParser;
            }
            catch (InterruptedException interruptedException) {
                Prism.class.notify();
                throw interruptedException;
            }
        }
    }

    public static synchronized void releasePrismParser() {
        prismParserInUse = false;
        Prism.class.notify();
    }

    public SimulatorEngine getSimulator() {
        if (this.theSimulator == null) {
            this.theSimulator = new SimulatorEngine(this);
        }
        return this.theSimulator;
    }

    public SCCComputer getSCCComputer(Model model) throws PrismException {
        return SCCComputer.createSCCComputer(this, model);
    }

    public SCCComputer getSCCComputer(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return SCCComputer.createSCCComputer(this, jDDNode, jDDNode2, jDDVars, jDDVars2);
    }

    public explicit.SCCComputer getExplicitSCCComputer(explicit.Model<?> model, SCCConsumer sCCConsumer) throws PrismException {
        return explicit.SCCComputer.createSCCComputer(this, model, sCCConsumer);
    }

    public ECComputer getECComputer(NondetModel nondetModel) throws PrismException {
        return ECComputer.createECComputer(this, nondetModel);
    }

    public ECComputer getECComputer(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3) throws PrismException {
        return ECComputer.createECComputer(this, jDDNode, jDDNode2, jDDNode3, jDDVars, jDDVars2, jDDVars3);
    }

    public explicit.ECComputer getExplicitECComputer(explicit.NondetModel<?> nondetModel) throws PrismException {
        return explicit.ECComputer.createECComputer(this, nondetModel);
    }

    public static List<String> getListOfKeywords() {
        return PrismParser.getListOfKeywords();
    }

    public void initialise() throws PrismException {
        boolean bl = this.getSettings().getBoolean("PRISM_VERBOSE");
        this.mainLog.setVerbosityLevel(bl ? 2 : 0);
        this.mainLog.print(Prism.getToolName() + "\n");
        this.mainLog.print(new String(new char[Prism.getToolName().length()]).replace("\u0000", "=") + "\n");
        this.mainLog.print("\nVersion: " + Prism.getVersion() + " (based on PRISM " + Prism.getBaseVersion() + ")\n");
        this.mainLog.print("Date: " + new Date() + "\n");
        try {
            String string = InetAddress.getLocalHost().getHostName();
            this.mainLog.print("Hostname: " + string + "\n");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.mainLog.print("Memory limits: cudd=" + this.getCUDDMaxMem());
        this.mainLog.println(", java(heap)=" + PrismUtils.convertBytesToMemoryString(Runtime.getRuntime().maxMemory()));
        long l = PrismUtils.convertMemoryStringtoKB(this.getCUDDMaxMem());
        JDD.InitialiseCUDD(l, this.getCUDDEpsilon());
        this.cuddStarted = true;
        JDD.SetOutputStream(this.mainLog.getFilePointer());
        PrismNative.initialise(this);
        PrismMTBDD.initialise(this.mainLog, this.mainLog);
        PrismSparse.initialise(this.mainLog, this.mainLog);
        PrismHybrid.initialise(this.mainLog, this.mainLog);
        DoubleVector.setCUDDManager();
        ODDUtils.setCUDDManager();
    }

    public ModulesFile parseModelFile(File file) throws FileNotFoundException, PrismLangException {
        return this.parseModelFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesFile parseModelFile(File file, ModelType modelType) throws FileNotFoundException, PrismLangException {
        ModulesFile modulesFile = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                modulesFile = prismParser.parseModulesFile(fileInputStream, modelType);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        modulesFile.tidyUp();
        return modulesFile;
    }

    public ModulesFile parseModelString(String string) throws PrismLangException {
        return this.parseModelString(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesFile parseModelString(String string, ModelType modelType) throws PrismLangException {
        ModulesFile modulesFile = null;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                modulesFile = prismParser.parseModulesFile(new ByteArrayInputStream(string.getBytes()), modelType);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        modulesFile.tidyUp();
        return modulesFile;
    }

    public ModulesFile importPepaFile(File file) throws PrismException, PrismLangException {
        return this.importModelFile("pepa", file);
    }

    public ModulesFile importPepaString(String string) throws PrismException, PrismLangException {
        return this.importModelString("pepa", string);
    }

    public ModulesFile importSBMLFile(File file) throws PrismException, PrismLangException {
        return this.importModelFile("sbml", file);
    }

    public ModulesFile importSBMLString(String string) throws PrismException, PrismLangException {
        return this.importModelString("sbml", string);
    }

    public ModulesFile importModelFile(String string, File file) throws PrismException, PrismLangException {
        PrismLanguageTranslator prismLanguageTranslator = this.createPrismLanguageTranslator(string);
        prismLanguageTranslator.load(file);
        String string2 = prismLanguageTranslator.translateToString();
        return this.parseModelString(string2);
    }

    public ModulesFile importModelString(String string, String string2) throws PrismException, PrismLangException {
        PrismLanguageTranslator prismLanguageTranslator = this.createPrismLanguageTranslator(string);
        prismLanguageTranslator.load(string2);
        String string3 = prismLanguageTranslator.translateToString();
        return this.parseModelString(string3);
    }

    private PrismLanguageTranslator createPrismLanguageTranslator(String string) throws PrismException {
        PrismLanguageTranslator prismLanguageTranslator = null;
        switch (string) {
            case "pepa": {
                prismLanguageTranslator = new PEPA2Prism();
                break;
            }
            case "sbml": {
                prismLanguageTranslator = new SBML2Prism();
                break;
            }
            default: {
                throw new PrismException("Unknown import language \"" + string + "\"");
            }
        }
        return prismLanguageTranslator;
    }

    public ModulesFile importPrismPreprocFile(File file, String[] stringArray) throws PrismException {
        Preprocessor preprocessor = new Preprocessor(this, file);
        preprocessor.setParameters(stringArray);
        String string = preprocessor.preprocess();
        if (string == null) {
            throw new PrismException("No preprocessing information");
        }
        return this.parseModelString(string);
    }

    public PropertiesFile parsePropertiesFile(File file) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(this.currentModelInfo, file, true);
    }

    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, File file) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(modelInfo, file, true);
    }

    public PropertiesFile parsePropertiesFile(File file, boolean bl) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(this.currentModelInfo, file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, File file, boolean bl) throws FileNotFoundException, PrismLangException {
        PropertiesFile propertiesFile = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                propertiesFile = prismParser.parsePropertiesFile(modelInfo, fileInputStream);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        if (bl) {
            propertiesFile.tidyUp();
        }
        return propertiesFile;
    }

    public PropertiesFile parsePropertiesString(String string) throws PrismLangException {
        return this.parsePropertiesString(this.currentModelInfo, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFile parsePropertiesString(ModelInfo modelInfo, String string) throws PrismLangException {
        PropertiesFile propertiesFile = null;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                propertiesFile = prismParser.parsePropertiesFile(modelInfo, new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        propertiesFile.tidyUp();
        return propertiesFile;
    }

    public static Expression parseSingleExpressionString(String string) throws PrismLangException {
        Expression expression;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                expression = prismParser.parseSingleExpression(new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForLoop parseForLoopString(String string) throws PrismLangException {
        ForLoop forLoop;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                forLoop = prismParser.parseForLoop(new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return forLoop;
    }

    public void clearModel() throws PrismException {
        this.currentModelSource = null;
        this.currentModelType = null;
        this.currentModelInfo = null;
        this.currentModulesFile = null;
        this.currentModelGenerator = null;
        this.currentRewardGenerator = null;
        this.currentDefinedMFConstants = null;
        this.clearBuiltModel();
    }

    public void loadPRISMModel(ModulesFile modulesFile) throws PrismException {
        if (modulesFile == null) {
            this.clearModel();
        }
        this.currentModelSource = ModelSource.PRISM_MODEL;
        this.currentModelType = modulesFile.getModelType();
        this.currentModelInfo = modulesFile;
        this.currentModulesFile = modulesFile;
        this.currentModelGenerator = null;
        this.currentRewardGenerator = modulesFile;
        this.currentDefinedMFConstants = null;
        this.clearBuiltModel();
        this.mainLog.println();
        this.mainLog.println("Type:        " + this.currentModelInfo.getModelType());
        this.mainLog.println("Modules:     " + String.join((CharSequence)" ", this.currentModulesFile.getModuleNames()));
        this.mainLog.println("Variables:   " + String.join((CharSequence)" ", this.currentModelInfo.getVarNames()));
        if (this.currentModulesFile.getModelType().partiallyObservable()) {
            this.mainLog.println("Observables: " + String.join((CharSequence)" ", this.currentModulesFile.getObservableNames()));
        }
        if (this.exportPrism) {
            try {
                this.exportPRISMModel(this.exportPrismFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + this.exportPrismFile + "\" for output");
            }
            catch (PrismException prismException) {
                this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
            }
        }
    }

    public void loadModelGenerator(ModelGenerator<?> modelGenerator) throws PrismException {
        if (modelGenerator == null) {
            this.clearModel();
        }
        this.currentModelSource = ModelSource.MODEL_GENERATOR;
        this.currentModelType = modelGenerator.getModelType();
        this.currentModelInfo = modelGenerator;
        this.currentModulesFile = null;
        this.currentModelGenerator = modelGenerator;
        this.currentRewardGenerator = modelGenerator instanceof RewardGenerator ? (RewardGenerator<Object>)((Object)modelGenerator) : new RewardGenerator<Object>(){};
        this.currentDefinedMFConstants = null;
        this.clearBuiltModel();
        this.mainLog.println();
        this.mainLog.println("Generator: " + this.currentModelGenerator.getClass().getName());
        this.mainLog.println("Type:      " + this.currentModelInfo.getModelType());
        this.mainLog.println("Variables: " + String.join((CharSequence)" ", this.currentModelInfo.getVarNames()));
    }

    public void setPRISMModelConstants(Values values) throws PrismException {
        this.setPRISMModelConstants(values, false);
    }

    public void setPRISMModelConstants(Values values, boolean bl) throws PrismException {
        boolean bl2;
        boolean bl3 = this.currentDefinedMFConstants == null || this.currentDefinedMFConstants.getNumValues() == 0;
        boolean bl4 = bl2 = values == null || values.getNumValues() == 0;
        if (bl3 && bl2 && this.currentDefinedMFConstantsAreExact == bl) {
            return;
        }
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.equals(values) && this.currentDefinedMFConstantsAreExact == bl) {
            return;
        }
        this.clearBuiltModel();
        this.currentDefinedMFConstants = values;
        this.currentDefinedMFConstantsAreExact = bl;
        if (this.currentModulesFile != null) {
            this.currentModulesFile.setSomeUndefinedConstants(values, bl);
        }
        if (this.currentModelGenerator != null) {
            this.currentModelGenerator.setSomeUndefinedConstants(values, bl);
        }
        if (this.exportPrismConst) {
            try {
                this.exportPRISMModelWithExpandedConstants(this.exportPrismConstFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + this.exportPrismConstFile + "\" for output");
            }
            catch (PrismException prismException) {
                this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
            }
        }
    }

    public void loadPRISMModelAndBuiltModel(ModulesFile modulesFile, Model model) {
        this.currentModelSource = ModelSource.PRISM_MODEL;
        this.clearBuiltModel();
        this.currentModulesFile = modulesFile;
        this.currentModel = model;
        this.currentModelBuildType = ModelBuildType.SYMBOLIC;
        this.currentModelType = this.currentModulesFile == null ? null : this.currentModulesFile.getModelType();
        this.currentModelInfo = this.currentModulesFile;
        this.currentDefinedMFConstants = null;
    }

    public void loadBuiltModel(Model model) {
        this.currentModelSource = ModelSource.BUILT_MODEL;
        this.clearBuiltModel();
        this.currentModulesFile = null;
        this.currentModel = model;
        this.currentModelBuildType = ModelBuildType.SYMBOLIC;
        this.currentModelType = this.currentModel == null ? null : this.currentModel.getModelType();
        this.currentDefinedMFConstants = null;
    }

    public void loadModelFromExplicitFiles(File file, File file2, File file3, List<File> list, ModelType modelType) throws PrismException {
        this.currentModelSource = ModelSource.EXPLICIT_FILES;
        this.clearBuiltModel();
        ExplicitFiles2ModelInfo explicitFiles2ModelInfo = new ExplicitFiles2ModelInfo(this);
        this.currentModelInfo = explicitFiles2ModelInfo.buildModelInfo(file, file2, file3, modelType);
        this.currentModulesFile = null;
        this.currentRewardGenerator = explicitFiles2ModelInfo.buildRewardInfo(list == null || list.isEmpty() ? null : list.get(0));
        this.explicitFilesStatesFile = file;
        this.explicitFilesTransFile = file2;
        this.explicitFilesLabelsFile = file3;
        this.explicitFilesStateRewardsFiles = list == null ? new ArrayList<File>() : new ArrayList<File>(list);
        this.explicitFilesNumStates = explicitFiles2ModelInfo.getNumStates();
        this.currentModelType = this.currentModelInfo == null ? null : this.currentModelInfo.getModelType();
        this.currentDefinedMFConstants = null;
    }

    public ModelType getModelType() {
        return this.currentModelType;
    }

    public ModulesFile getPRISMModel() {
        return this.currentModulesFile;
    }

    public PrismEngine getCurrentEngine() {
        if (this.getEngine() == 4) {
            return PrismEngine.EXPLICIT;
        }
        return PrismEngine.SYMBOLIC;
    }

    public ModelGenerator<?> getModelGenerator() throws PrismException {
        if (this.currentModelGenerator == null) {
            switch (this.currentModelSource) {
                case PRISM_MODEL: {
                    if (this.currentModulesFile != null) {
                        this.currentModelGenerator = ModulesFileModelGenerator.create(this.currentModulesFile, this);
                        this.currentRewardGenerator = (ModulesFileModelGenerator)this.currentModelGenerator;
                        break;
                    }
                    throw new PrismException("There is no currently loaded PRISM model");
                }
                case MODEL_GENERATOR: {
                    throw new PrismException("There is no currently loaded model generator");
                }
                case BUILT_MODEL: 
                case EXPLICIT_FILES: {
                    this.buildModelIfRequired();
                    break;
                }
                default: {
                    throw new PrismException("Unknown model source");
                }
            }
        }
        if (this.currentModelGenerator == null) {
            throw new PrismException("Could not create a model generator");
        }
        return this.currentModelGenerator;
    }

    public Values getUndefinedModelValues() {
        return this.currentDefinedMFConstants;
    }

    public Model getBuiltModel() {
        return this.currentModel;
    }

    public explicit.Model<?> getBuiltModelExplicit() {
        return this.currentModelExpl;
    }

    public boolean modelCanBeBuilt() {
        return !this.currentModelType.realTime();
    }

    public ModelBuildType getModelBuildTypeForEngine(PrismEngine prismEngine) {
        switch (prismEngine) {
            case EXPLICIT: {
                return ModelBuildType.EXPLICIT;
            }
            case SYMBOLIC: {
                return ModelBuildType.SYMBOLIC;
            }
        }
        return null;
    }

    public boolean modelIsBuilt() {
        ModelBuildType modelBuildType = this.getModelBuildTypeForEngine(this.getCurrentEngine());
        return modelBuildType != null && this.currentModelBuildType == modelBuildType;
    }

    public Strategy<?> getStrategy() {
        return this.strategy;
    }

    public void buildModel() throws PrismException {
        this.mainLog.printSeparator();
        this.chooseEngineForModelBuild();
        this.doBuildModel();
    }

    public void buildModelIfRequired() throws PrismException {
        this.chooseEngineForModelBuild();
        if (!this.modelIsBuilt()) {
            this.doBuildModel();
        }
    }

    private void chooseEngineForModelBuild() {
        switch (this.currentModelType) {
            case IDTMC: 
            case IMDP: 
            case LTS: 
            case POMDP: 
            case CSG: 
            case SMG: 
            case STPG: 
            case CTMDP: {
                if (this.getCurrentEngine() != PrismEngine.SYMBOLIC || this.currentModelType == ModelType.SMG && this.getEngine() == 1) break;
                this.mainLog.println("\nSwitching to explicit engine, which supports " + this.currentModelType + "s...");
                this.engineOld = this.getEngine();
                this.engineSwitched = true;
                try {
                    this.setEngine(4);
                }
                catch (PrismException prismException) {}
                break;
            }
            default: {
                if (!this.engineSwitched) break;
                try {
                    this.setEngine(this.engineOld);
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
                this.engineSwitched = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBuildModel() throws PrismException {
        this.clearBuiltModel();
        try {
            Object object;
            if (this.currentModelType.realTime()) {
                throw new PrismException("You cannot build a " + this.currentModelType + " model explicitly, only perform model checking");
            }
            this.mainLog.print("\nBuilding model...\n");
            if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
                this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
            }
            long l = System.currentTimeMillis();
            block2 : switch (this.getCurrentEngine()) {
                case SYMBOLIC: {
                    Object object2;
                    Object object3;
                    switch (this.currentModelSource) {
                        case PRISM_MODEL: {
                            object = new Modules2MTBDD(this, this.currentModulesFile);
                            this.currentModel = ((Modules2MTBDD)object).translate();
                            this.currentModelExpl = null;
                            this.currentModelBuildType = ModelBuildType.SYMBOLIC;
                            break block2;
                        }
                        case MODEL_GENERATOR: {
                            object3 = new ModelGenerator2MTBDD(this);
                            object2 = this.getModelGenerator();
                            this.currentModel = ((ModelGenerator2MTBDD)object3).build((ModelGenerator<Double>)object2, this.currentRewardGenerator);
                            this.currentModelExpl = null;
                            this.currentModelBuildType = ModelBuildType.SYMBOLIC;
                            break block2;
                        }
                        case EXPLICIT_FILES: {
                            ExplicitFiles2MTBDD explicitFiles2MTBDD = new ExplicitFiles2MTBDD(this);
                            ExplicitFilesRewardGenerator4MTBDD explicitFilesRewardGenerator4MTBDD = new ExplicitFilesRewardGenerator4MTBDD((PrismComponent)this, this.explicitFilesStateRewardsFiles, this.explicitFilesNumStates);
                            this.currentModel = explicitFiles2MTBDD.build(this.explicitFilesStatesFile, this.explicitFilesTransFile, this.explicitFilesLabelsFile, this.currentModelInfo, this.explicitFilesNumStates, explicitFilesRewardGenerator4MTBDD);
                            this.currentModelExpl = null;
                            this.currentModelBuildType = ModelBuildType.SYMBOLIC;
                            this.currentRewardGenerator = explicitFilesRewardGenerator4MTBDD;
                            break block2;
                        }
                    }
                    throw new PrismException("Cannot do symbolic model construction for model source " + this.currentModelSource);
                }
                case EXPLICIT: {
                    Object object2;
                    Object object3;
                    switch (this.currentModelSource) {
                        case PRISM_MODEL: 
                        case MODEL_GENERATOR: {
                            try {
                                this.getModelGenerator();
                            }
                            catch (PrismException prismException) {
                                throw prismException.prepend("Explicit engine: ");
                            }
                            object = new ConstructModel(this);
                            ((ConstructModel)object).setFixDeadlocks(this.getFixDeadlocks());
                            this.currentModelExpl = ((ConstructModel)object).constructModel(this.currentModelGenerator);
                            this.currentModel = null;
                            this.currentModelBuildType = ModelBuildType.EXPLICIT;
                            break block2;
                        }
                        case EXPLICIT_FILES: {
                            object3 = new ExplicitFiles2Model(this);
                            this.currentModelExpl = ((ExplicitFiles2Model)object3).build(this.explicitFilesStatesFile, this.explicitFilesTransFile, this.explicitFilesLabelsFile, this.currentModelInfo, this.explicitFilesNumStates);
                            this.currentModel = null;
                            this.currentModelBuildType = ModelBuildType.EXPLICIT;
                            this.currentModelGenerator = new ModelModelGenerator(this.currentModelExpl, this.currentModelInfo);
                            object2 = new ExplicitFilesRewardGenerator4Explicit((PrismComponent)this, this.explicitFilesStateRewardsFiles, this.explicitFilesNumStates);
                            ((ExplicitFilesRewardGenerator)object2).setStatesList(this.currentModelExpl.getStatesList());
                            this.currentRewardGenerator = object2;
                            break block2;
                        }
                    }
                    throw new PrismException("Cannot do explicit model construction for model source " + this.currentModelSource);
                }
                default: {
                    throw new PrismException("Unknown engine " + this.getCurrentEngine());
                }
            }
            l = System.currentTimeMillis() - l;
            this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
            if (this.digital) {
                this.doBuildModelDigitalClocksChecks();
            }
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                object = this.currentModel.getDeadlockStates();
                int n = object.size();
                if (n > 0) {
                    if (this.getFixDeadlocks()) {
                        this.mainLog.printWarning("Deadlocks detected and fixed in " + n + " states");
                    } else {
                        this.currentModel.printTransInfo(this.mainLog, this.getExtraDDInfo());
                        this.mainLog.print("\n" + n + " deadlock states found");
                        if (!this.getVerbose() && n > 10) {
                            this.mainLog.print(". The first 10 are below. Use verbose mode to view them all.\n");
                            object.print(this.mainLog, 10);
                        } else {
                            this.mainLog.print(":\n");
                            object.print(this.mainLog);
                        }
                        this.mainLog.print("\nTip: Use the \"fix deadlocks\" option to automatically add self-loops in deadlock states.\n");
                        throw new PrismException("Model contains " + n + " deadlock states");
                    }
                }
            } else {
                this.checkForDeadlocksExpl(this.currentModelExpl);
            }
            this.mainLog.println();
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                this.mainLog.println("Type:        " + this.currentModel.getModelType());
                this.currentModel.printTransInfo(this.mainLog, this.getExtraDDInfo());
            } else {
                this.mainLog.println("Type:        " + this.currentModelExpl.getModelType());
                this.mainLog.print(this.currentModelExpl.infoStringTable());
            }
            for (PrismModelListener prismModelListener : this.modelListeners) {
                if (prismModelListener == null) continue;
                prismModelListener.notifyModelBuildSuccessful();
            }
            return;
        }
        catch (PrismException prismException) {
            Iterator<PrismModelListener> iterator = this.modelListeners.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw prismException;
                }
                PrismModelListener prismModelListener = iterator.next();
                if (prismModelListener == null) continue;
                prismModelListener.notifyModelBuildFailed(prismException);
            }
        }
    }

    private void checkForDeadlocksExpl(explicit.Model model) throws PrismException {
        explicit.StateValues stateValues = model.getDeadlockStatesList();
        int n = model.getNumDeadlockStates();
        if (n > 0) {
            if (this.getFixDeadlocks()) {
                this.mainLog.printWarning("Deadlocks detected and fixed in " + n + " states");
            } else {
                if (this.currentModelExpl != null) {
                    this.mainLog.print(this.currentModelExpl.infoStringTable());
                }
                this.mainLog.print("\n" + n + " deadlock states found");
                if (!this.getVerbose() && n > 10) {
                    this.mainLog.print(". The first 10 are below. Use verbose mode to view them all.\n");
                    stateValues.print(this.mainLog, 10);
                } else {
                    this.mainLog.print(":\n");
                    stateValues.print(this.mainLog);
                    this.mainLog.print(String.format("deadlocked model: %s\n", model));
                }
                this.mainLog.print("\nTip: Use the \"fix deadlocks\" option to automatically add self-loops in deadlock states.\n");
                throw new PrismException("Model contains " + n + " deadlock state" + (n > 1 ? "s" : ""));
            }
        }
    }

    private void doBuildModelDigitalClocksChecks() throws PrismException {
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            StateList stateList = this.currentModel.getDeadlockStates();
            if (stateList.size() > 0) {
                throw new PrismException("Timelock in " + this.currentModelType + ", e.g. in state (" + stateList.getFirstAsValues() + ")");
            }
        } else if (this.currentModelExpl.getNumDeadlockStates() > 0) {
            int n = this.currentModelExpl.getFirstDeadlockState();
            String string = this.currentModelExpl.getStatesList().get(n).toString(this.currentModelInfo);
            throw new PrismException("Timelock in " + this.currentModelType + ", e.g. in state " + string);
        }
    }

    public Model buildModelExplicit(ModulesFile modulesFile) throws PrismException {
        if (modulesFile.getModelType().realTime()) {
            throw new PrismException("You cannot build a " + modulesFile.getModelType() + " model explicitly, only perform model checking");
        }
        this.mainLog.print("\nBuilding model...\n");
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        ConstructModel constructModel = new ConstructModel(this);
        ModulesFileModelGenerator<Double> modulesFileModelGenerator = ModulesFileModelGenerator.createForDoubles(modulesFile, this);
        explicit.Model<Double> model = constructModel.constructModel(modulesFileModelGenerator);
        List<State> list = constructModel.getStatesList();
        ExplicitModel2MTBDD explicitModel2MTBDD = new ExplicitModel2MTBDD(this);
        long l = System.currentTimeMillis();
        Model model2 = explicitModel2MTBDD.buildModel(model, list, modulesFile, false);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        return model2;
    }

    public void exportPRISMModel(File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting parsed PRISM file ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        prismLog.print(this.currentModulesFile.toString());
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportPRISMModelWithExpandedConstants(File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting parsed PRISM file (with constant expansion) ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        ModulesFile modulesFile = (ModulesFile)this.currentModulesFile.deepCopy();
        modulesFile = (ModulesFile)modulesFile.replaceConstants(this.currentModulesFile.getConstantValues());
        prismLog.print(modulesFile.toString());
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportToSpyFile(File file) throws FileNotFoundException, PrismException {
        if (this.getCurrentEngine() == PrismEngine.EXPLICIT) {
            throw new PrismNotSupportedException("Export to Spy file not yet supported by explicit engine");
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nExporting to spy file \"" + file + "\"...");
        int n = this.currentModel.getAllDDRowVars().n();
        if (n > 9) {
            n = 9;
        }
        JDDNode jDDNode = this.currentModel.getTrans();
        JDD.Ref(jDDNode);
        if (this.currentModelType == ModelType.MDP) {
            jDDNode = JDD.MaxAbstract(jDDNode, ((NondetModel)this.currentModel).getAllDDNondetVars());
        }
        JDD.ExportMatrixToSpyFile(jDDNode, this.currentModel.getAllDDRowVars(), this.currentModel.getAllDDColVars(), n, file.getPath());
        JDD.Deref(jDDNode);
    }

    public void exportToDotFile(File file) throws FileNotFoundException, PrismException {
        if (this.getCurrentEngine() == PrismEngine.EXPLICIT) {
            throw new PrismNotSupportedException("Export to Dot file not yet supported by explicit engine");
        }
        this.buildModelIfRequired();
        if (this.getCurrentEngine() == PrismEngine.EXPLICIT) {
            throw new PrismNotSupportedException("Export to Dot file not yet supported by explicit engine");
        }
        this.mainLog.println("\nExporting to dot file \"" + file + "\"...");
        JDD.ExportDDToDotFileLabelled(this.currentModel.getTrans(), file.getPath(), this.currentModel.getDDVarNames());
    }

    public void exportTransToFile(boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        PrismLog prismLog;
        if (this.currentModelType == ModelType.MDP) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix for MDPs; using ordered.");
            }
            bl = true;
        }
        if (n == 4) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix in MRMC format; using ordered.");
            }
            bl = true;
        }
        if (n == 5) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix in rows format; using ordered.");
            }
            bl = true;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting transition matrix ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        int n2 = this.settings.getInteger("prism.exportModelPrecision");
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            this.currentModel.exportToFile(n, bl, file, n2);
        } else {
            prismLog = this.getPrismLogForFile(file);
            switch (n) {
                case 1: {
                    this.currentModelExpl.exportToPrismExplicitTra(prismLog, n2);
                    break;
                }
                case 2: {
                    throw new PrismNotSupportedException("Export not yet supported");
                }
                case 3: {
                    this.currentModelExpl.exportToDotFile(prismLog, n2);
                    break;
                }
                case 6: {
                    this.currentModelExpl.exportToDotFile(prismLog, null, true, n2);
                    break;
                }
                case 4: 
                case 5: {
                    throw new PrismNotSupportedException("Export not yet supported");
                }
            }
            prismLog.close();
        }
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC && n == 6) {
            prismLog = this.getPrismLogForFile(file, true);
            this.currentModel.getReachableStates().printDot(prismLog);
            prismLog.println("}");
            if (file != null) {
                prismLog.close();
            }
        }
    }

    public void exportStateRewardsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2 = this.currentRewardGenerator.getNumRewardStructs();
        if (n2 == 0) {
            this.mainLog.println("\nOmitting state reward export as there are no reward structures");
            return;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting state rewards ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        int n3 = this.settings.getInteger("prism.exportModelPrecision");
        boolean bl = !this.settings.getBoolean("prism.exportModelHeaders");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            File file2;
            String string;
            String string2 = string = file != null ? file.getPath() : null;
            if (string != null && n2 > 1) {
                string = PrismUtils.addCounterSuffixToFilename(string, i + 1);
                arrayList.add(string);
            }
            File file3 = file2 = string == null ? null : new File(string);
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                this.currentModel.exportStateRewardsToFile(i, n, file2, n3, bl);
                continue;
            }
            explicit.StateModelChecker stateModelChecker = this.createModelCheckerExplicit(null);
            try (PrismLog prismLog = this.getPrismLogForFile(file2);){
                ((explicit.ProbModelChecker)stateModelChecker).exportStateRewardsToFile(this.currentModelExpl, i, n, prismLog, bl, n3);
                continue;
            }
            catch (PrismNotSupportedException prismNotSupportedException) {
                this.mainLog.println("\nReward export failed: " + prismNotSupportedException.getMessage());
                try {
                    if (file2 == null) continue;
                    file2.delete();
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (arrayList.size() > 1) {
            this.mainLog.println("Rewards were exported to multiple files: " + PrismUtils.joinString(arrayList, ","));
        }
    }

    public void exportTransRewardsToFile(boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        int n2 = this.currentRewardGenerator.getNumRewardStructs();
        if (n2 == 0) {
            this.mainLog.println("\nOmitting transition reward export as there are no reward structures");
            return;
        }
        if (this.currentModelType == ModelType.MDP) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition reward matrix for MDPs; using ordered.");
            }
            bl = true;
        }
        if (n == 4) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition reward matrix in MRMC format; using ordered.");
            }
            bl = true;
        }
        if (n == 5) {
            if (!bl) {
                this.mainLog.printWarning("Cannot export unordered transition matrix in rows format; using ordered.");
            }
            bl = true;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting transition rewards ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        int n3 = this.settings.getInteger("prism.exportModelPrecision");
        boolean bl2 = !this.settings.getBoolean("prism.exportModelHeaders");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            File file2;
            String string;
            String string2 = string = file != null ? file.getPath() : null;
            if (string != null && n2 > 1) {
                string = PrismUtils.addCounterSuffixToFilename(string, i + 1);
                arrayList.add(string);
            }
            File file3 = file2 = string == null ? null : new File(string);
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                this.currentModel.exportTransRewardsToFile(i, n, bl, file2, n3, bl2);
                continue;
            }
            explicit.StateModelChecker stateModelChecker = this.createModelCheckerExplicit(null);
            try (PrismLog prismLog = this.getPrismLogForFile(file2);){
                ((explicit.ProbModelChecker)stateModelChecker).exportTransRewardsToFile(this.currentModelExpl, i, n, prismLog, bl2, n3);
                continue;
            }
            catch (PrismNotSupportedException prismNotSupportedException) {
                this.mainLog.println("\nReward export failed: " + prismNotSupportedException.getMessage());
                try {
                    if (file2 == null) continue;
                    file2.delete();
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (arrayList.size() > 1) {
            this.mainLog.println("Rewards were exported to multiple files: " + PrismUtils.joinString(arrayList, ","));
        }
    }

    public void exportBSCCsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        SCCComputer sCCComputer = null;
        SCCConsumerStore sCCConsumerStore = null;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing BSCCs...");
        long l = System.currentTimeMillis();
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            sCCComputer = this.getSCCComputer(this.currentModel);
            sCCComputer.computeBSCCs();
        } else {
            sCCConsumerStore = new SCCConsumerStore();
            this.getExplicitSCCComputer(this.currentModelExpl, sCCConsumerStore).computeSCCs();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for BSCC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting BSCCs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.currentModelInfo.getNumVars(); ++n2) {
            prismLog.print(this.currentModelInfo.getVarName(n2));
            if (n2 >= this.currentModelInfo.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = this.currentModelBuildType == ModelBuildType.SYMBOLIC ? sCCComputer.getBSCCs().size() : sCCConsumerStore.getBSCCs().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("BSCC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("bscc" + (n2 + 1) + "=[");
            }
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                if (n != 2) {
                    new StateListMTBDD(sCCComputer.getBSCCs().get(n2), this.currentModel).print(prismLog);
                } else {
                    new StateListMTBDD(sCCComputer.getBSCCs().get(n2), this.currentModel).printMatlab(prismLog);
                }
                JDD.Deref(sCCComputer.getBSCCs().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(sCCConsumerStore.getBSCCs().get(n2), this.currentModelExpl).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            JDD.Deref(sCCComputer.getNotInBSCCs());
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportMECsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        ECComputer eCComputer = null;
        explicit.ECComputer eCComputer2 = null;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing MECs...");
        long l = System.currentTimeMillis();
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            eCComputer = this.getECComputer((NondetModel)this.currentModel);
            eCComputer.computeMECStates();
        } else {
            eCComputer2 = this.getExplicitECComputer((explicit.NondetModel)this.currentModelExpl);
            eCComputer2.computeMECStates();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for MEC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting MECs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.currentModelInfo.getNumVars(); ++n2) {
            prismLog.print(this.currentModelInfo.getVarName(n2));
            if (n2 >= this.currentModelInfo.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = this.currentModelBuildType == ModelBuildType.SYMBOLIC ? eCComputer.getMECStates().size() : eCComputer2.getMECStates().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("MEC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("mec" + (n2 + 1) + "=[");
            }
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                if (n != 2) {
                    new StateListMTBDD(eCComputer.getMECStates().get(n2), this.currentModel).print(prismLog);
                } else {
                    new StateListMTBDD(eCComputer.getMECStates().get(n2), this.currentModel).printMatlab(prismLog);
                }
                JDD.Deref(eCComputer.getMECStates().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(eCComputer2.getMECStates().get(n2), this.currentModelExpl).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportSCCsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        SCCComputer sCCComputer = null;
        SCCConsumerStore sCCConsumerStore = null;
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing SCCs...");
        long l = System.currentTimeMillis();
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            sCCComputer = this.getSCCComputer(this.currentModel);
            sCCComputer.computeSCCs();
        } else {
            sCCConsumerStore = new SCCConsumerStore();
            this.getExplicitSCCComputer(this.currentModelExpl, sCCConsumerStore).computeSCCs();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for SCC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting SCCs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.currentModelInfo.getNumVars(); ++n2) {
            prismLog.print(this.currentModelInfo.getVarName(n2));
            if (n2 >= this.currentModelInfo.getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = this.currentModelBuildType == ModelBuildType.SYMBOLIC ? sCCComputer.getSCCs().size() : sCCConsumerStore.getSCCs().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("SCC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("scc" + (n2 + 1) + "=[");
            }
            if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                if (n != 2) {
                    new StateListMTBDD(sCCComputer.getSCCs().get(n2), this.currentModel).print(prismLog);
                } else {
                    new StateListMTBDD(sCCComputer.getSCCs().get(n2), this.currentModel).printMatlab(prismLog);
                }
                JDD.Deref(sCCComputer.getSCCs().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(sCCConsumerStore.getSCCs().get(n2), this.currentModelExpl).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            JDD.Deref(sCCComputer.getNotInSCCs());
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportPropLabelsToFile(PropertiesFile propertiesFile, int n2, File file) throws FileNotFoundException, PrismException {
        Objects.requireNonNull(propertiesFile);
        ArrayList<String> arrayList = new ArrayList<String>();
        LabelList labelList = propertiesFile.getLabelList();
        new Range(labelList.size()).map(n -> labelList.getLabelName(n)).collect(arrayList);
        this.doExportLabelsToFile(propertiesFile, n2, file, arrayList);
    }

    public void exportLabelsToFile(PropertiesFile propertiesFile, int n2, File file) throws FileNotFoundException, PrismException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("init");
        arrayList.add("deadlock");
        arrayList.addAll(this.currentModelInfo.getLabelNames());
        if (propertiesFile != null) {
            LabelList labelList = propertiesFile.getLabelList();
            new Range(labelList.size()).map(n -> labelList.getLabelName(n)).collect(arrayList);
        }
        this.doExportLabelsToFile(propertiesFile, n2, file, arrayList);
    }

    private void doExportLabelsToFile(PropertiesFile propertiesFile, int n, File file, List<String> list) throws PrismException, FileNotFoundException {
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting labels and satisfying states ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        if (this.currentModelBuildType != ModelBuildType.SYMBOLIC) {
            PrismLog prismLog = this.getPrismLogForFile(file);
            explicit.StateModelChecker stateModelChecker = this.createModelCheckerExplicit(propertiesFile);
            stateModelChecker.exportLabels(this.currentModelExpl, list, n, prismLog);
            prismLog.close();
        } else {
            StateModelChecker stateModelChecker = this.createModelChecker(propertiesFile);
            stateModelChecker.exportLabels(list, n, file);
        }
    }

    public void exportStatesToFile(int n, File file) throws FileNotFoundException, PrismException {
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting list of reachable states ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            this.currentModel.exportStates(n, prismLog);
        } else {
            this.currentModelExpl.exportStates(n, this.currentModelInfo.createVarList(), prismLog);
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportObservationsToFile(int n, File file) throws FileNotFoundException, PrismException {
        if (!this.currentModelType.partiallyObservable()) {
            this.mainLog.println("\nOmitting observations export as the model is not partially observable");
            return;
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.print("\nExporting list of observations ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        ((PartiallyObservableModel)this.currentModelExpl).exportObservations(n, this.currentModelInfo, prismLog);
        if (file != null) {
            prismLog.close();
        }
    }

    public Result modelCheck(String string) throws PrismException {
        PropertiesFile propertiesFile = this.parsePropertiesString(string);
        if (propertiesFile.getNumProperties() != 1) {
            throw new PrismException("There should be exactly one property to check (there are " + propertiesFile.getNumProperties() + ")");
        }
        return this.modelCheck(propertiesFile, propertiesFile.getPropertyObject(0));
    }

    public Result modelCheck(PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        return this.modelCheck(propertiesFile, new Property(expression));
    }

    public Result modelCheck(PropertiesFile propertiesFile, Property property) throws PrismException, PrismLangException {
        return this.modelCheck(propertiesFile, property, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result modelCheck(PropertiesFile propertiesFile, Property property, boolean bl) throws PrismException, PrismLangException {
        Result result = null;
        Values values = propertiesFile.getConstantValues();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = -1;
        if (!this.digital) {
            this.mainLog.printSeparator();
        }
        this.mainLog.println("\nModel checking: " + property);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        property.getExpression().checkValid(this.currentModelType);
        this.clearStrategy();
        if (this.currentModelType.realTime()) {
            return this.modelCheckPTA(propertiesFile, property.getExpression(), values);
        }
        if (this.settings.getBoolean("prism.exact.enabled")) {
            return this.modelCheckExact(propertiesFile, property);
        }
        if (this.currentModelType == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
            FastAdaptiveUniformisationModelChecker fastAdaptiveUniformisationModelChecker = new FastAdaptiveUniformisationModelChecker(this, this.currentModulesFile, propertiesFile);
            return fastAdaptiveUniformisationModelChecker.check(property.getExpression());
        }
        if (this.settings.getString("prism.heuristic").equals("Speed")) {
            this.mainLog.printWarning("Switching to sparse engine and (backwards) Gauss Seidel (default for heuristic=speed).");
            bl2 = true;
            n = this.getEngine();
            this.setEngine(2);
            this.settings.set("prism.linEqMethod", "Backwards Gauss-Seidel");
        }
        if (this.currentModelType == ModelType.MDP && !Expression.containsMultiObjective(property.getExpression()) && this.getMDPSolnMethod() != 1 && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow use of chosen MDP solution method.");
            bl2 = true;
            n = this.getEngine();
            bl4 = true;
            this.setEngine(4);
        }
        if (Expression.containsNonProbLTLFormula(property.getExpression()) && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow non-probabilistic LTL model checking.");
            bl2 = true;
            n = this.getEngine();
            bl4 = true;
            this.setEngine(4);
        }
        if (this.settings.getBoolean("prism.intervalIter") && this.getCurrentEngine() == PrismEngine.SYMBOLIC && this.currentModelType == ModelType.MDP && Expression.containsMinReward(property.getExpression())) {
            this.mainLog.printWarning("Switching to explicit engine to allow interval iteration on Rmin operator.");
            bl2 = true;
            n = this.getEngine();
            bl4 = true;
            this.setEngine(4);
        }
        if ((this.currentModelType == ModelType.IDTMC || this.currentModelType == ModelType.IMDP) && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow model checking of interval model.");
            bl2 = true;
            n = this.getEngine();
            bl4 = true;
            this.setEngine(4);
        }
        if (this.genStrat && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow strategy generation.");
            bl2 = true;
            n = this.getEngine();
            bl4 = true;
            this.setEngine(4);
        }
        try {
            Expression expression = (Expression)property.getExpression().expandPropRefsAndLabels(propertiesFile, null);
            this.buildModelIfRequired();
            if (this.genStrat && this.currentModelType.nondeterministic() && this.getCurrentEngine() == PrismEngine.SYMBOLIC && !((NondetModel)this.currentModel).areAllChoiceActionsUnique()) {
                throw new PrismException("Cannot generate strategies with the current engine because some state of the model do not have unique action labels for each choice. Either switch to the explicit engine or add more action labels to the model");
            }
            if (this.getCurrentEngine() == PrismEngine.SYMBOLIC && this.getEngine() != 1 && !bl4) {
                long l = this.currentModel.getNumStates();
                if (l == -1L || l > Integer.MAX_VALUE) {
                    this.mainLog.printWarning("Switching to MTBDD engine, as number of states is too large for " + engineStrings[this.getEngine()] + " engine.");
                    bl3 = true;
                } else if (this.settings.getString("prism.heuristic").equals("Speed") && l > 100000000L) {
                    this.mainLog.printWarning("Switching to MTBDD engine (default for heuristic=speed and this state space size).");
                    bl3 = true;
                }
                if (bl3) {
                    bl2 = true;
                    n = this.getEngine();
                    this.setEngine(1);
                    this.settings.set("prism.linEqMethod", "Jacobi");
                }
            }
            if (this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
                StateModelChecker stateModelChecker = this.createModelChecker(propertiesFile);
                result = stateModelChecker.check(property.getExpression());
            } else {
                explicit.StateModelChecker stateModelChecker = this.createModelCheckerExplicit(propertiesFile);
                stateModelChecker.setComputeParetoSet(bl);
                result = stateModelChecker.check(this.currentModelExpl, expression);
            }
            if (result.getStrategy() != null) {
                this.strategy = result.getStrategy();
            }
        }
        finally {
            if (bl2) {
                this.setEngine(n);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result modelCheckPTA(PropertiesFile propertiesFile, Expression expression, Values values) throws PrismException, PrismLangException {
        expression.checkValid(this.currentModelType);
        this.clearStrategy();
        if (this.settings.getString("prism.ptaMethod").equals("Digital clocks") || this.currentModelType == ModelType.POPTA || this.currentModelType == ModelType.TPTG) {
            this.digital = true;
            ModulesFile modulesFile = this.currentModulesFile;
            try {
                DigitalClocks digitalClocks = new DigitalClocks(this);
                digitalClocks.translate(modulesFile, propertiesFile, expression);
                this.loadPRISMModel(digitalClocks.getNewModulesFile());
                if (this.exportDigital) {
                    try {
                        this.exportPRISMModel(this.exportDigitalFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + this.exportDigitalFile + "\" for output");
                    }
                    catch (PrismException prismException) {
                        this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
                    }
                }
                Result result = this.modelCheck(digitalClocks.getNewPropertiesFile(), digitalClocks.getNewPropertyToCheck());
                return result;
            }
            finally {
                this.digital = false;
                Strategy<?> strategy = this.strategy;
                this.strategy = null;
                this.currentModulesFile = modulesFile;
                this.currentModelType = modulesFile.getModelType();
                this.clearBuiltModel();
                this.strategy = strategy;
            }
        }
        PTAModelChecker pTAModelChecker = new PTAModelChecker(this, this.currentModulesFile, propertiesFile);
        return pTAModelChecker.check(expression);
    }

    public void checkModelForSimulation() throws PrismException {
        try {
            this.getModelGenerator();
            if (this.currentModelType.realTime()) {
                throw new PrismException(this.currentModelType + "s are not currently supported");
            }
        }
        catch (PrismException prismException) {
            throw prismException.prepend("Simulation not possible: ");
        }
    }

    public void loadModelIntoSimulator() throws PrismException {
        ModelGenerator<Double> modelGenerator = null;
        try {
            modelGenerator = this.getModelGenerator();
        }
        catch (PrismException prismException) {
            throw prismException.prepend("Simulation not possible: ");
        }
        this.getSimulator().loadModel(modelGenerator, this.currentRewardGenerator);
    }

    public void loadStrategyIntoSimulator() throws PrismException {
        if (this.getStrategy() != null && this.getStrategy() instanceof StrategyGenerator) {
            this.getSimulator().loadStrategy((StrategyGenerator)((Object)this.getStrategy()));
        }
    }

    public boolean isPropertyOKForSimulation(Expression expression) {
        return this.getSimulator().isPropertyOKForSimulation(expression);
    }

    public void checkPropertyForSimulation(Expression expression) throws PrismException {
        this.getSimulator().checkPropertyForSimulation(expression);
    }

    public Result modelCheckSimulator(PropertiesFile propertiesFile, Expression expression, Values values, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        this.mainLog.printSeparator();
        this.mainLog.println("\nSimulating: " + expression);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        if (this.currentModelType.nondeterministic() && this.currentModelType.removeNondeterminism() != this.currentModelType) {
            this.mainLog.printWarning("For simulation, nondeterminism in " + this.currentModelType + " is resolved uniformly (resulting in " + this.currentModelType.removeNondeterminism() + ").");
        }
        expression.checkValid(this.currentModelType.removeNondeterminism());
        this.clearStrategy();
        this.loadModelIntoSimulator();
        Result result = this.getSimulator().modelCheckSingleProperty(propertiesFile, expression, state, l, simulationMethod);
        return result;
    }

    public Result[] modelCheckSimulatorSimultaneously(PropertiesFile propertiesFile, List<Expression> list, Values values, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        this.mainLog.printSeparator();
        this.mainLog.print("\nSimulating");
        if (list.size() == 1) {
            this.mainLog.println(": " + list.get(0));
        } else {
            this.mainLog.println(" " + list.size() + " properties:");
            for (int i = 0; i < list.size(); ++i) {
                this.mainLog.println(" " + list.get(i));
            }
        }
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        if (this.currentModelType.nondeterministic() && this.currentModelType.removeNondeterminism() != this.currentModelType) {
            this.mainLog.printWarning("For simulation, nondeterminism in " + this.currentModelType + " is resolved uniformly (resulting in " + this.currentModelType.removeNondeterminism() + ").");
        }
        for (Expression expression : list) {
            expression.checkValid(this.currentModelType.removeNondeterminism());
        }
        this.clearStrategy();
        this.loadModelIntoSimulator();
        Result[] resultArray = this.getSimulator().modelCheckMultipleProperties(propertiesFile, list, state, l, simulationMethod);
        return resultArray;
    }

    public void modelCheckSimulatorExperiment(PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        this.mainLog.printSeparator();
        this.mainLog.println("\nSimulating: " + expression);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        this.mainLog.println("Property constants: " + undefinedConstants.getPFDefinedConstantsString());
        this.clearStrategy();
        this.loadModelIntoSimulator();
        this.getSimulator().modelCheckExperiment(propertiesFile, undefinedConstants, resultsCollection, expression, state, l, simulationMethod);
    }

    public Result modelCheckExact(PropertiesFile propertiesFile, Property property) throws PrismException {
        if (this.currentModelType != ModelType.DTMC && this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.MDP) {
            throw new PrismNotSupportedException("Exact model checking is only supported for DTMCs, CTMCs and MDPs");
        }
        if (this.currentModelType == ModelType.MDP && this.getFairness()) {
            throw new PrismNotSupportedException("Exact model checking does not support checking MDPs under fairness");
        }
        this.clearStrategy();
        String[] stringArray = new String[]{"dummy"};
        String[] stringArray2 = new String[]{"0"};
        String[] stringArray3 = new String[]{"1"};
        ModelBuilder modelBuilder = new ModelBuilder(this, ParamMode.EXACT);
        FunctionFactory functionFactory = modelBuilder.getFunctionFactory(stringArray, stringArray2, stringArray3);
        ParamModel paramModel = modelBuilder.constructModel(ModulesFileModelGenerator.createForRationalFunctions(this.currentModulesFile, functionFactory, this));
        ParamModelChecker paramModelChecker = new ParamModelChecker(this, ParamMode.EXACT);
        paramModelChecker.setParameters(stringArray, stringArray2, stringArray3);
        paramModelChecker.setModulesFileAndPropertiesFile(this.currentModulesFile, propertiesFile);
        if (this.digital && paramModel.getNumDeadlockStates() > 0) {
            int n = paramModel.getFirstDeadlockState();
            String string = paramModel.getStatesList().get(n).toString(this.currentModelInfo);
            throw new PrismException("Timelock in PTA, e.g. in state " + string);
        }
        Result result = paramModelChecker.check(paramModel, property.getExpression());
        ParamResult paramResult = (ParamResult)result.getResult();
        result.setResult(paramResult.getSimpleResult(property.getType()));
        result.setAccuracy(new Accuracy(Accuracy.AccuracyLevel.EXACT));
        Object object = "Result";
        object = (String)object + ": " + result.getResultAndAccuracy();
        if (result.getResult() instanceof BigRational) {
            object = (String)object + " (" + ((BigRational)result.getResult()).toApproximateString() + ")";
        }
        this.mainLog.println("\n" + (String)object);
        return result;
    }

    public Result modelCheckParametric(PropertiesFile propertiesFile, Property property, String[] stringArray, String[] stringArray2, String[] stringArray3) throws PrismException {
        if (stringArray == null) {
            throw new PrismException("Must specify some parameters when using the parametric analysis");
        }
        if (this.currentModelType != ModelType.DTMC && this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.MDP) {
            throw new PrismNotSupportedException("Parametric model checking is only supported for DTMCs, CTMCs and MDPs");
        }
        if (this.currentModelType == ModelType.MDP && this.getFairness()) {
            throw new PrismNotSupportedException("Parametric model checking does not support checking MDPs under fairness");
        }
        Values values = propertiesFile.getConstantValues();
        Values values2 = this.currentModulesFile.getConstantValues();
        for (int i = 0; i < stringArray.length; ++i) {
            values2.removeValue(stringArray[i]);
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nParametric model checking: " + property);
        if (this.currentDefinedMFConstants != null && this.currentDefinedMFConstants.getNumValues() > 0) {
            this.mainLog.println("Model constants: " + this.currentDefinedMFConstants);
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + values);
        }
        this.clearStrategy();
        ModelBuilder modelBuilder = new ModelBuilder(this, ParamMode.PARAMETRIC);
        FunctionFactory functionFactory = modelBuilder.getFunctionFactory(stringArray, stringArray2, stringArray3);
        ParamModel paramModel = modelBuilder.constructModel(ModulesFileModelGenerator.createForRationalFunctions(this.currentModulesFile, functionFactory, this));
        ParamModelChecker paramModelChecker = new ParamModelChecker(this, ParamMode.PARAMETRIC);
        paramModelChecker.setParameters(stringArray, stringArray2, stringArray3);
        paramModelChecker.setModulesFileAndPropertiesFile(this.currentModulesFile, propertiesFile);
        Result result = paramModelChecker.check(paramModel, property.getExpression());
        Object object = "Result";
        if (!"Result".equals(property.getExpression().getResultName())) {
            object = (String)object + " (" + property.getExpression().getResultName().toLowerCase() + ")";
        }
        object = (String)object + ": " + result.getResultString();
        this.mainLog.print("\n" + (String)object);
        return result;
    }

    public void exportStrategy(StrategyExportOptions strategyExportOptions, File file) throws FileNotFoundException, PrismException {
        if (this.getStrategy() == null) {
            throw new PrismException("There is no current strategy to export");
        }
        this.exportStrategy(this.getStrategy(), strategyExportOptions, file);
    }

    public void exportStrategy(StrategyExportOptions.StrategyExportType strategyExportType, File file) throws FileNotFoundException, PrismException {
        this.exportStrategy(new StrategyExportOptions(strategyExportType), file);
    }

    public void exportStrategy(Strategy<?> strategy, StrategyExportOptions strategyExportOptions, File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting strategy " + strategyExportOptions.description() + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        strategyExportOptions = strategyExportOptions.clone();
        strategyExportOptions.setModelPrecision(this.settings.getInteger("prism.exportModelPrecision"));
        strategy.export(prismLog, strategyExportOptions);
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportStrategy(Strategy<?> strategy, StrategyExportOptions.StrategyExportType strategyExportType, File file) throws FileNotFoundException, PrismException {
        this.exportStrategy(strategy, new StrategyExportOptions(strategyExportType), file);
    }

    public void generateSimulationPath(String string, long l, File file) throws PrismException, PrismLangException {
        this.loadModelIntoSimulator();
        GenerateSimulationPath generateSimulationPath = new GenerateSimulationPath(this.getSimulator(), this.mainLog);
        generateSimulationPath.generateSimulationPath(null, string, l, file);
    }

    public void doSteadyState() throws PrismException {
        this.doSteadyState(1, null, null);
    }

    public void doSteadyState(int n, File file, File file2) throws PrismException {
        long l = 0L;
        StateValues stateValues = null;
        explicit.StateValues stateValues2 = null;
        if (this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nComputing steady-state probabilities...");
        this.buildModelIfRequired();
        l = System.currentTimeMillis();
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            stateValues = this.computeSteadyStateProbabilities(this.currentModel, file2);
        } else {
            stateValues2 = this.computeSteadyStateProbabilitiesExplicit(this.currentModelExpl, file2);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nPrinting steady-state probabilities ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            stateValues.print(prismLog, file == null, n == 2, file == null, file == null);
        } else {
            stateValues2.print(prismLog, file == null, n == 2, file == null, file == null);
        }
        this.mainLog.println("\nTime for steady-state probability computation: " + (double)l / 1000.0 + " seconds.");
        if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
            stateValues.clear();
        } else {
            stateValues2.clear();
        }
        if (file != null) {
            prismLog.close();
        }
    }

    protected StateValues computeSteadyStateProbabilities(Model model, File file) throws PrismException {
        ProbModelChecker probModelChecker;
        if (model.getModelType() == ModelType.DTMC) {
            probModelChecker = new ProbModelChecker(this, model, null);
        } else if (model.getModelType() == ModelType.CTMC) {
            probModelChecker = new StochModelChecker(this, model, null);
        } else {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        return probModelChecker.doSteadyState(file);
    }

    protected explicit.StateValues computeSteadyStateProbabilitiesExplicit(explicit.Model<?> model, File file) throws PrismException {
        explicit.StateValues stateValues;
        switch (model.getModelType()) {
            case DTMC: {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
                stateValues = dTMCModelChecker.doSteadyState((DTMC<Double>)((DTMC)model), file);
                break;
            }
            case CTMC: {
                CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(this);
                stateValues = cTMCModelChecker.doSteadyState((CTMC<Double>)((CTMC)model), file);
                break;
            }
            default: {
                throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
            }
        }
        return stateValues;
    }

    public void doTransient(double d) throws PrismException {
        this.doTransient(d, 1, null, null);
    }

    public void doTransient(double d, int n, File file, File file2) throws PrismException {
        long l = 0L;
        ProbModelChecker probModelChecker = null;
        StateValues stateValues = null;
        explicit.StateValues stateValues2 = null;
        if (this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (d < 0.0) {
            throw new PrismException("Cannot compute transient probabilities for negative time value");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        this.mainLog.printSeparator();
        String string = this.currentModelType.continuousTime() ? Double.toString(d) : Integer.toString((int)d);
        this.mainLog.println("\nComputing transient probabilities (time = " + string + ")...");
        l = System.currentTimeMillis();
        if (this.currentModelType == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
            if (file2 != null) {
                throw new PrismException("Fast adaptive uniformisation cannot read an initial distribution from a file");
            }
            ModulesFileModelGenerator<Double> modulesFileModelGenerator = ModulesFileModelGenerator.createForDoubles(this.currentModulesFile, this);
            FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, modulesFileModelGenerator);
            fastAdaptiveUniformisation.setConstantValues(this.currentModulesFile.getConstantValues());
            stateValues2 = fastAdaptiveUniformisation.doTransient(d);
        } else if (this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.buildModelIfRequired();
            if (this.currentModelType == ModelType.DTMC) {
                probModelChecker = new ProbModelChecker(this, this.currentModel, null);
                stateValues = probModelChecker.doTransient((int)d, file2);
            } else {
                probModelChecker = new StochModelChecker(this, this.currentModel, null);
                stateValues = ((StochModelChecker)probModelChecker).doTransient(d, file2);
            }
        } else {
            this.buildModelIfRequired();
            if (this.currentModelType == ModelType.DTMC) {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
                stateValues2 = dTMCModelChecker.doTransient((DTMC<Double>)((DTMC)this.currentModelExpl), (int)d, file2);
            } else if (this.currentModelType == ModelType.CTMC) {
                CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(this);
                stateValues2 = cTMCModelChecker.doTransient((CTMC<Double>)((CTMC)this.currentModelExpl), d, file2);
            } else {
                throw new PrismException("Transient probabilities only computed for DTMCs/CTMCs");
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nPrinting transient probabilities ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (stateValues != null) {
            stateValues.print(prismLog, file == null, n == 2, file == null, file == null);
        } else {
            stateValues2.print(prismLog, file == null, n == 2, file == null, file == null);
        }
        this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
        if (stateValues != null) {
            stateValues.clear();
        }
        if (stateValues2 != null) {
            stateValues2.clear();
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void doTransient(UndefinedConstants undefinedConstants, int n, File file, File file2) throws PrismException {
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        long l = 0L;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        explicit.StateValues stateValues3 = null;
        explicit.StateValues stateValues4 = null;
        PrismLog prismLog = null;
        File file3 = null;
        if (this.currentModelType != ModelType.CTMC && this.currentModelType != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (n == 4) {
            n = 1;
        }
        if (n == 5) {
            n = 1;
        }
        for (int i = 0; i < undefinedConstants.getNumPropertyIterations(); ++i) {
            Object object;
            Object object2 = undefinedConstants.getPFConstantValues().getValue(0);
            if (this.currentModelType.continuousTime()) {
                d = (Double)object2;
            } else {
                n2 = (Integer)object2;
            }
            if (this.currentModelType.continuousTime() ? (Double)object2 < 0.0 : (Integer)object2 < 0) {
                throw new PrismException("Cannot compute transient probabilities for negative time value");
            }
            this.mainLog.printSeparator();
            this.mainLog.println("\nComputing transient probabilities (time = " + object2 + ")...");
            l = System.currentTimeMillis();
            if (this.currentModelType == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
                if (file2 != null) {
                    throw new PrismException("Fast adaptive uniformisation cannot read an initial distribution from a file");
                }
                object = ModulesFileModelGenerator.createForDoubles(this.currentModulesFile, this);
                FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, (ModelGenerator<Double>)object);
                fastAdaptiveUniformisation.setConstantValues(this.currentModulesFile.getConstantValues());
                if (i == 0) {
                    stateValues3 = fastAdaptiveUniformisation.doTransient(d);
                    d2 = 0.0;
                } else {
                    stateValues3 = fastAdaptiveUniformisation.doTransient(d - d2, stateValues3);
                }
            } else if (this.currentModelBuildType == ModelBuildType.SYMBOLIC) {
                this.buildModelIfRequired();
                if (this.currentModelType.continuousTime()) {
                    object = new StochModelChecker(this, this.currentModel, null);
                    if (i == 0) {
                        stateValues2 = ((ProbModelChecker)object).readDistributionFromFile(file2);
                        d2 = 0.0;
                    }
                    stateValues = ((StochModelChecker)object).doTransient(d - d2, stateValues2);
                } else {
                    object = new ProbModelChecker(this, this.currentModel, null);
                    if (i == 0) {
                        stateValues2 = ((ProbModelChecker)object).readDistributionFromFile(file2);
                        n3 = 0;
                    }
                    stateValues = ((ProbModelChecker)object).doTransient(n2 - n3, stateValues2);
                }
            } else {
                this.buildModelIfRequired();
                if (this.currentModelType.continuousTime()) {
                    object = new CTMCModelChecker(this);
                    if (i == 0) {
                        stateValues4 = ((explicit.ProbModelChecker)object).readDistributionFromFile(file2, this.currentModelExpl);
                        d2 = 0.0;
                    }
                    stateValues3 = ((CTMCModelChecker)object).doTransient((CTMC<Double>)((CTMC)this.currentModelExpl), d - d2, stateValues4);
                } else {
                    object = new DTMCModelChecker(this);
                    if (i == 0) {
                        stateValues4 = ((explicit.ProbModelChecker)object).readDistributionFromFile(file2, this.currentModelExpl);
                        n3 = 0;
                    }
                    stateValues3 = ((DTMCModelChecker)object).doTransient((DTMC<Double>)((DTMC)this.currentModelExpl), n2 - n3, stateValues4);
                }
            }
            l = System.currentTimeMillis() - l;
            file3 = file != null && undefinedConstants.getNumPropertyIterations() > 1 ? new File(PrismUtils.addSuffixToFilename(file.getPath(), object2.toString())) : file;
            this.mainLog.print("\nPrinting transient probabilities ");
            this.mainLog.print(Prism.getStringForExportType(n) + " ");
            this.mainLog.println(Prism.getDestinationStringForFile(file3));
            prismLog = this.getPrismLogForFile(file3);
            if (stateValues != null) {
                stateValues.print(prismLog, file == null, n == 2, file == null);
            } else if (!this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
                stateValues3.print(prismLog, file == null, n == 2, file == null, true);
            } else {
                stateValues3.print(prismLog, file == null, n == 2, true, false);
            }
            this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
            stateValues2 = stateValues;
            stateValues4 = stateValues3;
            n3 = n2;
            d2 = d;
            undefinedConstants.iterateProperty();
        }
        if (stateValues != null) {
            stateValues.clear();
        }
        if (stateValues3 != null) {
            stateValues3.clear();
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void explicitBuildTest() throws PrismException {
    }

    private void clearBuiltModel() {
        if (this.currentModel != null) {
            this.currentModel.clear();
            this.currentModel = null;
        }
        this.currentModelExpl = null;
        this.currentModelBuildType = null;
        this.clearStrategy();
    }

    private void clearStrategy() {
        if (this.strategy != null) {
            this.strategy.clear();
            this.strategy = null;
        }
    }

    public void closeDown() {
        this.closeDown(true);
    }

    public void closeDown(boolean bl) {
        this.clearBuiltModel();
        PrismNative.closeDown();
        PrismMTBDD.closeDown();
        PrismSparse.closeDown();
        PrismHybrid.closeDown();
        ParamModelChecker.closeDown();
        if (this.cuddStarted) {
            JDD.CloseDownCUDD(bl);
            this.cuddStarted = false;
        }
    }

    private StateModelChecker createModelChecker(PropertiesFile propertiesFile) throws PrismException {
        if (propertiesFile == null) {
            propertiesFile = this.parsePropertiesString("");
        }
        StateModelChecker stateModelChecker = StateModelChecker.createModelChecker(this.currentModelType, this, this.currentModel, propertiesFile);
        return stateModelChecker;
    }

    private explicit.StateModelChecker createModelCheckerExplicit(PropertiesFile propertiesFile) throws PrismException {
        explicit.StateModelChecker stateModelChecker = explicit.StateModelChecker.createModelChecker(this.currentModelType, this);
        stateModelChecker.setModelCheckingInfo(this.currentModelInfo, propertiesFile, this.currentRewardGenerator);
        stateModelChecker.setExportTarget(this.exportTarget);
        stateModelChecker.setExportTargetFilename(this.exportTargetFilename);
        stateModelChecker.setExportProductTrans(this.exportProductTrans);
        stateModelChecker.setExportProductTransFilename(this.exportProductTransFilename);
        stateModelChecker.setExportProductStates(this.exportProductStates);
        stateModelChecker.setExportProductStatesFilename(this.exportProductStatesFilename);
        stateModelChecker.setExportProductVector(this.exportProductVector);
        stateModelChecker.setExportProductVectorFilename(this.exportProductVectorFilename);
        stateModelChecker.setStoreVector(this.storeVector);
        stateModelChecker.setGenStrat(this.genStrat);
        stateModelChecker.setRestrictStratToReach(this.restrictStratToReach);
        stateModelChecker.setDoBisim(this.doBisim);
        return stateModelChecker;
    }

    private PrismLog getPrismLogForFile(File file) throws PrismException {
        return this.getPrismLogForFile(file, false);
    }

    private PrismLog getPrismLogForFile(File file, boolean bl) throws PrismException {
        PrismLog prismLog = file != null ? PrismFileLog.create(file.getPath(), bl) : this.mainLog;
        return prismLog;
    }

    private static String getStringForExportType(int n) {
        switch (n) {
            case 1: {
                return "in plain text format";
            }
            case 2: {
                return "in Matlab format";
            }
            case 3: {
                return "in Dot format";
            }
            case 4: {
                return "in MRMC format";
            }
            case 5: {
                return "in rows format";
            }
            case 6: {
                return "in Dot format (with states)";
            }
        }
        return "in ? format";
    }

    private static String getDestinationStringForFile(File file) {
        return file == null ? "below:" : "to file \"" + file + "\"...";
    }

    @Deprecated
    public Model buildModel(ModulesFile modulesFile) throws PrismException {
        this.loadPRISMModel(modulesFile);
        this.buildModel();
        return this.getBuiltModel();
    }

    @Deprecated
    public void exportToSpyFile(Model model, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportToSpyFile(file);
    }

    @Deprecated
    public void exportToDotFile(Model model, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportToDotFile(file);
    }

    @Deprecated
    public void exportToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.exportTransToFile(model, bl, n, file);
    }

    @Deprecated
    public void exportTransToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportTransToFile(bl, n, file);
    }

    @Deprecated
    public void exportStateRewardsToFile(Model model, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportStateRewardsToFile(n, file);
    }

    @Deprecated
    public void exportTransRewardsToFile(Model model, boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportTransRewardsToFile(bl, n, file);
    }

    @Deprecated
    public void exportBSCCsToFile(Model model, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportBSCCsToFile(n, file);
    }

    @Deprecated
    public void exportLabelsToFile(Model model, ModulesFile modulesFile, PropertiesFile propertiesFile, int n, File file) throws FileNotFoundException, PrismException {
        this.loadPRISMModelAndBuiltModel(modulesFile, model);
        this.exportLabelsToFile(propertiesFile, n, file);
    }

    @Deprecated
    public void exportStatesToFile(Model model, int n, File file) throws FileNotFoundException, PrismException {
        this.loadBuiltModel(model);
        this.exportStateRewardsToFile(n, file);
    }

    @Deprecated
    public Result modelCheck(Model model, PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        this.loadBuiltModel(model);
        return this.modelCheck(propertiesFile, expression);
    }

    @Deprecated
    public Result modelCheckPTA(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        this.loadPRISMModel(modulesFile);
        return this.modelCheckPTA(propertiesFile, expression, null);
    }

    @Deprecated
    public Result modelCheckSimulator(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        this.loadPRISMModel(modulesFile);
        return this.modelCheckSimulator(propertiesFile, expression, null, state, l, simulationMethod);
    }

    @Deprecated
    public Result[] modelCheckSimulatorSimultaneously(ModulesFile modulesFile, PropertiesFile propertiesFile, List<Expression> list, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        this.loadPRISMModel(modulesFile);
        return this.modelCheckSimulatorSimultaneously(propertiesFile, list, null, state, l, simulationMethod);
    }

    @Deprecated
    public void modelCheckSimulatorExperiment(ModulesFile modulesFile, PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        this.loadPRISMModel(modulesFile);
        this.modelCheckSimulatorExperiment(propertiesFile, undefinedConstants, resultsCollection, expression, state, l, simulationMethod);
    }

    @Deprecated
    public void doSteadyState(Model model) throws PrismException {
        this.doSteadyState(model, 1, null);
    }

    @Deprecated
    public void doSteadyState(Model model, int n, File file) throws PrismException {
        this.loadBuiltModel(model);
        this.doSteadyState(n, file, null);
    }

    @Deprecated
    public void doTransient(Model model, double d) throws PrismException {
        this.doTransient(model, d, 1, null, null);
    }

    @Deprecated
    public void doTransient(Model model, double d, int n, File file, File file2) throws PrismException {
        this.loadBuiltModel(model);
        this.doTransient(d, n, file, file2);
    }

    static {
        try {
            buildNumber = Prism.class.getClassLoader().loadClass("prism.Revision").getField("svnRevision").get(null).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        engineStrings = new String[]{"?", "MTBDD", "Sparse", "Hybrid", "Explicit"};
        thePrismParser = null;
        prismParserInUse = false;
        REACH_BFS = 1;
        REACH_FRONTIER = 2;
    }

    public static enum ModelSource {
        PRISM_MODEL,
        MODEL_GENERATOR,
        EXPLICIT_FILES,
        BUILT_MODEL;

    }

    public static enum ModelBuildType {
        SYMBOLIC,
        EXPLICIT;

    }

    public static enum PrismEngine {
        SYMBOLIC,
        EXPLICIT;

    }
}

