/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ForLoop;
import parser.type.Type;
import parser.type.TypeInt;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;

public class Preprocessor {
    private static final char DELIMITER = '#';
    private static final boolean IGNORE_COMMENTS = true;
    private Prism prism;
    private File modelFile;
    private int numPPExprs;
    private String[] ppExprStrings;
    private String[] ppExprs;
    private int[] ppExprLines;
    private String lastString;
    private int pc;
    private Stack<Object> stack;
    private String output;
    private boolean outputEnabled;
    private Vector<String> varNames;
    private Vector<Type> varTypes;
    private Vector<Integer> varScopes;
    private Values values;
    private int paramCounter;
    private String[] params;

    public Preprocessor(Prism prism, File file) {
        this.prism = prism;
        this.modelFile = file;
    }

    public void setParameters(String[] stringArray) {
        this.params = stringArray;
    }

    public String preprocess() throws PrismException {
        this.countPPExprs();
        if (this.numPPExprs == 0) {
            return null;
        }
        this.storePPExprs();
        this.interpret();
        return this.output;
    }

    private void countPPExprs() throws PrismException {
        int n = 0;
        this.numPPExprs = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.modelFile));){
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                int n2 = string.indexOf("//");
                String string2 = n2 != -1 ? string.substring(0, n2) : string;
                int n3 = 0;
                n2 = -1;
                while ((n2 = string2.indexOf(35, n2 + 1)) != -1) {
                    ++n3;
                }
                if (n3 % 2 != 0) {
                    throw new PrismException("Unterminated preprocessing expression at line " + n);
                }
                this.numPPExprs += n3 / 2;
                string = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.modelFile + "\"");
        }
    }

    private void storePPExprs() throws PrismException {
        int n = 0;
        this.ppExprStrings = new String[this.numPPExprs];
        this.ppExprs = new String[this.numPPExprs];
        this.ppExprLines = new int[this.numPPExprs];
        try {
            int n2 = 0;
            Object object = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.modelFile));
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                int n3 = string.indexOf("//");
                String string2 = n3 != -1 ? string.substring(0, n3) : string;
                Object object2 = n3 != -1 ? string.substring(n3) : "";
                n3 = string2.indexOf(35);
                if (n3 == -1) {
                    object = (String)object + string2;
                    object = (String)object + (String)object2;
                    object = (String)object + "\n";
                } else {
                    int n4 = string2.lastIndexOf(35);
                    Object object3 = string2.substring(n3, n4 + 1);
                    object2 = string2.substring(n4 + 1) + (String)object2;
                    string2 = string2.substring(0, n3);
                    String[] stringArray = ((String)(object3 = (String)object3 + " ")).split("#");
                    int n5 = (stringArray.length - 1) / 2;
                    if (n5 != 1 || string2.trim().length() != 0 || ((String)object2).trim().length() != 0) {
                        object = (String)object + string2;
                    }
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.ppExprStrings[n2] = object = (String)object + stringArray[2 * n3];
                        this.ppExprs[n2] = stringArray[2 * n3 + 1];
                        this.ppExprLines[n2] = n;
                        ++n2;
                        object = "";
                    }
                    if (n5 != 1 || string2.trim().length() != 0 || ((String)object2).trim().length() != 0) {
                        object = (String)object + (String)object2 + "\n";
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            this.lastString = object;
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + this.modelFile + "\"");
        }
    }

    private void interpret() throws PrismException {
        this.output = "";
        this.outputEnabled = true;
        this.pc = 0;
        this.stack = new Stack();
        this.varNames = new Vector();
        this.varTypes = new Vector();
        this.varScopes = new Vector();
        this.values = new Values();
        this.paramCounter = 0;
        try {
            while (this.pc < this.numPPExprs) {
                String string;
                if (this.outputEnabled) {
                    this.output = this.output + this.ppExprStrings[this.pc];
                }
                if ((string = this.ppExprs[this.pc].trim()).indexOf("param int ") == 0) {
                    string = string.substring(10).trim();
                    this.interpretConstant(string);
                    continue;
                }
                if (string.indexOf("const ") == 0) {
                    string = string.substring(6).trim();
                    this.interpretConstant(string);
                    continue;
                }
                if (string.indexOf("for ") == 0) {
                    string = string.substring(4).trim();
                    this.interpretForLoop(string, "");
                    continue;
                }
                if (string.indexOf("& ") == 0) {
                    string = string.substring(2).trim();
                    this.interpretForLoop(string, "&");
                    continue;
                }
                if (string.indexOf("| ") == 0) {
                    string = string.substring(2).trim();
                    this.interpretForLoop(string, "|");
                    continue;
                }
                if (string.indexOf("* ") == 0) {
                    string = string.substring(2).trim();
                    this.interpretForLoop(string, "*");
                    continue;
                }
                if (string.indexOf("+ ") == 0) {
                    string = string.substring(2).trim();
                    this.interpretForLoop(string, "+");
                    continue;
                }
                if (string.indexOf(", ") == 0) {
                    string = string.substring(2).trim();
                    this.interpretForLoop(string, ",");
                    continue;
                }
                if (string.indexOf("; ") == 0) {
                    string = string.substring(2).trim();
                    this.interpretForLoop(string, ";");
                    continue;
                }
                if (string.equals("end")) {
                    this.interpretEnd();
                    continue;
                }
                if (string.length() == 0) {
                    ++this.pc;
                    continue;
                }
                this.interpretExpression(string);
            }
            if (this.outputEnabled) {
                this.output = this.output + this.lastString;
            }
        }
        catch (PrismException prismException) {
            throw new PrismException(prismException.getMessage() + " (preprocessing expression \"" + this.ppExprs[this.pc] + "\" at line " + this.ppExprLines[this.pc] + ")");
        }
    }

    private void interpretConstant(String string) throws PrismException {
        String string2;
        if (!this.outputEnabled) {
            ++this.pc;
            return;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n == -1) {
            n = string.indexOf(9);
        }
        if (n == -1) {
            n = string.length();
        }
        if (!(string2 = string.substring(0, n).trim()).matches("[_a-zA-Z]([_a-zA-Z0-9])*")) {
            throw new PrismException("Invalid constant name \"" + string2 + "\"");
        }
        if (this.varNames.contains(string2)) {
            throw new PrismException("Duplicated variable/constant \"" + string2 + "\"");
        }
        Expression expression = null;
        if ((string = string.substring(n).trim()).length() > 0) {
            if (string.charAt(0) != '=') {
                throw new PrismException("Syntax error in constant definition");
            }
            string = string.substring(1).trim();
            expression = Prism.parseSingleExpressionString(string);
            expression = (Expression)expression.findAllVars(this.varNames, this.varTypes);
            expression.typeCheck();
            expression.semanticCheck();
        }
        this.varNames.add(string2);
        this.varTypes.add(TypeInt.getInstance());
        this.varScopes.add(this.stack.size());
        if (expression != null) {
            this.values.addValue(string2, expression.evaluateInt(null, this.values));
        } else {
            if (this.params.length <= this.paramCounter + 1) {
                throw new PrismException("No value provided for undefined preprocessor constant \"" + string2 + "\"");
            }
            this.values.addValue(string2, Integer.parseInt(this.params[++this.paramCounter]));
        }
        ++this.pc;
    }

    private void interpretForLoop(String string, String string2) throws PrismException {
        if (!this.outputEnabled) {
            this.stack.push("Dummy for loop");
            ++this.pc;
            return;
        }
        ForLoop forLoop = this.prism.parseForLoopString(string);
        if (this.varNames.contains(forLoop.getLHS())) {
            throw new PrismException("Duplicated variable/constant \"" + forLoop.getLHS() + "\"");
        }
        forLoop = (ForLoop)forLoop.findAllVars(this.varNames, this.varTypes);
        forLoop.typeCheck();
        forLoop.semanticCheck();
        forLoop.setPC(this.pc + 1);
        forLoop.setBetween(string2);
        this.stack.push(forLoop);
        this.varNames.add(forLoop.getLHS());
        this.varTypes.add(TypeInt.getInstance());
        this.varScopes.add(this.stack.size());
        this.values.addValue(forLoop.getLHS(), forLoop.getFrom().evaluateInt(null, this.values));
        if (forLoop.getFrom().evaluateInt(null, this.values) > forLoop.getTo().evaluateInt(null, this.values)) {
            this.outputEnabled = false;
        }
        ++this.pc;
    }

    private void interpretEnd() throws PrismException {
        if (this.stack.empty()) {
            throw new PrismException("Surplus \"end\" statement");
        }
        if (this.stack.peek() instanceof ForLoop) {
            ForLoop forLoop = (ForLoop)this.stack.peek();
            int n = this.stack.size();
            int n2 = 0;
            while (n2 < this.varNames.size()) {
                if (this.varScopes.get(n2) >= n && !this.varNames.get(n2).equals(forLoop.getLHS())) {
                    this.varNames.removeElementAt(n2);
                    this.varTypes.removeElementAt(n2);
                    this.varScopes.removeElementAt(n2);
                    this.values.removeValue(n2);
                    continue;
                }
                ++n2;
            }
            if (!this.outputEnabled) {
                this.outputEnabled = true;
                n2 = this.varNames.indexOf(forLoop.getLHS());
                this.varNames.removeElementAt(n2);
                this.varTypes.removeElementAt(n2);
                this.varScopes.removeElementAt(n2);
                this.values.removeValue(n2);
                this.stack.pop();
                ++this.pc;
            } else {
                n = (Integer)this.values.getValueOf(forLoop.getLHS());
                if ((n += forLoop.getStep().evaluateInt(null, this.values)) <= forLoop.getTo().evaluateInt(null, this.values)) {
                    this.values.setValue(forLoop.getLHS(), n);
                    this.output = this.output + forLoop.getBetween();
                    this.pc = forLoop.getPC();
                } else {
                    n2 = this.varNames.indexOf(forLoop.getLHS());
                    this.varNames.removeElementAt(n2);
                    this.varTypes.removeElementAt(n2);
                    this.varScopes.removeElementAt(n2);
                    this.values.removeValue(n2);
                    this.stack.pop();
                    ++this.pc;
                }
            }
        } else if (this.stack.peek() instanceof String && !this.outputEnabled) {
            this.stack.pop();
            ++this.pc;
        } else {
            throw new PrismException("Preprocessor stack error");
        }
    }

    private void interpretExpression(String string) throws PrismException {
        if (!this.outputEnabled) {
            ++this.pc;
            return;
        }
        Expression expression = Prism.parseSingleExpressionString(string);
        expression = (Expression)expression.findAllVars(this.varNames, this.varTypes);
        expression.typeCheck();
        expression.semanticCheck();
        this.output = this.output + expression.evaluate(null, this.values);
        ++this.pc;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            return;
        }
        Prism prism = new Prism(new PrismFileLog("stdout"));
        try {
            Preprocessor preprocessor = new Preprocessor(prism, new File(stringArray[0]));
            preprocessor.setParameters(stringArray);
            String string = preprocessor.preprocess();
            if (string == null) {
                System.out.println("Error: No preprocessing information.");
            } else {
                System.out.print(string);
            }
        }
        catch (PrismException prismException) {
            System.err.println("Error: " + prismException.getMessage());
        }
    }
}

