/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceRabin;
import automata.DA;
import automata.LTL2DA;
import dv.DoubleVector;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import parser.ast.Expression;
import parser.ast.RelOp;
import prism.LTLModelChecker;
import prism.ModelChecker;
import prism.MultiObjUtils;
import prism.NativeIntArray;
import prism.NondetModel;
import prism.OpRelOpBound;
import prism.Operator;
import prism.OpsAndBoundsList;
import prism.Point;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.Tile;
import prism.TileList;
import sparse.NDSparseMatrix;
import sparse.PrismSparse;

public class MultiObjModelChecker
extends PrismComponent {
    protected Prism prism;
    protected boolean verbose;

    public MultiObjModelChecker(PrismComponent prismComponent, Prism prism) throws PrismException {
        super(prismComponent);
        this.prism = prism;
        this.verbose = this.settings.getBoolean("prism.verbose");
    }

    protected NondetModel constructDRAandProductMulti(NondetModel nondetModel, LTLModelChecker lTLModelChecker, ModelChecker modelChecker, Expression expression, int n, DA<BitSet, AcceptanceRabin>[] dAArray, Operator operator, Expression expression2, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode) throws PrismException {
        Object object;
        Vector<JDDNode> vector = new Vector<JDDNode>();
        expression = lTLModelChecker.checkMaximalStateFormulas(modelChecker, nondetModel, expression2.deepCopy(), vector);
        if (Operator.isMinOrLe(operator)) {
            expression = Expression.Not(Expression.Parenth(expression));
        }
        this.mainLog.println("\nBuilding deterministic Rabin automaton (for " + expression + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this);
        dAArray[n] = lTL2DA.convertLTLFormulaToDRA(expression, modelChecker.getConstantValues());
        this.mainLog.print("DRA has " + dAArray[n].size() + " states, " + dAArray[n].getAcceptance().getSizeStatistics() + ".");
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for Rabin translation: " + (double)l / 1000.0 + " seconds.");
        if (this.settings.getExportPropAut()) {
            object = PrismUtils.addCounterSuffixToFilename(this.settings.getExportPropAutFilename(), n + 1);
            this.mainLog.println("Exporting DRA to file \"" + (String)object + "\"...");
            PrintStream printStream = PrismUtils.newPrintStream((String)object);
            dAArray[n].print(printStream, this.settings.getExportPropAutType());
            printStream.close();
        }
        this.mainLog.println("\nConstructing MDP-DRA product...");
        object = lTLModelChecker.constructProductMDP(dAArray[n], nondetModel, vector, jDDVars, jDDVars2, (n == 0 ? jDDNode : nondetModel.getStart()).copy());
        ((NondetModel)object).printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        return object;
    }

    protected boolean removeNonZeroRewardTrans(NondetModel nondetModel, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            JDDNode jDDNode;
            if (opsAndBoundsList.getRewardOperator(i) != Operator.R_MIN && opsAndBoundsList.getRewardOperator(i) != Operator.R_LE) continue;
            JDD.Ref(list.get(i));
            JDDNode jDDNode2 = JDD.GreaterThan(list.get(i), 0.0);
            if (jDDNode2.equals(JDD.ZERO)) continue;
            JDD.Ref(jDDNode2);
            if (!bl) {
                JDD.Ref(nondetModel.getTrans());
            }
            nondetModel.trans = jDDNode = JDD.ITE(jDDNode2, JDD.Constant(0.0), nondetModel.getTrans());
            if (!bl) {
                JDD.Ref(nondetModel.getTrans01());
            }
            nondetModel.trans01 = jDDNode = JDD.ITE(jDDNode2, JDD.Constant(0.0), nondetModel.getTrans01());
            bl = true;
        }
        return bl;
    }

    protected List<JDDNode> computeAllEcs(NondetModel nondetModel, LTLModelChecker lTLModelChecker, ArrayList<ArrayList<JDDNode>> arrayList, ArrayList<ArrayList<JDDNode>> arrayList2, JDDNode jDDNode, JDDNode jDDNode2, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, OpsAndBoundsList opsAndBoundsList, int n) throws PrismException {
        JDD.Ref(jDDNode);
        JDD.Ref(nondetModel.getTrans01());
        JDDNode jDDNode3 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode);
        for (int i = 0; i < n; ++i) {
            if (!opsAndBoundsList.isProbabilityObjective(i)) continue;
            jDDNode = JDD.PermuteVariables(jDDNode, jDDVarsArray[i], jDDVarsArray2[i]);
        }
        jDDNode3 = JDD.Apply(3, jDDNode3, jDDNode);
        jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDColVars());
        jDDNode3 = JDD.ThereExists(jDDNode3, nondetModel.getAllDDNondetVars());
        List<JDDNode> list = lTLModelChecker.findMECStates(nondetModel, jDDNode3, jDDNode2);
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return list;
    }

    protected JDDNode computeAcceptingEndComponent(DA<BitSet, AcceptanceRabin> dA, NondetModel nondetModel, JDDVars jDDVars, JDDVars jDDVars2, List<JDDNode> list, List<JDDNode> list2, List<JDDNode> list3, LTLModelChecker lTLModelChecker, boolean bl) throws PrismException {
        long l = System.currentTimeMillis();
        if (bl) {
            for (JDDNode jDDNode : list2) {
                JDD.Ref(jDDNode);
            }
            for (JDDNode jDDNode : list3) {
                JDD.Ref(jDDNode);
            }
        }
        JDDNode jDDNode = lTLModelChecker.findMultiAcceptingStates(dA, nondetModel, jDDVars, jDDVars2, false, list, list2, list3);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for end component identification: " + (double)l / 1000.0 + " seconds.");
        return jDDNode;
    }

    protected void removeNonZeroMecsForMax(NondetModel nondetModel, LTLModelChecker lTLModelChecker, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList, int n, DA<BitSet, AcceptanceRabin>[] dAArray, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2) throws PrismException {
        Object object;
        Object object2;
        JDDNode jDDNode42;
        List<JDDNode> list2 = lTLModelChecker.findMECStates(nondetModel, nondetModel.getReach());
        JDDNode jDDNode2 = JDD.Constant(0.0);
        JDDNode jDDNode3 = JDD.Constant(0.0);
        for (int i = 0; i < list.size(); ++i) {
            if (opsAndBoundsList.getRewardOperator(i) != Operator.R_MAX && opsAndBoundsList.getRewardOperator(i) != Operator.R_GE) continue;
            JDD.Ref(list.get(i));
            jDDNode42 = JDD.GreaterThan(list.get(i), 0.0);
            if (!jDDNode42.equals(JDD.ZERO)) {
                for (int j = 0; j < list2.size(); ++j) {
                    object2 = list2.get(j);
                    JDD.Ref((JDDNode)object2);
                    object = lTLModelChecker.maxStableSetTrans1(nondetModel, (JDDNode)object2);
                    JDD.Ref(jDDNode42);
                    object = JDD.And(jDDNode42, (JDDNode)object);
                    if (!((JDDNode)object).equals(JDD.ZERO)) {
                        JDD.Ref((JDDNode)object2);
                        jDDNode3 = JDD.Or(jDDNode3, (JDDNode)object2);
                    }
                    jDDNode2 = JDD.Or(jDDNode2, (JDDNode)object);
                }
            }
            JDD.Deref(jDDNode42);
        }
        for (JDDNode jDDNode42 : list2) {
            JDD.Deref(jDDNode42);
        }
        if (!jDDNode3.equals(JDD.ZERO)) {
            boolean bl = false;
            if (JDD.AreIntersecting(nondetModel.getStart(), jDDNode3)) {
                bl = true;
                JDD.Deref(jDDNode3);
            } else {
                JDD.Ref(jDDNode3);
                jDDNode42 = JDD.PermuteVariables(jDDNode3, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
                JDD.Ref(nondetModel.getTrans01());
                jDDNode42 = JDD.And(nondetModel.getTrans01(), jDDNode42);
                jDDNode42 = JDD.And(jDDNode42, JDD.Not(jDDNode3));
                Vector<JDDNode> vector = new Vector<JDDNode>();
                object2 = new ArrayList();
                object = new ArrayList();
                ArrayList<DA<BitSet, AcceptanceRabin>> arrayList = new ArrayList<DA<BitSet, AcceptanceRabin>>();
                ArrayList<JDDVars> arrayList2 = new ArrayList<JDDVars>();
                ArrayList<JDDVars> arrayList3 = new ArrayList<JDDVars>();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    if (!opsAndBoundsList.isProbabilityObjective(i) || opsAndBoundsList.getOperator(i) == Operator.P_MAX || opsAndBoundsList.getOperator(i) == Operator.P_MIN) continue;
                    arrayList.add(dAArray[i]);
                    arrayList2.add(jDDVarsArray[i]);
                    arrayList3.add(jDDVarsArray2[i]);
                    ++n2;
                }
                if (n2 > 0) {
                    DA[] dAArray2 = new DA[n2];
                    arrayList.toArray(dAArray2);
                    JDDVars[] jDDVarsArray32 = new JDDVars[n2];
                    arrayList2.toArray(jDDVarsArray32);
                    JDDVars[] jDDVarsArray3 = new JDDVars[n2];
                    arrayList3.toArray(jDDVarsArray3);
                    this.findTargetStates(nondetModel, lTLModelChecker, n2, n2, new boolean[n2], dAArray2, jDDVarsArray32, jDDVarsArray3, vector, (List<JDDNode>)object2, (List<Integer>)object);
                    OpsAndBoundsList opsAndBoundsList2 = new OpsAndBoundsList();
                    for (int i = 0; i < opsAndBoundsList.probSize(); ++i) {
                        if (opsAndBoundsList.getProbOperator(i) == Operator.P_MAX) continue;
                        opsAndBoundsList2.add(opsAndBoundsList.getOpRelOpBound(i), opsAndBoundsList.getProbOperator(i), opsAndBoundsList.getProbBound(i), opsAndBoundsList.getProbStepBound(i), i);
                    }
                    opsAndBoundsList2.add(new OpRelOpBound("R", RelOp.MAX, -1.0), Operator.R_MAX, -1.0, -1, opsAndBoundsList.probSize());
                    ArrayList<JDDNode> arrayList4 = new ArrayList<JDDNode>(1);
                    arrayList4.add(jDDNode42);
                    double d = (Double)this.computeMultiReachProbs(nondetModel, lTLModelChecker, arrayList4, nondetModel.getStart(), vector, (List<JDDNode>)object2, (List<Integer>)object, opsAndBoundsList2, n2 > 1);
                    if (d > 0.0) {
                        bl = true;
                    } else if (Double.isNaN(d)) {
                        throw new PrismException("The LTL formulae in multi-objective query cannot be satisfied!\n");
                    }
                } else {
                    bl = true;
                }
                for (JDDNode jDDNode : vector) {
                    JDD.Deref(jDDNode);
                }
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    JDDNode jDDNode = (JDDNode)iterator.next();
                    JDD.Deref(jDDNode);
                }
            }
            if (bl) {
                throw new PrismNotSupportedException("Cannot use multi-objective model checking with maximising objectives and non-zero reward end compoments");
            }
            JDD.Ref(jDDNode2);
            nondetModel.trans = JDD.Apply(3, nondetModel.trans, JDD.Not(jDDNode2));
            nondetModel.trans01 = JDD.Apply(3, nondetModel.trans01, JDD.Not(jDDNode2));
        } else {
            JDD.Deref(jDDNode3);
            JDD.Deref(jDDNode2);
        }
    }

    protected void checkConflictsInObjectives(NondetModel nondetModel, LTLModelChecker lTLModelChecker, int n, int n2, OpsAndBoundsList opsAndBoundsList, DA<BitSet, AcceptanceRabin>[] dAArray, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, List<JDDNode> list, List<ArrayList<JDDNode>> list2, List<ArrayList<JDDNode>> list3, List<JDDNode> list4, List<Integer> list5) throws PrismException {
        int n3;
        DA[] dAArray2 = new DA[n];
        JDDVars[] jDDVarsArray3 = new JDDVars[n];
        JDDVars[] jDDVarsArray4 = new JDDVars[n];
        ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>(n);
        ArrayList<List<JDDNode>> arrayList2 = new ArrayList<List<JDDNode>>(n);
        ArrayList<List<JDDNode>> arrayList3 = new ArrayList<List<JDDNode>>(n);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!opsAndBoundsList.isProbabilityObjective(i)) continue;
            dAArray2[n4] = dAArray[i];
            jDDVarsArray3[n4] = jDDVarsArray[i];
            jDDVarsArray4[n4] = jDDVarsArray2[i];
            arrayList.add(list.get(n4));
            arrayList2.add((List<JDDNode>)list2.get(i));
            arrayList3.add((List<JDDNode>)list3.get(i));
            ++n4;
        }
        ArrayList<List<Integer>> arrayList4 = new ArrayList<List<Integer>>();
        lTLModelChecker.findMultiConflictAcceptingStates(dAArray2, nondetModel, jDDVarsArray3, jDDVarsArray4, arrayList, arrayList2, arrayList3, list4, arrayList4);
        n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (!opsAndBoundsList.isProbabilityObjective(n3)) continue;
            list.remove(n4);
            list.add(n4, (JDDNode)arrayList.get(n4));
            ++n4;
        }
        for (n3 = 0; n3 < arrayList4.size(); ++n3) {
            list5.add(this.changeToInteger((List)arrayList4.get(n3)));
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (!opsAndBoundsList.isProbabilityObjective(n3)) continue;
            List list6 = list2.get(n3);
            for (JDDNode jDDNode : list6) {
                JDD.Deref(jDDNode);
            }
            list6 = list3.get(n3);
            for (JDDNode jDDNode : list6) {
                JDD.Deref(jDDNode);
            }
        }
    }

    protected void findTargetStates(NondetModel nondetModel, LTLModelChecker lTLModelChecker, int n, int n2, boolean[] blArray, DA<BitSet, AcceptanceRabin>[] dAArray, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, List<JDDNode> list, List<JDDNode> list2, List<Integer> list3) throws PrismException {
        JDDVars[] jDDVarsArray32;
        Object object3;
        Object object2;
        List<Object> list4;
        int n3;
        ArrayList arrayList = new ArrayList(n);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        JDDNode jDDNode = JDD.Constant(0.0);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (n3 = 0; n3 < n; ++n3) {
            if (!blArray[n3]) {
                list4 = new ArrayList<JDDVars[]>();
                object2 = new ArrayList();
                for (int i = 0; i < dAArray[n3].getAcceptance().size(); ++i) {
                    object3 = JDD.Constant(0.0);
                    jDDVarsArray32 = JDD.Constant(0.0);
                    for (int j = 0; j < dAArray[n3].size(); ++j) {
                        if (!((AcceptanceRabin.RabinPair)dAArray[n3].getAcceptance().get(i)).getL().get(j)) {
                            object3 = JDD.SetVectorElement((JDDNode)object3, jDDVarsArray[n3], j, 1.0);
                        }
                        if (!((AcceptanceRabin.RabinPair)dAArray[n3].getAcceptance().get(i)).getK().get(j)) continue;
                        jDDVarsArray32 = JDD.SetVectorElement((JDDNode)jDDVarsArray32, jDDVarsArray[n3], j, 1.0);
                    }
                    ((ArrayList)list4).add(object3);
                    JDD.Ref((JDDNode)object3);
                    jDDNode = JDD.Or(jDDNode, (JDDNode)object3);
                    ((ArrayList)object2).add(jDDVarsArray32);
                    JDD.Ref((JDDNode)jDDVarsArray32);
                    jDDNode2 = JDD.Or(jDDNode2, (JDDNode)jDDVarsArray32);
                }
                arrayList.add(n3, list4);
                arrayList2.add(n3, object2);
                continue;
            }
            arrayList.add(n3, null);
            arrayList2.add(n3, null);
        }
        list4 = null;
        JDD.Ref(jDDNode);
        JDD.Ref(nondetModel.getTrans01());
        object2 = JDD.Apply(3, nondetModel.getTrans01(), jDDNode);
        for (n3 = 0; n3 < n; ++n3) {
            if (blArray[n3]) continue;
            jDDNode = JDD.PermuteVariables(jDDNode, jDDVarsArray[n3], jDDVarsArray2[n3]);
        }
        object2 = JDD.Apply(3, (JDDNode)object2, jDDNode);
        object2 = JDD.ThereExists((JDDNode)object2, nondetModel.getAllDDColVars());
        object2 = JDD.ThereExists((JDDNode)object2, nondetModel.getAllDDNondetVars());
        list4 = lTLModelChecker.findMECStates(nondetModel, (JDDNode)object2, jDDNode2);
        JDD.Deref((JDDNode)object2);
        JDD.Deref(jDDNode2);
        for (n3 = 0; n3 < n; ++n3) {
            if (blArray[n3]) continue;
            long l = System.currentTimeMillis();
            if (n2 > 1) {
                List list5 = (List)arrayList.get(n3);
                for (JDDVars[] jDDVarsArray32 : list5) {
                    JDD.Ref((JDDNode)jDDVarsArray32);
                }
                list5 = (List)arrayList2.get(n3);
                for (JDDVars[] jDDVarsArray32 : list5) {
                    JDD.Ref((JDDNode)jDDVarsArray32);
                }
            }
            list.add(lTLModelChecker.findMultiAcceptingStates(dAArray[n3], nondetModel, jDDVarsArray[n3], jDDVarsArray2[n3], false, list4, (List)arrayList.get(n3), (List)arrayList2.get(n3)));
            l = System.currentTimeMillis() - l;
            this.mainLog.println("Time for end component identification: " + (double)l / 1000.0 + " seconds.");
        }
        if (n2 > 1) {
            DA[] dAArray2 = new DA[n2];
            object3 = new JDDVars[n2];
            jDDVarsArray32 = new JDDVars[n2];
            ArrayList<JDDNode> arrayList3 = new ArrayList<JDDNode>(n2);
            ArrayList<List<JDDNode>> arrayList4 = new ArrayList<List<JDDNode>>(n2);
            ArrayList<List<JDDNode>> arrayList5 = new ArrayList<List<JDDNode>>(n2);
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (blArray[n3]) continue;
                dAArray2[n4] = dAArray[n3];
                object3[n4] = jDDVarsArray[n3];
                jDDVarsArray32[n4] = jDDVarsArray2[n3];
                arrayList3.add(list.get(n4));
                arrayList4.add((List)arrayList.get(n3));
                arrayList5.add((List)arrayList2.get(n3));
                ++n4;
            }
            ArrayList<List<Integer>> arrayList6 = new ArrayList<List<Integer>>();
            lTLModelChecker.findMultiConflictAcceptingStates(dAArray2, nondetModel, (JDDVars[])object3, jDDVarsArray32, arrayList3, arrayList4, arrayList5, list2, arrayList6);
            n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (blArray[n3]) continue;
                list.remove(n4);
                list.add(n4, (JDDNode)arrayList3.get(n4));
                ++n4;
            }
            for (n3 = 0; n3 < arrayList6.size(); ++n3) {
                list3.add(this.changeToInteger((List)arrayList6.get(n3)));
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (blArray[n3]) continue;
                List list6 = (List)arrayList.get(n3);
                for (JDDNode jDDNode3 : list6) {
                    JDD.Deref(jDDNode3);
                }
                list6 = (List)arrayList2.get(n3);
                for (JDDNode jDDNode3 : list6) {
                    JDD.Deref(jDDNode3);
                }
            }
        }
        for (Object object3 : list4) {
            JDD.Deref((JDDNode)object3);
        }
    }

    private int changeToInteger(List<Integer> list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n2 = 1;
            if (list.get(i) > 0) {
                n2 <<= list.get(i).intValue();
            }
            n += n2;
        }
        return n;
    }

    protected Object computeMultiReachProbs(NondetModel nondetModel, LTLModelChecker lTLModelChecker, List<JDDNode> list, JDDNode jDDNode, List<JDDNode> list2, List<JDDNode> list3, List<Integer> list4, OpsAndBoundsList opsAndBoundsList, boolean bl) throws PrismException {
        Object object;
        block28: {
            JDDNode jDDNode2;
            Object object2;
            Object object3;
            int n;
            JDDNode jDDNode3 = null;
            int n2 = list2.size();
            JDDNode[] jDDNodeArray = new JDDNode[n2];
            for (n = 0; n < n2; ++n) {
                JDD.Ref(list2.get(n));
                object3 = list2.get(n);
                if (list3 != null) {
                    for (int i = 0; i < list3.size(); ++i) {
                        if ((list4.get(i) & 1 << n) <= 0) continue;
                        JDD.Ref(list3.get(i));
                        object3 = JDD.Or((JDDNode)object3, list3.get(i));
                    }
                }
                jDDNodeArray[n] = object3;
            }
            if (this.prism.getExportTarget()) {
                object3 = new JDDNode[n2 + 1];
                object2 = new String[n2 + 1];
                object3[0] = nondetModel.getStart();
                object2[0] = "init";
                for (n = 0; n < n2; ++n) {
                    object3[n + 1] = jDDNodeArray[n];
                    object2[n + 1] = "target" + n;
                }
                try {
                    this.mainLog.print("\nExporting target states info to file \"" + this.prism.getExportTargetFilename() + "\"...");
                    PrismMTBDD.ExportLabels((JDDNode[])object3, (String[])object2, "l", nondetModel.getAllDDRowVars(), nondetModel.getODD(), 1, this.prism.getExportTargetFilename());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mainLog.println("\nWarning: Could not export target to file \"" + this.prism.getExportTargetFilename() + "\"");
                }
            }
            JDDNode jDDNode4 = JDD.Constant(0.0);
            for (n = 0; n < n2; ++n) {
                JDD.Ref(list2.get(n));
                jDDNode4 = JDD.Or(jDDNode4, list2.get(n));
            }
            if (list3 != null) {
                for (n = 0; n < list3.size(); ++n) {
                    JDD.Ref(list3.get(n));
                    jDDNode4 = JDD.Or(jDDNode4, list3.get(n));
                }
            }
            if (opsAndBoundsList.rewardSize() == 0) {
                jDDNode2 = PrismMTBDD.Prob0A(nondetModel.getTrans01(), nondetModel.getReach(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), nondetModel.getReach(), jDDNode4);
            } else {
                jDDNode2 = JDD.Constant(0.0);
                jDDNode3 = PrismMTBDD.Prob0A(nondetModel.getTrans01(), nondetModel.getReach(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), nondetModel.getReach(), jDDNode4);
                object3 = lTLModelChecker.findMECStates(nondetModel, jDDNode3);
                JDD.Deref(jDDNode3);
                jDDNode3 = JDD.Constant(0.0);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    JDDNode jDDNode5 = (JDDNode)object2.next();
                    jDDNode3 = JDD.Or(jDDNode3, jDDNode5);
                }
            }
            JDD.Ref(nondetModel.getReach());
            JDD.Ref(jDDNode4);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode6 = JDD.And(nondetModel.getReach(), JDD.Not(JDD.Or(jDDNode4, jDDNode2)));
            for (n = 0; n < list.size(); ++n) {
                object3 = list.remove(n);
                JDD.Ref(jDDNode2);
                object3 = JDD.Apply(3, (JDDNode)object3, JDD.Not(jDDNode2));
                list.add(n, (JDDNode)object3);
            }
            this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode4, nondetModel.getAllDDRowVars().n()));
            this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode2, nondetModel.getAllDDRowVars().n()));
            this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode6, nondetModel.getAllDDRowVars().n()) + "\n");
            this.mainLog.println("\nComputing remaining probabilities...");
            int n3 = this.settings.getChoice("prism.engine");
            int n4 = this.prism.getMDPMultiSolnMethod();
            if (n3 == 3) {
                this.mainLog.println("Switching engine since only sparse engine currently supports this computation...");
                n3 = 2;
            }
            this.mainLog.println("Engine: " + Prism.getEngineString(n3));
            try {
                if (n3 != 2) {
                    throw new PrismNotSupportedException("Currently only sparse engine supports multi-objective properties");
                }
                if (n4 == 3 && opsAndBoundsList.numberOfNumerical() > 1) {
                    throw new PrismNotSupportedException("Pareto curve generation is not currently supported using linear programming");
                }
                if (n4 == 3) {
                    if (opsAndBoundsList.numberOfStepBounded() > 0) {
                        throw new PrismNotSupportedException("Step-bounded objectives are not currently supported with linear programming");
                    }
                    object = opsAndBoundsList.rewardSize() > 0 ? (bl ? Double.valueOf(PrismSparse.NondetMultiReachReward1(nondetModel.getTrans(), nondetModel.getTransActions(), nondetModel.getSynchs(), nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), list2, list3, list4, opsAndBoundsList, jDDNode6, jDDNode, list, jDDNode3)) : Double.valueOf(PrismSparse.NondetMultiReachReward(nondetModel.getTrans(), nondetModel.getTransActions(), nondetModel.getSynchs(), nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), list2, opsAndBoundsList, jDDNode6, jDDNode, list, jDDNode3))) : (bl ? Double.valueOf(PrismSparse.NondetMultiReach1(nondetModel.getTrans(), nondetModel.getTransActions(), nondetModel.getSynchs(), nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), list2, list3, list4, opsAndBoundsList, jDDNode6, jDDNode)) : Double.valueOf(PrismSparse.NondetMultiReach(nondetModel.getTrans(), nondetModel.getTransActions(), nondetModel.getSynchs(), nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), list2, opsAndBoundsList, jDDNode6, jDDNode)));
                    break block28;
                }
                if (n4 == 2 || n4 == 1) {
                    double d = System.currentTimeMillis();
                    object = this.weightedMultiReachProbs(nondetModel, jDDNode4, jDDNode6, jDDNode, jDDNodeArray, list, opsAndBoundsList);
                    double d2 = System.currentTimeMillis();
                    double d3 = (d2 - d) / 1000.0;
                    this.mainLog.println("Multi-objective value iterations took " + d3 + " s.");
                    break block28;
                }
                throw new PrismException("Unknown multi-objective model checking method");
            }
            catch (PrismException prismException) {
                throw prismException;
            }
            finally {
                if (opsAndBoundsList.rewardSize() > 0) {
                    JDD.Deref(jDDNode3);
                }
                JDD.Deref(jDDNode4);
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode6);
                for (int i = 0; i < jDDNodeArray.length; ++i) {
                    JDD.Deref(jDDNodeArray[i]);
                }
                for (n = 0; n < list.size(); ++n) {
                    JDD.Deref(list.get(n));
                }
            }
        }
        return object;
    }

    protected Object weightedMultiReachProbs(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode[] jDDNodeArray, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList) throws PrismException {
        int n = opsAndBoundsList.numberOfNumerical();
        if (n > 2) {
            throw new PrismException("Pareto curve generation is currently only supported for 2 objectives");
        }
        if (n >= 2 && opsAndBoundsList.probSize() + opsAndBoundsList.rewardSize() > n) {
            throw new PrismException("Pareto curve generation is currently not allowed if there are other (bounded) objectives");
        }
        if (n >= 2) {
            return this.generateParetoCurve(nondetModel, jDDNode, jDDNode2, jDDNode3, jDDNodeArray, list, opsAndBoundsList);
        }
        return this.targetDrivenMultiReachProbs(nondetModel, jDDNode, jDDNode2, jDDNode3, jDDNodeArray, list, opsAndBoundsList);
    }

    protected TileList generateParetoCurve(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode[] jDDNodeArray, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList) throws PrismException {
        String string;
        int n;
        double d;
        String string2;
        Point point;
        Object object;
        int n2;
        Object object2;
        boolean bl;
        int n3 = 0;
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = opsAndBoundsList.getRewardStepBound(i);
        }
        int[] nArray2 = new int[jDDNodeArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = opsAndBoundsList.getProbStepBound(i);
        }
        double d2 = System.currentTimeMillis();
        boolean bl2 = false;
        int n4 = 0;
        boolean bl3 = bl = this.settings.getChoice("prism.mdpSolnMethod") == 2;
        if (opsAndBoundsList.numberOfStepBounded() > 0) {
            this.mainLog.println("Not using Gauss-Seidel since there are step-bounded objectives");
            bl = false;
        }
        for (int i = 0; i < opsAndBoundsList.rewardSize(); ++i) {
            JDDNode jDDNode4;
            if (opsAndBoundsList.getRewardOperator(i) == Operator.R_LE) {
                jDDNode4 = JDD.Apply(3, JDD.Constant(-1.0), list.get(i));
                list.set(i, jDDNode4);
            }
            if (opsAndBoundsList.getRewardOperator(i) != Operator.R_MIN) continue;
            jDDNode4 = JDD.Apply(3, JDD.Constant(-1.0), list.get(i));
            list.set(i, jDDNode4);
        }
        double d3 = this.settings.getDouble("prism.paretoEpsilon");
        int n5 = this.settings.getInteger("prism.multiMaxIters");
        int n6 = this.settings.getChoice("prism.exportAdv");
        NativeIntArray nativeIntArray = new NativeIntArray((int)nondetModel.getNumStates());
        int n7 = jDDNodeArray.length;
        int n8 = list.size();
        Point point2 = new Point(n7 + n8);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        ArrayList<Point> arrayList3 = new ArrayList<Point>();
        DoubleVector[] doubleVectorArray = new DoubleVector[n7];
        NDSparseMatrix[] nDSparseMatrixArray = new NDSparseMatrix[n8];
        JDD.Ref(nondetModel.getTrans());
        JDD.Ref(nondetModel.getReach());
        JDDNode jDDNode5 = JDD.Apply(3, nondetModel.getTrans(), nondetModel.getReach());
        if (!bl2 && n8 == 0) {
            JDD.Ref(jDDNode5);
            object2 = JDD.And(JDD.Equals(jDDNode5, 1.0), JDD.Identity(nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars()));
            jDDNode5 = JDD.ITE((JDDNode)object2, JDD.Constant(0.0), jDDNode5);
        }
        object2 = NDSparseMatrix.BuildNDSparseMatrix(jDDNode5, nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars());
        if (this.settings.getChoice("prism.exportAdv") != 1) {
            NDSparseMatrix.AddActionsToNDSparseMatrix(jDDNode5, nondetModel.getTransActions(), nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), (NDSparseMatrix)object2);
        }
        for (n2 = 0; n2 < n7; ++n2) {
            doubleVectorArray[n2] = new DoubleVector(jDDNodeArray[n2], nondetModel.getAllDDRowVars(), nondetModel.getODD());
        }
        for (n2 = 0; n2 < n8; ++n2) {
            object = NDSparseMatrix.BuildSubNDSparseMatrix(jDDNode5, nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), list.get(n2));
            nDSparseMatrixArray[n2] = object;
        }
        JDD.Deref(jDDNode5);
        for (n2 = 0; n2 < n7; ++n2) {
            object = null;
            point = new Point(n7 + n8);
            point.setCoord(n2, 1.0);
            try {
                string2 = this.settings.getString("prism.exportAdvFilename");
                if (this.settings.getChoice("prism.exportAdv") != 1) {
                    PrismNative.setExportAdvFilename(PrismUtils.addCounterSuffixToFilename(string2, ++n4));
                }
                this.mainLog.println("Optimising weighted sum for probability objective " + (n2 + 1) + "/" + n7 + ": weights " + point);
                object = bl ? (Object)PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, doubleVectorArray, nDSparseMatrixArray, point.getCoords()) : (Object)PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, nondetModel.getSynchs(), doubleVectorArray, nArray2, nDSparseMatrixArray, point.getCoords(), nArray);
            }
            catch (PrismException prismException) {
                this.mainLog.println("Ignoring the last multi-objective computation since it did not complete successfully");
                d = 10000.0;
                for (n = 0; n < n7 + n8; ++n) {
                    point.setCoord(n, n == n2 ? d : 1.0);
                }
                point = point.normalize();
                this.mainLog.println("Optimising weighted sum for probability objective " + (n2 + 1) + "/" + n7 + ": weights " + point);
                object = bl ? (Object)PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, doubleVectorArray, nDSparseMatrixArray, point.getCoords()) : (Object)PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, nondetModel.getSynchs(), doubleVectorArray, nArray2, nDSparseMatrixArray, point.getCoords(), nArray);
            }
            point2 = new Point((double[])object);
            this.mainLog.println("Computed point: " + point2);
            arrayList3.add(point2);
        }
        for (n2 = 0; n2 < n8; ++n2) {
            object = null;
            point = new Point(n7 + n8);
            point.setCoord(n7 + n2, 1.0);
            try {
                string2 = this.settings.getString("prism.exportAdvFilename");
                if (this.settings.getChoice("prism.exportAdv") != 1) {
                    PrismNative.setExportAdvFilename(PrismUtils.addCounterSuffixToFilename(string2, ++n4));
                }
                this.mainLog.println("Optimising weighted sum for reward objective " + (n2 + 1) + "/" + n8 + ": weights " + point);
                object = bl ? (Object)PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, doubleVectorArray, nDSparseMatrixArray, point.getCoords()) : (Object)PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, nondetModel.getSynchs(), doubleVectorArray, nArray2, nDSparseMatrixArray, point.getCoords(), nArray);
            }
            catch (PrismException prismException) {
                this.mainLog.println("Ignoring the last multi-objective computation since it did not complete successfully");
                d = 10000.0;
                for (n = 0; n < n7 + n8; ++n) {
                    point.setCoord(n, n == n7 + n2 ? d : 1.0);
                }
                point = point.normalize();
                this.mainLog.println("Optimising weighted sum for reward objective " + (n2 + 1) + "/" + n8 + ": weights " + point);
                object = bl ? (Object)PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, doubleVectorArray, nDSparseMatrixArray, point.getCoords()) : (Object)PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, nondetModel.getSynchs(), doubleVectorArray, nArray2, nDSparseMatrixArray, point.getCoords(), nArray);
            }
            ++n3;
            point2 = new Point((double[])object);
            this.mainLog.println("Computed point: " + point2);
            arrayList3.add(point2);
            if (!this.verbose) continue;
            this.mainLog.println("Upper bound is " + Arrays.toString((double[])object));
        }
        if (this.verbose) {
            this.mainLog.println("Points for the initial tile: " + arrayList3);
        }
        Tile tile = new Tile(arrayList3);
        object = new TileList(tile, opsAndBoundsList, d3);
        point = ((TileList)object).getCandidateHyperplane();
        if (this.verbose) {
            this.mainLog.println("The initial direction is " + point);
        }
        boolean bl4 = false;
        int n9 = 0;
        while (n9 < n5) {
            ++n9;
            string = this.settings.getString("prism.exportAdvFilename");
            if (this.settings.getChoice("prism.exportAdv") != 1) {
                PrismNative.setExportAdvFilename(PrismUtils.addCounterSuffixToFilename(string, ++n4));
            }
            this.mainLog.println("Optimising weighted sum of objectives: weights " + point);
            double[] dArray = bl ? PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, doubleVectorArray, nDSparseMatrixArray, point.getCoords()) : PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object2, nondetModel.getSynchs(), doubleVectorArray, nArray2, nDSparseMatrixArray, point.getCoords(), nArray);
            ++n3;
            Point point3 = new Point(dArray);
            this.mainLog.println("Computed point: " + point3);
            if (this.verbose) {
                this.mainLog.println("\n" + n3 + ": New point is " + point3 + ".");
                this.mainLog.println("TileList:" + (TileList)object);
            }
            arrayList.add(point3);
            arrayList2.add(point);
            ((TileList)object).addNewPoint(point3);
            point = ((TileList)object).getCandidateHyperplane();
            if (this.verbose) {
                this.mainLog.println("New direction is " + point);
            }
            if (point != null) continue;
            bl4 = true;
            break;
        }
        d2 = (double)System.currentTimeMillis() - d2;
        this.mainLog.println("The value iteration(s) took " + d2 / 1000.0 + " seconds altogether.");
        this.mainLog.println("Number of weight vectors used: " + n3);
        if (!bl4) {
            throw new PrismException("The computation did not finish in " + n5 + " target point iterations, try increasing this number using the -multimaxpoints switch.");
        }
        string = this.settings.getString("prism.exportParetoFileName");
        if (string != null && !string.equals("")) {
            MultiObjUtils.exportPareto((TileList)object, string);
            this.mainLog.println("Exported Pareto curve. To see it, run\n etc/scripts/prism-pareto.py " + string);
        }
        if (this.verbose) {
            this.mainLog.print("Computed " + ((TileList)object).getNumberOfDifferentPoints() + " points altogether: ");
            this.mainLog.println(((TileList)object).getPoints().toString());
        }
        return object;
    }

    protected double targetDrivenMultiReachProbs(NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode[] jDDNodeArray, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList) throws PrismException {
        int n;
        Object object;
        int n2;
        boolean bl;
        int n3 = 0;
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = opsAndBoundsList.getRewardStepBound(i);
        }
        int[] nArray2 = new int[jDDNodeArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = opsAndBoundsList.getProbStepBound(i);
        }
        double d = System.currentTimeMillis();
        boolean bl2 = false;
        boolean bl3 = bl = this.settings.getChoice("prism.mdpSolnMethod") == 2;
        if (opsAndBoundsList.numberOfStepBounded() > 0) {
            this.mainLog.println("Not using Gauss-Seidel since there are step-bounded objectives");
            bl = false;
        }
        for (n2 = 0; n2 < opsAndBoundsList.rewardSize(); ++n2) {
            JDDNode jDDNode4;
            if (opsAndBoundsList.getRewardOperator(n2) == Operator.R_LE) {
                jDDNode4 = JDD.Apply(3, JDD.Constant(-1.0), list.get(n2));
                list.set(n2, jDDNode4);
            }
            if (opsAndBoundsList.getRewardOperator(n2) != Operator.R_MIN) continue;
            jDDNode4 = JDD.Apply(3, JDD.Constant(-1.0), list.get(n2));
            list.set(n2, jDDNode4);
        }
        n2 = opsAndBoundsList.probSize() > 0 && (opsAndBoundsList.getProbOperator(0) == Operator.P_MAX || opsAndBoundsList.getProbOperator(0) == Operator.P_MIN) ? 1 : 0;
        boolean bl4 = opsAndBoundsList.rewardSize() > 0 && (opsAndBoundsList.getRewardOperator(0) == Operator.R_MAX || opsAndBoundsList.getRewardOperator(0) == Operator.R_MIN);
        boolean bl5 = n2 != 0 && opsAndBoundsList.getProbOperator(0) == Operator.P_MIN || bl4 && opsAndBoundsList.getRewardOperator(0) == Operator.R_MIN;
        int n4 = this.settings.getInteger("prism.multiMaxIters");
        NativeIntArray nativeIntArray = new NativeIntArray((int)nondetModel.getNumStates());
        int n5 = jDDNodeArray.length;
        int n6 = list.size();
        Point point = new Point(n5 + n6);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        DoubleVector[] doubleVectorArray = new DoubleVector[n5];
        NDSparseMatrix[] nDSparseMatrixArray = new NDSparseMatrix[n6];
        JDD.Ref(nondetModel.getTrans());
        JDD.Ref(nondetModel.getReach());
        JDDNode jDDNode5 = JDD.Apply(3, nondetModel.getTrans(), nondetModel.getReach());
        if (!bl2 && n6 == 0) {
            JDD.Ref(jDDNode5);
            object = JDD.And(JDD.Equals(jDDNode5, 1.0), JDD.Identity(nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars()));
            jDDNode5 = JDD.ITE((JDDNode)object, JDD.Constant(0.0), jDDNode5);
        }
        object = NDSparseMatrix.BuildNDSparseMatrix(jDDNode5, nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars());
        for (n = 0; n < n5; ++n) {
            doubleVectorArray[n] = new DoubleVector(jDDNodeArray[n], nondetModel.getAllDDRowVars(), nondetModel.getODD());
        }
        for (n = 0; n < n6; ++n) {
            NDSparseMatrix nDSparseMatrix;
            nDSparseMatrixArray[n] = nDSparseMatrix = NDSparseMatrix.BuildSubNDSparseMatrix(jDDNode5, nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), list.get(n));
        }
        JDD.Deref(jDDNode5);
        for (n = 0; n < n5; ++n) {
            point.setCoord(n, opsAndBoundsList.getProbBound(n));
        }
        if (n2 != 0) {
            point.setCoord(0, 1.0);
        }
        for (n = 0; n < n6; ++n) {
            double d2 = opsAndBoundsList.getRewardOperator(n) == Operator.R_LE ? -opsAndBoundsList.getRewardBound(n) : opsAndBoundsList.getRewardBound(n);
            point.setCoord(n + n5, d2);
        }
        if (bl4) {
            if (this.verbose) {
                this.mainLog.println("Getting an upper bound on maximizing objective");
            }
            double[] dArray = bl ? PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object, null, new NDSparseMatrix[]{nDSparseMatrixArray[0]}, new double[]{1.0}) : PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object, nondetModel.getSynchs(), null, null, new NDSparseMatrix[]{nDSparseMatrixArray[0]}, new double[]{1.0}, new int[]{nArray[0]});
            ++n3;
            point.setCoord(n5, dArray[0]);
            if (this.verbose) {
                this.mainLog.println("Upper bound is " + dArray[0]);
            }
        }
        Point point2 = MultiObjUtils.getWeights(point, arrayList);
        if (this.verbose) {
            this.mainLog.println("The initial target point is " + point);
            this.mainLog.println("The initial direction is " + point2);
        }
        boolean bl6 = false;
        boolean bl7 = false;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            ++n7;
            double[] dArray = new double[n5 + n6];
            for (int i = 0; i < n5 + n6; ++i) {
                dArray[i] = point2.getCoord(i);
            }
            double[] dArray2 = bl ? PrismSparse.NondetMultiObjGS(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object, doubleVectorArray, nDSparseMatrixArray, dArray) : PrismSparse.NondetMultiObj(nondetModel.getODD(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars(), nondetModel.getAllDDNondetVars(), false, jDDNode3, nativeIntArray, (NDSparseMatrix)object, nondetModel.getSynchs(), doubleVectorArray, nArray2, nDSparseMatrixArray, dArray, nArray);
            ++n3;
            Point point3 = new Point(dArray2);
            if (this.verbose) {
                this.mainLog.println("New point is " + point3 + ".");
            }
            arrayList.add(point3);
            arrayList2.add(point2);
            double d3 = 0.0;
            for (int i = 0; i < n5 + n6; ++i) {
                d3 += point3.getCoord(i) * point2.getCoord(i);
            }
            double d4 = 0.0;
            for (n8 = 0; n8 < n5 + n6; ++n8) {
                d4 += point.getCoord(n8) * point2.getCoord(n8);
            }
            if (d4 > d3) {
                if (n2 != 0 || bl4) {
                    n8 = n2 != 0 ? 0 : n5;
                    double d5 = d3 - (d4 - point2.getCoord(n8) * point.getCoord(n8));
                    if (!bl5 && d5 < 0.0 || bl5 && d5 > 0.0) {
                        bl6 = true;
                        point.setCoord(n8, Double.NaN);
                        if (!this.verbose) break;
                        this.mainLog.println("Decided, target is " + point);
                        break;
                    }
                    double d6 = d5 / point2.getCoord(n8);
                    point.setCoord(n8, d6);
                    if (d6 == Double.NEGATIVE_INFINITY) {
                        point.setCoord(n8, Double.NaN);
                        this.mainLog.println("\nThe constraints are not achievable!\n");
                        bl6 = true;
                        bl7 = false;
                        break;
                    }
                    if (this.verbose) {
                        this.mainLog.println("Target lowered to " + point);
                    }
                } else {
                    bl6 = true;
                    bl7 = false;
                    break;
                }
            }
            point2 = MultiObjUtils.getWeights(point, arrayList);
            if (this.verbose) {
                this.mainLog.println("New direction is " + point2);
            }
            if (point2 != null && !arrayList2.contains(point2)) continue;
            bl6 = true;
            bl7 = true;
            break;
        }
        d = (double)System.currentTimeMillis() - d;
        this.mainLog.println("The value iteration(s) took " + d / 1000.0 + " seconds altogether.");
        this.mainLog.println("Number of weight vectors used: " + n3);
        if (!bl6) {
            throw new PrismException("The computation did not finish in " + n4 + " target point iterations, try increasing this number using the -multimaxpoints switch.");
        }
        if (n2 != 0 || bl4) {
            int n9 = n2 != 0 ? 0 : n5;
            return bl5 ? -point.getCoord(n9) : point.getCoord(n9);
        }
        return bl7 ? 1.0 : 0.0;
    }
}

