/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.Interval;
import java.util.Collections;
import java.util.List;
import parser.State;
import parser.ast.Expression;
import prism.Evaluator;
import prism.ModelInfo;
import prism.PrismException;

public interface ModelGenerator<Value>
extends ModelInfo {
    default public Evaluator<Value> getEvaluator() {
        return Evaluator.forDouble();
    }

    default public Evaluator<Interval<Value>> getIntervalEvaluator() {
        return this.getEvaluator().createIntervalEvaluator();
    }

    default public boolean hasSingleInitialState() throws PrismException {
        return true;
    }

    default public List<State> getInitialStates() throws PrismException {
        return Collections.singletonList(this.getInitialState());
    }

    public State getInitialState() throws PrismException;

    public void exploreState(State var1) throws PrismException;

    default public int getPlayerOwningState() throws PrismException {
        return -1;
    }

    public int getNumChoices() throws PrismException;

    default public int getNumTransitions() throws PrismException {
        int n = 0;
        int n2 = this.getNumChoices();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumTransitions(i);
        }
        return n;
    }

    public int getNumTransitions(int var1) throws PrismException;

    default public int getChoiceIndexOfTransition(int n) throws PrismException {
        int n2 = 0;
        int n3 = this.getNumChoices();
        for (int i = 0; i < n3; ++i) {
            if (n >= (n2 += this.getNumTransitions(i))) continue;
            return i;
        }
        return -1;
    }

    default public int getChoiceOffsetOfTransition(int n) throws PrismException {
        int n2 = 0;
        int n3 = this.getNumChoices();
        for (int i = 0; i < n3; ++i) {
            if (n >= (n2 += this.getNumTransitions(i))) continue;
            return n - (n2 - this.getNumTransitions(i));
        }
        return -1;
    }

    default public int getTotalIndexOfTransition(int n, int n2) throws PrismException {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += this.getNumTransitions(i);
        }
        return n3 + n2;
    }

    default public boolean isDeadlock() throws PrismException {
        return this.getNumChoices() == 0;
    }

    public Object getTransitionAction(int var1, int var2) throws PrismException;

    default public int getTransitionActionIndex(int n, int n2) throws PrismException {
        List<Object> list = this.getActions();
        if (list != null) {
            int n3 = list.indexOf(this.getTransitionAction(n, n2));
            if (n3 != -1) {
                return n;
            }
            throw new PrismException("Action name \"" + this.getTransitionAction(n, n2) + "\" is not in the list of actions");
        }
        throw new PrismException("Action index information not available");
    }

    default public String getTransitionActionString(int n, int n2) throws PrismException {
        Object object = this.getTransitionAction(n, n2);
        return object == null ? "" : object.toString();
    }

    default public Object getChoiceAction(int n) throws PrismException {
        return this.getTransitionAction(n, 0);
    }

    default public int getChoiceActionIndex(int n) throws PrismException {
        return this.getTransitionActionIndex(n, 0);
    }

    default public String getChoiceActionString(int n) throws PrismException {
        Object object = this.getChoiceAction(n);
        return object == null ? "" : object.toString();
    }

    default public int getChoiceIndexByAction(Object object) throws PrismException {
        int n = this.getNumChoices();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.getChoiceAction(i);
            if (!(object2 == null ? object == null : object2.equals(object))) continue;
            return i;
        }
        return -1;
    }

    default public Expression getChoiceClockGuard(int n) throws PrismException {
        return null;
    }

    default public int[] getTransitionIndexes(int n) {
        return null;
    }

    public Value getTransitionProbability(int var1, int var2) throws PrismException;

    default public Value getChoiceProbabilitySum(int n) throws PrismException {
        Evaluator<Value> evaluator = this.getEvaluator();
        int n2 = this.getNumTransitions(n);
        Value Value2 = evaluator.zero();
        for (int i = 0; i < n2; ++i) {
            Value2 = evaluator.add(Value2, this.getTransitionProbability(n, i));
        }
        return Value2;
    }

    default public Value getProbabilitySum() throws PrismException {
        Evaluator<Value> evaluator = this.getEvaluator();
        int n = this.getNumChoices();
        Value Value2 = evaluator.zero();
        for (int i = 0; i < n; ++i) {
            Value2 = evaluator.add(Value2, this.getChoiceProbabilitySum(i));
        }
        return Value2;
    }

    default public Interval<Value> getTransitionProbabilityInterval(int n, int n2) throws PrismException {
        return null;
    }

    default public Object getTransitionProbabilityObject(int n, int n2) throws PrismException {
        if (!this.getModelType().uncertain()) {
            return this.getTransitionProbability(n, n2);
        }
        return this.getTransitionProbabilityInterval(n, n2);
    }

    default public String getTransitionProbabilityString(int n, int n2) throws PrismException {
        if (!this.getModelType().uncertain()) {
            return this.getTransitionProbability(n, n2).toString();
        }
        return this.getTransitionProbabilityInterval(n, n2).toString();
    }

    default public boolean isDeterministic() throws PrismException {
        if (this.getNumChoices() == 1 && this.getNumTransitions(0) == 1) {
            if (!this.getModelType().uncertain()) {
                return this.getEvaluator().isOne(this.getTransitionProbability(0, 0));
            }
            return this.getIntervalEvaluator().isOne(this.getTransitionProbabilityInterval(0, 0));
        }
        return false;
    }

    default public String getTransitionUpdateString(int n, int n2) throws PrismException {
        State state = this.computeTransitionTarget(n, n2);
        Object object = "";
        int n3 = this.getNumVars();
        for (int i = 0; i < n3; ++i) {
            object = (String)object + (i > 0 ? ", " : "") + this.getVarName(i) + "'=" + state.varValues[i];
        }
        return object;
    }

    default public String getTransitionUpdateStringFull(int n, int n2) throws PrismException {
        return this.getTransitionUpdateString(n, n2);
    }

    public State computeTransitionTarget(int var1, int var2) throws PrismException;

    default public boolean isLabelTrue(String string) throws PrismException {
        int n = this.getLabelIndex(string);
        if (n == -1) {
            throw new PrismException("Label \"" + string + "\" not defined");
        }
        return this.isLabelTrue(n);
    }

    default public Expression getClockInvariant() throws PrismException {
        return null;
    }

    default public boolean isLabelTrue(int n) throws PrismException {
        throw new PrismException("Label number \"" + n + "\" not defined");
    }

    default public State getObservation(State state) throws PrismException {
        if (!this.getModelType().partiallyObservable()) {
            return null;
        }
        throw new PrismException("Observation not defined");
    }
}

