/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.ModelType;
import prism.ModelVariablesDD;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.StateList;

public interface Model {
    public ModelType getModelType();

    public int getNumModules();

    public String[] getModuleNames();

    public String getModuleName(int var1);

    public int getNumVars();

    public VarList getVarList();

    public String getVarName(int var1);

    public int getVarIndex(String var1);

    public int getVarModule(int var1);

    public int getVarLow(int var1);

    public int getVarHigh(int var1);

    public int getVarRange(int var1);

    public Values getConstantValues();

    public List<String> getSynchs();

    public JDDNode getLabelDD(String var1);

    default public boolean hasLabelDD(String string) {
        return this.getLabels().contains(string);
    }

    public Set<String> getLabels();

    public String addUniqueLabelDD(String var1, JDDNode var2, Set<String> var3);

    public String globalToLocal(long var1);

    public int globalToLocal(long var1, int var3);

    public State convertBddToState(JDDNode var1);

    public int convertBddToIndex(JDDNode var1) throws PrismNotSupportedException;

    public StateList getReachableStates();

    public StateList getDeadlockStates();

    public StateList getStartStates();

    public int getNumRewardStructs();

    public long getNumStates();

    public long getNumTransitions();

    public long getNumStartStates();

    public String getNumStatesString();

    public String getNumTransitionsString();

    public String getNumStartStatesString();

    public JDDNode getTrans();

    public JDDNode getTrans01();

    public JDDNode getStart();

    public JDDNode getReach();

    public JDDNode getTransReln();

    public JDDNode getDeadlocks();

    public JDDNode getStateRewards();

    public JDDNode getStateRewards(int var1);

    public JDDNode getStateRewards(String var1);

    public JDDNode getTransRewards();

    public JDDNode getTransRewards(int var1);

    public JDDNode getTransRewards(String var1);

    public JDDNode getTransActions();

    public JDDNode[] getTransPerAction();

    public JDDVars[] getVarDDRowVars();

    public JDDVars[] getVarDDColVars();

    public JDDVars getVarDDRowVars(int var1);

    public JDDVars getVarDDColVars(int var1);

    public JDDVars[] getModuleDDRowVars();

    public JDDVars[] getModuleDDColVars();

    public JDDVars getModuleDDRowVars(int var1);

    public JDDVars getModuleDDColVars(int var1);

    public JDDVars getAllDDRowVars();

    public JDDVars getAllDDColVars();

    public int getNumDDRowVars();

    public int getNumDDColVars();

    public int getNumDDVarsInTrans();

    public Vector<String> getDDVarNames();

    public ModelVariablesDD getModelVariables();

    public ODDNode getODD();

    public void setSynchs(List<String> var1);

    public void addLabelDD(String var1, JDDNode var2);

    public void resetTrans(JDDNode var1);

    public void resetTransRewards(int var1, JDDNode var2);

    public void doReachability() throws PrismException;

    public void skipReachability() throws PrismException;

    public void setReach(JDDNode var1) throws PrismException;

    public void setTransActions(JDDNode var1);

    public void setTransPerAction(JDDNode[] var1);

    public void filterReachableStates();

    public void findDeadlocks(boolean var1);

    public void printTrans();

    public void printTrans01();

    public void printTransInfo(PrismLog var1);

    public void printTransInfo(PrismLog var1, boolean var2);

    default public void exportToFile(int n, boolean bl, File file) throws FileNotFoundException, PrismException {
        this.exportToFile(n, bl, file, 16);
    }

    public void exportToFile(int var1, boolean var2, File var3, int var4) throws FileNotFoundException, PrismException;

    default public void exportStateRewardsToFile(int n, int n2, File file) throws FileNotFoundException, PrismException {
        this.exportStateRewardsToFile(n, n2, file, 16, false);
    }

    public void exportStateRewardsToFile(int var1, int var2, File var3, int var4, boolean var5) throws FileNotFoundException, PrismException;

    @Deprecated
    default public String exportStateRewardsToFile(int n, File file) throws FileNotFoundException, PrismException {
        return this.exportStateRewardsToFile(n, file, 16);
    }

    @Deprecated
    public String exportStateRewardsToFile(int var1, File var2, int var3) throws FileNotFoundException, PrismException;

    default public void exportTransRewardsToFile(int n, int n2, boolean bl, File file) throws FileNotFoundException, PrismException {
        this.exportTransRewardsToFile(n, n2, bl, file, 16, false);
    }

    public void exportTransRewardsToFile(int var1, int var2, boolean var3, File var4, int var5, boolean var6) throws FileNotFoundException, PrismException;

    @Deprecated
    default public String exportTransRewardsToFile(int n, boolean bl, File file) throws FileNotFoundException, PrismException {
        return this.exportTransRewardsToFile(n, bl, file, 16);
    }

    @Deprecated
    public String exportTransRewardsToFile(int var1, boolean var2, File var3, int var4) throws FileNotFoundException, PrismException;

    public void exportStates(int var1, PrismLog var2);

    public void clear();
}

