/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.MinMax;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import parser.type.TypePathDouble;
import prism.GamesModel;
import prism.IntegerBound;
import prism.Model;
import prism.NonProbModelChecker;
import prism.OpRelOpBound;
import prism.Prism;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.StateValues;
import prism.StateValuesMTBDD;

public class GamesModelChecker
extends NonProbModelChecker {
    protected GamesModel model;
    protected JDDNode nondetMask;
    protected JDDVars allDDNondetVars;
    protected JDDVars allDDPlayerVars;
    protected JDDNode ddc1;
    protected JDDNode ddc2;
    protected boolean precomp;
    protected boolean prob0;
    protected boolean prob1;
    protected int maxIters;

    public GamesModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
        if (!(model instanceof GamesModel)) {
            throw new PrismException("Wrong model type passed to GamesModelChecker.");
        }
        this.model = (GamesModel)model;
        this.nondetMask = this.model.getNondetMask();
        this.allDDNondetVars = this.model.getAllDDNondetVars();
        this.allDDPlayerVars = this.model.getAllDDPlayerVars();
        this.precomp = prism.getPrecomp();
        this.prob0 = prism.getProb0();
        this.prob1 = prism.getProb1();
        this.maxIters = prism.getMaxIters();
    }

    @Override
    public StateValues checkExpression(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues;
        if (expression instanceof ExpressionStrategy) {
            stateValues = this.checkExpressionStrategy((ExpressionStrategy)expression, jDDNode);
        } else if (expression instanceof ExpressionProb) {
            stateValues = this.checkExpressionProb((ExpressionProb)expression, jDDNode);
        } else if (expression instanceof ExpressionReward) {
            stateValues = this.checkExpressionReward((ExpressionReward)expression, jDDNode);
        } else if (expression instanceof ExpressionFunc) {
            if (((ExpressionFunc)expression).getName().equals("multi")) {
                throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
            }
            stateValues = super.checkExpression(expression, jDDNode);
        } else {
            stateValues = super.checkExpression(expression, jDDNode);
        }
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionStrategy(ExpressionStrategy expressionStrategy, JDDNode jDDNode) throws PrismException {
        List<Expression> list;
        boolean bl = !expressionStrategy.isThereExists();
        Coalition coalition = expressionStrategy.getCoalition();
        if (coalition != null && !this.model.getModelType().multiplePlayers()) {
            if (coalition.isEmpty()) {
                bl = !bl;
            }
            coalition = null;
        }
        if ((list = expressionStrategy.getOperands()).size() == 1 && list.get(0) instanceof ExpressionProb) {
            return this.checkExpressionProb((ExpressionProb)list.get(0), bl, jDDNode, coalition);
        }
        if (list.size() == 1 && list.get(0) instanceof ExpressionReward) {
            return this.checkExpressionReward((ExpressionReward)list.get(0), bl, jDDNode, coalition);
        }
        throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb, JDDNode jDDNode) throws PrismException {
        Coalition coalition = new Coalition();
        coalition.setAllPlayers();
        return this.checkExpressionProb(expressionProb, true, jDDNode, coalition);
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb, boolean bl, JDDNode jDDNode, Coalition coalition) throws PrismException {
        OpRelOpBound opRelOpBound = expressionProb.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(this.model.getModelType(), bl, coalition);
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            JDD.Deref(jDDNode);
            return new StateValuesMTBDD(this.reach, this.model);
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            JDD.Deref(jDDNode);
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        }
        StateValues stateValues = this.checkProbPathFormula(expressionProb.getExpression(), minMax, jDDNode);
        if (this.verbose) {
            this.mainLog.print("\n" + (minMax.isMin() ? "Minimum" : "Maximum") + " probabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        JDDNode jDDNode2 = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode2 = JDD.And(jDDNode2, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD(jDDNode2, this.model);
    }

    protected StateValues checkExpressionReward(ExpressionReward expressionReward, JDDNode jDDNode) throws PrismException {
        Coalition coalition = new Coalition();
        coalition.setAllPlayers();
        return this.checkExpressionReward(expressionReward, true, jDDNode, coalition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected StateValues checkExpressionReward(ExpressionReward expressionReward, boolean bl, JDDNode jDDNode, Coalition coalition) throws PrismException {
        Object object;
        if (expressionReward.getRewardStructIndexDiv() != null) {
            throw new PrismException("Ratio rewards not supported with the selected engine and module type.");
        }
        OpRelOpBound opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(this.model.getModelType(), bl, coalition);
        Object object2 = expressionReward.getRewardStructIndex();
        JDDNode jDDNode2 = this.getStateRewardsByIndexObject(object2, this.model, this.constantValues);
        JDDNode jDDNode3 = this.getTransitionRewardsByIndexObject(object2, this.model, this.constantValues);
        StateValues stateValues = null;
        Expression expression = expressionReward.getExpression();
        JDD.Deref(jDDNode);
        if (expression.getType() instanceof TypePathDouble) {
            object = (ExpressionTemporal)expression;
            switch (((ExpressionTemporal)object).getOperator()) {
                case 11: {
                    if (!((ExpressionTemporal)object).hasBounds()) {
                        throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
                    }
                    int n = ((ExpressionTemporal)object).getUpperBound().evaluateInt(this.constantValues);
                    if (n < 0) {
                        throw new PrismException("Invalid bound " + n + " in cumulative rewards property");
                    }
                    stateValues = this.computeCumulativeRewards(jDDNode2, jDDNode3, n, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    break;
                }
                case 15: {
                    throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
                }
                case 12: {
                    int n = ((ExpressionTemporal)object).getUpperBound().evaluateInt(this.constantValues);
                    if (n < 0) {
                        throw new PrismException("Invalid bound " + n + " in instantaneous rewards property");
                    }
                    stateValues = this.computeInstantaneousRewards(jDDNode2, n, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
                }
            }
        } else {
            if (!(expression.getType() instanceof TypePathBool) && !(expression.getType() instanceof TypeBool)) throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
            if (Expression.isReach(expression)) {
                stateValues = this.computeReachRewardsInfinity((ExpressionTemporal)expression, jDDNode2, jDDNode3, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
            } else {
                if (!Expression.isCoSafeLTLSyntactic(expressionReward, true)) throw new PrismException("R operator contains a path formula that is not syntactically co-safe: " + expression);
                throw new PrismNotSupportedException("Cosafe rewards not currently supported by the MTBDD engine");
            }
        }
        if (this.verbose) {
            this.mainLog.print("\n" + (minMax.isMin() ? "Minimum" : "Maximum") + " rewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        object = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        object = JDD.And((JDDNode)object, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD((JDDNode)object, this.model);
    }

    protected StateValues checkProbPathFormula(Expression expression, MinMax minMax, JDDNode jDDNode) throws PrismException {
        JDD.Deref(jDDNode);
        if (Expression.containsRewardBoundedPathFormula(expression)) {
            throw new PrismException("Reward-bounded path formulas not supported");
        }
        boolean bl = expression.isSimplePathFormula();
        if (bl) {
            return this.checkProbPathFormulaSimple(expression, minMax);
        }
        throw new PrismNotSupportedException("Not currently supported by the MTBDD engine");
    }

    protected StateValues checkProbPathFormulaSimple(Expression expression, MinMax minMax) throws PrismException {
        boolean bl = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl = true;
            minMax = minMax.negate();
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(expressionTemporal, minMax);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(expressionTemporal, minMax) : this.checkProbUntil(expressionTemporal, minMax);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl) {
            stateValues.subtractFromOne();
        }
        return stateValues;
    }

    protected StateValues checkProbNext(ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        StateValues stateValues = null;
        JDDNode jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        stateValues = this.computeNextProbs(jDDNode, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
        return stateValues;
    }

    protected StateValues checkProbBoundedUntil(ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        if (n2 == null) {
            try {
                stateValues = this.computeUntilProbs(jDDNode2, jDDNode, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode);
                throw prismException;
            }
        }
        if (n2 == 0) {
            JDD.Ref(jDDNode);
            stateValues = new StateValuesMTBDD(jDDNode, this.model);
        } else {
            try {
                stateValues = this.computeBoundedUntilProbs(jDDNode2, jDDNode, n2, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode2);
                JDD.Deref(jDDNode);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkProbUntil(ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        JDDNode jDDNode;
        StateValues stateValues = null;
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        try {
            stateValues = this.computeUntilProbs(jDDNode2, jDDNode, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode);
            throw prismException;
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected JDDNode prob1(JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2) {
        int n = 0;
        boolean bl3 = false;
        this.mainLog.println("Starting Prob1...");
        long l = System.currentTimeMillis();
        JDDNode jDDNode3 = this.reach.copy();
        while (!bl3) {
            boolean bl4 = false;
            JDDNode jDDNode4 = JDD.Constant(0.0);
            while (!bl4) {
                ++n;
                JDDNode jDDNode5 = JDD.SwapVariables(jDDNode3.copy(), this.allDDRowVars, this.allDDColVars);
                jDDNode5 = JDD.ForAll(JDD.Implies(this.trans01.copy(), jDDNode5), this.allDDColVars);
                JDDNode jDDNode6 = JDD.SwapVariables(jDDNode4.copy(), this.allDDRowVars, this.allDDColVars);
                jDDNode6 = JDD.ThereExists(JDD.And(jDDNode6, this.trans01.copy()), this.allDDColVars);
                JDDNode jDDNode7 = JDD.And(jDDNode5, jDDNode6);
                jDDNode7 = this.computeExistsForall(jDDNode7, !bl, !bl2);
                jDDNode7 = JDD.And(jDDNode.copy(), jDDNode7);
                jDDNode7 = JDD.Or(jDDNode2.copy(), jDDNode7);
                bl4 = jDDNode7.equals(jDDNode4);
                JDD.Deref(jDDNode4);
                jDDNode4 = jDDNode7;
            }
            bl3 = jDDNode4.equals(jDDNode3);
            JDD.Deref(jDDNode3);
            jDDNode3 = jDDNode4;
        }
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Prob1 took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        return jDDNode3;
    }

    protected JDDNode prob0(JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2) {
        int n = 0;
        this.mainLog.println("Starting Prob0...");
        long l = System.currentTimeMillis();
        if (jDDNode2.equals(JDD.ZERO)) {
            return this.reach.copy();
        }
        boolean bl3 = false;
        JDDNode jDDNode3 = jDDNode2.copy();
        while (!bl3) {
            ++n;
            JDDNode jDDNode4 = JDD.SwapVariables(jDDNode3.copy(), this.allDDRowVars, this.allDDColVars);
            jDDNode4 = JDD.ThereExists(JDD.And(jDDNode4, this.trans01.copy()), this.allDDColVars);
            jDDNode4 = this.computeExistsForall(jDDNode4, !bl, !bl2);
            jDDNode4 = JDD.And(jDDNode.copy(), jDDNode4);
            jDDNode4 = JDD.Or(jDDNode2.copy(), jDDNode4);
            bl3 = jDDNode3.equals(jDDNode4);
            JDD.Deref(jDDNode3);
            jDDNode3 = jDDNode4;
        }
        JDD.Ref(this.reach);
        JDD.Ref(jDDNode2);
        jDDNode3 = JDD.And(JDD.Not(jDDNode3), JDD.Not(jDDNode2), this.reach);
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Prob0 took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        return jDDNode3;
    }

    protected StateValues computeNextProbs(JDDNode jDDNode, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        StateValuesMTBDD stateValuesMTBDD = null;
        this.mainLog.println("Computing next probabilities ...");
        long l = System.currentTimeMillis();
        this.setCoalition(coalition);
        jDDNode = JDD.SwapVariables(jDDNode, this.allDDRowVars, this.allDDColVars);
        JDDNode jDDNode2 = JDD.MatrixMultiply(this.trans.copy(), jDDNode, this.allDDColVars, 1);
        jDDNode2 = this.computeMaxMin(jDDNode2, bl, bl2);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Computation took " + (double)l / 1000.0 + " seconds.");
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode2, this.model);
        this.setCoalition(null);
        return stateValuesMTBDD;
    }

    protected StateValues computeBoundedUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        JDDNode jDDNode3;
        JDDNode jDDNode4;
        JDDNode jDDNode5;
        StateValuesMTBDD stateValuesMTBDD = null;
        this.setCoalition(coalition);
        if (jDDNode2.equals(JDD.ZERO)) {
            jDDNode5 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode4 = this.reach;
            jDDNode3 = JDD.Constant(0.0);
        } else if (jDDNode.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode2);
            jDDNode5 = jDDNode2;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode2);
            jDDNode4 = JDD.And(this.reach, JDD.Not(jDDNode2));
            jDDNode3 = JDD.Constant(0.0);
        } else {
            JDD.Ref(jDDNode2);
            jDDNode5 = jDDNode2;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode);
            JDD.Ref(jDDNode2);
            jDDNode4 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode, jDDNode2)));
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode4);
            jDDNode3 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode5, jDDNode4)));
        }
        this.mainLog.print("\ntarget=" + JDD.GetNumMintermsString(jDDNode2, this.allDDRowVars.n()));
        this.mainLog.print(", yes=" + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", no=" + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()));
        this.mainLog.print(", maybe=" + JDD.GetNumMintermsString(jDDNode3, this.allDDRowVars.n()) + "\n");
        if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode5);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode5, this.model);
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            JDDNode jDDNode6 = this.computeReachProbsValIter(jDDNode5, jDDNode3, n, bl, bl2);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode6, this.model);
        }
        JDD.Deref(jDDNode4);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode3);
        this.setCoalition(null);
        return stateValuesMTBDD;
    }

    protected StateValues computeUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        JDDNode jDDNode3;
        JDDNode jDDNode4;
        JDDNode jDDNode5;
        StateValuesMTBDD stateValuesMTBDD = null;
        this.setCoalition(coalition);
        if (jDDNode2.equals(JDD.ZERO)) {
            jDDNode5 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode4 = this.reach;
            jDDNode3 = JDD.Constant(0.0);
        } else if (jDDNode.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode2);
            jDDNode5 = jDDNode2;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode2);
            jDDNode4 = JDD.And(this.reach, JDD.Not(jDDNode2));
            jDDNode3 = JDD.Constant(0.0);
        } else {
            long l = System.currentTimeMillis();
            jDDNode4 = this.precomp && this.prob0 ? this.prob0(jDDNode.copy(), jDDNode2.copy(), bl, bl2) : JDD.And(this.reach.copy(), JDD.Not(JDD.Or(jDDNode.copy(), jDDNode2.copy())));
            jDDNode5 = this.precomp && this.prob1 ? this.prob1(jDDNode.copy(), jDDNode2.copy(), bl, bl2) : jDDNode2.copy();
            jDDNode3 = JDD.And(this.reach.copy(), JDD.Not(JDD.Or(jDDNode5.copy(), jDDNode4.copy())));
            l = System.currentTimeMillis() - l;
            this.mainLog.println("Precomputation took " + (double)l / 1000.0 + " seconds.");
        }
        this.mainLog.print("\ntarget=" + JDD.GetNumMintermsString(jDDNode2, this.allDDRowVars.n()));
        this.mainLog.print(", yes=" + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", no=" + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()));
        this.mainLog.print(", maybe=" + JDD.GetNumMintermsString(jDDNode3, this.allDDRowVars.n()) + "\n");
        if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode5);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode5, this.model);
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                JDDNode jDDNode6 = this.computeReachProbsValIter(jDDNode5, jDDNode3, -1, bl, bl2);
                stateValuesMTBDD = new StateValuesMTBDD(jDDNode6, this.model);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode4);
                JDD.Deref(jDDNode5);
                JDD.Deref(jDDNode3);
                this.setCoalition(null);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode4);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode3);
        this.setCoalition(null);
        return stateValuesMTBDD;
    }

    protected JDDNode computeReachProbsValIter(JDDNode jDDNode, JDDNode jDDNode2, int n, boolean bl, boolean bl2) throws PrismException {
        boolean bl3 = false;
        this.mainLog.println("Starting value iteration...");
        long l = System.currentTimeMillis();
        JDDNode jDDNode3 = JDD.Times(this.trans.copy(), jDDNode2.copy());
        JDDNode jDDNode4 = jDDNode.copy();
        int n2 = 0;
        while (!bl3) {
            JDDNode jDDNode5 = jDDNode4.copy();
            jDDNode4 = JDD.MatrixMultiply(jDDNode3.copy(), JDD.PermuteVariables(jDDNode4, this.allDDRowVars, this.allDDColVars), this.allDDColVars, 1);
            jDDNode4 = this.computeMaxMin(jDDNode4, bl, bl2);
            jDDNode4 = JDD.Max(jDDNode4, jDDNode.copy());
            bl3 = JDD.EqualSupNorm(jDDNode4, jDDNode5, this.termCritParam);
            JDD.Deref(jDDNode5);
            if (++n2 == this.maxIters) break;
            if (n2 != n) continue;
            bl3 = true;
        }
        if (bl3) {
            l = System.currentTimeMillis() - l;
            this.mainLog.println("Value iteration converged after " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3) {
            JDD.Deref(jDDNode3);
            JDD.Deref(jDDNode4);
            throw new PrismException("Could not converge after " + n2 + " iterations.\nConsider increasing the maximum number of iterations");
        }
        JDD.Deref(jDDNode3);
        return jDDNode4;
    }

    protected StateValues computeCumulativeRewards(JDDNode jDDNode, JDDNode jDDNode2, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        this.mainLog.println("\nComputing bounded cumulative reachability...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        this.setCoalition(coalition);
        JDDNode jDDNode3 = this.computeReachRewardsValIter(null, null, null, jDDNode, jDDNode2, n, bl, bl2);
        StateValuesMTBDD stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        this.setCoalition(null);
        return stateValuesMTBDD;
    }

    protected StateValues computeInstantaneousRewards(JDDNode jDDNode, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        StateValuesMTBDD stateValuesMTBDD = null;
        this.setCoalition(coalition);
        this.mainLog.println("\nComputing instantaneous rewards...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        long l = System.currentTimeMillis();
        JDDNode jDDNode2 = JDD.SwapVariables(jDDNode.copy(), this.allDDRowVars, this.allDDColVars);
        JDDNode jDDNode3 = JDD.ITE(this.nondetMask.copy(), JDD.PlusInfinity(), JDD.Constant(0.0));
        for (int i = 0; i < n; ++i) {
            jDDNode2 = JDD.MatrixMultiply(this.trans.copy(), jDDNode2, this.allDDColVars, 1);
            jDDNode2 = this.computeMaxMin(jDDNode2, jDDNode3, bl, bl2);
            jDDNode2 = JDD.SwapVariables(jDDNode2, this.allDDRowVars, this.allDDColVars);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Instantatenous rewards took " + (double)l / 1000.0 + " seconds.");
        jDDNode2 = JDD.SwapVariables(jDDNode2, this.allDDColVars, this.allDDRowVars);
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode2, this.model);
        this.setCoalition(null);
        JDD.Deref(jDDNode3);
        return stateValuesMTBDD;
    }

    protected StateValues computeReachRewardsInfinity(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        JDDNode jDDNode3;
        StateValuesMTBDD stateValuesMTBDD = null;
        this.mainLog.println("\nStarting expected reachability...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        JDDNode jDDNode4 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        this.setCoalition(coalition);
        long l = System.currentTimeMillis();
        JDD.Ref(jDDNode4);
        JDDNode jDDNode5 = this.prob1(JDD.Constant(1.0), jDDNode4, !bl, !bl2);
        JDD.Ref(this.reach);
        jDDNode5 = JDD.And(JDD.Not(jDDNode5), this.reach);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Precomputation took " + (double)l / 1000.0 + " seconds.");
        this.mainLog.println("target=" + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()) + ", inf=" + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        double d = Math.min(JDD.FindMinPositive(jDDNode), JDD.FindMinPositive(jDDNode2));
        double d2 = Math.max(JDD.FindMax(jDDNode), JDD.FindMax(jDDNode2));
        double d3 = Math.min(d, d2 * 0.01);
        JDD.Ref(jDDNode);
        JDDNode jDDNode6 = JDD.Equals(jDDNode, 0.0);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode7 = JDD.Equals(jDDNode2, 0.0);
        JDD.Ref(this.trans01);
        jDDNode7 = JDD.And(jDDNode7, this.trans01);
        jDDNode7 = JDD.Times(jDDNode7, JDD.Constant(d3));
        JDD.Ref(jDDNode2);
        jDDNode7 = JDD.Plus(jDDNode2, jDDNode7);
        jDDNode6 = JDD.Times(jDDNode6, JDD.Constant(d3));
        JDD.Ref(jDDNode);
        JDD.Ref(this.reach);
        JDD.Ref(jDDNode4);
        jDDNode6 = JDD.Times(JDD.Plus(jDDNode6, jDDNode), this.reach, JDD.Not(jDDNode4), JDD.Not(jDDNode5.copy()));
        JDDNode jDDNode8 = null;
        try {
            this.mainLog.println("Computing the upper bound where " + d3 + " is used instead of 0.0.");
            jDDNode8 = this.computeReachRewardsValIter(null, jDDNode5, jDDNode4, jDDNode6, jDDNode7, -1, bl, bl2);
            jDDNode3 = this.computeReachRewardsValIter(jDDNode8, jDDNode5, jDDNode4, jDDNode, jDDNode2, -1, bl, bl2);
        }
        catch (PrismException prismException) {
            this.setCoalition(null);
            if (jDDNode8 != null) {
                JDD.Deref(jDDNode8);
            }
            JDD.Deref(jDDNode5);
            JDD.Deref(jDDNode4);
            JDD.Deref(jDDNode6);
            JDD.Deref(jDDNode7);
            throw prismException;
        }
        this.setCoalition(null);
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode4);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode7);
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        return stateValuesMTBDD;
    }

    protected JDDNode computeReachRewardsValIter(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5, int n, boolean bl, boolean bl2) throws PrismException {
        JDDNode jDDNode6;
        boolean bl3 = false;
        this.mainLog.println("Starting value iteration...");
        long l = System.currentTimeMillis();
        JDDNode jDDNode7 = this.trans.copy();
        JDDNode jDDNode8 = jDDNode4.copy();
        if (jDDNode2 != null && jDDNode3 != null) {
            JDD.Ref(jDDNode2);
            JDD.Ref(jDDNode3);
            JDD.Ref(jDDNode2);
            JDD.Ref(jDDNode3);
            jDDNode7 = JDD.Times(jDDNode7, JDD.Not(jDDNode2), JDD.Not(jDDNode3));
            jDDNode8 = JDD.Times(jDDNode8, JDD.Not(jDDNode2), JDD.Not(jDDNode3));
        } else if (jDDNode2 != null) {
            JDD.Ref(jDDNode2);
            JDD.Ref(jDDNode2);
            jDDNode7 = JDD.Times(jDDNode7, JDD.Not(jDDNode2));
            jDDNode8 = JDD.Times(jDDNode8, JDD.Not(jDDNode2));
        } else if (jDDNode3 != null) {
            JDD.Ref(jDDNode3);
            JDD.Ref(jDDNode3);
            jDDNode7 = JDD.Times(jDDNode7, JDD.Not(jDDNode3));
            jDDNode8 = JDD.Times(jDDNode8, JDD.Not(jDDNode3));
        }
        if (jDDNode == null) {
            jDDNode6 = jDDNode2 == null ? JDD.Constant(0.0) : JDD.ITE(jDDNode2.copy(), JDD.PlusInfinity(), JDD.Constant(0.0));
        } else {
            JDD.Ref(jDDNode);
            jDDNode6 = JDD.SwapVariables(jDDNode, this.allDDRowVars, this.allDDColVars);
        }
        JDDNode jDDNode9 = JDD.Times(jDDNode7.copy(), jDDNode5.copy());
        jDDNode9 = JDD.SumAbstract(jDDNode9, this.allDDColVars);
        int n2 = 0;
        JDDNode jDDNode10 = JDD.ITE(this.nondetMask.copy(), JDD.PlusInfinity(), JDD.Constant(0.0));
        JDDNode jDDNode11 = null;
        if (n == 0) {
            bl3 = true;
        }
        while (!bl3) {
            jDDNode11 = n2 != 0 ? jDDNode6.copy() : JDD.PlusInfinity();
            jDDNode6 = JDD.MatrixMultiply(jDDNode7.copy(), jDDNode6, this.allDDColVars, 1);
            jDDNode6 = JDD.Apply(1, jDDNode6, jDDNode9.copy());
            jDDNode6 = this.computeMaxMin(jDDNode6, jDDNode10, bl, bl2);
            jDDNode6 = JDD.Plus(jDDNode6, jDDNode8.copy());
            if (jDDNode2 != null) {
                jDDNode6 = JDD.ITE(jDDNode2.copy(), JDD.PlusInfinity(), jDDNode6);
            }
            jDDNode6 = JDD.SwapVariables(jDDNode6, this.allDDRowVars, this.allDDColVars);
            bl3 = JDD.EqualSupNorm(jDDNode6, jDDNode11, this.termCritParam);
            JDD.Deref(jDDNode11);
            if (++n2 == this.maxIters) break;
            if (n2 != n) continue;
            bl3 = true;
        }
        if (bl3) {
            l = System.currentTimeMillis() - l;
            this.mainLog.println("Value iteration converged after " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3) {
            JDD.Deref(jDDNode7);
            JDD.Deref(jDDNode6);
            JDD.Deref(jDDNode10);
            JDD.Deref(jDDNode8);
            JDD.Deref(jDDNode9);
            throw new PrismException("Could not converge after " + n2 + " iterations.\nConsider increasing the maximum number of iterations");
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode10);
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode9);
        jDDNode6 = JDD.SwapVariables(jDDNode6, this.allDDColVars, this.allDDRowVars);
        if (jDDNode2 != null) {
            jDDNode6 = JDD.Max(jDDNode6, JDD.Times(jDDNode2.copy(), JDD.PlusInfinity()));
        }
        return jDDNode6;
    }

    public void setCoalition(Coalition coalition) throws PrismException {
        if (coalition == null) {
            if (this.ddc1 != null) {
                JDD.Deref(this.ddc1);
            }
            if (this.ddc2 != null) {
                JDD.Deref(this.ddc2);
            }
            return;
        }
        this.model.getPlayerInfo().setCoalition(coalition);
        this.ddc1 = JDD.Constant(0.0);
        this.ddc2 = JDD.Constant(0.0);
        for (int i = 0; i < this.model.getNumPlayers(); ++i) {
            if (this.model.getPlayerInfo().getPlayer(i) == 0) {
                this.ddc1 = JDD.Or(this.ddc1, this.model.getDdPlayerCube(i).copy());
            }
            if (this.model.getPlayerInfo().getPlayer(i) != 1) continue;
            this.ddc2 = JDD.Or(this.ddc2, this.model.getDdPlayerCube(i).copy());
        }
    }

    protected JDDNode computeMaxMin(JDDNode jDDNode, boolean bl, boolean bl2) {
        return this.computeMaxMin(jDDNode, null, bl, bl2);
    }

    protected JDDNode computeMaxMin(JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2) {
        JDDNode jDDNode3 = JDD.Times(jDDNode.copy(), this.ddc1.copy());
        if (bl) {
            jDDNode3 = JDD.Apply(6, jDDNode3, jDDNode2 == null ? this.nondetMask.copy() : jDDNode2.copy());
            jDDNode3 = JDD.MinAbstract(jDDNode3, this.allDDNondetVars);
        } else {
            jDDNode3 = JDD.MaxAbstract(jDDNode3, this.allDDNondetVars);
        }
        JDDNode jDDNode4 = JDD.Times(jDDNode.copy(), this.ddc2.copy());
        if (bl2) {
            jDDNode4 = JDD.Apply(6, jDDNode4, jDDNode2 == null ? this.nondetMask.copy() : jDDNode2.copy());
            jDDNode4 = JDD.MinAbstract(jDDNode4, this.allDDNondetVars);
        } else {
            jDDNode4 = JDD.MaxAbstract(jDDNode4, this.allDDNondetVars);
        }
        JDD.Deref(jDDNode);
        return JDD.Apply(1, jDDNode3, jDDNode4);
    }

    protected JDDNode computeExistsForall(JDDNode jDDNode, boolean bl, boolean bl2) {
        JDDNode jDDNode2 = JDD.And(jDDNode.copy(), this.ddc1.copy());
        jDDNode2 = bl ? JDD.ThereExists(jDDNode2, this.allDDNondetVars) : JDD.ForAll(JDD.Or(jDDNode2, this.nondetMask.copy()), this.allDDNondetVars);
        JDDNode jDDNode3 = JDD.And(jDDNode.copy(), this.ddc2.copy());
        jDDNode3 = bl2 ? JDD.ThereExists(jDDNode3, this.allDDNondetVars) : JDD.ForAll(JDD.Or(jDDNode3, this.nondetMask.copy()), this.allDDNondetVars);
        JDD.Deref(jDDNode);
        return JDD.Or(jDDNode2, jDDNode3);
    }
}

