/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.util.Collections;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.ExplicitFilesRewardGenerator;
import prism.PrismComponent;
import prism.PrismException;

public class ExplicitFilesRewardGenerator4MTBDD
extends ExplicitFilesRewardGenerator {
    protected JDDNode[] stateRewards = new JDDNode[this.stateRewardsFiles.size()];
    protected int numVars;
    protected int[][] statesArray = null;
    protected JDDVars[] varDDRowVars;
    protected JDDVars[] varDDColVars;
    protected boolean rewardGeneratorInitialized = false;

    public ExplicitFilesRewardGenerator4MTBDD(PrismComponent prismComponent, List<File> list, int n) throws PrismException {
        super(prismComponent, list, n);
    }

    public ExplicitFilesRewardGenerator4MTBDD(PrismComponent prismComponent, File file, int n) throws PrismException {
        this(prismComponent, Collections.singletonList(file), n);
    }

    public void initRewardGenerator(int[][] nArray, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, int n) {
        this.statesArray = nArray;
        this.varDDColVars = jDDVarsArray;
        this.varDDRowVars = jDDVarsArray2;
        this.numVars = n;
        this.rewardGeneratorInitialized = true;
    }

    @Override
    protected void storeReward(int n, int n2, double d) {
        JDDNode jDDNode;
        if (!this.rewardGeneratorInitialized) {
            throw new IllegalStateException("Reward generator is not initialized!");
        }
        if (this.statesArray == null) {
            jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[0], n2, 1.0);
        } else {
            jDDNode = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                jDDNode = JDD.Times(jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.statesArray[n2][i], 1.0));
            }
        }
        this.stateRewards[n] = JDD.Plus(this.stateRewards[n], JDD.Times(JDD.Constant(d), jDDNode));
    }

    public JDDNode[] getRewardStructs() throws PrismException {
        int n = this.stateRewardsFiles.size();
        for (int i = 0; i < n; ++i) {
            this.getStateReward(i);
        }
        return this.stateRewards;
    }

    public JDDNode getStateReward(int n) throws PrismException {
        if (this.stateRewards[n] == null) {
            this.stateRewards[n] = JDD.Constant(0.0);
            this.extractStateRewards(n);
        }
        return this.stateRewards[n];
    }
}

