/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.iterable.Reducible;
import csv.BasicReader;
import csv.CsvFormatException;
import csv.CsvReader;
import csv.ReplacingReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import parser.ParseException;
import parser.PrismParser;
import parser.State;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.RewardGenerator;

public abstract class ExplicitFilesRewardGenerator
extends PrismComponent
implements RewardGenerator<Double> {
    protected List<RewardFile> stateRewardsFiles = new ArrayList<RewardFile>();
    protected int numStates;
    protected List<State> statesList = null;
    protected static final Pattern COMMENT_PATTERN = Pattern.compile("#.*");
    protected static final Pattern REWARD_NAME_PATTERN = Pattern.compile("# Reward structure (\"([a-zA-Z0-9]*)\")$");

    public ExplicitFilesRewardGenerator(PrismComponent prismComponent, List<File> list, int n) throws PrismException {
        super(prismComponent);
        if (n < 1) {
            throw new PrismException("Expected number of states > 0");
        }
        this.numStates = n;
        this.stateRewardsFiles = new ArrayList<RewardFile>(list.size());
        for (File file : list) {
            this.stateRewardsFiles.add(new RewardFile(file));
        }
    }

    public void setStatesList(List<State> list) {
        this.statesList = list;
    }

    protected abstract void storeReward(int var1, int var2, double var3);

    protected void extractStateRewards(int n) throws PrismException {
        RewardFile rewardFile = this.stateRewardsFiles.get(n);
        rewardFile.extractRewards((n2, d) -> this.storeReward(n, (int)n2, (double)d), this.numStates);
    }

    @Override
    public List<String> getRewardStructNames() {
        return Reducible.extend(this.stateRewardsFiles).map(rewardFile -> rewardFile.getName().orElse("")).collect(new ArrayList(this.stateRewardsFiles.size()));
    }

    @Override
    public int getNumRewardStructs() {
        return this.stateRewardsFiles.size();
    }

    @Override
    public boolean rewardStructHasTransitionRewards(int n) {
        return false;
    }

    @Override
    public boolean isRewardLookupSupported(RewardGenerator.RewardLookup rewardLookup) {
        return rewardLookup == RewardGenerator.RewardLookup.BY_STATE_INDEX || rewardLookup == RewardGenerator.RewardLookup.BY_STATE && this.statesList != null;
    }

    @Override
    public Double getStateReward(int n, State state) throws PrismException {
        if (this.statesList == null) {
            throw new PrismException("Reward lookup by State not possible since state list is missing");
        }
        int n2 = this.statesList.indexOf(state);
        if (n2 == -1) {
            throw new PrismException("Unknown state " + state);
        }
        return (Double)this.getStateReward(n, n2);
    }

    public static class RewardFile {
        protected final File file;
        protected final Optional<String> name;

        public RewardFile(File file) throws PrismException {
            this.file = Objects.requireNonNull(file);
            this.name = this.extractRewardStructureName(file);
        }

        public Optional<String> getName() {
            return this.name;
        }

        protected void extractRewards(BiConsumer<Integer, Double> biConsumer, int n) throws PrismException {
            int n2 = 0;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
                n2 += this.skipCommentAndFirstLine(bufferedReader);
                ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
                CsvReader csvReader = new CsvReader(toChar, false, true, false, 32, 10);
                for (String[] stringArray : csvReader) {
                    ++n2;
                    if ("".equals(stringArray[0])) {
                        break;
                    }
                    int n3 = Objects.checkIndex(Integer.parseInt(stringArray[0]), n);
                    double d = Double.parseDouble(stringArray[1]);
                    biConsumer.accept(n3, d);
                }
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + this.file + "\"");
            }
            catch (CsvFormatException | IndexOutOfBoundsException | NumberFormatException exception) {
                throw new PrismException("Error detected " + exception.getMessage() + " at line " + n2 + " of state rewards file \"" + this.file + "\"");
            }
        }

        protected Optional<String> extractRewardStructureName(File file) throws PrismException {
            Optional<String> optional = Optional.empty();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                int n = 0;
                String string = bufferedReader.readLine();
                while (string != null) {
                    ++n;
                    if (!COMMENT_PATTERN.matcher(string).matches()) {
                        break;
                    }
                    Matcher matcher = REWARD_NAME_PATTERN.matcher(string);
                    if (matcher.matches()) {
                        if (optional.isPresent()) {
                            throw new PrismException("Found second reward structure names" + RewardFile.printFileLocation(file, n));
                        }
                        try {
                            optional = Optional.of(RewardFile.checkRewardName(matcher.group(2)));
                        }
                        catch (PrismException prismException) {
                            throw new PrismException(prismException.getMessage() + RewardFile.printFileLocation(file, n));
                        }
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + this.file + "\"");
            }
            return optional;
        }

        protected int skipCommentAndFirstLine(BufferedReader bufferedReader) throws IOException {
            String string;
            int n = 0;
            do {
                string = bufferedReader.readLine();
                ++n;
            } while (string != null && COMMENT_PATTERN.matcher(string).matches());
            return n;
        }

        protected static String printFileLocation(File file, int n) {
            return ": line " + n + " in " + file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static String checkRewardName(String string) throws PrismException {
            if (string == null) {
                throw new PrismException("Expected identifier but got: null");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            try {
                Prism.getPrismParser();
                try {
                    PrismParser.ReInit(byteArrayInputStream);
                    boolean bl = true;
                    try {
                        bl = string.equals(PrismParser.Identifier());
                    }
                    catch (ParseException parseException) {
                        bl = false;
                    }
                    if (!bl) {
                        throw new PrismLangException("Expected identifier but got: " + string);
                    }
                }
                finally {
                    Prism.releasePrismParser();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new PrismLangException("Concurrency error in parser");
            }
            return string;
        }
    }
}

