/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.RewardGenerator;

public class ExplicitFiles2ModelInfo
extends PrismComponent {
    private int numVars;
    private List<String> varNames;
    private List<Type> varTypes;
    private int[] varMins;
    private int[] varMaxs;
    private int[] varRanges;
    private List<String> labelNames;
    private int numStates = 0;

    public ExplicitFiles2ModelInfo(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public int getNumStates() {
        return this.numStates;
    }

    public ModelInfo buildModelInfo(File file, File file2, File file3, ModelType modelType) throws PrismException {
        ModelType modelType2;
        Object object;
        if (file != null) {
            this.extractVarInfoFromStatesFile(file);
        } else {
            this.extractVarInfoFromTransFile(file2);
        }
        if (file3 != null) {
            this.extractLabelNamesFromLabelsFile(file3);
        } else {
            this.labelNames = new ArrayList<String>();
        }
        if (modelType == null) {
            object = this.autodetectModelType(file2);
            if (object != null) {
                this.mainLog.println("Auto-detected model type: " + object);
            } else {
                object = ModelType.MDP;
                this.mainLog.println("Assuming default model type: " + object);
            }
            modelType2 = object;
        } else {
            this.mainLog.println("Using specified model type: " + modelType);
            modelType2 = modelType;
        }
        object = new ModelInfo(){

            @Override
            public ModelType getModelType() {
                return modelType2;
            }

            @Override
            public List<String> getVarNames() {
                return ExplicitFiles2ModelInfo.this.varNames;
            }

            @Override
            public List<Type> getVarTypes() {
                return ExplicitFiles2ModelInfo.this.varTypes;
            }

            @Override
            public DeclarationType getVarDeclarationType(int n) throws PrismException {
                if (ExplicitFiles2ModelInfo.this.varTypes.get(n) instanceof TypeInt) {
                    return new DeclarationInt(Expression.Int(ExplicitFiles2ModelInfo.this.varMins[n]), Expression.Int(ExplicitFiles2ModelInfo.this.varMaxs[n]));
                }
                return new DeclarationBool();
            }

            @Override
            public List<String> getLabelNames() {
                return ExplicitFiles2ModelInfo.this.labelNames;
            }
        };
        return object;
    }

    public RewardGenerator buildRewardInfo(File file) throws PrismException {
        if (file != null) {
            return new RewardGenerator(){

                @Override
                public List<String> getRewardStructNames() {
                    return Collections.singletonList("");
                }
            };
        }
        return new RewardGenerator(){};
    }

    private void extractVarInfoFromStatesFile(File file) throws PrismException {
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            int n2;
            String string = bufferedReader.readLine();
            n = 1;
            if (string == null) {
                throw new PrismException("empty states file");
            }
            if ((string = string.trim()).charAt(0) != '(' || string.charAt(string.length() - 1) != ')') {
                throw new PrismException("badly formatted state");
            }
            string = string.substring(1, string.length() - 1);
            this.varNames = new ArrayList<String>(Arrays.asList(string.split(",")));
            this.numVars = this.varNames.size();
            this.varMins = new int[this.numVars];
            this.varMaxs = new int[this.numVars];
            this.varRanges = new int[this.numVars];
            this.varTypes = new ArrayList<Type>();
            string = bufferedReader.readLine();
            ++n;
            this.numStates = 0;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    ++this.numStates;
                    String[] stringArray = (string = string.substring(string.indexOf(40) + 1, string.indexOf(41))).split(",");
                    if (stringArray.length != this.numVars) {
                        throw new PrismException("wrong number of variables");
                    }
                    for (n2 = 0; n2 < this.numVars; ++n2) {
                        if (this.numStates == 1) {
                            if (stringArray[n2].equals("true") || stringArray[n2].equals("false")) {
                                this.varTypes.add(TypeBool.getInstance());
                            } else {
                                this.varTypes.add(TypeInt.getInstance());
                            }
                        }
                        if (!(this.varTypes.get(n2) instanceof TypeInt)) continue;
                        int n3 = Integer.parseInt(stringArray[n2]);
                        if (this.numStates == 1) {
                            this.varMins[n2] = this.varMaxs[n2] = n3;
                            continue;
                        }
                        if (n3 < this.varMins[n2]) {
                            this.varMins[n2] = n3;
                        }
                        if (n3 <= this.varMaxs[n2]) continue;
                        this.varMaxs[n2] = n3;
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            for (n2 = 0; n2 < this.numVars; ++n2) {
                if (!(this.varTypes.get(n2) instanceof TypeInt)) continue;
                this.varRanges[n2] = this.varMaxs[n2] - this.varMins[n2];
                if (this.varRanges[n2] != 0) continue;
                int n4 = n2;
                this.varMaxs[n4] = this.varMaxs[n4] + 1;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of states file \"" + file + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected (" + prismException.getMessage() + ") at line " + n + " of states file \"" + file + "\"");
        }
    }

    private void extractVarInfoFromTransFile(File file) throws PrismException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            if (string == null) {
                throw new PrismException("empty transitions file");
            }
            String[] stringArray = (string = string.trim()).split(" ");
            if (stringArray.length < 2) {
                throw new PrismException("");
            }
            this.numStates = Integer.parseInt(stringArray[0]);
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line 1 of transition matrix file \"" + file + "\"");
        }
        this.numVars = 1;
        this.varNames = Collections.singletonList("x");
        this.varTypes = Collections.singletonList(TypeInt.getInstance());
        this.varMins = new int[]{0};
        this.varMaxs = new int[]{this.numStates - 1};
        this.varRanges = new int[]{this.numStates - 1};
    }

    private void extractLabelNamesFromLabelsFile(File file) throws PrismException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            Pattern pattern = Pattern.compile("(\\d+)=\"([^\"]+)\"\\s*");
            Matcher matcher = pattern.matcher(string);
            this.labelNames = new ArrayList<String>();
            while (matcher.find()) {
                String string2 = matcher.group(2);
                if (string2.equals("init") || string2.equals("deadlock")) continue;
                if (!ExpressionIdent.isLegalIdentifierName(string2)) {
                    throw new PrismException("Illegal label name \"" + string2 + "\"");
                }
                if (this.labelNames.contains(string2)) {
                    throw new PrismException("Duplicate label \"" + string2 + "\"");
                }
                this.labelNames.add(string2);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelType autodetectModelType(File file) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string;
            boolean bl;
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                ModelType modelType = null;
                return modelType;
            }
            String[] stringArray = string2.trim().split(" ");
            if (stringArray.length == 3) {
                bl = true;
            } else {
                if (stringArray.length != 2) {
                    ModelType modelType = null;
                    return modelType;
                }
                bl = false;
            }
            int n = 0;
            int n2 = 5;
            string2 = bufferedReader.readLine();
            while (string2 != null && n < n2) {
                ++n;
                stringArray = string2.trim().split(" ");
                if (bl && stringArray.length >= 4) {
                    string = stringArray[3];
                } else if (!bl && stringArray.length >= 3) {
                    string = stringArray[2];
                } else {
                    ModelType modelType = null;
                    return modelType;
                }
                if (string.matches("\\[.+,.+\\]")) {
                    ModelType modelType = bl ? ModelType.IMDP : ModelType.IDTMC;
                    return modelType;
                }
                double d = Double.parseDouble(string);
                if (d > 1.0) {
                    ModelType modelType = ModelType.CTMC;
                    return modelType;
                }
                if (n == n2) {
                    ModelType modelType = bl ? ModelType.MDP : ModelType.DTMC;
                    return modelType;
                }
                string2 = bufferedReader.readLine();
            }
            string = null;
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

