/*
 * Decompiled with CFR 0.152.
 */
package prism;

import prism.Accuracy;
import prism.Pair;
import prism.PrismException;

public class AccuracyFactory {
    public static Accuracy valueIteration(double d, double d2, boolean bl) {
        if (d2 == 0.0) {
            return new Accuracy(Accuracy.AccuracyLevel.EXACT_FLOATING_POINT);
        }
        double d3 = 10.0 * d2;
        return new Accuracy(Accuracy.AccuracyLevel.ESTIMATED_BOUNDED, d3, bl);
    }

    public static Accuracy guaranteedNumericalIterative(double d, boolean bl) {
        if (d == 0.0) {
            return new Accuracy(Accuracy.AccuracyLevel.EXACT_FLOATING_POINT);
        }
        return new Accuracy(Accuracy.AccuracyLevel.BOUNDED, d, bl);
    }

    public static Accuracy boundedNumericalIterations() {
        return new Accuracy(Accuracy.AccuracyLevel.EXACT_FLOATING_POINT);
    }

    public static Accuracy doublesFromQualitative() {
        return new Accuracy(Accuracy.AccuracyLevel.EXACT_FLOATING_POINT);
    }

    public static Pair<Double, Accuracy> valueAndAccuracyFromInterval(double d, Accuracy accuracy, double d2, Accuracy accuracy2) throws PrismException {
        double d3;
        double d4;
        double d5;
        if (accuracy != null && accuracy.getLevel() == Accuracy.AccuracyLevel.PROBABLY_BOUNDED) {
            throw new PrismException("Cannot create interval accuracy from probabilistic bounds");
        }
        if (accuracy != null && accuracy.getLevel() == Accuracy.AccuracyLevel.PROBABLY_BOUNDED) {
            throw new PrismException("Cannot create interval accuracy from probabilistic bounds");
        }
        double d6 = accuracy == null ? d : accuracy.getResultLowerBound(d);
        double d7 = d5 = accuracy2 == null ? d2 : accuracy2.getResultLowerBound(d2);
        if (Double.isFinite(d6) && Double.isFinite(d5)) {
            d4 = (d6 + d5) / 2.0;
            d3 = (d5 - d6) / 2.0;
        } else if (Double.isInfinite(d6) && Double.isInfinite(d5)) {
            d4 = d6 == d5 ? d6 : 0.0;
            d3 = d6 == d5 ? 0.0 : Double.POSITIVE_INFINITY;
        } else {
            d3 = Double.NaN;
            d4 = Double.NaN;
        }
        Accuracy.AccuracyLevel accuracyLevel = accuracy == null || accuracy.getLevel() == Accuracy.AccuracyLevel.ESTIMATED_BOUNDED ? Accuracy.AccuracyLevel.ESTIMATED_BOUNDED : (accuracy2 == null || accuracy2.getLevel() == Accuracy.AccuracyLevel.ESTIMATED_BOUNDED ? Accuracy.AccuracyLevel.ESTIMATED_BOUNDED : (d3 == 0.0 ? Accuracy.AccuracyLevel.EXACT_FLOATING_POINT : Accuracy.AccuracyLevel.BOUNDED));
        Accuracy accuracy3 = new Accuracy(accuracyLevel, d3, true);
        return new Pair<Double, Accuracy>(d4, accuracy3);
    }
}

