/*
 * Decompiled with CFR 0.152.
 */
package prism;

public class Accuracy {
    private AccuracyLevel level;
    private double errorBound;
    public static final double DEFAULT_ERROR_BOUND = 1.0E-5;
    public static final double FLOATING_POINT_ERROR = 1.0E-12;
    private AccuracyType type;
    private double probability = 1.0;

    public Accuracy(AccuracyLevel accuracyLevel) {
        this(accuracyLevel, 1.0E-5);
    }

    public Accuracy(AccuracyLevel accuracyLevel, double d) {
        this(accuracyLevel, d, AccuracyType.ABSOLUTE);
    }

    public Accuracy(AccuracyLevel accuracyLevel, double d, boolean bl) {
        this(accuracyLevel, d, bl ? AccuracyType.ABSOLUTE : AccuracyType.RELATIVE);
    }

    public Accuracy(AccuracyLevel accuracyLevel, double d, AccuracyType accuracyType) {
        this.setLevel(accuracyLevel);
        switch (accuracyLevel) {
            case EXACT: 
            case EXACT_FLOATING_POINT: {
                this.setErrorBound(0.0);
                this.setType(AccuracyType.ABSOLUTE);
                break;
            }
            case BOUNDED: 
            case ESTIMATED_BOUNDED: 
            case PROBABLY_BOUNDED: {
                this.setErrorBound(d);
                this.setType(accuracyType);
            }
        }
    }

    public void setLevel(AccuracyLevel accuracyLevel) {
        this.level = accuracyLevel;
    }

    public void setErrorBound(double d) {
        this.errorBound = d;
    }

    public void setProbability(double d) {
        this.probability = d;
    }

    public void setType(AccuracyType accuracyType) {
        this.type = accuracyType;
    }

    public AccuracyLevel getLevel() {
        return this.level;
    }

    public double getErrorBound() {
        switch (this.level) {
            case EXACT: 
            case EXACT_FLOATING_POINT: {
                return 0.0;
            }
        }
        return this.errorBound;
    }

    public AccuracyType getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.type == AccuracyType.RELATIVE ? "relative" : "absolute";
    }

    public double getAbsoluteErrorBound(double d) {
        if (this.type == AccuracyType.ABSOLUTE) {
            return this.errorBound;
        }
        return Double.isFinite(d) ? this.errorBound * Math.abs(d) : 0.0;
    }

    public double getRelativeErrorBound(double d) {
        if (this.type == AccuracyType.RELATIVE) {
            return this.errorBound;
        }
        return this.errorBound == 0.0 || Double.isInfinite(d) ? 0.0 : this.errorBound / Math.abs(d);
    }

    public double getResultLowerBound(double d) {
        return d - this.getAbsoluteErrorBound(d);
    }

    public double getResultUpperBound(double d) {
        return d + this.getAbsoluteErrorBound(d);
    }

    public double getResultLowerBound(double d, boolean bl) {
        double d2 = bl ? 1.0E-12 : 0.0;
        return d - this.getAbsoluteErrorBound(d) - d2;
    }

    public double getResultUpperBound(double d, boolean bl) {
        double d2 = bl ? 1.0E-12 : 0.0;
        return d + this.getAbsoluteErrorBound(d) + d2;
    }

    public double getProbability() {
        return this.level == AccuracyLevel.PROBABLY_BOUNDED ? this.probability : 1.0;
    }

    public String toString(Object object) {
        switch (this.getLevel()) {
            case EXACT: {
                return "exact";
            }
            case EXACT_FLOATING_POINT: {
                return "exact floating point";
            }
        }
        if (object instanceof Double) {
            double d = (Double)object;
            String string = "+/- " + this.getAbsoluteErrorBound(d);
            if (this.level == AccuracyLevel.ESTIMATED_BOUNDED) {
                string = string + " estimated";
            } else if (this.level == AccuracyLevel.PROBABLY_BOUNDED) {
                string = string + " with probability " + this.getProbability();
            }
            return string + "; rel err " + this.getRelativeErrorBound(d);
        }
        if (this.level == AccuracyLevel.PROBABLY_BOUNDED) {
            return "with probability " + this.getProbability();
        }
        return "";
    }

    public String toString() {
        switch (this.getLevel()) {
            case EXACT: {
                return "exact";
            }
            case EXACT_FLOATING_POINT: {
                return "exact floating point";
            }
        }
        String string = "+/- " + this.getErrorBound() + " " + this.getTypeString();
        if (this.level == AccuracyLevel.ESTIMATED_BOUNDED) {
            string = string + " estimated";
        } else if (this.level == AccuracyLevel.PROBABLY_BOUNDED) {
            string = string + " with probability " + this.getProbability();
        }
        return string;
    }

    public static enum AccuracyLevel {
        EXACT,
        EXACT_FLOATING_POINT,
        BOUNDED,
        ESTIMATED_BOUNDED,
        PROBABLY_BOUNDED;

    }

    public static enum AccuracyType {
        ABSOLUTE,
        RELATIVE;

    }
}

