/*
 * Decompiled with CFR 0.152.
 */
package parser.type;

import common.Interval;
import java.util.HashMap;
import java.util.Map;
import parser.EvaluateContext;
import parser.type.Type;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismLangException;

public class TypeInterval
extends Type {
    private static Map<Type, TypeInterval> singletons = new HashMap<Type, TypeInterval>();
    private Type subType;

    private TypeInterval(Type type) {
        this.subType = type;
    }

    public static TypeInterval getInstance(Type type) {
        return singletons.computeIfAbsent(type, TypeInterval::new);
    }

    public Type getSubType() {
        return this.subType;
    }

    public void setSubType(Type type) {
        this.subType = type;
    }

    @Override
    public String getTypeString() {
        return "interval of " + this.subType.getTypeString();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return new Interval<Object>(this.subType.defaultValue(), this.subType.defaultValue());
    }

    @Override
    public boolean canAssign(Type type) {
        return type instanceof TypeDouble || type instanceof TypeInt || type instanceof TypeInterval && this.getSubType().canAssign(((TypeInterval)type).getSubType());
    }

    @Override
    public Interval<?> castValueTo(Object object) throws PrismLangException {
        if (object instanceof Double || object instanceof Integer) {
            Object object2 = this.getSubType().castValueTo(object);
            return new Interval<Object>(object2, object2);
        }
        if (object instanceof Interval) {
            Object object3 = this.getSubType().castValueTo(((Interval)object).getLower());
            Object object4 = this.getSubType().castValueTo(((Interval)object).getUpper());
            return new Interval<Object>(object3, object4);
        }
        throw new PrismLangException("Can't convert " + object.getClass() + " to type " + this.getTypeString());
    }

    @Override
    public Interval<?> castValueTo(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        if (object instanceof Double || object instanceof Integer) {
            Object object2 = this.getSubType().castValueTo(object, evalMode);
            return new Interval<Object>(object2, object2);
        }
        if (object instanceof Interval) {
            Object object3 = this.getSubType().castValueTo(((Interval)object).getLower(), evalMode);
            Object object4 = this.getSubType().castValueTo(((Interval)object).getUpper(), evalMode);
            return new Interval<Object>(object3, object4);
        }
        throw new PrismLangException("Can't convert " + object.getClass() + " to type " + this.getTypeString());
    }

    public boolean equals(Object object) {
        if (object instanceof TypeInterval) {
            TypeInterval typeInterval = (TypeInterval)object;
            return this.subType.equals(typeInterval.getSubType());
        }
        return false;
    }
}

