/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class RewardStructItem
extends ASTElement {
    private ArrayList<String> synchs;
    private ArrayList<Integer> synchIndices;
    private Expression states;
    private Expression reward;

    public RewardStructItem(String string, Expression expression, Expression expression2) {
        this.setSynch(string);
        this.states = expression;
        this.reward = expression2;
    }

    public RewardStructItem(List<String> list, Expression expression, Expression expression2) {
        this.setSynchs(list);
        this.states = expression;
        this.reward = expression2;
    }

    public void setSynch(String string) {
        if (string == null) {
            this.synchs = null;
            this.synchIndices = null;
        }
        this.synchs = new ArrayList(1);
        this.synchs.add(string);
        this.synchIndices = new ArrayList(1);
        this.synchIndices.add(-1);
    }

    public void setSynchs(List<String> list) {
        if (list == null) {
            this.synchs = null;
            this.synchIndices = null;
        } else if (list.isEmpty()) {
            this.synchs = new ArrayList(1);
            this.synchs.add("");
            this.synchIndices = new ArrayList(1);
            this.synchIndices.add(-1);
        } else {
            this.synchs = new ArrayList<String>(list);
            this.synchIndices = new ArrayList<Integer>(Collections.nCopies(list.size(), -1));
        }
    }

    public void setSynchIndices(List<String> list) throws PrismLangException {
        if (this.synchs == null) {
            return;
        }
        int n = this.synchs.size();
        for (int i = 0; i < n; ++i) {
            String string = this.synchs.get(i);
            if (string.equals("")) {
                this.synchIndices.set(i, 0);
                continue;
            }
            int n2 = list.indexOf(string);
            if (n2 != -1) {
                this.synchIndices.set(i, n2 + 1);
                continue;
            }
            throw new PrismLangException("Unknown action name " + string + " in reward structure item", this);
        }
    }

    public void setStates(Expression expression) {
        this.states = expression;
    }

    public void setReward(Expression expression) {
        this.reward = expression;
    }

    public String getSynch() {
        return this.synchs == null ? null : this.synchs.get(0);
    }

    public List<String> getSynchs() {
        return this.synchs;
    }

    public int getSynchIndex() {
        return this.synchs == null ? -1 : this.synchIndices.get(0);
    }

    public List<Integer> getSynchIndices() {
        return this.synchIndices;
    }

    public Expression getStates() {
        return this.states;
    }

    public Expression getReward() {
        return this.reward;
    }

    public boolean isTransitionReward() {
        return this.synchs != null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        if (this.synchs != null) {
            object = (String)object + "[" + String.join((CharSequence)",", this.synchs) + "] ";
        }
        object = (String)object + this.states + " : " + this.reward + ";";
        return object;
    }

    @Override
    public RewardStructItem deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.states = deepCopy.copy(this.states);
        this.reward = deepCopy.copy(this.reward);
        return this;
    }

    @Override
    public RewardStructItem clone() {
        RewardStructItem rewardStructItem = (RewardStructItem)super.clone();
        if (this.synchs != null) {
            rewardStructItem.synchs = (ArrayList)this.synchs.clone();
        }
        if (this.synchIndices != null) {
            rewardStructItem.synchIndices = (ArrayList)this.synchIndices.clone();
        }
        return (RewardStructItem)super.clone();
    }
}

