/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import param.BigRational;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.DefinedConstant;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;
import prism.Result;
import prism.ResultTesting;

public class Property
extends ASTElement {
    private Expression expr;
    private String name;
    private String comment;

    public Property(Expression expression) {
        this(expression, null, null);
    }

    public Property(Expression expression, String string) {
        this(expression, string, null);
    }

    public Property(Expression expression, String string, String string2) {
        this.expr = expression;
        this.name = string;
        this.comment = string2;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean checkAgainstExpectedResult(Object object) throws PrismException {
        return this.checkAgainstExpectedResult(object, null);
    }

    public boolean checkAgainstExpectedResult(Object object, Values values) throws PrismException {
        return this.checkAgainstExpectedResult(object, values, null);
    }

    public boolean checkAgainstExpectedResult(Object object, Values values, List<String> list) throws PrismException {
        Result result = object instanceof Result ? (Result)object : new Result(object);
        String string = this.getExpectedResultString(values);
        return ResultTesting.checkAgainstExpectedResultString(string, values, list, this.expr.getType(), result);
    }

    private String getExpectedResultString(Values values) throws PrismException {
        String string = null;
        if (this.comment != null) {
            Pattern pattern = Pattern.compile("RESULT[ \t]*(\\(([^\\)]+)\\))?[ \t]*:[ \t]*([^ \t\n\r]+)");
            Matcher matcher = pattern.matcher(this.comment);
            while (matcher.find()) {
                String[] stringArray;
                String string2 = matcher.group(2) == null ? "" : matcher.group(2);
                boolean bl = true;
                for (String string3 : stringArray = string2.split(",")) {
                    boolean bl2 = true;
                    if ((string3 = string3.trim()).length() == 0) continue;
                    String[] stringArray2 = string3.split("=");
                    if (stringArray2.length != 2) {
                        throw new PrismException("Badly formed RESULT specification \"" + matcher.group() + "\"");
                    }
                    String string4 = stringArray2[0].trim();
                    String string5 = stringArray2[1].trim();
                    Object object = values.getIndexOf(string4) == -1 ? null : values.getValueOf(string4);
                    bl2 = object == null ? false : (object instanceof Double ? PrismUtils.doublesAreEqual((Double)object, DefinedConstant.parseDouble(string5)) : (object instanceof BigRational ? BigRational.from(string5).equals(object) : object.toString().equals(string5)));
                    bl &= bl2;
                }
                if (!bl) continue;
                string = matcher.group(3);
                break;
            }
        }
        if (string == null) {
            throw new PrismException("Did not find a RESULT specification (for " + values + ") to test against");
        }
        return string;
    }

    private String getExpectedResultString(String string) throws PrismException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        if (this.comment != null) {
            Pattern pattern = Pattern.compile("RESULT[ \t]*(\\(([^\\)]+)\\))?[ \t]*:[ \t]*([^ \t\n\r]+)");
            Matcher matcher = pattern.matcher(this.comment);
            while (matcher.find()) {
                String string3;
                String string4 = matcher.group(2) == null ? "" : matcher.group(2);
                if (hashMap.put(string4, string3 = matcher.group(3)) == null) continue;
                if (string4.length() == 0) {
                    throw new PrismException("Multiple RESULT specificiations for test");
                }
                throw new PrismException("Multiple RESULT (" + string4 + ") specificiations for test");
            }
        }
        if (hashMap.size() == 0) {
            throw new PrismException("Did not find any RESULT specifications to test against");
        }
        string2 = (String)hashMap.get(string);
        if (string2 == null) {
            throw new PrismException("Did not find a RESULT specification (for " + string + ") to test against");
        }
        return string2;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        if (this.name != null) {
            object = (String)object + "\"" + this.name + "\": ";
        }
        object = (String)object + this.expr;
        return object;
    }

    @Override
    public Property deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.expr = deepCopy.copy(this.expr);
        return this;
    }

    @Override
    public Property clone() {
        return (Property)super.clone();
    }
}

