/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.ast.ASTElement;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class Player
extends ASTElement {
    private String name;
    private ArrayList<String> modules;
    private ArrayList<String> actions;

    public Player(String string) {
        this.name = string;
        this.modules = new ArrayList();
        this.actions = new ArrayList();
    }

    public void addModule(String string) {
        this.modules.add(string);
    }

    public void addAction(String string) {
        this.actions.add(string);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public List<String> getActions() {
        return this.actions;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Player deepCopy(DeepCopy deepCopy) throws PrismLangException {
        return this;
    }

    @Override
    public Player clone() {
        Player player = (Player)super.clone();
        player.modules = (ArrayList)this.modules.clone();
        player.actions = (ArrayList)this.actions.clone();
        return player;
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + "player " + this.name + "\n\t";
        boolean bl = true;
        for (String string : this.modules) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + string;
        }
        boolean bl2 = true;
        for (String string : this.actions) {
            if (bl2) {
                bl2 = false;
                if (!bl) {
                    object = (String)object + ",\n\t";
                }
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + "[" + string + "]";
        }
        object = (String)object + "\nendplayer";
        return object;
    }

    @Override
    public Player deepCopy() {
        Player player = new Player(this.name);
        for (String string : this.modules) {
            player.addModule(string);
        }
        for (String string : this.actions) {
            player.addAction(string);
        }
        player.setPosition(this);
        return player;
    }
}

