/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import parser.EvaluateContext;
import parser.IdentUsage;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionVar;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.Observable;
import parser.ast.ObservableVars;
import parser.ast.Player;
import parser.ast.Property;
import parser.ast.RenamedModule;
import parser.ast.RewardStruct;
import parser.ast.SystemDefn;
import parser.ast.Updates;
import parser.type.Type;
import parser.type.TypeInterval;
import parser.visitor.ASTTraverse;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import parser.visitor.ModulesFileSemanticCheck;
import parser.visitor.ModulesFileSemanticCheckAfterConstants;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;
import prism.RewardGenerator;

public class ModulesFile
extends ASTElement
implements ModelInfo,
RewardGenerator {
    private ModelType modelTypeInFile = null;
    private ModelType modelType = null;
    private FormulaList formulaList = new FormulaList();
    private LabelList labelList = new LabelList();
    private ConstantList constantList = new ConstantList();
    private ArrayList<Declaration> globals = new ArrayList();
    private ArrayList<Object> modules = new ArrayList();
    private ArrayList<SystemDefn> systemDefns = new ArrayList();
    private ArrayList<String> systemDefnNames = new ArrayList();
    private ArrayList<RewardStruct> rewardStructs = new ArrayList();
    private ArrayList<String> rewardStructNames = new ArrayList();
    private Expression initStates = null;
    private ArrayList<ObservableVars> observableVarLists = new ArrayList();
    private ArrayList<Observable> observableDefns = new ArrayList();
    private ArrayList<Player> players = new ArrayList();
    private ArrayList<String> playerNames = new ArrayList();
    private IdentUsage identUsage = new IdentUsage();
    private IdentUsage quotedIdentUsage = new IdentUsage(true);
    private String[] moduleNames;
    private ArrayList<String> synchs;
    private ArrayList<Object> actions;
    private ArrayList<Declaration> varDecls = new ArrayList();
    private ArrayList<String> varNames = new ArrayList();
    private ArrayList<Type> varTypes = new ArrayList();
    private ArrayList<Integer> varModules = new ArrayList();
    private ArrayList<Observable> observables = new ArrayList();
    private ArrayList<String> observableNames = new ArrayList();
    private ArrayList<Type> observableTypes = new ArrayList();
    private ArrayList<String> observableVars = new ArrayList();
    private EvaluateContext ecUndefined = null;
    private Values constantValues = null;
    private EvaluateContext ec = EvaluateContext.create();

    public void setFormulaList(FormulaList formulaList) {
        this.formulaList = formulaList;
    }

    public void setLabelList(LabelList labelList) {
        this.labelList = labelList;
    }

    public void setConstantList(ConstantList constantList) {
        this.constantList = constantList;
    }

    public void setModelTypeInFile(ModelType modelType) {
        this.modelType = this.modelTypeInFile = modelType;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void addGlobal(Declaration declaration) {
        this.globals.add(declaration);
    }

    public void setGlobal(int n, Declaration declaration) {
        this.globals.set(n, declaration);
    }

    public void addModule(Module module) {
        this.modules.add(module);
        module.setParent(this);
    }

    public void setModule(int n, Module module) {
        this.modules.set(n, module);
        module.setParent(this);
    }

    public void addRenamedModule(RenamedModule renamedModule) {
        this.modules.add(renamedModule);
    }

    public void setSystemDefn(SystemDefn systemDefn) {
        this.clearSystemDefns();
        this.addSystemDefn(systemDefn);
    }

    public void clearSystemDefns() {
        this.systemDefns.clear();
        this.systemDefnNames.clear();
    }

    public void addSystemDefn(SystemDefn systemDefn) {
        this.addSystemDefn(systemDefn, null);
    }

    public void addSystemDefn(SystemDefn systemDefn, String string) {
        this.systemDefns.add(systemDefn);
        this.systemDefnNames.add(string);
    }

    public void setSystemDefn(int n, SystemDefn systemDefn, String string) {
        this.systemDefns.set(n, systemDefn);
        this.systemDefnNames.set(n, string);
    }

    public void clearRewardStructs() {
        this.rewardStructs.clear();
        this.rewardStructNames.clear();
    }

    public void addRewardStruct(RewardStruct rewardStruct) {
        this.rewardStructs.add(rewardStruct);
        this.rewardStructNames.add(rewardStruct.getName());
    }

    public void setRewardStruct(int n, RewardStruct rewardStruct) {
        this.rewardStructs.set(n, rewardStruct);
        this.rewardStructNames.set(n, rewardStruct.getName());
    }

    public void setRewardStruct(RewardStruct rewardStruct) {
        this.clearRewardStructs();
        this.addRewardStruct(rewardStruct);
    }

    public void setInitialStates(Expression expression) {
        this.initStates = expression;
    }

    public void addObservableVarList(ObservableVars observableVars) {
        this.observableVarLists.add(observableVars);
    }

    public void setObservableVarList(int n, ObservableVars observableVars) {
        this.observableVarLists.set(n, observableVars);
    }

    public void addObservableDefinition(Observable observable) {
        this.observableDefns.add(observable);
    }

    public void setObservableDefinition(int n, Observable observable) {
        this.observableDefns.set(n, observable);
    }

    public void addPlayer(Player player) {
        this.players.add(player);
        this.playerNames.add(player.getName());
    }

    public void addPlayer(int n, Player player) {
        this.players.add(n, player);
        this.playerNames.add(n, player.getName());
    }

    public void setPlayer(int n, Player player) {
        this.players.set(n, player);
        this.playerNames.set(n, player.getName());
    }

    public FormulaList getFormulaList() {
        return this.formulaList;
    }

    @Override
    public int getNumLabels() {
        return this.labelList.size();
    }

    @Override
    public List<String> getLabelNames() {
        return this.labelList.getLabelNames();
    }

    @Override
    public String getLabelName(int n) throws PrismException {
        return this.labelList.getLabelName(n);
    }

    @Override
    public int getLabelIndex(String string) {
        return this.labelList.getLabelIndex(string);
    }

    public LabelList getLabelList() {
        return this.labelList;
    }

    public ConstantList getConstantList() {
        return this.constantList;
    }

    public ModelType getModelTypeInFile() {
        return this.modelTypeInFile;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    public String getTypeString() {
        return "" + this.modelType;
    }

    public String getTypeFullString() {
        return this.modelType.fullName();
    }

    public int getNumGlobals() {
        return this.globals.size();
    }

    public Declaration getGlobal(int n) {
        return this.globals.get(n);
    }

    public int getNumModules() {
        return this.modules.size();
    }

    public Module getModule(int n) {
        Object object = this.modules.get(n);
        return object instanceof Module ? (Module)object : null;
    }

    public int getModuleIndex(String string) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module module = this.getModule(i);
            if (module == null || !string.equals(module.getName())) continue;
            return i;
        }
        return -1;
    }

    public SystemDefn getSystemDefn() {
        int n = this.systemDefns.size();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (this.systemDefnNames.get(i) != null) continue;
            return this.systemDefns.get(i);
        }
        return this.systemDefns.get(0);
    }

    public String getSystemDefnName() {
        int n = this.systemDefns.size();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (this.systemDefnNames.get(i) != null) continue;
            return null;
        }
        return this.systemDefnNames.get(0);
    }

    public int getNumSystemDefns() {
        return this.systemDefns.size();
    }

    public SystemDefn getSystemDefn(int n) {
        return this.systemDefns.get(n);
    }

    public String getSystemDefnName(int n) {
        return this.systemDefnNames.get(n);
    }

    public int getSystemDefnIndex(String string) {
        int n = this.systemDefns.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.systemDefnNames.get(i);
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            return i;
        }
        return -1;
    }

    public SystemDefn getSystemDefnByName(String string) {
        int n = this.getSystemDefnIndex(string);
        return n == -1 ? null : this.getSystemDefn(n);
    }

    @Override
    public int getNumRewardStructs() {
        return this.rewardStructs.size();
    }

    @Override
    public List<String> getRewardStructNames() {
        return this.rewardStructNames;
    }

    @Override
    public int getRewardStructIndex(String string) {
        int n = this.rewardStructs.size();
        for (int i = 0; i < n; ++i) {
            if (!this.rewardStructs.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean rewardStructHasStateRewards(int n) {
        RewardStruct rewardStruct = this.getRewardStruct(n);
        return rewardStruct.getNumStateItems() > 0;
    }

    @Override
    public boolean rewardStructHasTransitionRewards(int n) {
        RewardStruct rewardStruct = this.getRewardStruct(n);
        return rewardStruct.getNumTransItems() > 0;
    }

    @Override
    public RewardStruct getRewardStruct(int n) {
        return n < this.rewardStructs.size() ? this.rewardStructs.get(n) : null;
    }

    public List<RewardStruct> getRewardStructs() {
        return this.rewardStructs;
    }

    public RewardStruct getRewardStructByName(String string) {
        int n = this.getRewardStructIndex(string);
        return n == -1 ? null : this.getRewardStruct(n);
    }

    public RewardStruct getRewardStruct() {
        return this.getRewardStruct(0);
    }

    @Override
    public boolean isRewardLookupSupported(RewardGenerator.RewardLookup rewardLookup) {
        return rewardLookup == RewardGenerator.RewardLookup.BY_REWARD_STRUCT;
    }

    public Expression getInitialStates() {
        return this.initStates;
    }

    public boolean hasObservables() {
        return this.observableVarLists.size() > 0 || this.observableDefns.size() > 0;
    }

    public int getNumObservableVarLists() {
        return this.observableVarLists.size();
    }

    public ObservableVars getObservableVarList(int n) {
        return this.observableVarLists.get(n);
    }

    public int getNumObservableDefinitions() {
        return this.observableDefns.size();
    }

    public Observable getObservableDefinition(int n) {
        return this.observableDefns.get(n);
    }

    public Player getPlayer(int n) {
        return this.players.get(n);
    }

    @Override
    public List<String> getPlayerNames() {
        return this.playerNames;
    }

    public int getPlayerForAction(String string) {
        if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        int n = 0;
        for (Player player : this.players) {
            for (String string2 : player.getActions()) {
                if (!string2.equals(string)) continue;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getPlayerForModule(String string) {
        int n = 0;
        for (Player player : this.players) {
            for (String string2 : player.getModules()) {
                if (!string2.equals(string)) continue;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getPlayerForModuleOrAction(String string) {
        return string.charAt(0) == '[' ? this.getPlayerForAction(string) : this.getPlayerForModule(string);
    }

    public Property getPropertyByName(String string) {
        return null;
    }

    private void checkAndAddIdentifier(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        this.identUsage.checkAndAddIdentifier(string, aSTElement, string2, "the model");
    }

    @Override
    public boolean isIdentUsed(String string) {
        return this.identUsage.isIdentUsed(string);
    }

    @Override
    public void checkIdent(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        this.identUsage.checkIdent(string, aSTElement, string2);
    }

    private void checkAndAddQuotedIdentifier(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        this.quotedIdentUsage.checkAndAddIdentifier(string, aSTElement, string2, "the model");
    }

    @Override
    public boolean isQuotedIdentUsed(String string) {
        return this.quotedIdentUsage.isIdentUsed(string);
    }

    @Override
    public void checkQuotedIdent(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        this.quotedIdentUsage.checkIdent(string, aSTElement, string2);
    }

    @Override
    public String getModuleName(int n) {
        return this.moduleNames[n];
    }

    public String[] getModuleNames() {
        return this.moduleNames;
    }

    public List<String> getSynchs() {
        return this.synchs;
    }

    public String getSynch(int n) {
        return this.synchs.get(n);
    }

    public boolean isSynch(String string) {
        if (this.synchs == null) {
            return false;
        }
        return this.synchs.contains(string);
    }

    @Override
    public int getNumVars() {
        return this.varNames.size();
    }

    @Override
    public int getVarIndex(String string) {
        return this.varNames.indexOf(string);
    }

    public Declaration getVarDeclaration(int n) {
        return this.varDecls.get(n);
    }

    @Override
    public String getVarName(int n) {
        return this.varNames.get(n);
    }

    @Override
    public Type getVarType(int n) {
        return this.varTypes.get(n);
    }

    @Override
    public List<String> getVarNames() {
        return this.varNames;
    }

    @Override
    public List<Type> getVarTypes() {
        return this.varTypes;
    }

    @Override
    public DeclarationType getVarDeclarationType(int n) {
        return this.varDecls.get(n).getDeclType();
    }

    @Override
    public int getVarModuleIndex(int n) {
        return this.varModules.get(n);
    }

    public boolean isGlobalVariable(String string) {
        int n = this.getNumGlobals();
        for (int i = 0; i < n; ++i) {
            if (!this.getGlobal(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUnboundedVariables() {
        int n = this.getNumVars();
        for (int i = 0; i < n; ++i) {
            DeclarationType declarationType = this.getVarDeclaration(i).getDeclType();
            if (!(declarationType instanceof DeclarationClock) && !(declarationType instanceof DeclarationIntUnbounded)) continue;
            return true;
        }
        return false;
    }

    public boolean containsClockVariables() {
        int n = this.getNumVars();
        for (int i = 0; i < n; ++i) {
            if (!(this.getVarDeclaration(i).getDeclType() instanceof DeclarationClock)) continue;
            return true;
        }
        return false;
    }

    public Observable getObservable(int n) {
        return this.observables.get(n);
    }

    @Override
    public boolean isVarObservable(int n) {
        return this.observableVars.contains(this.getVarName(n));
    }

    public boolean isVarObservable(String string) {
        return this.observableVars.contains(string);
    }

    @Override
    public List<String> getObservableNames() {
        return this.observableNames;
    }

    @Override
    public List<Type> getObservableTypes() {
        return this.observableTypes;
    }

    public void tidyUp() throws PrismLangException {
        this.identUsage.clear();
        this.quotedIdentUsage.clear();
        this.varDecls.clear();
        this.varNames.clear();
        this.varTypes.clear();
        this.varModules.clear();
        this.checkFormulaIdents();
        this.findAllFormulas(this.formulaList);
        this.formulaList.findCycles();
        this.expandFormulas(this.formulaList);
        this.sortRenamings();
        this.checkLabelIdents();
        this.checkModuleNames();
        this.checkConstantIdents();
        this.findAllConstants(this.constantList);
        this.constantList.findCycles();
        this.checkVarNames();
        this.findAllVars(this.varNames, this.varTypes);
        this.findAllPropRefs(this, null);
        this.checkRewardStructNames();
        this.checkSystemDefns();
        this.getSynchNames();
        this.findAllActions(this.synchs);
        this.finaliseModelType();
        this.checkPlayerDefns();
        this.doSemanticChecks();
        this.typeCheck();
        this.checkObservables();
        if (this.getUndefinedConstants().isEmpty()) {
            this.setSomeUndefinedConstants(EvaluateContext.create());
        }
    }

    private void checkFormulaIdents() throws PrismLangException {
        int n = this.formulaList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.formulaList.getFormulaName(i);
            this.checkAndAddIdentifier(string, this.formulaList.getFormulaNameIdent(i), "formula");
        }
    }

    private void sortRenamings() throws PrismLangException {
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = this.modules.get(i);
            if (object2 instanceof Module) continue;
            RenamedModule renamedModule = (RenamedModule)object2;
            int n2 = this.getModuleIndex(renamedModule.getBaseModule());
            if (n2 == -1) {
                object = "No such module " + renamedModule.getBaseModule();
                object = (String)object + " in renamed module \"" + renamedModule.getName() + "\"";
                throw new PrismLangException((String)object, renamedModule.getBaseModuleASTElement());
            }
            int n3 = renamedModule.getNumRenames();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int j = 0; j < n3; ++j) {
                object = renamedModule.getOldName(j);
                if (!hashSet.add(object)) {
                    throw new PrismLangException("Identifier \"" + (String)object + "\" is renamed more than once in module \"" + renamedModule.getName() + "\"", renamedModule.getOldNameASTElement(j));
                }
                if (this.formulaList.getFormulaIndex((String)object) == -1) continue;
                throw new PrismLangException("Formula \"" + (String)object + "\" cannot be renamed since formulas are expanded before module renaming", renamedModule.getOldNameASTElement(j));
            }
            Module module = (Module)this.getModule(n2).deepCopy().rename(renamedModule);
            module.setNameASTElement(renamedModule.getNameASTElement());
            module.setBaseModule(renamedModule.getBaseModule());
            this.setModule(i, module);
        }
    }

    private void checkLabelIdents() throws PrismLangException {
        int n = this.labelList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.labelList.getLabelName(i);
            this.checkAndAddQuotedIdentifier(string, this.labelList.getLabelNameIdent(i), "label");
        }
    }

    private void checkModuleNames() throws PrismLangException {
        int n = this.modules.size();
        if (n == 0) {
            throw new PrismLangException("There must be at least one module");
        }
        this.moduleNames = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = this.getModule(i).getName();
            for (int j = 0; j < i; ++j) {
                if (!string.equals(this.moduleNames[j])) continue;
                throw new PrismLangException("Duplicated module name \"" + string + "\"", this.getModule(i).getNameASTElement());
            }
            this.moduleNames[i] = string;
        }
    }

    private void getSynchNames() throws PrismLangException {
        this.synchs = new ArrayList();
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            List<String> list = this.getModule(i).getAllSynchs();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                String string = list.get(j);
                if (this.synchs.contains(string)) continue;
                this.synchs.add(string);
            }
        }
        SystemDefn systemDefn = this.getSystemDefn();
        if (systemDefn != null) {
            systemDefn.getSynchs(this.synchs, this);
        }
        this.actions = new ArrayList<String>(this.synchs);
    }

    @Override
    public List<Object> getActions() {
        return this.actions;
    }

    @Override
    public String getActionStringDescription() {
        return "Module/[action]";
    }

    private void checkConstantIdents() throws PrismLangException {
        int n = this.constantList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.constantList.getConstantName(i);
            this.checkAndAddIdentifier(string, this.constantList.getConstantNameIdent(i), "constant");
        }
    }

    private void checkVarNames() throws PrismLangException {
        int n;
        int n2 = this.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            String string = this.getGlobal(n).getName();
            this.checkAndAddIdentifier(string, this.getGlobal(n), "variable");
            this.varDecls.add(this.getGlobal(n));
            this.varNames.add(string);
            this.varTypes.add(this.getGlobal(n).getType());
            this.varModules.add(-1);
        }
        n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            Module module = this.getModule(i);
            int n3 = module.getNumDeclarations();
            for (int j = 0; j < n3; ++j) {
                String string = module.getDeclaration(j).getName();
                this.checkAndAddIdentifier(string, module.getDeclaration(j), "variable");
                this.varDecls.add(module.getDeclaration(j));
                this.varNames.add(string);
                this.varTypes.add(module.getDeclaration(j).getType());
                this.varModules.add(i);
            }
        }
        if (this.varNames.size() == 0) {
            throw new PrismLangException("There must be at least one variable");
        }
    }

    private void checkRewardStructNames() throws PrismLangException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.getNumRewardStructs();
        for (int i = 0; i < n; ++i) {
            String string = this.getRewardStruct(i).getName();
            if (string == null || "".equals(string) || hashSet.add(string)) continue;
            throw new PrismLangException("Duplicated reward structure name \"" + string + "\"", this.getRewardStruct(i));
        }
    }

    private void checkPlayerDefns() throws PrismLangException {
        if (this.modelType.multiplePlayers()) {
            if (this.players.isEmpty()) {
                throw new PrismLangException(this.modelType + " model has no player definitions");
            }
        } else if (!this.players.isEmpty()) {
            throw new PrismLangException("Player definitions not allowed for " + this.modelType + " models", this.players.get(0));
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Player cloneable2 : this.players) {
            String string = cloneable2.getName();
            if ("".equals(string) || hashSet.add(string)) continue;
            throw new PrismLangException("Duplicate player name \"" + (String)string + "\"", cloneable2);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Player player : this.players) {
            for (String string : player.getModules()) {
                if (this.getModuleIndex(string) == -1) {
                    throw new PrismLangException("Module name \"" + string + "\" in player definition \"" + player.getName() + "\" does not exist", player);
                }
                if (arrayList.contains(string)) {
                    throw new PrismLangException("Module name \"" + string + "\" appears in multiple player definitions", player);
                }
                arrayList.add(string);
            }
            for (String string : player.getActions()) {
                if (!this.isSynch(string)) {
                    throw new PrismLangException("Action name \"" + string + "\" in player definition \"" + player.getName() + "\" does not exist", player);
                }
                if (arrayList2.contains(string)) {
                    throw new PrismLangException("Action name \"" + string + "\" appears in multiple player definitions", player);
                }
                arrayList2.add(string);
            }
        }
    }

    private void checkSystemDefns() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.systemDefns.size();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n2; ++i) {
            String string = this.systemDefnNames.get(i);
            if (string == null) {
                ++n3;
            } else if (!hashSet.add(string)) {
                throw new PrismLangException("Duplicated system...endystem name \"" + string + "\"", this.getSystemDefn(i));
            }
            if (n3 <= 1) continue;
            throw new PrismLangException("There can be at most one un-named system...endsystem construct", this.getSystemDefn(i));
        }
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.systemDefns.get(n);
            ArrayList<String> arrayList = new ArrayList<String>();
            ((SystemDefn)object).getReferences(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                int n4 = this.getSystemDefnIndex((String)arrayList.get(i));
                if (n4 == -1) continue;
                blArray[n][n4] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency from references in system...endsystem definition \"" + this.getSystemDefnName(n) + "\"";
            throw new PrismLangException((String)object, this.getSystemDefn(n));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkObservables() throws PrismLangException {
        if (this.getModelType().partiallyObservable() && !this.hasObservables()) {
            throw new PrismLangException(this.getModelType() + "s must specify observables");
        }
        if (this.hasObservables() && !this.getModelType().partiallyObservable()) {
            throw new PrismLangException(this.getModelType() + "s cannot specify observables");
        }
        for (ObservableVars aSTElement : this.observableVarLists) {
            int n = aSTElement.getNumVars();
            for (int i = 0; i < n; ++i) {
                if (!(aSTElement.getVar(i) instanceof ExpressionVar)) {
                    throw new PrismLangException("Observable variables list can only contain variables", aSTElement.getVar(i));
                }
                ExpressionVar expressionVar = (ExpressionVar)aSTElement.getVar(i);
                String string = expressionVar.getName();
                this.addObservable(string, aSTElement.getVar(i), expressionVar, expressionVar);
            }
        }
        for (Observable observable : this.observableDefns) {
            String string = observable.getName();
            ExpressionVar expressionVar = null;
            if (observable.getDefinition() instanceof ExpressionVar) {
                expressionVar = (ExpressionVar)observable.getDefinition();
            }
            this.addObservable(string, observable, observable.getDefinition(), expressionVar);
        }
        if (this.getModelType().partiallyObservable() && this.getModelType().realTime()) {
            void var2_7;
            int n = this.getNumVars();
            boolean bl = false;
            while (var2_7 < n) {
                if (this.getVarDeclaration((int)var2_7).getDeclType() instanceof DeclarationClock && !this.observableVars.contains(this.getVarName((int)var2_7))) {
                    throw new PrismLangException("All clocks in " + this.modelType + "s must be observable", this.getVarDeclaration((int)var2_7));
                }
                ++var2_7;
            }
        }
    }

    private void addObservable(String string, ASTElement aSTElement, Expression expression, ExpressionVar expressionVar) throws PrismLangException {
        this.checkAndAddQuotedIdentifier(string, aSTElement, "observable");
        this.observables.add(new Observable(string, expression));
        this.observableNames.add(string);
        this.observableTypes.add(expression.getType());
        if (expressionVar != null) {
            this.observableVars.add(expressionVar.getName());
        }
    }

    private void doSemanticChecks() throws PrismLangException {
        ModulesFileSemanticCheck modulesFileSemanticCheck = new ModulesFileSemanticCheck(this);
        this.accept(modulesFileSemanticCheck);
    }

    public void doSemanticChecksAfterConstants() throws PrismLangException {
        ModulesFileSemanticCheckAfterConstants modulesFileSemanticCheckAfterConstants = new ModulesFileSemanticCheckAfterConstants(this);
        this.accept(modulesFileSemanticCheckAfterConstants);
    }

    public List<String> getUndefinedConstants() {
        return this.constantList.getUndefinedConstants();
    }

    @Override
    public void setSomeUndefinedConstants(EvaluateContext evaluateContext) throws PrismLangException {
        this.ecUndefined = evaluateContext == null ? EvaluateContext.create() : EvaluateContext.create(evaluateContext);
        this.constantValues = this.constantList.evaluateSomeConstants(evaluateContext);
        this.ec = EvaluateContext.create(this.constantValues, evaluateContext.getEvaluationMode());
        this.doSemanticChecksAfterConstants();
    }

    @Deprecated
    public void setUndefinedConstants(Values values) throws PrismException {
        this.setSomeUndefinedConstants(values);
    }

    public boolean isDefinedConstant(String string) {
        return this.constantList.isDefinedConstant(string);
    }

    public EvaluateContext getUndefinedEvaluateContext() {
        return this.ecUndefined;
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public EvaluateContext getEvaluateContext() {
        return this.ec;
    }

    public State getDefaultInitialState() throws PrismLangException {
        ASTElement aSTElement;
        int n;
        if (this.initStates != null) {
            return null;
        }
        State state = new State(this.getNumVars());
        int n2 = 0;
        int n3 = this.getNumGlobals();
        for (n = 0; n < n3; ++n) {
            aSTElement = this.getGlobal(n);
            Object object = aSTElement.getType().castValueTo(((Declaration)aSTElement).getStartOrDefault().evaluate(this.ec));
            state.setValue(n2++, object);
        }
        n3 = this.getNumModules();
        for (n = 0; n < n3; ++n) {
            aSTElement = this.getModule(n);
            int n4 = ((Module)aSTElement).getNumDeclarations();
            for (int i = 0; i < n4; ++i) {
                Declaration declaration = ((Module)aSTElement).getDeclaration(i);
                Object object = declaration.getType().castValueTo(declaration.getStartOrDefault().evaluate(this.ec));
                state.setValue(n2++, object);
            }
        }
        return state;
    }

    @Deprecated
    public Values getInitialValues() throws PrismLangException {
        State state = this.getDefaultInitialState();
        return state == null ? null : new Values(state, this);
    }

    public void recomputeVariableinformation() throws PrismLangException {
        this.varDecls = new ArrayList();
        this.varNames = new ArrayList();
        this.varTypes = new ArrayList();
        this.varModules = new ArrayList();
        for (Declaration declaration : this.globals) {
            this.varDecls.add(declaration);
            this.varNames.add(declaration.getName());
            this.varTypes.add(declaration.getType());
            this.varModules.add(-1);
        }
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            for (Declaration declaration : this.getModule(i).getDeclarations()) {
                this.varDecls.add(declaration);
                this.varNames.add(declaration.getName());
                this.varTypes.add(declaration.getType());
                this.varModules.add(i);
            }
        }
        this.findAllVars(this.varNames, this.varTypes);
    }

    @Override
    public VarList createVarList() throws PrismException {
        return new VarList(this);
    }

    private void finaliseModelType() throws PrismLangException {
        boolean bl;
        this.modelType = this.modelTypeInFile == null ? ((bl = this.isNonProbabilistic()) ? ModelType.LTS : ModelType.MDP) : this.modelTypeInFile;
        bl = this.containsClockVariables();
        boolean bl2 = this.hasObservables();
        boolean bl3 = this.probabilitiesContainIntervals();
        if (bl) {
            if (this.modelType == ModelType.MDP || this.modelType == ModelType.LTS) {
                this.modelType = ModelType.PTA;
            } else if (this.modelType == ModelType.SMG || this.modelType == ModelType.STPG) {
                this.modelType = ModelType.TPTG;
            }
        }
        if (bl2) {
            if (this.modelType == ModelType.MDP || this.modelType == ModelType.LTS) {
                this.modelType = ModelType.POMDP;
            } else if (this.modelType == ModelType.PTA) {
                this.modelType = ModelType.POPTA;
            }
        }
        if (bl3) {
            if (this.modelType == ModelType.DTMC) {
                this.modelType = ModelType.IDTMC;
            } else if (this.modelType == ModelType.MDP) {
                this.modelType = ModelType.IMDP;
            } else {
                throw new PrismLangException("Intervals only allowed in DTMCs and MDPs currently");
            }
        }
    }

    public boolean probabilitiesContainIntervals() {
        return this.findIntervalInProbabilities() != null;
    }

    public ASTElement findIntervalInProbabilities() {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(Updates updates) throws PrismLangException {
                    int n = updates.getNumUpdates();
                    for (int i = 0; i < n; ++i) {
                        if (updates.getProbability(i) == null || !(updates.getProbability(i).getType() instanceof TypeInterval)) continue;
                        throw new PrismLangException("Found one", updates);
                    }
                }
            };
            this.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return prismLangException.getASTElement();
        }
        return null;
    }

    private boolean isNonProbabilistic() {
        try {
            this.accept(new ASTTraverse(){

                @Override
                public Object visit(Updates updates) throws PrismLangException {
                    int n = updates.getNumUpdates();
                    for (int i = 0; i < n; ++i) {
                        if (updates.getProbability(i) == null) continue;
                        throw new PrismLangException("Found one");
                    }
                    this.visitPost(updates);
                    return null;
                }
            });
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        int n;
        Object object = "";
        if (this.modelTypeInFile != null) {
            object = (String)object + this.modelTypeInFile.toString().toLowerCase() + "\n\n";
        }
        for (Player aSTElement : this.players) {
            object = (String)object + aSTElement + "\n\n";
        }
        String string = "" + this.formulaList;
        if (string.length() > 0) {
            string = string + "\n";
        }
        object = (String)object + string;
        string = "" + this.labelList;
        if (string.length() > 0) {
            string = string + "\n";
        }
        object = (String)object + string;
        string = "" + this.constantList;
        if (string.length() > 0) {
            string = string + "\n";
        }
        object = (String)object + string;
        for (ObservableVars observableVars : this.observableVarLists) {
            object = (String)object + observableVars + "\n\n";
        }
        for (Observable observable : this.observableDefns) {
            object = (String)object + observable + "\n";
        }
        if (!this.observableDefns.isEmpty()) {
            object = (String)object + "\n";
        }
        int n2 = this.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            object = (String)object + "global " + this.getGlobal(n) + ";\n";
        }
        if (n2 > 0) {
            object = (String)object + "\n";
        }
        for (n = 0; n < this.modules.size() - 1; ++n) {
            object = (String)object + this.modules.get(n) + "\n\n";
        }
        object = (String)object + this.modules.get(this.modules.size() - 1) + "\n";
        for (n = 0; n < this.systemDefns.size(); ++n) {
            object = (String)object + "\nsystem ";
            if (this.systemDefnNames.get(n) != null) {
                object = (String)object + "\"" + this.systemDefnNames.get(n) + "\" ";
            }
            object = (String)object + this.systemDefns.get(n) + " endsystem\n";
        }
        n2 = this.getNumRewardStructs();
        for (n = 0; n < n2; ++n) {
            object = (String)object + "\n" + this.getRewardStruct(n);
        }
        if (this.initStates != null) {
            object = (String)object + "\ninit " + this.initStates + " endinit\n";
        }
        return object;
    }

    @Override
    public ModulesFile deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.labelList = deepCopy.copy(this.labelList);
        this.formulaList = deepCopy.copy(this.formulaList);
        this.constantList = deepCopy.copy(this.constantList);
        this.initStates = deepCopy.copy(this.initStates);
        this.identUsage = this.identUsage.deepCopy();
        this.quotedIdentUsage = this.quotedIdentUsage.deepCopy();
        deepCopy.copyAll(this.globals);
        deepCopy.copyAll(this.varDecls);
        deepCopy.copyAll(this.systemDefns);
        deepCopy.copyAll(this.observables);
        deepCopy.copyAll(this.rewardStructs);
        deepCopy.copyAll(this.observableDefns);
        deepCopy.copyAll(this.observableVarLists);
        deepCopy.copyAll(this.players);
        int n = this.getNumModules();
        for (int i = 0; i < n; ++i) {
            Module module = Objects.requireNonNull(this.getModule(i));
            this.setModule(i, deepCopy.copy(module));
        }
        return this;
    }

    @Override
    public ModulesFile clone() {
        ModulesFile modulesFile = (ModulesFile)super.clone();
        modulesFile.globals = (ArrayList)this.globals.clone();
        modulesFile.modules = (ArrayList)this.modules.clone();
        modulesFile.systemDefns = (ArrayList)this.systemDefns.clone();
        modulesFile.systemDefnNames = (ArrayList)this.systemDefnNames.clone();
        modulesFile.rewardStructs = (ArrayList)this.rewardStructs.clone();
        modulesFile.rewardStructNames = (ArrayList)this.rewardStructNames.clone();
        modulesFile.observableVarLists = (ArrayList)this.observableVarLists.clone();
        modulesFile.observableDefns = (ArrayList)this.observableDefns.clone();
        modulesFile.varDecls = (ArrayList)this.varDecls.clone();
        modulesFile.varNames = (ArrayList)this.varNames.clone();
        modulesFile.varTypes = (ArrayList)this.varTypes.clone();
        modulesFile.varModules = (ArrayList)this.varModules.clone();
        modulesFile.observables = (ArrayList)this.observables.clone();
        modulesFile.observableNames = (ArrayList)this.observableNames.clone();
        modulesFile.observableTypes = (ArrayList)this.observableTypes.clone();
        modulesFile.observableVars = (ArrayList)this.observableVars.clone();
        modulesFile.players = (ArrayList)this.players.clone();
        modulesFile.playerNames = (ArrayList)this.playerNames.clone();
        if (this.constantValues != null) {
            modulesFile.constantValues = this.constantValues.clone();
        }
        if (this.moduleNames != null) {
            modulesFile.moduleNames = (String[])this.moduleNames.clone();
        }
        if (this.synchs != null) {
            modulesFile.synchs = (ArrayList)this.synchs.clone();
        }
        if (this.actions != null) {
            modulesFile.actions = (ArrayList)this.actions.clone();
        }
        if (this.ecUndefined != null) {
            this.ecUndefined = EvaluateContext.create(this.ecUndefined);
        }
        if (this.ec != null) {
            this.ec = EvaluateContext.create(this.ec);
        }
        return modulesFile;
    }
}

