/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class LabelList
extends ASTElement {
    private ArrayList<String> names = new ArrayList();
    private ArrayList<Expression> labels = new ArrayList();
    private ArrayList<ExpressionIdent> nameIdents = new ArrayList();

    public void addLabel(ExpressionIdent expressionIdent, Expression expression) {
        this.names.add(expressionIdent.getName());
        this.labels.add(expression);
        this.nameIdents.add(expressionIdent);
    }

    public void setLabelName(int n, ExpressionIdent expressionIdent) {
        this.names.set(n, expressionIdent.getName());
        this.nameIdents.set(n, expressionIdent);
    }

    public void setLabel(int n, Expression expression) {
        this.labels.set(n, expression);
    }

    public int size() {
        return this.labels.size();
    }

    public String getLabelName(int n) {
        return this.names.get(n);
    }

    public List<String> getLabelNames() {
        return this.names;
    }

    public Expression getLabel(int n) {
        return this.labels.get(n);
    }

    public ExpressionIdent getLabelNameIdent(int n) {
        return this.nameIdents.get(n);
    }

    public int getLabelIndex(String string) {
        return this.names.indexOf(string);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            object = (String)object + "label \"" + this.getLabelName(i);
            object = (String)object + "\" = " + this.getLabel(i) + ";\n";
        }
        return object;
    }

    @Override
    public LabelList deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.labels);
        deepCopy.copyAll(this.nameIdents);
        return this;
    }

    @Override
    public LabelList clone() {
        LabelList labelList = (LabelList)super.clone();
        labelList.names = (ArrayList)this.names.clone();
        labelList.labels = (ArrayList)this.labels.clone();
        labelList.nameIdents = (ArrayList)this.nameIdents.clone();
        return labelList;
    }
}

