/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import parser.EvaluateContext;
import parser.ast.ASTElement;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionStrategy
extends Expression {
    protected boolean thereExists = false;
    protected List<Coalition> coalitions = Collections.singletonList(new Coalition());
    protected ArrayList<Expression> operands = new ArrayList();
    protected boolean singleOperand = false;
    protected ArrayList<Expression> optionsSpec = null;
    protected EquilibriumType equilibriumType;
    protected EquilibriumCriterion equilibriumCriterion;

    public ExpressionStrategy() {
    }

    public ExpressionStrategy(boolean bl) {
        this.thereExists = bl;
    }

    public ExpressionStrategy(boolean bl, Expression expression) {
        this.thereExists = bl;
        this.operands.add(expression);
        this.singleOperand = true;
    }

    public void setThereExists(boolean bl) {
        this.thereExists = bl;
    }

    public void setCoalition(List<String> list) {
        this.coalitions.clear();
        this.coalitions.add(new Coalition(list));
    }

    public void setCoalition(Coalition coalition) {
        this.coalitions.clear();
        this.coalitions.add(new Coalition(coalition));
    }

    public void setCoalitionsFromPlayerLists(List<List<String>> list) {
        this.coalitions = new ArrayList<Coalition>();
        for (List<String> list2 : list) {
            this.coalitions.add(new Coalition(list2));
        }
    }

    public void setCoalitions(List<Coalition> list) {
        this.coalitions = new ArrayList<Coalition>();
        for (Coalition coalition : list) {
            this.coalitions.add(new Coalition(coalition));
        }
    }

    public void setSingleOperand(Expression expression) {
        this.operands.clear();
        this.operands.add(expression);
        this.singleOperand = true;
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }

    public void setOperand(int n, Expression expression) {
        this.operands.set(n, expression);
    }

    public void processOptions(ArrayList<Expression> arrayList) throws PrismLangException {
        this.optionsSpec = arrayList;
        if (arrayList == null) {
            return;
        }
        for (Expression expression : arrayList) {
            if (expression instanceof ExpressionIdent && ((ExpressionIdent)expression).getName().equals("nash")) {
                this.equilibriumType = EquilibriumType.NASH;
                continue;
            }
            if (expression instanceof ExpressionIdent && ((ExpressionIdent)expression).getName().equals("correlated") || ((ExpressionIdent)expression).getName().equals("corr")) {
                this.equilibriumType = EquilibriumType.CORRELATED;
                continue;
            }
            if (expression instanceof ExpressionIdent && ((ExpressionIdent)expression).getName().equals("social")) {
                this.equilibriumCriterion = EquilibriumCriterion.SOCIAL;
                continue;
            }
            if (expression instanceof ExpressionIdent && ((ExpressionIdent)expression).getName().equals("fair")) {
                this.equilibriumCriterion = EquilibriumCriterion.FAIR;
                continue;
            }
            throw new PrismLangException("Unknown option \"" + expression + "\" for " + this.getOperatorString() + " operator");
        }
    }

    public boolean isThereExists() {
        return this.thereExists;
    }

    public String getOperatorString() {
        return this.thereExists ? "<<>>" : "[[]]";
    }

    public Coalition getCoalition() {
        return this.coalitions.get(0);
    }

    public int getNumCoalitions() {
        return this.coalitions.size();
    }

    public Coalition getCoalition(int n) {
        return this.coalitions.get(n);
    }

    public List<Coalition> getCoalitions() {
        return this.coalitions;
    }

    public boolean coalitionIsAllPlayers() {
        return this.coalitions.get(0).isAllPlayers();
    }

    public List<String> getCoalitionPlayers() {
        return this.coalitions.get(0).getPlayers();
    }

    public boolean hasSingleOperand() {
        return this.singleOperand;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public Expression getOperand(int n) {
        return this.operands.get(n);
    }

    public List<Expression> getOperands() {
        return this.operands;
    }

    public EquilibriumType getEquilibriumType() {
        return this.equilibriumType;
    }

    public EquilibriumCriterion getEquilibriumCriterion() {
        return this.equilibriumCriterion;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a " + this.getOperatorString() + " operator without a model");
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionStrategy deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.operands);
        deepCopy.copyAll(this.optionsSpec);
        return this;
    }

    @Override
    public ExpressionStrategy clone() {
        ExpressionStrategy expressionStrategy = (ExpressionStrategy)super.clone();
        expressionStrategy.setCoalitions(this.coalitions);
        expressionStrategy.operands = (ArrayList)this.operands.clone();
        expressionStrategy.optionsSpec = this.optionsSpec == null ? null : (ArrayList)this.optionsSpec.clone();
        expressionStrategy.equilibriumType = this.equilibriumType;
        expressionStrategy.equilibriumCriterion = this.equilibriumCriterion;
        return expressionStrategy;
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + (this.thereExists ? "<<" : "[[");
        object = (String)object + this.coalitions.stream().map(Coalition::toString).collect(Collectors.joining(":"));
        object = (String)object + (this.thereExists ? ">>" : "]]");
        if (this.optionsSpec != null) {
            object = (String)object + "{" + this.optionsSpec.stream().map(ASTElement::toString).collect(Collectors.joining(",")) + "}";
        }
        if (this.singleOperand) {
            object = (String)object + this.operands.get(0);
        } else {
            object = (String)object + "(";
            boolean bl = true;
            for (Expression expression : this.operands) {
                if (!bl) {
                    object = (String)object + ", ";
                } else {
                    bl = false;
                }
                object = (String)object + expression;
            }
            object = (String)object + ")";
        }
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.coalitions == null ? 0 : this.coalitions.hashCode());
        n = 31 * n + (this.operands == null ? 0 : this.operands.hashCode());
        n = 31 * n + (this.singleOperand ? 1231 : 1237);
        n = 31 * n + (this.thereExists ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionStrategy expressionStrategy = (ExpressionStrategy)object;
        if (this.coalitions == null ? expressionStrategy.coalitions != null : !this.coalitions.equals(expressionStrategy.coalitions)) {
            return false;
        }
        if (this.operands == null ? expressionStrategy.operands != null : !this.operands.equals(expressionStrategy.operands)) {
            return false;
        }
        if (this.singleOperand != expressionStrategy.singleOperand) {
            return false;
        }
        return this.thereExists == expressionStrategy.thereExists;
    }

    public static enum EquilibriumType {
        NASH,
        CORRELATED;

    }

    public static enum EquilibriumCriterion {
        SOCIAL,
        FAIR;

    }
}

