/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import param.BigRational;
import parser.EvaluateContext;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionQuant;
import parser.ast.RelOp;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.OpRelOpBound;
import prism.PrismLangException;

public class ExpressionMultiNash
extends Expression {
    protected RelOp relOp = null;
    protected Expression bound = null;
    protected ArrayList<ExpressionQuant> operands = new ArrayList();

    public void setRelOp(RelOp relOp) {
        this.relOp = relOp;
    }

    public void setRelOp(String string) {
        this.relOp = RelOp.parseSymbol(string);
    }

    public void setBound(Expression expression) {
        this.bound = expression;
    }

    public void addOperand(ExpressionQuant expressionQuant) {
        this.operands.add(expressionQuant);
    }

    public void setOperand(int n, ExpressionQuant expressionQuant) {
        this.operands.set(n, expressionQuant);
    }

    public RelOp getRelOp() {
        return this.relOp;
    }

    public Expression getBound() {
        return this.bound;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public ExpressionQuant getOperand(int n) {
        return this.operands.get(n);
    }

    public List<ExpressionQuant> getOperands() {
        return this.operands;
    }

    public OpRelOpBound getRelopBoundInfo(Values values) throws PrismLangException {
        if (this.getBound() != null) {
            double d = this.getBound().evaluateDouble(values);
            return new OpRelOpBound("", this.getRelOp(), d);
        }
        return new OpRelOpBound("", this.getRelOp(), null);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a Nash operator without a model");
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a Nash operator without a model");
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionMultiNash deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.bound = deepCopy.copy(this.bound);
        deepCopy.copyAll(this.operands);
        return this;
    }

    @Override
    public ExpressionMultiNash clone() {
        ExpressionMultiNash expressionMultiNash = (ExpressionMultiNash)super.clone();
        expressionMultiNash.operands = (ArrayList)this.operands.clone();
        return expressionMultiNash;
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + this.getRelOp();
        object = (String)object + (this.getBound() == null ? "?" : this.getBound().toString());
        object = (String)object + " (";
        int n = this.operands.size();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                object = (String)object + " + ";
            } else {
                bl = false;
            }
            object = (String)object + this.getOperand(i);
        }
        object = (String)object + ")";
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.bound == null ? 0 : this.bound.hashCode());
        n = 31 * n + (this.operands == null ? 0 : this.operands.hashCode());
        n = 31 * n + (this.relOp == null ? 0 : this.relOp.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionMultiNash expressionMultiNash = (ExpressionMultiNash)object;
        if (this.bound == null ? expressionMultiNash.bound != null : !this.bound.equals(expressionMultiNash.bound)) {
            return false;
        }
        if (this.operands == null ? expressionMultiNash.operands != null : !this.operands.equals(expressionMultiNash.operands)) {
            return false;
        }
        return this.relOp == expressionMultiNash.relOp;
    }
}

