/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import common.Interval;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionInterval
extends Expression {
    protected Expression operand1 = null;
    protected Expression operand2 = null;

    public ExpressionInterval(Expression expression, Expression expression2) {
        this.operand1 = expression;
        this.operand2 = expression2;
    }

    public void setOperand1(Expression expression) {
        this.operand1 = expression;
    }

    public void setOperand2(Expression expression) {
        this.operand2 = expression;
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public boolean isConstant() {
        return this.operand1.isConstant() && this.operand2.isConstant();
    }

    @Override
    public boolean isProposition() {
        return this.operand1.isProposition() && this.operand2.isProposition();
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        double d;
        double d2 = this.operand1.evaluateDouble(evaluateContext);
        if (d2 > (d = this.operand2.evaluateDouble(evaluateContext))) {
            throw new PrismLangException("Invalid interval bounds " + d2 + "," + d, this);
        }
        return new Interval<Double>(d2, d);
    }

    @Override
    public boolean returnsSingleValue() {
        return this.operand1.returnsSingleValue() && this.operand2.returnsSingleValue();
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionInterval deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.operand1 = deepCopy.copy(this.operand1);
        this.operand2 = deepCopy.copy(this.operand2);
        return this;
    }

    @Override
    public ExpressionInterval clone() {
        return (ExpressionInterval)super.clone();
    }

    @Override
    public String toString() {
        return "[" + this.operand1 + "," + this.operand2 + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.operand1 == null ? 0 : this.operand1.hashCode());
        n = 31 * n + (this.operand2 == null ? 0 : this.operand2.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)object;
        if (this.operand1 == null ? expressionBinaryOp.operand1 != null : !this.operand1.equals(expressionBinaryOp.operand1)) {
            return false;
        }
        return !(this.operand2 == null ? expressionBinaryOp.operand2 != null : !this.operand2.equals(expressionBinaryOp.operand2));
    }
}

