/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import common.SafeCast;
import java.math.BigInteger;
import java.util.ArrayList;
import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;
import prism.PrismUtils;

public class ExpressionFunc
extends Expression {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int FLOOR = 2;
    public static final int CEIL = 3;
    public static final int ROUND = 4;
    public static final int POW = 5;
    public static final int MOD = 6;
    public static final int LOG = 7;
    public static final int MULTI = 8;
    public static final int OR = 10;
    public static final int AND = 11;
    public static final int NOT = 12;
    public static final int IMPL = 13;
    public static final int EQUIV = 14;
    public static final String[] names = new String[]{"min", "max", "floor", "ceil", "round", "pow", "mod", "log", "multi", "comp", "or", "and", "not", "impl", "equiv"};
    public static final int[] minArities = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2};
    public static final int[] maxArities = new int[]{-1, -1, 1, 1, 1, 2, 2, 2, -1, -1, -1, -1, 1, 2, 2};
    private String name = "";
    private int code = -1;
    private ArrayList<Expression> operands;
    private boolean oldStyle = false;

    public ExpressionFunc() {
        this.operands = new ArrayList();
    }

    public ExpressionFunc(String string) {
        this.setName(string);
        this.operands = new ArrayList();
    }

    public void setName(String string) {
        this.name = string;
        int n = names.length;
        this.code = -1;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(names[i])) continue;
            this.code = i;
            break;
        }
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }

    public void setOperand(int n, Expression expression) {
        this.operands.set(n, expression);
    }

    public void setOldStyle(boolean bl) {
        this.oldStyle = bl;
    }

    public String getName() {
        return this.name;
    }

    public int getNameCode() {
        return this.code;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public Expression getOperand(int n) {
        return this.operands.get(n);
    }

    public boolean getOldStyle() {
        return this.oldStyle;
    }

    public int getMinArity() {
        return this.code == -1 ? Integer.MAX_VALUE : minArities[this.code];
    }

    public int getMaxArity() {
        return this.code == -1 ? -1 : maxArities[this.code];
    }

    @Override
    public boolean isConstant() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isProposition() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).isProposition()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            int n = this.getNumOperands();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.getOperand(i).evaluate(evaluateContext);
            }
            return this.apply(objectArray, evaluateContext.getEvaluationMode());
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public boolean isPareto() {
        switch (this.code) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public Object apply(Object[] objectArray, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (this.code) {
            case 0: {
                return this.applyMin(objectArray, evalMode);
            }
            case 1: {
                return this.applyMax(objectArray, evalMode);
            }
            case 2: {
                return this.applyFloor(objectArray[0], evalMode);
            }
            case 3: {
                return this.applyCeil(objectArray[0], evalMode);
            }
            case 4: {
                return this.applyRound(objectArray[0], evalMode);
            }
            case 5: {
                return this.applyPow(objectArray[0], objectArray[1], evalMode);
            }
            case 6: {
                return this.applyMod(objectArray[0], objectArray[1], evalMode);
            }
            case 7: {
                return this.applyLog(objectArray[0], objectArray[1], evalMode);
            }
            case 8: {
                throw new PrismLangException("Cannot evaluate \"multi\" function.", this);
            }
            case 10: {
                throw new PrismLangException("Cannot evaluate \"or\" function.", this);
            }
            case 11: {
                throw new PrismLangException("Cannot evaluate \"and\" function.", this);
            }
            case 12: {
                throw new PrismLangException("Cannot evaluate \"not\" function.", this);
            }
            case 13: {
                throw new PrismLangException("Cannot evaluate \"impl\" function.", this);
            }
            case 14: {
                throw new PrismLangException("Cannot evaluate \"equiv\" function.", this);
            }
        }
        throw new PrismLangException("Unknown function \"" + this.name + "\"", this);
    }

    public Object applyUnary(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (this.code) {
            case 2: {
                return this.applyFloor(object, evalMode);
            }
            case 3: {
                return this.applyCeil(object, evalMode);
            }
            case 4: {
                return this.applyRound(object, evalMode);
            }
        }
        throw new PrismLangException("Unknown unary function \"" + this.name + "\"", this);
    }

    public Object applyBinary(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (this.code) {
            case 0: {
                return this.applyMinBinary(object, object2, evalMode);
            }
            case 1: {
                return this.applyMaxBinary(object, object2, evalMode);
            }
            case 5: {
                return this.applyPow(object, object2, evalMode);
            }
            case 6: {
                return this.applyMod(object, object2, evalMode);
            }
            case 7: {
                return this.applyLog(object, object2, evalMode);
            }
        }
        throw new PrismLangException("Unknown binary function \"" + this.name + "\"", this);
    }

    private Object applyMin(Object[] objectArray, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        int n = objectArray.length;
        if (this.getType() instanceof TypeInt) {
            switch (evalMode) {
                case FP: {
                    int n2 = (Integer)objectArray[0];
                    for (int i = 1; i < n; ++i) {
                        n2 = Math.min(n2, (Integer)objectArray[i]);
                    }
                    return n2;
                }
                case EXACT: {
                    BigInteger bigInteger = (BigInteger)objectArray[0];
                    for (int i = 1; i < n; ++i) {
                        bigInteger = bigInteger.min((BigInteger)objectArray[i]);
                    }
                    return bigInteger;
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        switch (evalMode) {
            case FP: {
                double d = (Double)TypeDouble.getInstance().castValueTo(objectArray[0], evalMode);
                for (int i = 1; i < n; ++i) {
                    d = Math.min(d, (Double)TypeDouble.getInstance().castValueTo(objectArray[i], evalMode));
                }
                return d;
            }
            case EXACT: {
                BigRational bigRational = (BigRational)TypeDouble.getInstance().castValueTo(objectArray[0], evalMode);
                for (int i = 1; i < n; ++i) {
                    bigRational = bigRational.min((BigRational)TypeDouble.getInstance().castValueTo(objectArray[i], evalMode));
                }
                return bigRational;
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    private Object applyMinBinary(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        if (this.getType() instanceof TypeInt) {
            switch (evalMode) {
                case FP: {
                    return Math.min((Integer)object, (Integer)object2);
                }
                case EXACT: {
                    return ((BigInteger)object).min((BigInteger)object2);
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
        Number number2 = TypeDouble.getInstance().castValueTo(object2, evalMode);
        switch (evalMode) {
            case FP: {
                return Math.min((Double)number, (Double)number2);
            }
            case EXACT: {
                return ((BigRational)number).min((BigRational)number2);
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    private Object applyMax(Object[] objectArray, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        int n = objectArray.length;
        if (this.getType() instanceof TypeInt) {
            switch (evalMode) {
                case FP: {
                    int n2 = (Integer)objectArray[0];
                    for (int i = 1; i < n; ++i) {
                        n2 = Math.max(n2, (Integer)objectArray[i]);
                    }
                    return n2;
                }
                case EXACT: {
                    BigInteger bigInteger = (BigInteger)objectArray[0];
                    for (int i = 1; i < n; ++i) {
                        bigInteger = bigInteger.max((BigInteger)objectArray[i]);
                    }
                    return bigInteger;
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        switch (evalMode) {
            case FP: {
                double d = (Double)TypeDouble.getInstance().castValueTo(objectArray[0], evalMode);
                for (int i = 1; i < n; ++i) {
                    d = Math.max(d, (Double)TypeDouble.getInstance().castValueTo(objectArray[i], evalMode));
                }
                return d;
            }
            case EXACT: {
                BigRational bigRational = (BigRational)TypeDouble.getInstance().castValueTo(objectArray[0], evalMode);
                for (int i = 1; i < n; ++i) {
                    bigRational = bigRational.max((BigRational)TypeDouble.getInstance().castValueTo(objectArray[i], evalMode));
                }
                return bigRational;
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    private Object applyMaxBinary(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        if (this.getType() instanceof TypeInt) {
            switch (evalMode) {
                case FP: {
                    return Math.max((Integer)object, (Integer)object2);
                }
                case EXACT: {
                    return ((BigInteger)object).max((BigInteger)object2);
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
        Number number2 = TypeDouble.getInstance().castValueTo(object2, evalMode);
        switch (evalMode) {
            case FP: {
                return Math.max((Double)number, (Double)number2);
            }
            case EXACT: {
                return ((BigRational)number).max((BigRational)number2);
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    private Object applyFloor(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        try {
            Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
            switch (evalMode) {
                case FP: {
                    return SafeCast.toIntExact(Math.floor((Double)number));
                }
                case EXACT: {
                    return ((BigRational)number).floor().bigIntegerValue();
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Error evaluating " + this.getName() + ":" + arithmeticException.getMessage(), this);
        }
    }

    private Object applyCeil(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        try {
            Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
            switch (evalMode) {
                case FP: {
                    return SafeCast.toIntExact(Math.ceil((Double)number));
                }
                case EXACT: {
                    return ((BigRational)number).ceil().bigIntegerValue();
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Error evaluating " + this.getName() + ":" + arithmeticException.getMessage(), this);
        }
    }

    private Object applyRound(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        try {
            Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
            switch (evalMode) {
                case FP: {
                    return SafeCast.toIntExact(Math.round((Double)number));
                }
                case EXACT: {
                    return ((BigRational)number).round().bigIntegerValue();
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Error evaluating " + this.getName() + ":" + arithmeticException.getMessage(), this);
        }
    }

    private Object applyPow(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        if (this.getType() instanceof TypeInt) {
            switch (evalMode) {
                case FP: {
                    int n = (Integer)object;
                    int n2 = (Integer)object2;
                    if (n2 < 0) {
                        throw new PrismLangException("Negative exponent not allowed for integer power", this);
                    }
                    try {
                        return SafeCast.toIntExact(Math.pow(n, n2));
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new PrismLangException("Overflow evaluating integer power: " + arithmeticException.getMessage(), this);
                    }
                }
                case EXACT: {
                    BigInteger bigInteger = (BigInteger)object;
                    BigInteger bigInteger2 = (BigInteger)object2;
                    if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
                        throw new PrismLangException("Negative exponent not allowed for integer power", this);
                    }
                    try {
                        return bigInteger.pow(bigInteger2.intValue());
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new PrismLangException("Can not compute pow exactly, as there is a problem with the exponent: " + arithmeticException.getMessage(), this);
                    }
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + evalMode);
        }
        Number number = TypeDouble.getInstance().castValueTo(object);
        Number number2 = TypeDouble.getInstance().castValueTo(object2);
        switch (evalMode) {
            case FP: {
                return Math.pow((Double)number, (Double)number2);
            }
            case EXACT: {
                return ((BigRational)number).pow(((BigRational)number2).toInt());
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    private Object applyMod(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (evalMode) {
            case FP: {
                int n = (Integer)object;
                int n2 = (Integer)object2;
                if (n2 <= 0) {
                    throw new PrismLangException("Attempt to compute modulo with non-positive divisor", this);
                }
                int n3 = n % n2;
                return n3 < 0 ? n3 + n2 : n3;
            }
            case EXACT: {
                BigInteger bigInteger = (BigInteger)object;
                BigInteger bigInteger2 = (BigInteger)object2;
                if (bigInteger2.compareTo(BigInteger.ZERO) <= 0) {
                    throw new PrismLangException("Attempt to compute modulo with non-positive divisor");
                }
                return bigInteger.mod(bigInteger2);
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    private Object applyLog(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
        Number number2 = TypeDouble.getInstance().castValueTo(object2, evalMode);
        switch (evalMode) {
            case FP: {
                return PrismUtils.log((Double)number, (Double)number2);
            }
            case EXACT: {
                throw new PrismLangException("Currently, can not compute log exactly", this);
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + evalMode);
    }

    @Override
    public boolean returnsSingleValue() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).returnsSingleValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionFunc deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.operands);
        return this;
    }

    @Override
    public ExpressionFunc clone() {
        ExpressionFunc expressionFunc = (ExpressionFunc)super.clone();
        expressionFunc.operands = (ArrayList)this.operands.clone();
        return expressionFunc;
    }

    @Override
    public String toString() {
        Object object = "";
        boolean bl = true;
        object = !this.oldStyle ? (String)object + this.name + "(" : (String)object + "func(" + this.name + ", ";
        int n = this.operands.size();
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                object = (String)object + ", ";
            } else {
                bl = false;
            }
            object = (String)object + this.getOperand(i);
        }
        object = (String)object + ")";
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.code;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.oldStyle ? 1231 : 1237);
        n = 31 * n + (this.operands == null ? 0 : this.operands.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionFunc expressionFunc = (ExpressionFunc)object;
        if (this.code != expressionFunc.code) {
            return false;
        }
        if (this.name == null ? expressionFunc.name != null : !this.name.equals(expressionFunc.name)) {
            return false;
        }
        if (this.oldStyle != expressionFunc.oldStyle) {
            return false;
        }
        return !(this.operands == null ? expressionFunc.operands != null : !this.operands.equals(expressionFunc.operands));
    }
}

