/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.Updates;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class Command
extends ASTElement {
    private ArrayList<String> synchs;
    private ArrayList<Integer> synchIndices;
    private Expression guard;
    private Updates updates;
    private Module parent;

    public Command() {
        this.setSynch("");
        this.guard = null;
        this.updates = null;
    }

    public void setSynch(String string) {
        this.synchs = new ArrayList(1);
        this.synchs.add(string);
        this.synchIndices = new ArrayList(1);
        this.synchIndices.add(-1);
    }

    public void setSynchs(List<String> list) {
        if (list.isEmpty()) {
            this.synchs = new ArrayList(1);
            this.synchs.add("");
            this.synchIndices = new ArrayList(1);
            this.synchIndices.add(-1);
        } else {
            this.synchs = new ArrayList<String>(list);
            this.synchIndices = new ArrayList<Integer>(Collections.nCopies(list.size(), -1));
        }
    }

    public void setSynchIndices(List<String> list) throws PrismLangException {
        int n = this.synchs.size();
        for (int i = 0; i < n; ++i) {
            String string = this.synchs.get(i);
            if (string.equals("")) {
                this.synchIndices.set(i, 0);
                continue;
            }
            int n2 = list.indexOf(string);
            if (n2 != -1) {
                this.synchIndices.set(i, n2 + 1);
                continue;
            }
            throw new PrismLangException("Unknown action name " + string + " in command", this);
        }
    }

    public void setGuard(Expression expression) {
        this.guard = expression;
    }

    public void setUpdates(Updates updates) {
        this.updates = updates;
        updates.setParent(this);
    }

    public void setParent(Module module) {
        this.parent = module;
    }

    public String getSynch() {
        return this.synchs.get(0);
    }

    public List<String> getSynchs() {
        return this.synchs;
    }

    public int getSynchIndex() {
        return this.synchIndices.get(0);
    }

    public ArrayList<Integer> getSynchIndices() {
        return this.synchIndices;
    }

    public boolean isUnlabelled() {
        return "".equals(this.getSynch());
    }

    public Expression getGuard() {
        return this.guard;
    }

    public Updates getUpdates() {
        return this.updates;
    }

    public Module getParent() {
        return this.parent;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "[" + String.join((CharSequence)",", this.synchs) + "] " + this.guard + " -> " + this.updates;
    }

    @Override
    public Command deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.guard = deepCopy.copy(this.guard);
        this.setUpdates(deepCopy.copy(this.updates));
        return this;
    }

    @Override
    public Command clone() {
        Command command = (Command)super.clone();
        command.synchs = (ArrayList)this.synchs.clone();
        command.synchIndices = (ArrayList)this.synchIndices.clone();
        return command;
    }
}

