/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import param.BigRational;
import parser.State;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.ModelInfo;
import prism.PrismLangException;
import prism.PrismUtils;

public class Values
implements Cloneable {
    protected ArrayList<String> names;
    protected ArrayList<Object> values;

    public Values() {
        this.names = new ArrayList();
        this.values = new ArrayList();
    }

    public Values(Values values) {
        if (values == null) {
            this.names = new ArrayList();
            this.values = new ArrayList();
        } else {
            this.names = (ArrayList)values.names.clone();
            this.values = (ArrayList)values.values.clone();
        }
    }

    public Values(Values values, Values values2) {
        this(values);
        this.addValues(values2);
    }

    public Values(State state, ModelInfo modelInfo) {
        this();
        if (state == null) {
            return;
        }
        int n = state.varValues.length;
        for (int i = 0; i < n; ++i) {
            this.addValue(modelInfo.getVarName(i), state.varValues[i]);
        }
    }

    public void addValue(String string, Object object) {
        this.names.add(string);
        this.values.add(object);
    }

    public void addValues(Values values) {
        if (values == null) {
            return;
        }
        int n = values.getNumValues();
        for (int i = 0; i < n; ++i) {
            this.addValue(values.getName(i), values.getValue(i));
        }
    }

    public int setValue(String string, Object object) {
        int n = this.getIndexOf(string);
        if (n == -1) {
            this.addValue(string, object);
            return 0;
        }
        this.values.set(n, object);
        return -1;
    }

    public int setValues(Values values) {
        int n = 0;
        if (values == null) {
            return n;
        }
        int n2 = values.getNumValues();
        for (int i = 0; i < n2; ++i) {
            if (this.setValue(values.getName(i), values.getValue(i)) != 0) continue;
            ++n;
        }
        return n;
    }

    public void removeValue(int n) {
        if (n >= 0 && n < this.getNumValues()) {
            this.names.remove(n);
            this.values.remove(n);
        }
    }

    public void removeValue(String string) {
        int n = this.getIndexOf(string);
        if (n != -1) {
            this.removeValue(n);
        }
    }

    public int getNumValues() {
        return this.names.size();
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public List<String> getNames() {
        return this.names;
    }

    public int getIndexOf(String string) {
        return this.names.indexOf(string);
    }

    public boolean contains(String string) {
        return this.names.contains(string);
    }

    public Type getType(int n) {
        Object object = this.values.get(n);
        if (object instanceof Integer) {
            return TypeInt.getInstance();
        }
        if (object instanceof BigInteger) {
            return TypeInt.getInstance();
        }
        if (object instanceof Double) {
            return TypeDouble.getInstance();
        }
        if (object instanceof BigRational) {
            return TypeDouble.getInstance();
        }
        if (object instanceof Boolean) {
            return TypeBool.getInstance();
        }
        return null;
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public Object getValueOf(String string) throws PrismLangException {
        int n = this.getIndexOf(string);
        if (n == -1) {
            throw new PrismLangException("Couldn't get value for \"" + string + "\"");
        }
        return this.getValue(n);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean equals(Object object) {
        Values values;
        if (object == null) {
            return false;
        }
        try {
            values = (Values)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n = this.getNumValues();
        if (values.getNumValues() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.getName(i);
            int n2 = values.getIndexOf(string);
            if (n2 == -1) {
                return false;
            }
            object = values.getValue(n2);
            if (this.getValue(i).equals(object)) continue;
            return false;
        }
        return true;
    }

    public Values clone() {
        Values values;
        try {
            values = (Values)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Object#clone is expected to work for Cloneable objects.", cloneNotSupportedException);
        }
        values.names = (ArrayList)this.names.clone();
        values.values = (ArrayList)this.values.clone();
        return values;
    }

    public String toString() {
        return this.toString(true, ",");
    }

    public String toString(boolean bl, String string) {
        int n = this.getNumValues();
        Object object = "";
        for (int i = 0; i < n; ++i) {
            if (bl) {
                object = (String)object + this.getName(i) + "=";
            }
            object = (String)object + Values.valToString(this.getValue(i));
            if (i >= n - 1) continue;
            object = (String)object + string;
        }
        return object;
    }

    public static String toStringConcatenated(Values values, Values values2) {
        String string;
        Object object = "";
        if (values != null) {
            object = (String)object + values.toString();
        }
        if (values2 != null && (string = values2.toString()).length() > 0) {
            if (((String)object).length() > 0) {
                object = (String)object + ",";
            }
            object = (String)object + string;
        }
        return object;
    }

    public static String valToString(Object object) {
        String string = object instanceof Double ? PrismUtils.formatDouble(12, (Double)object) : String.valueOf(object);
        return string;
    }
}

