/*
 * Decompiled with CFR 0.152.
 */
package param;

import explicit.MDP;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import param.BigRational;
import param.Function;
import param.FunctionFactory;
import param.Point;
import parser.Values;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;

public final class ParamModel
extends ModelExplicit<Function>
implements MDP<Function> {
    private int numTotalChoices;
    private int numTotalTransitions;
    private int numMaxChoices;
    private int[] rows;
    private int[] choices;
    private int[] cols;
    private Function[] nonZeros;
    private String[] labels;
    private Function[] sumRates;
    private ModelType modelType;
    private FunctionFactory functionFactory;

    ParamModel() {
        this.numStates = 0;
        this.numTotalChoices = 0;
        this.numTotalTransitions = 0;
        this.initialStates = new LinkedList();
        this.deadlocks = new TreeSet();
    }

    void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public Values getConstantValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumTransitions() {
        return this.numTotalTransitions;
    }

    @Override
    public SuccessorsIterator getSuccessors(final int n) {
        return SuccessorsIterator.chain(new Iterator<SuccessorsIterator>(){
            private int choice = 0;
            private int choices = ParamModel.this.getNumChoices(n);

            @Override
            public boolean hasNext() {
                return this.choice < this.choices;
            }

            @Override
            public SuccessorsIterator next() {
                return ParamModel.this.getSuccessors(n, this.choice++);
            }
        });
    }

    @Override
    public SuccessorsIterator getSuccessors(final int n, final int n2) {
        return new SuccessorsIterator(){
            final int start;
            int col;
            final int end;
            {
                this.col = this.start = ParamModel.this.choiceBegin(ParamModel.this.stateBegin(n) + n2);
                this.end = ParamModel.this.choiceBegin(ParamModel.this.stateBegin(n) + n2 + 1);
            }

            @Override
            public boolean hasNext() {
                return this.col < this.end;
            }

            @Override
            public int nextInt() {
                assert (this.col < this.end);
                int n3 = this.col++;
                return ParamModel.this.cols[n3];
            }

            @Override
            public boolean successorsAreDistinct() {
                return false;
            }
        };
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        for (int i = this.stateBegin(n); i < this.stateEnd(n); ++i) {
            for (int j = this.choiceBegin(i); j < this.choiceEnd(i); ++j) {
                if (this.succState(j) != n2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<Integer, Function>> getTransitionsIterator(final int n, final int n2) {
        return new Iterator<Map.Entry<Integer, Function>>(){
            final int start;
            int col;
            final int end;
            {
                this.col = this.start = ParamModel.this.choiceBegin(ParamModel.this.stateBegin(n) + n2);
                this.end = ParamModel.this.choiceBegin(ParamModel.this.stateBegin(n) + n2 + 1);
            }

            @Override
            public boolean hasNext() {
                return this.col < this.end;
            }

            @Override
            public Map.Entry<Integer, Function> next() {
                assert (this.col < this.end);
                final int n3 = this.col++;
                return new Map.Entry<Integer, Function>(){
                    int key;
                    Function value;
                    {
                        this.key = ParamModel.this.cols[n3];
                        this.value = ParamModel.this.nonZeros[n3];
                    }

                    @Override
                    public Integer getKey() {
                        return this.key;
                    }

                    @Override
                    public Function getValue() {
                        return this.value;
                    }

                    @Override
                    public Function setValue(Function function) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog, int n) {
        if (this.modelType.nondeterministic()) {
            prismLog.print(this.numStates + " " + this.getNumChoices() + " " + this.getNumTransitions() + "\n");
        } else {
            prismLog.print(this.numStates + " " + this.getNumTransitions() + "\n");
        }
        TreeMap<Integer, Function> treeMap = new TreeMap<Integer, Function>();
        for (int i = 0; i < this.numStates; ++i) {
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Iterator<Map.Entry<Integer, Function>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Function> entry = iterator.next();
                    treeMap.put((Integer)entry.getKey(), (Function)entry.getValue());
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    Object object = ((Function)entry.getValue()).isConstant() ? ((Function)entry.getValue()).asBigRational() : entry.getValue();
                    if (this.modelType.nondeterministic()) {
                        prismLog.print(i + " " + j + " " + entry.getKey() + " " + object);
                    } else {
                        prismLog.print(i + " " + entry.getKey() + " " + object);
                    }
                    Object object2 = this.getAction(i, j);
                    prismLog.print((String)(object2 == null ? "\n" : " " + object2 + "\n"));
                }
                treeMap.clear();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable, int n2) {
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            Object object;
            String string = null;
            if (this.modelType.nondeterministic()) {
                string = "n" + n + "_" + i;
                prismLog.print(n + " -> " + string + " ");
                object = new Decoration();
                ((Decoration)object).attributes().put("arrowhead", "none");
                ((Decoration)object).setLabel(Integer.toString(i));
                if (iterable != null) {
                    for (Decorator decorator : iterable) {
                        object = decorator.decorateTransition(n, i, (Decoration)object);
                    }
                }
                prismLog.print(object);
                prismLog.println(";");
                prismLog.print(string + " [ shape=point,width=0.1,height=0.1,label=\"\" ];\n");
            }
            object = this.getTransitionsIterator(n, i);
            while (object.hasNext()) {
                void var10_14;
                Map.Entry<Integer, Function> entry = object.next();
                if (!this.modelType.nondeterministic()) {
                    prismLog.print(n + " -> " + entry.getKey() + " ");
                } else {
                    prismLog.print(string + " -> " + entry.getKey() + " ");
                }
                if (entry.getValue().isConstant()) {
                    BigRational bigRational = ((Function)entry.getValue()).asBigRational();
                } else {
                    Object v = entry.getValue();
                }
                Decoration decoration = new Decoration();
                decoration.setLabel(var10_14.toString());
                if (iterable != null) {
                    for (Decorator decorator : iterable) {
                        if (!this.modelType.nondeterministic()) {
                            decoration = decorator.decorateProbability(n, (Integer)entry.getKey(), var10_14, decoration);
                            continue;
                        }
                        decoration = decorator.decorateProbability(n, (Integer)entry.getKey(), i, var10_14, decoration);
                    }
                }
                prismLog.print(decoration);
                prismLog.println(";");
            }
        }
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismLanguage(String string, int n) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model<Function> constructInducedModel(MDStrategy<Function> mDStrategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        return object;
    }

    @Override
    public int getNumChoices(int n) {
        return this.stateEnd(n) - this.stateBegin(n);
    }

    @Override
    public int getMaxNumChoices() {
        return this.numMaxChoices;
    }

    @Override
    public int getNumChoices() {
        return this.numTotalChoices;
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return this.choiceEnd(this.stateBegin(n) + n2) - this.choiceBegin(this.stateBegin(n) + n2);
    }

    @Override
    public Object getAction(int n, int n2) {
        return null;
    }

    void reserveMem(int n, int n2, int n3) {
        this.rows = new int[n + 1];
        this.choices = new int[n2 + 1];
        this.labels = new String[n3];
        this.cols = new int[n3];
        this.nonZeros = new Function[n3];
        this.sumRates = new Function[n2];
    }

    void finishState() {
        int n = this.numStates;
        this.rows[this.numStates + 1] = this.numTotalChoices;
        ++this.numStates;
        this.numMaxChoices = Math.max(this.numMaxChoices, this.getNumChoices(n));
    }

    void finishChoice() {
        this.choices[this.numTotalChoices + 1] = this.numTotalTransitions;
        ++this.numTotalChoices;
    }

    void addTransition(int n, Function function, String string) {
        this.cols[this.numTotalTransitions] = n;
        this.nonZeros[this.numTotalTransitions] = function;
        this.labels[this.numTotalTransitions] = string;
        ++this.numTotalTransitions;
    }

    void setSumLeaving(Function function) {
        this.sumRates[this.numTotalChoices] = function;
    }

    int stateBegin(int n) {
        return this.rows[n];
    }

    int stateEnd(int n) {
        return this.rows[n + 1];
    }

    int choiceBegin(int n) {
        return this.choices[n];
    }

    int choiceEnd(int n) {
        return this.choices[n + 1];
    }

    int succState(int n) {
        return this.cols[n];
    }

    Function succProb(int n) {
        return this.nonZeros[n];
    }

    String getLabel(int n) {
        return this.labels[n];
    }

    Function sumLeaving(int n) {
        return this.sumRates[n];
    }

    ParamModel instantiate(Point point, boolean bl) {
        ParamModel paramModel = new ParamModel();
        paramModel.setModelType(this.getModelType());
        paramModel.reserveMem(this.numStates, this.numTotalChoices, this.numTotalTransitions);
        paramModel.initialStates = new LinkedList(this.initialStates);
        for (int i = 0; i < this.numStates; ++i) {
            for (int j = this.stateBegin(i); j < this.stateEnd(i); ++j) {
                for (int k = this.choiceBegin(j); k < this.choiceEnd(j); ++k) {
                    BigRational bigRational = this.succProb(k).evaluate(point);
                    if (bl && (bigRational.isSpecial() || bigRational.compareTo(BigRational.ONE) == 1 || bigRational.signum() <= 0)) {
                        return null;
                    }
                    paramModel.addTransition(this.succState(k), this.functionFactory.fromBigRational(bigRational), this.labels[k]);
                }
                paramModel.setSumLeaving(this.functionFactory.fromBigRational(this.sumLeaving(j).evaluate(point)));
                paramModel.finishChoice();
            }
            paramModel.finishState();
        }
        paramModel.functionFactory = this.functionFactory;
        return paramModel;
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    void setFunctionFactory(FunctionFactory functionFactory) {
        this.functionFactory = functionFactory;
    }

    FunctionFactory getFunctionFactory() {
        return this.functionFactory;
    }
}

