/*
 * Decompiled with CFR 0.152.
 */
package param;

import explicit.IndexedSet;
import explicit.StateStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import param.BigRational;
import param.CachedFunctionFactory;
import param.DagFunctionFactory;
import param.Function;
import param.FunctionFactory;
import param.JasFunctionFactory;
import param.ParamMode;
import param.ParamModel;
import parser.State;
import parser.ast.Expression;
import prism.ModelGenerator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public final class ModelBuilder
extends PrismComponent {
    private final ParamMode mode;
    private FunctionFactory functionFactory;
    private String[] paramNames;
    private String functionType;
    private double dagMaxError;
    private static Map<String, Expression> constExprs;

    public ModelBuilder(PrismComponent prismComponent, ParamMode paramMode) throws PrismException {
        super(prismComponent);
        this.mode = paramMode;
        if (this.settings != null) {
            this.functionType = this.settings.getString("prism.param.function");
            this.dagMaxError = this.settings.getDouble("prism.param.functionDagMaxError");
        }
    }

    public List<String> getParameterNames() {
        return Arrays.asList(this.paramNames);
    }

    public FunctionFactory getFunctionFactory(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.paramNames = stringArray;
        BigRational[] bigRationalArray = new BigRational[stringArray2.length];
        BigRational[] bigRationalArray2 = new BigRational[stringArray3.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            bigRationalArray[i] = new BigRational(stringArray2[i]);
            bigRationalArray2[i] = new BigRational(stringArray3[i]);
        }
        if (this.functionType.equals("JAS")) {
            this.functionFactory = new JasFunctionFactory(stringArray, bigRationalArray, bigRationalArray2);
        } else if (this.functionType.equals("JAS-cached")) {
            this.functionFactory = new CachedFunctionFactory(new JasFunctionFactory(stringArray, bigRationalArray, bigRationalArray2));
        } else if (this.functionType.equals("DAG")) {
            this.functionFactory = new DagFunctionFactory(stringArray, bigRationalArray, bigRationalArray2, this.dagMaxError, false);
        }
        return this.functionFactory;
    }

    public ParamModel constructModel(ModelGenerator<Function> modelGenerator) throws PrismException {
        if (modelGenerator.getModelType() == ModelType.PTA) {
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", you cannot build a PTA model explicitly, only perform model checking");
        }
        this.mainLog.print("\nBuilding model (" + this.mode.engine() + ")...\n");
        long l = System.currentTimeMillis();
        ParamModel paramModel = this.doModelConstruction(modelGenerator);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\n" + paramModel.infoStringTable());
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        return paramModel;
    }

    private void reserveMemoryAndExploreStates(ModelGenerator<Function> modelGenerator, ParamModel paramModel, StateStorage<State> stateStorage) throws PrismException {
        boolean bl = modelGenerator.getModelType().nondeterministic();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList<State> linkedList = new LinkedList<State>();
        State state = modelGenerator.getInitialState();
        stateStorage.add(state);
        linkedList.add(state);
        ++n;
        while (!linkedList.isEmpty()) {
            state = (State)linkedList.removeFirst();
            modelGenerator.exploreState(state);
            int n4 = modelGenerator.getNumChoices();
            n2 = bl ? (n2 += n4) : ++n2;
            for (int i = 0; i < n4; ++i) {
                int n5 = modelGenerator.getNumTransitions(i);
                n3 += n5;
                for (int j = 0; j < n5; ++j) {
                    State state2 = modelGenerator.computeTransitionTarget(i, j);
                    if (!stateStorage.add(state2)) continue;
                    ++n;
                    linkedList.add(state2);
                    stateStorage.add(state2);
                }
            }
            if (n4 != 0) continue;
            if (bl) {
                ++n2;
            }
            ++n3;
        }
        paramModel.reserveMem(n, n2, n3);
    }

    private ParamModel doModelConstruction(ModelGenerator<Function> modelGenerator) throws PrismException {
        if (!modelGenerator.hasSingleInitialState()) {
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", cannot do explicit-state reachability if there are multiple initial states");
        }
        boolean bl = this.getSettings().getBoolean("prism.doProbChecks");
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        long l = System.currentTimeMillis();
        ModelType modelType = modelGenerator.getModelType();
        ParamModel paramModel = new ParamModel();
        paramModel.setModelType(modelType);
        if (modelType != ModelType.DTMC && modelType != ModelType.CTMC && modelType != ModelType.MDP) {
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", unsupported model type: " + modelType);
        }
        boolean bl2 = modelType == ModelType.MDP;
        boolean bl3 = modelType == ModelType.CTMC;
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        this.reserveMemoryAndExploreStates(modelGenerator, paramModel, indexedSet);
        int[] nArray = indexedSet.buildSortingPermutation();
        ArrayList<State> arrayList = indexedSet.toPermutedArrayList(nArray);
        paramModel.setStatesList(arrayList);
        paramModel.addInitialState(nArray[0]);
        int n = 0;
        for (State state : arrayList) {
            int n2;
            int n3;
            modelGenerator.exploreState(state);
            int n4 = modelGenerator.getNumChoices();
            boolean bl4 = !bl2;
            Function function = this.functionFactory.getZero();
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = modelGenerator.getNumTransitions(n3);
                for (n2 = 0; n2 < n5; ++n2) {
                    Function function2 = modelGenerator.getTransitionProbability(n3, n2);
                    if (!bl4) continue;
                    function = function.add(function2);
                }
            }
            if (function.isZero()) {
                function = this.functionFactory.getOne();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Object object = modelGenerator.getChoiceAction(n3);
                n2 = modelGenerator.getNumTransitions(n3);
                for (int i = 0; i < n2; ++i) {
                    State state2 = modelGenerator.computeTransitionTarget(n3, i);
                    Function function3 = modelGenerator.getTransitionProbability(n3, i);
                    if (modelType == ModelType.CTMC) {
                        if (function3.isInf() || function3.isMInf() || function3.isNaN()) {
                            throw new PrismException("For state " + state.toString(modelGenerator) + ", illegal rate " + function3.asBigRational());
                        }
                        if (function3.isConstant() && function3.asBigRational().signum() < 0) {
                            throw new PrismException("For state " + state.toString(modelGenerator) + ", negative rate " + function3.asBigRational());
                        }
                    }
                    function3 = function3.divide(function);
                    if (modelType == ModelType.DTMC || modelType == ModelType.MDP) {
                        if (function3.isInf() || function3.isMInf() || function3.isNaN()) {
                            throw new PrismException("For state " + state.toString(modelGenerator) + ", illegal probability " + function3.asBigRational());
                        }
                        if (function3.isConstant() && function3.asBigRational().signum() < 0) {
                            throw new PrismException("For state " + state.toString(modelGenerator) + ", negative probability " + function3.asBigRational());
                        }
                    }
                    paramModel.addTransition(nArray[indexedSet.get(state2)], function3, object == null ? "" : object.toString());
                }
                if (!bl2) continue;
                paramModel.setSumLeaving(bl3 ? function : this.functionFactory.getOne());
                paramModel.finishChoice();
            }
            if (n4 == 0) {
                paramModel.addDeadlockState(n);
                paramModel.addTransition(n, this.functionFactory.getOne(), null);
                if (bl2) {
                    paramModel.setSumLeaving(bl3 ? function : this.functionFactory.getOne());
                    paramModel.finishChoice();
                }
            }
            if (!bl2) {
                paramModel.setSumLeaving(bl3 ? function : this.functionFactory.getOne());
                paramModel.finishChoice();
            }
            paramModel.finishState();
            ++n;
        }
        paramModel.setFunctionFactory(this.functionFactory);
        this.mainLog.println();
        this.mainLog.print("Reachable states exploration and model construction");
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        return paramModel;
    }
}

