/*
 * Decompiled with CFR 0.152.
 */
package param;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.ufd.Quotient;
import java.math.BigInteger;
import java.util.ArrayList;
import param.BigRational;
import param.Function;
import param.JasFunctionFactory;
import param.Point;
import param.Polynomial;

final class JasFunction
extends Function {
    private Quotient<edu.jas.arith.BigInteger> jas;
    Polynomial num;
    Polynomial den;
    int type;
    static final int NORMAL = 0;
    static final int INF = 1;
    static final int MINF = 2;
    static final int NAN = 3;

    JasFunction(JasFunctionFactory jasFunctionFactory, Quotient<edu.jas.arith.BigInteger> quotient, int n) {
        super(jasFunctionFactory);
        this.jas = quotient;
        this.num = null;
        this.den = null;
        this.type = n;
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInf()) {
            return "Infinity";
        }
        if (this.isMInf()) {
            return "-Infinity";
        }
        return this.jas.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JasFunction)) {
            return false;
        }
        JasFunction jasFunction = (JasFunction)object;
        if (this.isNaN()) {
            return jasFunction.isNaN();
        }
        if (this.isInf()) {
            return jasFunction.isInf();
        }
        if (this.isMInf()) {
            return jasFunction.isMInf();
        }
        return this.jas.equals(jasFunction.jas);
    }

    public int hashCode() {
        return this.jas.hashCode();
    }

    Quotient<edu.jas.arith.BigInteger> getJas() {
        return this.jas;
    }

    @Override
    public Function add(Function function) {
        if (this.isNaN() || function.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isInf() || function.isInf()) {
            if (this.isMInf() || function.isMInf()) {
                return this.factory.getZero();
            }
            return this.factory.getInf();
        }
        if (this.isMInf() || function.isMInf()) {
            return this.factory.getMInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.sum(((JasFunction)function).jas), 0);
    }

    @Override
    public Function negate() {
        if (this.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isInf()) {
            return this.factory.getMInf();
        }
        if (this.isMInf()) {
            return this.factory.getMInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.negate(), 0);
    }

    @Override
    public Function multiply(Function function) {
        if (this.isNaN() || function.isNaN()) {
            return this.factory.getNaN();
        }
        if (this.isZero() || function.isZero()) {
            return this.factory.getZero();
        }
        if (this.isInf() || function.isInf()) {
            if (this.isMInf() || function.isMInf()) {
                return this.factory.getMInf();
            }
            return this.factory.getInf();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.multiply(((JasFunction)function).jas), 0);
    }

    @Override
    public Function divide(Function function) {
        if (this.isNaN() || function.isNaN()) {
            return this.factory.getNaN();
        }
        if (function.isInf() || function.isMInf()) {
            return this.factory.getNaN();
        }
        if (function.isZero()) {
            if (this.isConstant()) {
                return this.factory.fromBigRational(this.asBigRational().divide(BigRational.ZERO));
            }
            return this.factory.getInf();
        }
        if (this.isZero()) {
            return this.factory.getZero();
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.divide(((JasFunction)function).jas), 0);
    }

    @Override
    public Function star() {
        if (this.isNaN()) {
            return this.factory.getNaN();
        }
        Quotient quotient = ((JasFunctionFactory)this.factory).getJasQuotRing().getONE();
        Quotient quotient2 = quotient.subtract(this.jas);
        quotient2 = quotient.divide(quotient2);
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)quotient2, 0);
    }

    private Polynomial jasToPoly(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        int n = genPolynomial.numberOfVariables();
        Polynomial polynomial = new Polynomial(n, genPolynomial.length());
        for (Monomial monomial : genPolynomial) {
            BigInteger bigInteger = ((edu.jas.arith.BigInteger)monomial.coefficient()).getVal();
            ExpVector expVector = monomial.exponent();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                arrayList.add((int)expVector.getVal(i));
            }
            polynomial.addTerm(bigInteger, arrayList);
        }
        return polynomial;
    }

    @Override
    public Function toConstraint() {
        if (this.isNaN() || this.isInf() || this.isMInf()) {
            return this;
        }
        if (this.num == null) {
            this.num = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.num);
        }
        if (this.den == null) {
            this.den = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.den);
        }
        BigRational[] bigRationalArray = new BigRational[this.factory.getNumVariables()];
        for (int i = 0; i < this.factory.getNumVariables(); ++i) {
            bigRationalArray[i] = this.factory.getUpperBound(i).subtract(this.factory.getLowerBound(i));
        }
        BigRational bigRational = BigRational.ZERO;
        while (bigRational.isZero() || bigRational.isSpecial()) {
            for (int i = 0; i < this.factory.getNumVariables(); ++i) {
                bigRationalArray[i] = bigRationalArray[i].divide(2L);
            }
            BigRational[] bigRationalArray2 = new BigRational[this.factory.getNumVariables()];
            for (int i = 0; i < this.factory.getNumVariables(); ++i) {
                bigRationalArray2[i] = this.factory.getLowerBound(i).add(bigRationalArray[i]);
            }
            bigRational = this.den.evaluate(new Point(bigRationalArray2), false);
        }
        if (bigRational.signum() == -1) {
            return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.multiply(this.jas.den).negate(), 0);
        }
        return new JasFunction((JasFunctionFactory)this.factory, (Quotient<edu.jas.arith.BigInteger>)this.jas.multiply(this.jas.den), 0);
    }

    @Override
    public BigRational evaluate(Point point, boolean bl) {
        if (this.isNaN()) {
            return BigRational.NAN;
        }
        if (this.isInf()) {
            return BigRational.INF;
        }
        if (this.isMInf()) {
            return BigRational.MINF;
        }
        if (this.num == null) {
            this.num = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.num);
        }
        if (this.den == null) {
            this.den = this.jasToPoly((GenPolynomial<edu.jas.arith.BigInteger>)this.jas.den);
        }
        if (this.isNaN()) {
            return BigRational.NAN;
        }
        return this.num.evaluate(point, bl).divide(this.den.evaluate(point, bl), bl);
    }

    @Override
    public BigRational evaluate(Point point) {
        return this.evaluate(point, true);
    }

    @Override
    public boolean check(Point point, boolean bl) {
        BigRational bigRational = this.evaluate(point, false);
        int n = bigRational.signum();
        return bl ? n > 0 : n >= 0;
    }

    @Override
    public BigRational asBigRational() {
        if (this.isNaN()) {
            return BigRational.NAN;
        }
        if (this.isInf()) {
            return BigRational.INF;
        }
        if (this.isMInf()) {
            return BigRational.MINF;
        }
        BigRational[] bigRationalArray = new BigRational[this.factory.getNumVariables()];
        for (int i = 0; i < this.factory.getNumVariables(); ++i) {
            bigRationalArray[i] = new BigRational(0L);
        }
        return this.evaluate(new Point(bigRationalArray));
    }

    @Override
    public boolean isNaN() {
        return this.type == 3;
    }

    @Override
    public boolean isInf() {
        return this.type == 1;
    }

    @Override
    public boolean isMInf() {
        return this.type == 2;
    }

    @Override
    public boolean isOne() {
        if (this.type != 0) {
            return false;
        }
        return this.jas.isONE();
    }

    @Override
    public boolean isZero() {
        if (this.type != 0) {
            return false;
        }
        return this.jas.isZERO();
    }

    @Override
    public boolean isConstant() {
        if (this.type != 0) {
            return true;
        }
        if (this.jas.isZERO()) {
            return true;
        }
        return this.jas.isConstant();
    }
}

