/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.HashMap;
import param.BigRational;
import param.Function;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionUnaryOp;
import prism.PrismException;
import prism.PrismLangException;

public abstract class FunctionFactory {
    protected String[] parameterNames;
    protected BigRational[] lowerBounds;
    protected BigRational[] upperBounds;
    protected HashMap<String, Integer> varnameToInt;

    public FunctionFactory(String[] stringArray, BigRational[] bigRationalArray, BigRational[] bigRationalArray2) {
        this.parameterNames = stringArray;
        this.lowerBounds = bigRationalArray;
        this.upperBounds = bigRationalArray2;
        this.varnameToInt = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            this.varnameToInt.put(stringArray[i], i);
        }
    }

    public abstract Function getOne();

    public abstract Function getZero();

    public abstract Function getNaN();

    public abstract Function getInf();

    public abstract Function getMInf();

    public abstract Function fromBigRational(BigRational var1);

    public abstract Function getVar(int var1);

    public Function getVar(String string) {
        return this.getVar(this.varnameToInt.get(string));
    }

    public String getParameterName(int n) {
        return this.parameterNames[n];
    }

    public BigRational getLowerBound(int n) {
        return this.lowerBounds[n];
    }

    public BigRational getUpperBound(int n) {
        return this.upperBounds[n];
    }

    public int getNumVariables() {
        return this.parameterNames.length;
    }

    public Function fromLong(long l) {
        return this.fromBigRational(new BigRational(l));
    }

    public Function expr2function(Expression expression) throws PrismLangException {
        return this.expr2function(expression, null);
    }

    public Function expr2function(Expression expression, Values values) throws PrismLangException {
        if (expression instanceof ExpressionLiteral) {
            String string = ((ExpressionLiteral)expression).getString();
            if (string == null || string.equals("")) {
                throw new PrismLangException("Cannot convert from literal for which no string is set", expression);
            }
            return this.fromBigRational(new BigRational(string));
        }
        if (expression instanceof ExpressionConstant) {
            String string = ((ExpressionConstant)expression).getName();
            if (values != null && values.contains(string)) {
                Object object = values.getValueOf(string);
                return this.fromBigRational(new BigRational(object.toString()));
            }
            return this.getVar(string);
        }
        if (expression instanceof ExpressionBinaryOp) {
            ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
            Function function = this.expr2function(expressionBinaryOp.getOperand1());
            Function function2 = this.expr2function(expressionBinaryOp.getOperand2());
            switch (expressionBinaryOp.getOperator()) {
                case 11: {
                    return function.add(function2);
                }
                case 12: {
                    return function.subtract(function2);
                }
                case 13: {
                    return function.multiply(function2);
                }
                case 14: {
                    return function.divide(function2);
                }
            }
            throw new PrismLangException("Cannot create a function for expression " + expression, expression);
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            Function function = this.expr2function(expressionUnaryOp.getOperand());
            switch (expressionUnaryOp.getOperator()) {
                case 2: {
                    return function.negate();
                }
                case 3: {
                    return function;
                }
            }
            throw new PrismLangException("Cannot create a function for expression " + expression, expression);
        }
        if (expression instanceof ExpressionITE) {
            ExpressionITE expressionITE = (ExpressionITE)expression;
            if (expressionITE.getOperand1().isConstant()) {
                try {
                    boolean bl = expressionITE.getOperand1().evaluateExact().toBoolean();
                    if (bl) {
                        return this.expr2function(expressionITE.getOperand2());
                    }
                    return this.expr2function(expressionITE.getOperand3());
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
            }
            throw new PrismLangException("Cannot create a function for expression " + expression, expression);
        }
        if (expression instanceof ExpressionFunc) {
            try {
                BigRational bigRational = expression.evaluateExact();
                return this.fromBigRational(bigRational);
            }
            catch (PrismException prismException) {
                throw new PrismLangException("Cannot create a function for expression " + expression, expression);
            }
        }
        throw new PrismLangException("Cannot create a function for expression " + expression, expression);
    }
}

