/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.math.BigInteger;
import prism.PrismLangException;

public final class BigRational
extends Number
implements Comparable<BigRational> {
    private static final long serialVersionUID = 8273185089413305187L;
    private static final BigInteger BMONE = BigInteger.ONE.negate();
    private static final BigInteger BITWO = BigInteger.TWO;
    private static final BigInteger BITEN = BigInteger.TEN;
    public static final BigRational ONE = new BigRational(BigInteger.ONE);
    public static final BigRational TWO = new BigRational(BigInteger.valueOf(2L));
    public static final BigRational MONE = new BigRational(BigInteger.ONE).negate();
    public static final BigRational ZERO = new BigRational(BigInteger.ZERO);
    public static final BigRational HALF = ONE.divide(TWO);
    public static final BigRational INF = new BigRational(BigInteger.ONE, BigInteger.ZERO);
    public static final BigRational MINF = new BigRational(BMONE, BigInteger.ZERO);
    public static final BigRational NAN = new BigRational(BigInteger.ZERO, BigInteger.ZERO);
    private BigInteger num;
    private BigInteger den;

    public BigRational() {
        this.num = BigInteger.ZERO;
        this.den = BigInteger.ONE;
    }

    public BigRational(BigInteger bigInteger) {
        this.num = bigInteger;
        this.den = BigInteger.ONE;
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, true);
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
        if (bigInteger2.equals(BigInteger.ZERO)) {
            int n = bigInteger.compareTo(BigInteger.ZERO);
            switch (n) {
                case -1: {
                    bigInteger = BMONE;
                    break;
                }
                case 1: {
                    bigInteger = BigInteger.ONE;
                }
            }
        }
        if (bl) {
            this.canceled(bigInteger, bigInteger2);
        } else {
            this.num = bigInteger;
            this.den = bigInteger2;
        }
    }

    protected void canceled(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            if (!bigInteger2.equals(BigInteger.ZERO)) {
                bigInteger = BigInteger.ZERO;
                bigInteger2 = BigInteger.ONE;
            }
        } else {
            BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
            bigInteger = bigInteger.divide(bigInteger3);
            if ((bigInteger2 = bigInteger2.divide(bigInteger3)).signum() == -1) {
                bigInteger = bigInteger.negate();
                bigInteger2 = bigInteger2.negate();
            }
        }
        this.num = bigInteger;
        this.den = bigInteger2;
    }

    public BigRational(long l, long l2) {
        this(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public BigRational(long l) {
        this(l, 1L);
    }

    public BigRational(double d) {
        if (Double.isNaN(d)) {
            this.num = BigInteger.ZERO;
            this.den = BigInteger.ZERO;
        }
        if (d == Double.POSITIVE_INFINITY) {
            this.num = BigInteger.ONE;
            this.den = BigInteger.ZERO;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            this.num = BMONE;
            this.den = BigInteger.ZERO;
        }
        if (d <= -4.503599627370496E15 || d >= 4.503599627370496E15) {
            int n = 0;
            while ((double)((long)d) != d) {
                d /= 2.0;
                ++n;
            }
            this.num = BigInteger.valueOf((long)d).shiftLeft(n);
            this.den = BigInteger.ONE;
        } else {
            int n = 0;
            while ((double)((long)d) != d) {
                d *= 2.0;
                ++n;
            }
            this.num = BigInteger.valueOf((long)d);
            this.den = BigInteger.ONE.shiftLeft(n);
        }
    }

    public BigRational(String string) {
        BigInteger bigInteger;
        Object object;
        if (string.equals("Infinity") || string.equals("+Infinity") || string.equals("Inf") || string.equals("+Inf")) {
            this.num = BigInteger.ONE;
            this.den = BigInteger.ZERO;
            return;
        }
        if (string.equals("-Infinity") || string.equals("-Inf")) {
            this.num = BigInteger.ONE.negate();
            this.den = BigInteger.ZERO;
            return;
        }
        if (string.equals("NaN")) {
            this.num = BigInteger.ZERO;
            this.den = BigInteger.ZERO;
            return;
        }
        int n = (string = string.trim()).lastIndexOf(47);
        if (n < 0) {
            Object object2;
            int n2;
            Double.parseDouble(string);
            boolean bl = false;
            if (string.charAt(0) == '-') {
                bl = true;
                string = string.substring(1);
            }
            if ((n2 = string.indexOf("e")) < 0) {
                n2 = string.indexOf("E");
            }
            String string2 = string.substring(0, n2 >= 0 ? n2 : string.length());
            int n3 = string2.indexOf(46);
            int n4 = 0;
            if (n3 >= 0) {
                object2 = string2.substring(0, n3);
                object2 = (String)object2 + string2.substring(n3 + 1);
                n4 = -string2.substring(n3 + 1).length();
            } else {
                object2 = string2;
            }
            if (n2 >= 0) {
                object = string.substring(n2 + 1);
                int n5 = Integer.parseInt((String)object);
                n4 += n5;
            }
            object = new BigInteger((bl ? "-" : "") + (String)object2);
            BigInteger bigInteger2 = BITEN;
            if (n4 == 0) {
                bigInteger = BigInteger.ONE;
            } else if (n4 > 0) {
                bigInteger = BigInteger.ONE;
                object = ((BigInteger)object).multiply(bigInteger2.pow(n4));
            } else {
                bigInteger = bigInteger2.pow(-n4);
            }
        } else {
            if (n == 0 || n == string.length() - 1) {
                throw new NumberFormatException("Illegal fraction syntax");
            }
            BigRational bigRational = new BigRational(string.substring(0, n));
            BigRational bigRational2 = new BigRational(string.substring(n + 1, string.length()));
            BigRational bigRational3 = bigRational.divide(bigRational2);
            this.num = bigRational3.num;
            this.den = bigRational3.den;
            return;
        }
        BigRational bigRational = new BigRational((BigInteger)object, bigInteger, true);
        this.num = bigRational.num;
        this.den = bigRational.den;
    }

    public static BigRational from(Object object) {
        if (object instanceof BigRational) {
            BigRational bigRational = (BigRational)object;
            return new BigRational(bigRational.num, bigRational.den);
        }
        if (object instanceof BigInteger) {
            return new BigRational((BigInteger)object);
        }
        if (object instanceof Integer) {
            return new BigRational(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new BigRational((Long)object);
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            return bl ? ONE : ZERO;
        }
        if (object instanceof Double) {
            return new BigRational((Double)object);
        }
        if (object instanceof String) {
            return new BigRational((String)object);
        }
        throw new IllegalArgumentException("Can not convert from " + object.getClass() + " to BigRational");
    }

    public BigRational negate() {
        return new BigRational(this.num.negate(), this.den, false);
    }

    public BigRational cancel() {
        return new BigRational(this.num, this.den, true);
    }

    public BigRational add(BigRational bigRational, boolean bl) {
        if (this.isNaN() || bigRational.isNaN()) {
            return NAN;
        }
        if (this.isInf() || bigRational.isInf()) {
            if (this.isMInf() || bigRational.isMInf()) {
                return ZERO;
            }
            return INF;
        }
        if (this.isMInf() || bigRational.isMInf()) {
            return MINF;
        }
        BigInteger bigInteger = this.num.multiply(bigRational.den).add(bigRational.num.multiply(this.den));
        BigInteger bigInteger2 = this.den.multiply(bigRational.den);
        return new BigRational(bigInteger, bigInteger2, bl);
    }

    public BigRational add(BigRational bigRational) {
        return this.add(bigRational, true);
    }

    public BigRational subtract(BigRational bigRational) {
        if (this.isNaN() || bigRational.isNaN()) {
            return NAN;
        }
        if (this.isInf() && bigRational.isInf() || this.isMInf() && bigRational.isMInf()) {
            return ZERO;
        }
        if (this.isInf()) {
            return INF;
        }
        if (this.isMInf()) {
            return MINF;
        }
        if (bigRational.isInf()) {
            return INF;
        }
        if (bigRational.isMInf()) {
            return MINF;
        }
        BigInteger bigInteger = this.num.multiply(bigRational.den).subtract(bigRational.num.multiply(this.den));
        BigInteger bigInteger2 = this.den.multiply(bigRational.den);
        return new BigRational(bigInteger, bigInteger2);
    }

    public BigRational multiply(BigRational bigRational, boolean bl) {
        if (this.isNaN() || bigRational.isNaN()) {
            return NAN;
        }
        if (this.isZero() || bigRational.isZero()) {
            return ZERO;
        }
        if (this.isInf() || bigRational.isInf()) {
            return this.signum() * bigRational.signum() == 1 ? INF : MINF;
        }
        BigInteger bigInteger = this.num.multiply(bigRational.num);
        BigInteger bigInteger2 = this.den.multiply(bigRational.den);
        return new BigRational(bigInteger, bigInteger2, bl);
    }

    public BigRational multiply(BigRational bigRational) {
        return this.multiply(bigRational, true);
    }

    public BigRational multiply(long l, boolean bl) {
        return this.multiply(new BigRational(l), bl);
    }

    public BigRational multiply(long l) {
        return this.multiply(l, true);
    }

    public BigRational divide(BigRational bigRational, boolean bl) {
        if (bigRational.isInf() || bigRational.isMInf()) {
            return NAN;
        }
        if (bigRational.isZero()) {
            if (this.isZero() || this.isNaN()) {
                return NAN;
            }
            if (this.signum() > 0) {
                return INF;
            }
            return MINF;
        }
        BigRational bigRational2 = new BigRational(bigRational.den, bigRational.num, bl);
        return this.multiply(bigRational2, bl);
    }

    public BigRational divide(BigRational bigRational) {
        return this.divide(bigRational, true);
    }

    public BigRational divide(long l) {
        return this.divide(new BigRational(l));
    }

    public int signum() {
        if (this.isInf()) {
            return 1;
        }
        if (this.isMInf()) {
            return -1;
        }
        return this.num.signum() * this.den.signum();
    }

    public BigRational pow(int n) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (n == 0) {
            return ONE;
        }
        if (n > 0) {
            bigInteger2 = this.num.pow(n);
            bigInteger = this.den.pow(n);
        } else {
            n = -n;
            bigInteger2 = this.den.pow(n);
            bigInteger = this.num.pow(n);
        }
        return new BigRational(bigInteger2, bigInteger, false);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigRational)) {
            return false;
        }
        BigRational bigRational = (BigRational)object;
        if (this.isNaN()) {
            return bigRational.isNaN();
        }
        if (this.isInf()) {
            return bigRational.isInf();
        }
        if (this.isMInf()) {
            return bigRational.isMInf();
        }
        return this.num.equals(bigRational.num) && this.den.equals(bigRational.den);
    }

    public int hashCode() {
        return 37 * this.num.hashCode() + this.den.hashCode();
    }

    @Override
    public double doubleValue() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInf()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isMInf()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isOne()) {
            return 1.0;
        }
        if (this.isZero()) {
            return 0.0;
        }
        int n = this.num.signum() * this.den.signum();
        BigInteger bigInteger = this.num.abs();
        BigInteger bigInteger2 = this.den.abs();
        BigInteger bigInteger3 = bigInteger.shiftLeft(55);
        BigInteger bigInteger4 = bigInteger3.divide(bigInteger2);
        if (bigInteger3.remainder(bigInteger2).multiply(BITWO).compareTo(bigInteger2) == 1) {
            bigInteger4 = bigInteger4.add(BigInteger.ONE);
        }
        return (double)n * bigInteger4.doubleValue() / Math.pow(2.0, 55.0);
    }

    @Override
    public int intValue() {
        if (this.isSpecial()) {
            if (this.isInf()) {
                return Integer.MAX_VALUE;
            }
            if (this.isMInf()) {
                return Integer.MIN_VALUE;
            }
            if (this.isNaN()) {
                return 0;
            }
        }
        if (!this.isInteger()) {
            throw new ArithmeticException("Can not convert fractional number to int");
        }
        int n = this.getNum().intValue();
        if (!this.getNum().equals(BigInteger.valueOf(n))) {
            throw new ArithmeticException("Can not convert BigInteger to int, value " + this + " out of range");
        }
        return n;
    }

    @Override
    public long longValue() {
        if (this.isSpecial()) {
            if (this.isInf()) {
                return Long.MAX_VALUE;
            }
            if (this.isMInf()) {
                return Long.MIN_VALUE;
            }
            if (this.isNaN()) {
                return 0L;
            }
        }
        if (!this.isInteger()) {
            throw new ArithmeticException("Can not convert fractional number to long");
        }
        long l = this.getNum().longValue();
        if (!this.getNum().equals(BigInteger.valueOf(l))) {
            throw new ArithmeticException("Can not convert BigInteger to long, value " + this + " out of range");
        }
        return l;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public BigInteger bigIntegerValue() {
        if (this.isSpecial()) {
            if (this.isInf()) {
                return BigInteger.valueOf(Long.MAX_VALUE);
            }
            if (this.isMInf()) {
                return BigInteger.valueOf(Long.MIN_VALUE);
            }
            if (this.isNaN()) {
                return BigInteger.ZERO;
            }
        }
        if (!this.isInteger()) {
            throw new ArithmeticException("Can not convert fractional number to int");
        }
        return this.getNum();
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInf()) {
            return "Inf";
        }
        if (this.isMInf()) {
            return "-Inf";
        }
        if (this.den.equals(BigInteger.ONE)) {
            return this.num.toString();
        }
        return this.num + "/" + this.den;
    }

    @Override
    public int compareTo(BigRational bigRational) {
        if (this.isInf()) {
            if (bigRational.isInf()) {
                return 0;
            }
            return 1;
        }
        if (this.isMInf()) {
            if (bigRational.isMInf()) {
                return 0;
            }
            return -1;
        }
        return this.num.multiply(bigRational.den).compareTo(bigRational.num.multiply(this.den));
    }

    @Override
    public int compareTo(long l) {
        return this.compareTo(new BigRational(l));
    }

    public boolean lessThan(BigRational bigRational) {
        return this.compareTo(bigRational) < 0;
    }

    public boolean lessThanEquals(BigRational bigRational) {
        return this.compareTo(bigRational) <= 0;
    }

    public boolean greaterThan(BigRational bigRational) {
        return this.compareTo(bigRational) > 0;
    }

    public boolean greaterThanEquals(BigRational bigRational) {
        return this.compareTo(bigRational) >= 0;
    }

    public BigInteger getNum() {
        return this.num;
    }

    public BigInteger getDen() {
        return this.den;
    }

    public BigRational abs() {
        if (this.num.signum() == -1) {
            return new BigRational(this.num.negate(), this.den);
        }
        return this;
    }

    public BigRational ceil() throws PrismLangException {
        if (this.isSpecial()) {
            throw new PrismLangException("Can not compute ceil of " + this);
        }
        BigInteger[] bigIntegerArray = this.getNum().divideAndRemainder(this.getDen());
        switch (bigIntegerArray[1].compareTo(BigInteger.ZERO)) {
            case -1: 
            case 0: {
                return new BigRational(bigIntegerArray[0]);
            }
            case 1: {
                return new BigRational(bigIntegerArray[0].add(BigInteger.ONE));
            }
        }
        throw new IllegalStateException("Should not be reached");
    }

    public BigRational floor() throws PrismLangException {
        if (this.isSpecial()) {
            throw new PrismLangException("Can not compute floor of " + this);
        }
        BigInteger[] bigIntegerArray = this.getNum().divideAndRemainder(this.getDen());
        switch (bigIntegerArray[1].compareTo(BigInteger.ZERO)) {
            case 0: 
            case 1: {
                return new BigRational(bigIntegerArray[0]);
            }
            case -1: {
                return new BigRational(bigIntegerArray[0].subtract(BigInteger.ONE));
            }
        }
        throw new IllegalStateException("Should not be reached");
    }

    public BigRational round() throws PrismLangException {
        if (this.isSpecial()) {
            throw new PrismLangException("Can not compute round of " + this);
        }
        return this.add(HALF).floor();
    }

    public BigRational max(BigRational bigRational) {
        if (this.compareTo(bigRational) >= 0) {
            return this;
        }
        return bigRational;
    }

    public BigRational min(BigRational bigRational) {
        if (this.compareTo(bigRational) <= 0) {
            return this;
        }
        return bigRational;
    }

    public boolean isZero() {
        return this.num.equals(BigInteger.ZERO) && this.den.equals(BigInteger.ONE);
    }

    public boolean isOne() {
        return this.num.equals(BigInteger.ONE) && this.den.equals(BigInteger.ONE);
    }

    public boolean isNaN() {
        return this.num.equals(BigInteger.ZERO) && this.den.equals(BigInteger.ZERO);
    }

    public boolean isInf() {
        return this.num.equals(BigInteger.ONE) && this.den.equals(BigInteger.ZERO);
    }

    public boolean isMInf() {
        return this.num.equals(BMONE) && this.den.equals(BigInteger.ZERO);
    }

    public boolean isRational() {
        return !this.isNaN() && !this.isInf() && !this.isMInf();
    }

    public boolean isInteger() {
        return this.isRational() && this.getDen().equals(BigInteger.ONE);
    }

    public boolean isSpecial() {
        return this.isNaN() || this.isInf() || this.isMInf();
    }

    public boolean toBoolean() throws PrismLangException {
        if (this.isOne()) {
            return true;
        }
        if (this.isZero()) {
            return false;
        }
        throw new PrismLangException("Conversion from BigRational to Boolean not possible, invalid value: " + this);
    }

    public String toApproximateString() {
        String string = Double.toString(this.doubleValue());
        if (new BigRational(string).equals(this)) {
            return string;
        }
        return "~" + string;
    }

    public int toInt() throws PrismLangException {
        if (!this.isInteger()) {
            throw new PrismLangException("Can not convert fractional number to int");
        }
        int n = this.getNum().intValue();
        if (!this.getNum().equals(BigInteger.valueOf(n))) {
            throw new PrismLangException("Can not convert BigInteger to int, value out of range");
        }
        return n;
    }
}

